/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client.service;

import com.azul.crs.client.Client;
import com.azul.crs.client.Inventory;
import com.azul.crs.client.Options;
import com.azul.crs.client.Utils;
import com.azul.crs.client.models.VMEvent;
import com.azul.crs.client.service.ClientService;
import java.util.HashMap;
import java.util.Map;

public class ClassLoadMonitor
implements ClientService {
    private static final ClassLoadMonitor instance = new ClassLoadMonitor();
    private static final String MAIN_METHOD_NAME = ".main";
    private Client client;
    private volatile boolean started;
    private volatile boolean stopped;
    private final boolean doNotifyClassLoad = Options.notifyClassLoad.isYes();

    private ClassLoadMonitor() {
    }

    public static ClassLoadMonitor getInstance(Client client) {
        ClassLoadMonitor.instance.client = client;
        return instance;
    }

    private VMEvent classLoadEvent(String string, String string2, String string3, int n, int n2, String string4, long l) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("className", string);
        if (string2 != null) {
            hashMap.put("transformedHash", string3);
        }
        hashMap.put("hash", string2 != null ? string2 : string3);
        hashMap.put("classId", Integer.toString(n));
        hashMap.put("loaderId", Integer.toString(n2));
        if (string4 != null) {
            hashMap.put("source", string4);
        }
        return new VMEvent().eventType(VMEvent.Type.VM_CLASS_LOADED).eventTime(l).eventPayload(hashMap);
    }

    @Override
    public synchronized void start() {
        this.started = true;
    }

    @Override
    public synchronized void stop(Utils.Deadline deadline) {
        this.started = false;
        this.stopped = true;
    }

    public void notifyClassLoad(String string, byte[] byArray, byte[] byArray2, int n, int n2, String string2) {
        if (!this.doNotifyClassLoad) {
            return;
        }
        if (this.stopped) {
            return;
        }
        if (!this.started) {
            this.logger().error("service is not yet started", new Object[0]);
        }
        long l = Utils.currentTimeMillis();
        String string3 = Utils.encodeToStringOrNull(byArray);
        String string4 = Utils.encodeToStringOrNull(byArray2);
        this.client.postVMEvent(this.classLoadEvent(string, string3, string4, n, n2, string2, l));
    }

    public void notifyMainClass(String string) {
        Map<String, Object> map = new Inventory().mainMethod(string + MAIN_METHOD_NAME).toMap();
        this.client.patchInventory(map);
    }
}

