/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client;

import com.azul.crs.client.ConnectionManagerFactory;
import com.azul.crs.client.InterfaceConnectionManager;
import com.azul.crs.client.PerformanceMetrics;
import com.azul.crs.client.Result;
import com.azul.crs.client.Utils;
import com.azul.crs.client.Version;
import com.azul.crs.client.models.VMArtifact;
import com.azul.crs.client.models.VMArtifactChunk;
import com.azul.crs.client.models.VMEvent;
import com.azul.crs.client.models.VMInstance;
import com.azul.crs.client.service.EventService;
import com.azul.crs.client.service.ServerRequestsService;
import com.azul.crs.client.service.UploadService;
import com.azul.crs.datafilter.SensitiveDataFilterFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;

public final class Client {
    private final InterfaceConnectionManager connectionManager;
    private final UploadService uploadService;
    private final EventService eventService;
    private final ServerRequestsService serverRequestsService;
    private final AtomicInteger nextArtifactId = new AtomicInteger();
    private final AtomicLong nextArtifactChunkId = new AtomicLong();
    private static volatile Utils.Deadline vmShutdownDeadline;
    private final Predicate<String> envFilter;
    private final Predicate<String> sysPropsFilter;
    private String vmId;

    public Client(Map<ClientProp, Object> map, final ClientListener clientListener) {
        this.eventService = EventService.getInstance(this);
        this.serverRequestsService = new ServerRequestsService();
        this.connectionManager = ConnectionManagerFactory.create(map, this, new InterfaceConnectionManager.ConnectionListener(){

            @Override
            public void authenticated() {
                Client.this.vmId = Client.this.connectionManager.getVmId();
                clientListener.authenticated();
            }

            @Override
            public void syncFailed(Result<String[]> result) {
                clientListener.syncFailed(result);
            }
        });
        this.uploadService = new UploadService(this);
        SensitiveDataFilterFactory sensitiveDataFilterFactory = new SensitiveDataFilterFactory();
        this.sysPropsFilter = sensitiveDataFilterFactory.createSystemPropertyFilter();
        this.envFilter = sensitiveDataFilterFactory.createEnvironmentFilter();
    }

    public void postVMStart(Map<String, Object> map, long l) throws IOException {
        this.postVMEvent(new VMEvent().eventType(VMEvent.Type.VM_CREATE).eventPayload(new VMInstance().agentVersion(this.getClientVersion()).agentRevision(this.getClientRevision()).owner(this.connectionManager.getMailbox()).inventory(map).startTime(l)));
    }

    public void patchInventory(Map<String, Object> map) {
        this.postVMEvent(new VMEvent().eventType(VMEvent.Type.VM_PATCH).eventPayload(new VMInstance().inventory(map)));
    }

    public void postVMEvent(VMEvent vMEvent) {
        this.eventService.add(vMEvent.randomEventId());
    }

    public void postVMShutdown(Collection<VMEvent> collection) {
        this.eventService.addAll(collection);
        this.eventService.add(new VMEvent().randomEventId().eventType(VMEvent.Type.VM_SHUTDOWN).eventTime(Utils.currentTimeMillis()));
    }

    public int createArtifactId() {
        return this.nextArtifactId.incrementAndGet();
    }

    public long createArtifactChunkId() {
        return this.nextArtifactChunkId.incrementAndGet();
    }

    public void postVMArtifactCreate(VMArtifact.Type type, int n, Map<String, Object> map) {
        this.postVMEvent(new VMEvent().eventType(VMEvent.Type.VM_ARTIFACT_CREATE).eventPayload(new VMArtifact().artifactType(type).artifactId(Client.artifactIdToString(n)).metadata(map)));
    }

    public void postVMArtifactPatch(VMArtifact.Type type, int n, Map<String, Object> map) {
        this.postVMEvent(new VMEvent().eventType(VMEvent.Type.VM_ARTIFACT_PATCH).eventPayload(new VMArtifact().artifactType(type).artifactId(Client.artifactIdToString(n)).metadata(map)));
    }

    public void postVMArtifactData(Integer n, String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("artifactId", Client.artifactIdToString(n));
        hashMap.put("data", string);
        this.postVMEvent(new VMEvent().eventType(VMEvent.Type.VM_ARTIFACT_DATA).eventPayload(hashMap));
        PerformanceMetrics.logArtifactBytes(string.length());
    }

    public void postVMArtifact(VMArtifact.Type type, int n, Map<String, Object> map, DataWriter dataWriter) {
        this.postVMArtifactCreate(type, n, map);
        this.postVMArtifactChunk(type, Collections.singleton(n), Collections.emptyMap(), dataWriter);
    }

    public void postVMArtifactChunk(VMArtifact.Type type, Set<Integer> set, Map<String, Object> map, DataWriter dataWriter) {
        HashSet<String> hashSet = new HashSet<String>();
        set.forEach(n -> hashSet.add(Client.artifactIdToString(n)));
        this.uploadService.post(new VMArtifactChunk().artifactIds(hashSet).metadata(map).artifactType(type), dataWriter);
    }

    public void finishChunkPost() {
        this.uploadService.sync();
    }

    public static String artifactIdToString(int n) {
        return Integer.toString(n, 36);
    }

    public void startup() throws IOException {
        this.connectionManager.start();
        this.eventService.start();
        this.uploadService.start();
        this.serverRequestsService.start();
    }

    public void connectionEstablished() {
        this.eventService.connectionEstablished();
        this.uploadService.connectionEstablished();
    }

    public static boolean isVMShutdownInitiated() {
        return vmShutdownDeadline != null;
    }

    public static void setVMShutdownInitiated(Utils.Deadline deadline) {
        vmShutdownDeadline = deadline;
    }

    public static Utils.Deadline getVMShutdownDeadline() {
        return vmShutdownDeadline;
    }

    public void shutdown(Utils.Deadline deadline) {
        this.eventService.stop(deadline);
        this.uploadService.stop(deadline);
        this.connectionManager.stop(deadline);
        this.serverRequestsService.stop(deadline);
    }

    public void cancel() {
        this.eventService.cancel();
        this.uploadService.cancel();
        this.serverRequestsService.cancel();
    }

    public String getVmId() {
        return this.vmId;
    }

    public String getClientVersion() throws IOException {
        return new Version().clientVersion();
    }

    public String getClientRevision() throws IOException {
        return new Version().clientRevision();
    }

    public String getMailbox() {
        return this.connectionManager.getMailbox();
    }

    public String getRestAPI() {
        return this.connectionManager.getRestAPI();
    }

    public InterfaceConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public Predicate<String> getEnvFilter() {
        return this.envFilter;
    }

    public Predicate<String> getSysPropsFilter() {
        return this.sysPropsFilter;
    }

    public static interface DataWriter {
        public void writeData(OutputStream var1) throws IOException;

        default public void handleException(IOException iOException) {
        }
    }

    public static enum ClientProp {
        CONNECTION_MANAGER("connection.manager", false),
        API_URL("api.url", true),
        API_MAILBOX("api.mailbox", true),
        KS("keystore", false),
        KSP("keystorepassword", false),
        ACCESS_KEY("accessKey", false),
        HEAP_BUFFER_SIZE("heapBufferSize", false),
        FILE_SYSTEM_BUFFER_SIZE("fileSystemBufferSize", false),
        FILE_SYSTEM_BUFFER_LOCATION("fileSystemBufferLocation", false),
        NUM_CONCURRENT_CONNECTIONS("numConcurrentConnections", false),
        BACKUP_JFR_CHUNKS("backupJfrChunks", false),
        VM_SHUTDOWN_DELAY("delayShutdownInternal", true);

        private final Object value;
        private final boolean mandatory;

        private ClientProp(String string2, boolean bl) {
            this.value = string2;
            this.mandatory = bl;
        }

        Object value() {
            return this.value;
        }

        boolean isMandatory() {
            return this.mandatory;
        }
    }

    public static interface ClientListener {
        public void authenticated();

        public void syncFailed(Result<String[]> var1);
    }
}

