/*
 * Decompiled with CFR 0.152.
 */
package sun.reflect;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Locale;
import java.util.Objects;
import sun.reflect.AccessorGenerator;
import sun.reflect.ByteVector;
import sun.reflect.ByteVectorFactory;
import sun.reflect.ClassDefiner;
import sun.reflect.ClassFileAssembler;
import sun.reflect.ConstructorAccessor;
import sun.reflect.Label;
import sun.reflect.MagicAccessorImpl;
import sun.reflect.MethodAccessor;
import sun.reflect.SerializationConstructorAccessorImpl;

class MethodAccessorGenerator
extends AccessorGenerator {
    private static final short NUM_BASE_CPOOL_ENTRIES = 12;
    private static final short NUM_METHODS = 2;
    private static final short NUM_SERIALIZATION_CPOOL_ENTRIES = 2;
    private Class<?> declaringClass;
    private Class<?>[] parameterTypes;
    private Class<?> returnType;
    private boolean isConstructor;
    private boolean forSerialization;
    private short targetMethodRef;
    private short invokeIdx;
    private short invokeDescriptorIdx;
    private short nonPrimitiveParametersBaseIdx;

    MethodAccessorGenerator() {
    }

    public MethodAccessor generateMethod(Class<?> clazz, String string, Class<?>[] classArray, Class<?> clazz2, Class<?>[] classArray2, int n) {
        return (MethodAccessor)this.generate(clazz, string, classArray, clazz2, classArray2, n, false, false, null);
    }

    public ConstructorAccessor generateConstructor(Class<?> clazz, Class<?>[] classArray, Class<?>[] classArray2, int n) {
        return (ConstructorAccessor)this.generate(clazz, "<init>", classArray, Void.TYPE, classArray2, n, true, false, null);
    }

    public SerializationConstructorAccessorImpl generateSerializationConstructor(Class<?> clazz, Class<?>[] classArray, Class<?>[] classArray2, int n, Class<?> clazz2) {
        return (SerializationConstructorAccessorImpl)this.generate(clazz, "<init>", classArray, Void.TYPE, classArray2, n, true, true, clazz2);
    }

    private MagicAccessorImpl generate(final Class<?> clazz, String string, Class<?>[] classArray, Class<?> clazz2, Class<?>[] classArray2, int n, boolean bl, boolean bl2, Class<?> clazz3) {
        ByteVector byteVector = ByteVectorFactory.create();
        this.asm = new ClassFileAssembler(byteVector);
        this.declaringClass = clazz;
        this.parameterTypes = classArray;
        this.returnType = clazz2;
        this.modifiers = n;
        this.isConstructor = bl;
        this.forSerialization = bl2;
        this.asm.emitMagicAndVersion();
        short s = 42;
        boolean bl3 = this.usesPrimitiveTypes();
        if (bl3) {
            s = (short)(s + 72);
        }
        if (bl2) {
            s = (short)(s + 2);
        }
        s = (short)(s + (short)(2 * this.numNonPrimitiveParameterTypes()));
        this.asm.emitShort(MethodAccessorGenerator.add((short)s, (short)1));
        String string2 = MethodAccessorGenerator.getClassName(clazz, (boolean)false);
        String string3 = this.buildInternalSignature();
        int n2 = Objects.hash(string2, string, string3);
        final String string4 = MethodAccessorGenerator.generateName(bl, bl2, n2);
        this.asm.emitConstantPoolUTF8(string4);
        this.asm.emitConstantPoolClass(this.asm.cpi());
        this.thisClass = this.asm.cpi();
        if (bl) {
            if (bl2) {
                this.asm.emitConstantPoolUTF8("sun/reflect/SerializationConstructorAccessorImpl");
            } else {
                this.asm.emitConstantPoolUTF8("sun/reflect/ConstructorAccessorImpl");
            }
        } else {
            this.asm.emitConstantPoolUTF8("sun/reflect/MethodAccessorImpl");
        }
        this.asm.emitConstantPoolClass(this.asm.cpi());
        this.superClass = this.asm.cpi();
        this.asm.emitConstantPoolUTF8(string2);
        this.asm.emitConstantPoolClass(this.asm.cpi());
        this.targetClass = this.asm.cpi();
        short s2 = 0;
        if (bl2) {
            this.asm.emitConstantPoolUTF8(MethodAccessorGenerator.getClassName(clazz3, (boolean)false));
            this.asm.emitConstantPoolClass(this.asm.cpi());
            s2 = this.asm.cpi();
        }
        this.asm.emitConstantPoolUTF8(string);
        this.asm.emitConstantPoolUTF8(string3);
        this.asm.emitConstantPoolNameAndType(MethodAccessorGenerator.sub((short)this.asm.cpi(), (short)1), this.asm.cpi());
        if (this.isInterface()) {
            this.asm.emitConstantPoolInterfaceMethodref(this.targetClass, this.asm.cpi());
        } else if (bl2) {
            this.asm.emitConstantPoolMethodref(s2, this.asm.cpi());
        } else {
            this.asm.emitConstantPoolMethodref(this.targetClass, this.asm.cpi());
        }
        this.targetMethodRef = this.asm.cpi();
        if (bl) {
            this.asm.emitConstantPoolUTF8("newInstance");
        } else {
            this.asm.emitConstantPoolUTF8("invoke");
        }
        this.invokeIdx = this.asm.cpi();
        if (bl) {
            this.asm.emitConstantPoolUTF8("([Ljava/lang/Object;)Ljava/lang/Object;");
        } else {
            this.asm.emitConstantPoolUTF8("(Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;");
        }
        this.invokeDescriptorIdx = this.asm.cpi();
        this.nonPrimitiveParametersBaseIdx = MethodAccessorGenerator.add((short)this.asm.cpi(), (short)2);
        for (int i = 0; i < classArray.length; ++i) {
            Class<?> clazz4 = classArray[i];
            if (MethodAccessorGenerator.isPrimitive(clazz4)) continue;
            this.asm.emitConstantPoolUTF8(MethodAccessorGenerator.getClassName(clazz4, (boolean)false));
            this.asm.emitConstantPoolClass(this.asm.cpi());
        }
        this.emitCommonConstantPoolEntries();
        if (bl3) {
            this.emitBoxingContantPoolEntries();
        }
        if (this.asm.cpi() != s) {
            throw new InternalError("Adjust this code (cpi = " + this.asm.cpi() + ", numCPEntries = " + s + ")");
        }
        this.asm.emitShort((short)1);
        this.asm.emitShort(this.thisClass);
        this.asm.emitShort(this.superClass);
        this.asm.emitShort((short)0);
        this.asm.emitShort((short)0);
        this.asm.emitShort((short)2);
        this.emitConstructor();
        this.emitInvoke();
        this.asm.emitShort((short)0);
        byteVector.trim();
        final byte[] byArray = byteVector.getData();
        return AccessController.doPrivileged(new PrivilegedAction<MagicAccessorImpl>(){

            @Override
            public MagicAccessorImpl run() {
                try {
                    return (MagicAccessorImpl)ClassDefiner.defineClass((String)string4, (byte[])byArray, (int)0, (int)byArray.length, (ClassLoader)clazz.getClassLoader()).newInstance();
                }
                catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                    throw new InternalError(reflectiveOperationException);
                }
            }
        });
    }

    private void emitInvoke() {
        Class clazz;
        short s;
        short s2;
        Label label;
        if (this.parameterTypes.length > 65535) {
            throw new InternalError("Can't handle more than 65535 parameters");
        }
        ClassFileAssembler classFileAssembler = new ClassFileAssembler();
        if (this.isConstructor) {
            classFileAssembler.setMaxLocals(2);
        } else {
            classFileAssembler.setMaxLocals(3);
        }
        short s3 = 0;
        if (this.isConstructor) {
            classFileAssembler.opc_new(this.targetClass);
            classFileAssembler.opc_dup();
        } else {
            if (MethodAccessorGenerator.isPrimitive(this.returnType)) {
                classFileAssembler.opc_new(this.indexForPrimitiveType(this.returnType));
                classFileAssembler.opc_dup();
            }
            if (!this.isStatic()) {
                classFileAssembler.opc_aload_1();
                label = new Label();
                classFileAssembler.opc_ifnonnull(label);
                classFileAssembler.opc_new(this.nullPointerClass);
                classFileAssembler.opc_dup();
                classFileAssembler.opc_invokespecial(this.nullPointerCtorIdx, 0, 0);
                classFileAssembler.opc_athrow();
                label.bind();
                s3 = classFileAssembler.getLength();
                classFileAssembler.opc_aload_1();
                classFileAssembler.opc_checkcast(this.targetClass);
            }
        }
        label = new Label();
        if (this.parameterTypes.length == 0) {
            if (this.isConstructor) {
                classFileAssembler.opc_aload_1();
            } else {
                classFileAssembler.opc_aload_2();
            }
            classFileAssembler.opc_ifnull(label);
        }
        if (this.isConstructor) {
            classFileAssembler.opc_aload_1();
        } else {
            classFileAssembler.opc_aload_2();
        }
        classFileAssembler.opc_arraylength();
        classFileAssembler.opc_sipush((short)this.parameterTypes.length);
        classFileAssembler.opc_if_icmpeq(label);
        classFileAssembler.opc_new(this.illegalArgumentClass);
        classFileAssembler.opc_dup();
        classFileAssembler.opc_invokespecial(this.illegalArgumentCtorIdx, 0, 0);
        classFileAssembler.opc_athrow();
        label.bind();
        short s4 = this.nonPrimitiveParametersBaseIdx;
        Label label2 = null;
        byte by = 1;
        for (s2 = 0; s2 < this.parameterTypes.length; ++s2) {
            Class<?> clazz2 = this.parameterTypes[s2];
            by = (byte)(by + (byte)this.typeSizeInStackSlots(clazz2));
            if (label2 != null) {
                label2.bind();
                label2 = null;
            }
            if (this.isConstructor) {
                classFileAssembler.opc_aload_1();
            } else {
                classFileAssembler.opc_aload_2();
            }
            classFileAssembler.opc_sipush(s2);
            classFileAssembler.opc_aaload();
            if (MethodAccessorGenerator.isPrimitive(clazz2)) {
                if (this.isConstructor) {
                    classFileAssembler.opc_astore_2();
                } else {
                    classFileAssembler.opc_astore_3();
                }
                Label label3 = null;
                label2 = new Label();
                for (s = 0; s < primitiveTypes.length; ++s) {
                    clazz = primitiveTypes[s];
                    if (!MethodAccessorGenerator.canWidenTo((Class)clazz, clazz2)) continue;
                    if (label3 != null) {
                        label3.bind();
                    }
                    if (this.isConstructor) {
                        classFileAssembler.opc_aload_2();
                    } else {
                        classFileAssembler.opc_aload_3();
                    }
                    classFileAssembler.opc_instanceof(this.indexForPrimitiveType(clazz));
                    label3 = new Label();
                    classFileAssembler.opc_ifeq(label3);
                    if (this.isConstructor) {
                        classFileAssembler.opc_aload_2();
                    } else {
                        classFileAssembler.opc_aload_3();
                    }
                    classFileAssembler.opc_checkcast(this.indexForPrimitiveType(clazz));
                    classFileAssembler.opc_invokevirtual(this.unboxingMethodForPrimitiveType(clazz), 0, this.typeSizeInStackSlots(clazz));
                    MethodAccessorGenerator.emitWideningBytecodeForPrimitiveConversion((ClassFileAssembler)classFileAssembler, (Class)clazz, clazz2);
                    classFileAssembler.opc_goto(label2);
                }
                if (label3 == null) {
                    throw new InternalError("Must have found at least identity conversion");
                }
                label3.bind();
                classFileAssembler.opc_new(this.illegalArgumentClass);
                classFileAssembler.opc_dup();
                classFileAssembler.opc_invokespecial(this.illegalArgumentCtorIdx, 0, 0);
                classFileAssembler.opc_athrow();
                continue;
            }
            classFileAssembler.opc_checkcast(s4);
            s4 = MethodAccessorGenerator.add((short)s4, (short)2);
        }
        if (label2 != null) {
            label2.bind();
        }
        s2 = classFileAssembler.getLength();
        if (this.isConstructor) {
            classFileAssembler.opc_invokespecial(this.targetMethodRef, (int)by, 0);
        } else if (this.isStatic()) {
            classFileAssembler.opc_invokestatic(this.targetMethodRef, (int)by, this.typeSizeInStackSlots(this.returnType));
        } else if (this.isInterface()) {
            if (this.isPrivate()) {
                classFileAssembler.opc_invokespecial(this.targetMethodRef, (int)by, 0);
            } else {
                classFileAssembler.opc_invokeinterface(this.targetMethodRef, (int)by, by, this.typeSizeInStackSlots(this.returnType));
            }
        } else {
            classFileAssembler.opc_invokevirtual(this.targetMethodRef, (int)by, this.typeSizeInStackSlots(this.returnType));
        }
        short s5 = classFileAssembler.getLength();
        if (!this.isConstructor) {
            if (MethodAccessorGenerator.isPrimitive(this.returnType)) {
                classFileAssembler.opc_invokespecial(this.ctorIndexForPrimitiveType(this.returnType), this.typeSizeInStackSlots(this.returnType), 0);
            } else if (this.returnType == Void.TYPE) {
                classFileAssembler.opc_aconst_null();
            }
        }
        classFileAssembler.opc_areturn();
        short s6 = classFileAssembler.getLength();
        classFileAssembler.setStack(1);
        classFileAssembler.opc_invokespecial(this.toStringIdx, 0, 1);
        classFileAssembler.opc_new(this.illegalArgumentClass);
        classFileAssembler.opc_dup_x1();
        classFileAssembler.opc_swap();
        classFileAssembler.opc_invokespecial(this.illegalArgumentStringCtorIdx, 1, 0);
        classFileAssembler.opc_athrow();
        s = classFileAssembler.getLength();
        classFileAssembler.setStack(1);
        classFileAssembler.opc_new(this.invocationTargetClass);
        classFileAssembler.opc_dup_x1();
        classFileAssembler.opc_swap();
        classFileAssembler.opc_invokespecial(this.invocationTargetCtorIdx, 1, 0);
        classFileAssembler.opc_athrow();
        clazz = new ClassFileAssembler();
        clazz.emitShort(s3);
        clazz.emitShort(s2);
        clazz.emitShort(s6);
        clazz.emitShort(this.classCastClass);
        clazz.emitShort(s3);
        clazz.emitShort(s2);
        clazz.emitShort(s6);
        clazz.emitShort(this.nullPointerClass);
        clazz.emitShort(s2);
        clazz.emitShort(s5);
        clazz.emitShort(s);
        clazz.emitShort(this.throwableClass);
        this.emitMethod(this.invokeIdx, classFileAssembler.getMaxLocals(), classFileAssembler, (ClassFileAssembler)clazz, new short[]{this.invocationTargetClass});
    }

    private boolean usesPrimitiveTypes() {
        if (this.returnType.isPrimitive()) {
            return true;
        }
        for (int i = 0; i < this.parameterTypes.length; ++i) {
            if (!this.parameterTypes[i].isPrimitive()) continue;
            return true;
        }
        return false;
    }

    private int numNonPrimitiveParameterTypes() {
        int n = 0;
        for (int i = 0; i < this.parameterTypes.length; ++i) {
            if (this.parameterTypes[i].isPrimitive()) continue;
            ++n;
        }
        return n;
    }

    private boolean isInterface() {
        return this.declaringClass.isInterface();
    }

    private String buildInternalSignature() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        for (int i = 0; i < this.parameterTypes.length; ++i) {
            stringBuffer.append(MethodAccessorGenerator.getClassName(this.parameterTypes[i], (boolean)true));
        }
        stringBuffer.append(")");
        stringBuffer.append(MethodAccessorGenerator.getClassName(this.returnType, (boolean)true));
        return stringBuffer.toString();
    }

    private static synchronized String generateName(boolean bl, boolean bl2, int n) {
        String string = Integer.toHexString(n).toUpperCase(Locale.ENGLISH);
        string = ("00000000" + string).substring(string.length());
        if (bl) {
            if (bl2) {
                return "sun/reflect/GeneratedSerializationConstructorAccessor_RN" + string;
            }
            return "sun/reflect/GeneratedConstructorAccessor_RN" + string;
        }
        return "sun/reflect/GeneratedMethodAccessor_RN" + string;
    }
}

