/*
 * Decompiled with CFR 0.152.
 */
package com.azul.threadopt;

import com.azul.threadopt.TimeUtils;
import com.azul.threadopt.mxbeans.TimeMXBean;
import java.lang.management.ManagementPermission;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class TimeMXBeanImpl
implements TimeMXBean {
    private static final String timeMXBeanVersion = "1.0.0";
    private static TimeMXBeanImpl _instance = new TimeMXBeanImpl();
    private static final String TIME_MXBEAN_DOMAIN_TYPE = "com.azul.threadopt:type=Time";
    private static final String _defaultDateTimeFormatString = "EEE MMM dd HH:mm:ss.SSS zzz yyyy";
    private static String _dateTimeFormatString = "EEE MMM dd HH:mm:ss.SSS zzz yyyy";
    private static final String _defaultyyyyMMdd_HHmmss_SSSFormatString = "yyyyMMdd_HHmmss_SSS";

    @Override
    public String getVersion() {
        return timeMXBeanVersion;
    }

    public static ObjectName getObjectName() {
        try {
            return ObjectName.getInstance("com.azul.threadopt:type=Time,name=time");
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw new IllegalArgumentException(malformedObjectNameException);
        }
    }

    static TimeMXBeanImpl getInstance() {
        return _instance;
    }

    private TimeMXBeanImpl() {
    }

    @Override
    public long getElapsedTimeSinceJVMStartMillis() {
        return TimeUtils.getUptimeMillis();
    }

    @Override
    public double getElapsedTimeSinceJVMStartSec() {
        return (float)TimeUtils.getUptimeMillis() / 1000.0f;
    }

    @Override
    public String getElapsedTimeSinceJVMStartSecStr() {
        return String.format("%.3f", this.getElapsedTimeSinceJVMStartSec());
    }

    @Override
    public long getUnixTimeOfJVMStartMillis() {
        return TimeUtils.getStartTimeMillis();
    }

    @Override
    public String getUnixTimeOfJVMStartAsDateTimeString() {
        try {
            long l = this.getUnixTimeOfJVMStartMillis();
            Date date = new Date(l);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(_dateTimeFormatString);
            return simpleDateFormat.format(date);
        }
        catch (Exception exception) {
            return "";
        }
    }

    @Override
    public String convertElapsedTimeSinceJVMStartSecToDateTimeString(double d) {
        return this.convertElapsedTimeSinceJVMStartFormattedDateTimeString(d, _dateTimeFormatString);
    }

    @Override
    public String convertElapsedTimeSinceJVMStartSecToYearMonthDayPlusTimeString(double d) {
        return this.convertElapsedTimeSinceJVMStartFormattedDateTimeString(d, _defaultyyyyMMdd_HHmmss_SSSFormatString);
    }

    private String convertElapsedTimeSinceJVMStartFormattedDateTimeString(double d, String string) {
        try {
            if (d < 0.0) {
                d = 0.0;
            }
            long l = this.getUnixTimeOfJVMStartMillis();
            double d2 = (9.223372036854776E18 - (double)l - 1.0) / 1000.0;
            long l2 = l;
            l2 = d > d2 ? Long.MAX_VALUE : (long)(d * 1000.0 + (double)5.0E-4f);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
            Date date = new Date(l + l2);
            return simpleDateFormat.format(date);
        }
        catch (Exception exception) {
            return "";
        }
    }

    @Override
    public boolean setFormatForDateTimeString(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new ManagementPermission("control"));
        }
        if (string != null && string.length() > 2) {
            _dateTimeFormatString = string;
            return true;
        }
        return false;
    }

    @Override
    public boolean setFormatForDateTimeStringToDefaultValue() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new ManagementPermission("control"));
        }
        _dateTimeFormatString = _defaultDateTimeFormatString;
        return true;
    }
}

