/*
 * Decompiled with CFR 0.152.
 */
package com.azul.threadopt;

import com.azul.threadopt.ThreadOpt;
import com.azul.threadopt.mxbeans.ProcessThreadAffinityStatisticsMBean;
import com.azul.threadopt.mxbeans.ThreadIDCPUTimeNameMBean;
import com.azul.threadopt.mxbeans.ThreadOptMXBean;
import java.lang.management.ManagementPermission;
import java.util.List;
import java.util.Map;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class ThreadOptMXBeanImpl
implements ThreadOptMXBean {
    private static final String threadOptMXBeanVersion = "1.0.0";
    private static final ThreadOptMXBeanImpl INSTANCE = new ThreadOptMXBeanImpl();
    private static final String THREADOPT_MXBEAN_DOMAIN_TYPE = "com.azul.threadopt:type=ThreadOpt";

    @Override
    public String getVersion() {
        return threadOptMXBeanVersion;
    }

    public static final ThreadOptMXBeanImpl getInstance() {
        return INSTANCE;
    }

    public static ObjectName getObjectName() {
        try {
            return ObjectName.getInstance("com.azul.threadopt:type=ThreadOpt,name=threadOpt");
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw new IllegalArgumentException(malformedObjectNameException);
        }
    }

    @Override
    public void setLowToHighCPUTimeUseThresholdSecs(int n) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new ManagementPermission("control"));
        }
        if (n < 1) {
            System.err.println("[ThreadOptMXBean] " + System.currentTimeMillis() + " ThreadOptMXBean.lowToHighCPUTimeUseThresholdSecs(int): Value of input parameter is not valid: " + n + " value will remain unchanged");
        } else {
            ThreadOpt threadOpt = ThreadOpt.getInstance();
            if (threadOpt == null) {
                System.err.println("[ThreadOptMXBean] " + System.currentTimeMillis() + " ThreadOptMXBean.lowToHighCPUTimeUseThresholdSecs(int): No running ThreadOpt found");
            } else {
                threadOpt.setLowToHighCPUTimeUseThresholdSecs(n);
            }
        }
    }

    @Override
    public int getLowToHighCPUTimeUseThresholdSecs() {
        ThreadOpt threadOpt = ThreadOpt.getInstance();
        if (threadOpt == null) {
            System.err.println("[ThreadOptMXBean] " + System.currentTimeMillis() + " ThreadOptMXBean.lowToHighCPUTimeUseThresholdSecs(): No running ThreadOpt found");
            return -1;
        }
        return threadOpt.getLowToHighCPUTimeUseThresholdSecs();
    }

    @Override
    public void setTimeIntervalBetweenAffinitySettingsSecs(int n) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new ManagementPermission("control"));
        }
        if (n < 1) {
            System.err.println("[ThreadOptMXBean] " + System.currentTimeMillis() + " ThreadOptMXBean.setTimeIntervalBetweenAffinitySettingsSecs(int): Value of input parameter is not valid: " + n + " value will remain unchanged");
        } else {
            ThreadOpt threadOpt = ThreadOpt.getInstance();
            if (threadOpt == null) {
                System.err.println("[ThreadOptMXBean] " + System.currentTimeMillis() + " ThreadOptMXBean.setTimeIntervalBetweenAffinitySettingsSecs(int): No running ThreadOpt found");
            } else {
                threadOpt.setTimeIntervalBetweenAffinitySettingsSecs(n);
            }
        }
    }

    @Override
    public int getTimeIntervalBetweenAffinitySettingsSecs() {
        ThreadOpt threadOpt = ThreadOpt.getInstance();
        if (threadOpt == null) {
            System.err.println("[ThreadOptMXBean] " + System.currentTimeMillis() + " ThreadOptMXBean.getTimeIntervalBetweenAffinitySettingsSecs(): No running ThreadOpt found");
            return -1;
        }
        return threadOpt.getTimeIntervalBetweenAffinitySettingsSecs();
    }

    @Override
    public void doThreadAffinitySettingsNow() {
        ThreadOpt threadOpt;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new ManagementPermission("control"));
        }
        if ((threadOpt = ThreadOpt.getInstance()) == null) {
            System.err.println("[ThreadOptMXBean] " + System.currentTimeMillis() + " ThreadOptMXBean.getTimeIntervalBetweenAffinitySettingsSecs(): No running ThreadOpt found");
        }
        threadOpt.doThreadAffinitySettingsNow();
    }

    @Override
    public void setAffinitySetToAllCPUThreadsForEveryApplicationThread(boolean bl) {
        ThreadOpt threadOpt;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new ManagementPermission("control"));
        }
        if ((threadOpt = ThreadOpt.getInstance()) == null) {
            System.err.println("[ThreadOptMXBean] " + System.currentTimeMillis() + " ThreadOptMXBean.getTimeIntervalBetweenAffinitySettingsSecs(): No running ThreadOpt found");
        }
        threadOpt.setAffinitySetToAllCPUThreadsForEveryApplicationThread(bl);
    }

    @Override
    public boolean isAffinitySetToAllCPUThreadsForEveryApplicationThread() {
        ThreadOpt threadOpt = ThreadOpt.getInstance();
        if (threadOpt == null) {
            System.err.println("[ThreadOptMXBean] " + System.currentTimeMillis() + " ThreadOptMXBean.getTimeIntervalBetweenAffinitySettingsSecs(): No running ThreadOpt found");
        }
        return threadOpt.isAffinitySetToAllCPUThreadsForEveryApplicationThread();
    }

    @Override
    public void setRegExpThreadNameMatchForcesToLowCPUTime(String string) {
        ThreadOpt threadOpt = ThreadOpt.getInstance();
        threadOpt.setRegExpThreadNameMatchForcesToLowCPU(string);
    }

    @Override
    public String getRegExpThreadNameMatchForcesToLowCPUTime() {
        ThreadOpt threadOpt = ThreadOpt.getInstance();
        return threadOpt.getRegExpThreadNameMatchForcesToLowCPU();
    }

    @Override
    public void setRegExpThreadNameMatchForcesToHighCPUTime(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new ManagementPermission("control"));
        }
        ThreadOpt threadOpt = ThreadOpt.getInstance();
        threadOpt.setRegExpThreadNameMatchForcesToHighCPU(string);
    }

    @Override
    public String getRegExpThreadNameMatchForcesToHighCPUTime() {
        ThreadOpt threadOpt = ThreadOpt.getInstance();
        return threadOpt.getRegExpThreadNameMatchForcesToHighCPU();
    }

    @Override
    public Map<Integer, Integer> getCPUTimeUseForAllThreads() {
        ThreadOpt threadOpt = ThreadOpt.getInstance();
        return threadOpt.getCPUTimeUseForAllThreads();
    }

    @Override
    public List<ThreadIDCPUTimeNameMBean> getCPUTimeUseForAllThreadsList() {
        ThreadOpt threadOpt = ThreadOpt.getInstance();
        return threadOpt.getCPUTimeUseForAllThreadsList();
    }

    @Override
    public List<ProcessThreadAffinityStatisticsMBean> getAffinityStatisticsForAllThreadsList() {
        ThreadOpt threadOpt = ThreadOpt.getInstance();
        return threadOpt.getAffinityStatisticsForAllThreadsList();
    }

    @Override
    public int getThreadsNotRunnning() {
        ThreadOpt threadOpt = ThreadOpt.getInstance();
        return threadOpt.getCPUThreadSetRunning().getNotRunning();
    }

    @Override
    public int getThreadsRunningOnCPUThreadsForLowCPUTimeConsumers() {
        ThreadOpt threadOpt = ThreadOpt.getInstance();
        return threadOpt.getCPUThreadSetRunning().getLowCPUConsumerCPUThreads();
    }

    @Override
    public int getThreadsRunningOnCPUThreadsForHighCPUTimeConsumers() {
        ThreadOpt threadOpt = ThreadOpt.getInstance();
        return threadOpt.getCPUThreadSetRunning().getHighCPUConsumerCPUThreads();
    }

    @Override
    public int getThreadsRunningOnAllCPUThreads() {
        ThreadOpt threadOpt = ThreadOpt.getInstance();
        return threadOpt.getCPUThreadSetRunning().getAllCPUThreads();
    }
}

