/*
 * Decompiled with CFR 0.152.
 */
package com.azul.threadopt;

import com.azul.threadopt.CommandLineOptions;
import com.azul.threadopt.MachineArchitecture;
import com.azul.threadopt.MonitorProcessCPUUse;
import com.azul.threadopt.ProcessThreadAffinityStatisticsMBeanImpl;
import com.azul.threadopt.ProcessThreads;
import com.azul.threadopt.ProcessThreadsCPUUse;
import com.azul.threadopt.ProcessThreadsOnCPUThreads;
import com.azul.threadopt.ThreadIDCPUTimeNameMBeanImpl;
import com.azul.threadopt.ThreadOptMXBeanImpl;
import com.azul.threadopt.TimeMXBeanImpl;
import com.azul.threadopt.Utils;
import com.azul.threadopt.Version;
import com.azul.threadopt.mxbeans.ProcessThreadAffinityStatisticsMBean;
import com.azul.threadopt.mxbeans.ThreadIDCPUTimeNameMBean;
import com.azul.threadopt.mxbeans.TimeMXBean;
import java.io.BufferedWriter;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class ThreadOpt
extends Thread {
    private final boolean verboseOnDefaultValue = false;
    private final boolean verboseDefaultValue = false;
    private final boolean verboseCommandDefaultValue = false;
    private final boolean verboseDisplayThreadsDefaultValue = false;
    private final boolean verboseThreadNameDefaultValue = false;
    private final boolean verboseOptionsCheckDefaultValue = false;
    private final boolean verboseProgressDefaultValue = false;
    private final boolean debugDefaultValue = false;
    private final boolean logDefaultValue = false;
    private final boolean printDetailedInfoDefaultValue = false;
    private final boolean repeatOnCommandLineDefaultValue = false;
    private final boolean testInitializationDefaultValue = false;
    private final boolean useThreadNamesDefaultValue = true;
    private final boolean useThreadNamesSetDefaultValue = false;
    private final boolean useCPUMonitoringDefaultValue = false;
    private final boolean assignAffinityPerPhysicalCoreDefaultValue = false;
    private final boolean assignAffinityPerCPUThreadDefaultValue = false;
    private final boolean assignAffinityPerCPUThreadsOnPhysicalCoreDefaultValue = false;
    private final boolean skipFirstAffinitySettingtDefaultValue = false;
    private final long delayStartTimeMSDefaultValue = 12000L;
    private final int timeIntervalBetweenAffinitySettingsSecsDefaultValue = 60;
    private final int numberOfIterationsDefaultValue = 1;
    private final int lowToHighCPUUseThresholdSecsDefaultValue = 20;
    private boolean verboseOn = false;
    private boolean verbose = false;
    private boolean verboseCommand = false;
    private boolean verboseDisplayThreads = false;
    private boolean verboseThreadName = false;
    private boolean verboseOptionsCheck = false;
    private boolean verboseProgress = false;
    private boolean debug = false;
    private boolean log = false;
    private boolean printDetailedInfo = false;
    private boolean repeatOnCommandLine = false;
    private boolean testInitialization = false;
    private boolean useThreadNames = true;
    private boolean useThreadNamesSet = false;
    private boolean useCPUMonitoring = false;
    private boolean assignAffinityPerPhysicalCore = false;
    private boolean assignAffinityPerCPUThread = false;
    private boolean assignAffinityPerCPUThreadsOnPhysicalCore = false;
    private boolean skipFirstAffinitySetting = false;
    private long delayStartTimeMS = 12000L;
    private int timeIntervalBetweenAffinitySettingsSecs = 60;
    private int numberOfIterations = 1;
    private int lowToHighCPUUseThresholdSecs = 20;
    private static ThreadOpt thisThreadOptInstance = null;
    private boolean printDelayStartMessageDefaultValue;
    private boolean printDelayStartMessage = this.printDelayStartMessageDefaultValue = true;
    private boolean listOfCPUThreadsToUseForLowCPUConsumersAffinityIsProvided = false;
    private boolean listOfCPUThreadsToUseForHighCPUConsumersAffinityIsProvided = false;
    private boolean doThreadAffinitySettingsNow = false;
    private boolean setAffinityToAllCPUThreads = false;
    private boolean setAffinityToAllCPUThreadsMXBeans = false;
    private String logfile = "";
    private String threadRegExpLow = "";
    private String threadRegExpHigh = "";
    private String threadRegExpLowMXBean = "";
    private String threadRegExpHighMXBean = "";
    private int originalNumberOfIterations = 0;
    private String parameterCSVListOfCPUThreadsForLowCPUConsumers = "";
    private String parameterCSVListOfCPUThreadsForHighCPUConsumers = "";
    private List<Integer> parameterArrayListOfCPUThreadsForLowCPUConsumers = null;
    private List<Integer> parameterArrayListOfCPUThreadsForHighCPUConsumers = null;
    private static MachineArchitecture machineArchitecture = null;
    private ProcessThreads processThreads = null;
    private MonitorProcessCPUUse monitorProcessCPUUse = null;
    private Map<Integer, ProcessThreadsOnCPUThreads> threadIDOnCPUThreadSets = new TreeMap<Integer, ProcessThreadsOnCPUThreads>();
    private TimeMXBean timeMXBean = null;
    private CPUThreadSetRunning _cpuThreadSetRunning = new CPUThreadSetRunning();
    private long printPTMTCTHHeader = 0L;
    private static TimeMXBean timeMXBeanSt = TimeMXBeanImpl.getInstance();

    public boolean verboseProgress() {
        return this.verboseProgress;
    }

    static MachineArchitecture getMachineArchitecture() {
        return machineArchitecture;
    }

    public String getParameterCSVListOfCPUThreadsForLowCPUConsumers() {
        return this.parameterCSVListOfCPUThreadsForLowCPUConsumers;
    }

    public String getParameterCSVListOfCPUThreadsForHighCPUConsumers() {
        return this.parameterCSVListOfCPUThreadsForHighCPUConsumers;
    }

    private String getLogLinePrefix() {
        if (this.timeMXBean != null) {
            return this.timeMXBean.getElapsedTimeSinceJVMStartSecStr() + " [ThreadOpt] ";
        }
        return "[ThreadOpt] ";
    }

    public CPUThreadSetRunning getCPUThreadSetRunning() {
        return this._cpuThreadSetRunning;
    }

    private void setCPUThreadSetRunning(CPUThreadSetRunning cPUThreadSetRunning) {
        this._cpuThreadSetRunning = cPUThreadSetRunning;
    }

    private boolean repeatAnotherIteration() {
        return this.repeatOnCommandLine || this.numberOfIterations > 0;
    }

    static ThreadOpt getInstance() {
        return thisThreadOptInstance;
    }

    public void setRegExpThreadNameMatchForcesToLowCPU(String string) {
        this.threadRegExpLowMXBean = string == null ? "" : string;
    }

    public String getRegExpThreadNameMatchForcesToLowCPU() {
        if (this.threadRegExpLowMXBean == null) {
            this.threadRegExpLowMXBean = "";
        }
        return this.threadRegExpLowMXBean;
    }

    public void setRegExpThreadNameMatchForcesToHighCPU(String string) {
        this.threadRegExpHighMXBean = string == null ? "" : string;
    }

    public String getRegExpThreadNameMatchForcesToHighCPU() {
        if (this.threadRegExpHighMXBean == null) {
            this.threadRegExpHighMXBean = "";
        }
        return this.threadRegExpHighMXBean;
    }

    public void setLowToHighCPUTimeUseThresholdSecs(int n) {
        if (n < 0) {
            System.err.println(this.getLogLinePrefix() + "ThreadOpt.lowToHighCPUUseThresholdSecs(int): Value of input parameter is not valid: " + n + " value will remain unchanged: " + this.lowToHighCPUUseThresholdSecs);
        } else {
            this.lowToHighCPUUseThresholdSecs = n;
            if (this.processThreads != null) {
                this.processThreads.setLowToHighCPUUseThresholdSecs(n);
            }
        }
    }

    public int getLowToHighCPUTimeUseThresholdSecsDefaultValue() {
        return 20;
    }

    public int getLowToHighCPUTimeUseThresholdSecs() {
        return this.lowToHighCPUUseThresholdSecs;
    }

    public void setTimeIntervalBetweenAffinitySettingsSecs(int n) {
        if (n < 1) {
            System.err.println(this.getLogLinePrefix() + "ThreadOpt.setTimeIntervalBetweenAffinitySettingsSecs(int): Value of input parameter is not valid: " + n + " value will remain unchanged: " + this.timeIntervalBetweenAffinitySettingsSecs);
        } else {
            this.timeIntervalBetweenAffinitySettingsSecs = n;
        }
    }

    public int getTimeIntervalBetweenAffinitySettingsSecs() {
        return this.timeIntervalBetweenAffinitySettingsSecs;
    }

    public void doThreadAffinitySettingsNow() {
        this.doThreadAffinitySettingsNow = true;
    }

    public void setAffinitySetToAllCPUThreadsForEveryApplicationThread(boolean bl) {
        if (this.setAffinityToAllCPUThreads == bl) {
            return;
        }
        this.setAffinityToAllCPUThreadsMXBeans = bl;
        this.doThreadAffinitySettingsNow = true;
    }

    public boolean isAffinitySetToAllCPUThreadsForEveryApplicationThread() {
        return this.setAffinityToAllCPUThreadsMXBeans;
    }

    public Map<Integer, Integer> getCPUTimeUseForAllThreads() {
        ProcessThreadsCPUUse processThreadsCPUUse = this.processThreads.collectThreadCPUUseInfo();
        if (processThreadsCPUUse == null) {
            return new TreeMap<Integer, Integer>();
        }
        return processThreadsCPUUse.threadCPUUse();
    }

    public List<ThreadIDCPUTimeNameMBean> getCPUTimeUseForAllThreadsList() {
        ArrayList<ThreadIDCPUTimeNameMBean> arrayList = new ArrayList<ThreadIDCPUTimeNameMBean>();
        ProcessThreadsCPUUse processThreadsCPUUse = this.processThreads.collectThreadCPUUseInfo();
        if (processThreadsCPUUse == null) {
            ThreadIDCPUTimeNameMBeanImpl threadIDCPUTimeNameMBeanImpl = new ThreadIDCPUTimeNameMBeanImpl(0, 0, "No thread information available");
            arrayList.add(threadIDCPUTimeNameMBeanImpl);
            return arrayList;
        }
        Map<Integer, Integer> map = processThreadsCPUUse.threadCPUUse();
        if (map == null) {
            ThreadIDCPUTimeNameMBeanImpl threadIDCPUTimeNameMBeanImpl = new ThreadIDCPUTimeNameMBeanImpl(0, 0, "No thread information available");
            arrayList.add(threadIDCPUTimeNameMBeanImpl);
            return arrayList;
        }
        Map<Integer, String> map2 = this.processThreads.getJavaProcessThreadNames();
        for (Integer n : map.keySet()) {
            Integer n2 = map.get(n);
            String string = "";
            if (map2 != null && (string = map2.get(n)) == null) {
                string = "thread-name-not-found-" + n;
            }
            ThreadIDCPUTimeNameMBeanImpl threadIDCPUTimeNameMBeanImpl = new ThreadIDCPUTimeNameMBeanImpl(n, n2, string);
            arrayList.add(threadIDCPUTimeNameMBeanImpl);
        }
        return arrayList;
    }

    public List<ProcessThreadAffinityStatisticsMBean> getAffinityStatisticsForAllThreadsList() {
        ArrayList<ProcessThreadAffinityStatisticsMBean> arrayList = new ArrayList<ProcessThreadAffinityStatisticsMBean>();
        Map<Integer, String> map = this.processThreads.getJavaProcessThreadNames();
        for (Integer n : this.threadIDOnCPUThreadSets.keySet()) {
            ProcessThreadsOnCPUThreads processThreadsOnCPUThreads = this.threadIDOnCPUThreadSets.get(n);
            String string = "";
            if (map != null && (string = map.get(n)) == null) {
                string = "thread-name-not-found-" + n;
            }
            ProcessThreadAffinityStatisticsMBeanImpl processThreadAffinityStatisticsMBeanImpl = new ProcessThreadAffinityStatisticsMBeanImpl(n, processThreadsOnCPUThreads.getOnLowCPUConsumerSet(), processThreadsOnCPUThreads.getOnHighCPUConsumerSet(), processThreadsOnCPUThreads.getOnAllCPUThreads(), processThreadsOnCPUThreads.getTotal(), processThreadsOnCPUThreads.getCurrentCPUThreadSet(), processThreadsOnCPUThreads.getFirstSeenMS(), processThreadsOnCPUThreads.getLastSeenMS(), string);
            arrayList.add(processThreadAffinityStatisticsMBeanImpl);
        }
        return arrayList;
    }

    public void printProcessThreadToCPUThreads(BufferedWriter bufferedWriter) {
        if (bufferedWriter == null) {
            return;
        }
        try {
            if (this.printPTMTCTHHeader++ % 10L == 0L) {
                bufferedWriter.write("[ThreadOptPTMTCTH: ElapsedTimeMillis threadID firstSeenSec lastSeenSec notRunningSet onLowCPUConsumerSet onHighCPUConsumerSet onAllCPUThreads totaOnRunning@currentCPUThreadSet ]\n");
            }
            long l = System.currentTimeMillis();
            long l2 = l - this.timeMXBean.getUnixTimeOfJVMStartMillis();
            for (Integer n : this.threadIDOnCPUThreadSets.keySet()) {
                ProcessThreadsOnCPUThreads processThreadsOnCPUThreads = this.threadIDOnCPUThreadSets.get(n);
                bufferedWriter.write("[ThreadOptPTMTCT: " + l2 + " " + n + " " + processThreadsOnCPUThreads.toString() + " ]\n");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void checkForNonRunningThreads(long l) {
        for (Integer n : this.threadIDOnCPUThreadSets.keySet()) {
            ProcessThreadsOnCPUThreads processThreadsOnCPUThreads = this.threadIDOnCPUThreadSets.get(n);
            if (processThreadsOnCPUThreads.getLastSeenMS() == l) continue;
            processThreadsOnCPUThreads.notRunningSet();
            this._cpuThreadSetRunning.addOneThreadNotRunning();
        }
    }

    private void setThreadAffinityToAllCPUThreads(int n, String string, Map<Integer, String> map, String string2, long l) {
        Object object;
        if (this.verboseOn || this.verbose) {
            object = "";
            if (map != null && (object = map.get(n)) == null) {
                object = "thread-name-not-found-" + n;
            }
            System.out.println(string2 + n + " Name: " + (String)object + " CPU threads: " + string);
        }
        object = new ArrayList();
        Utils.runACommand("taskset -pc " + string + " " + n, (List<String>)object);
        ProcessThreadsOnCPUThreads processThreadsOnCPUThreads = this.threadIDOnCPUThreadSets.get(n);
        if (processThreadsOnCPUThreads == null) {
            processThreadsOnCPUThreads = new ProcessThreadsOnCPUThreads();
            this.threadIDOnCPUThreadSets.put(n, processThreadsOnCPUThreads);
        }
        processThreadsOnCPUThreads.runningOnAllCPUThreads(l);
    }

    private synchronized void setThreadAffinities(List<Integer> list, List<Integer> list2, Map<Integer, String> map) {
        int n;
        String string = "";
        String string2 = "";
        List<Integer> list3 = null;
        List<Integer> list4 = null;
        CPUThreadSetRunning cPUThreadSetRunning = new CPUThreadSetRunning();
        String string3 = machineArchitecture.getCSVListOfAllCPUThreads();
        if (this.listOfCPUThreadsToUseForLowCPUConsumersAffinityIsProvided && this.listOfCPUThreadsToUseForHighCPUConsumersAffinityIsProvided) {
            string = this.parameterCSVListOfCPUThreadsForLowCPUConsumers;
            string2 = this.parameterCSVListOfCPUThreadsForHighCPUConsumers;
            list3 = this.parameterArrayListOfCPUThreadsForHighCPUConsumers;
            this.assignAffinityPerPhysicalCore = false;
            list4 = new ArrayList<Integer>();
        } else {
            string = machineArchitecture.getCSVListOfCPUThreadsForLowCPUConsumers();
            string2 = machineArchitecture.getCSVListOfCPUThreadsForHighCPUConsumers();
            list3 = machineArchitecture.getArrayOfCPUThreadsForHighCPUConsumers();
            list4 = machineArchitecture.getArrayOfCPUCoresForHighCPUConsumers();
        }
        if (list == null || list2 == null) {
            if (this.verbose) {
                System.out.println(this.getLogLinePrefix() + "setThreadAffinities: Low and high CPU consuming application thread lists are null");
            }
            return;
        }
        long l = System.currentTimeMillis();
        if (this.setAffinityToAllCPUThreads || list == null || list2 == null || list.size() < 1 || list2.size() < 1 || list3.size() < 1) {
            int n2;
            int n3;
            String string4 = this.getLogLinePrefix() + "Set affinity all: ";
            ArrayList arrayList = new ArrayList();
            for (n3 = 0; n3 < list.size(); ++n3) {
                n2 = list.get(n3);
                this.setThreadAffinityToAllCPUThreads(n2, string3, map, string4, l);
                cPUThreadSetRunning.addOneThreadRunningInAllCPUThreads();
            }
            for (n3 = 0; n3 < list2.size(); ++n3) {
                n2 = list2.get(n3);
                this.setThreadAffinityToAllCPUThreads(n2, string3, map, string4, l);
                cPUThreadSetRunning.addOneThreadRunningInAllCPUThreads();
            }
            this.setCPUThreadSetRunning(cPUThreadSetRunning);
            this.checkForNonRunningThreads(l);
            if (this.verboseOn || this.verbose) {
                System.out.println(this.getLogLinePrefix() + "Finished with tasksetting process's threads");
            }
            return;
        }
        String string5 = this.getLogLinePrefix() + "Set affinity low: ";
        for (int i = 0; i < list.size(); ++i) {
            Object object;
            n = list.get(i);
            if (this.verboseOn || this.verbose) {
                object = "";
                if (map != null && (object = map.get(n)) == null) {
                    object = "thread-name-not-found-" + n;
                }
                System.out.println(string5 + n + " Name: " + (String)object + " CPU threads: " + string);
            }
            object = new ArrayList();
            Utils.runACommand("taskset -pc " + string + " " + n, (List<String>)object);
            ProcessThreadsOnCPUThreads processThreadsOnCPUThreads = this.threadIDOnCPUThreadSets.get(n);
            if (processThreadsOnCPUThreads == null) {
                processThreadsOnCPUThreads = new ProcessThreadsOnCPUThreads();
                this.threadIDOnCPUThreadSets.put(n, processThreadsOnCPUThreads);
            }
            processThreadsOnCPUThreads.runningOnLowCPUConsumerSet(l);
            cPUThreadSetRunning.addOneThreadRunningInLowCPUConsumerCPUThreads();
        }
        String string6 = this.getLogLinePrefix() + "Set affinity high: ";
        n = 0;
        for (int i = 0; i < list2.size(); ++i) {
            Object object;
            int n4 = list2.get(i);
            String string7 = "";
            ProcessThreadsOnCPUThreads processThreadsOnCPUThreads = this.threadIDOnCPUThreadSets.get(n4);
            if (processThreadsOnCPUThreads == null) {
                processThreadsOnCPUThreads = new ProcessThreadsOnCPUThreads();
                this.threadIDOnCPUThreadSets.put(n4, processThreadsOnCPUThreads);
            }
            processThreadsOnCPUThreads.runningOnHighCPUConsumerSet(l);
            cPUThreadSetRunning.addOneThreadRunningInHighCPUConsumerCPUThreads();
            if (!(this.assignAffinityPerCPUThread || this.assignAffinityPerPhysicalCore || this.assignAffinityPerCPUThreadsOnPhysicalCore)) {
                object = new ArrayList<String>();
                Utils.runACommand("taskset -pc " + string2 + " " + n4, object);
                string7 = string2;
            } else if (this.assignAffinityPerCPUThread && list3.size() > 0) {
                if (n > list3.size() - 1) {
                    n = 0;
                }
                if (this.verbose) {
                    System.out.println(this.getLogLinePrefix() + "assignAffinityPerCPUThread: affinity for thread: " + n4 + " is: " + list3.get(n));
                }
                object = new ArrayList();
                Utils.runACommand("taskset -pc " + list3.get(n) + " " + n4, (List<String>)object);
                string7 = list3.get(n).toString();
                ++n;
            } else if (this.assignAffinityPerPhysicalCore && list4.size() > 0) {
                if (n > list4.size() - 1) {
                    n = 0;
                }
                if (this.verbose) {
                    System.out.println(this.getLogLinePrefix() + "assignAffinityPerPhysicalCore: affinity for thread: " + n4 + " is: " + list4.get(n));
                }
                object = new ArrayList();
                Utils.runACommand("taskset -pc " + list4.get(n) + " " + n4, (List<String>)object);
                string7 = list4.get(n).toString();
                ++n;
            } else if (this.assignAffinityPerCPUThreadsOnPhysicalCore && list4.size() > 0) {
                if (n > list4.size() - 1) {
                    n = 0;
                }
                object = machineArchitecture.physicalCoreToCPUThreadsRunningOnCore(list4.get(n));
                String string8 = "";
                Object object2 = object.iterator();
                while (object2.hasNext()) {
                    Integer n5 = (Integer)object2.next();
                    if (string8.length() > 0) {
                        string8 = string8 + "," + n5;
                        continue;
                    }
                    string8 = n5.toString();
                }
                if (this.verbose) {
                    System.out.println(this.getLogLinePrefix() + "assignAffinityPerCPUThreadsOnPhysicalCore: affinity for thread: " + n4 + " is: " + string8);
                }
                object2 = new ArrayList();
                Utils.runACommand("taskset -pc " + string8 + " " + n4, (List<String>)object2);
                string7 = string8;
                ++n;
            } else {
                System.err.println(this.getLogLinePrefix() + "ERROR: Options not correctly processed - needs investigation");
            }
            if (!this.verboseOn && !this.verbose) continue;
            object = "";
            if (map != null && (object = map.get(n4)) == null) {
                object = "thread-name-not-found-" + n4;
            }
            System.out.println(string6 + n4 + " Name: " + (String)object + " CPU threads: " + string7);
        }
        this.setCPUThreadSetRunning(cPUThreadSetRunning);
        this.checkForNonRunningThreads(l);
        if (this.verboseOn || this.verbose) {
            System.out.println(this.getLogLinePrefix() + "Finished with tasksetting process's threads");
        }
    }

    private void addRegExpMatchingNameToLowCPUList(List<Integer> list, List<Integer> list2, Map<Integer, String> map) {
        if (this.verbose) {
            System.out.println(this.getLogLinePrefix() + "Use a regular expression pattern that matches the application thread's name to set affinity to low");
        }
        String string = this.threadRegExpLow;
        for (int n : map.keySet()) {
            String string2 = map.get(n);
            if (this.verboseThreadName) {
                System.out.println(this.getLogLinePrefix() + "addRegExpMatchingNameToLowCPUList: Seaching for match for regular expression to move to low: " + string + " in candidate: " + string2);
            }
            try {
                if (!string2.matches(string)) continue;
                Integer n2 = new Integer(n);
                if (!list.contains(n2)) {
                    list.add(n2);
                }
                if (list2.contains(n2)) {
                    list2.remove(n2);
                }
                if (!this.verbose) continue;
                System.out.println(this.getLogLinePrefix() + "addRegExpMatchingNameToLowCPUList: Match found for (to low): " + string + " Thread id: " + n + " name: " + string2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void addRegExpMatchingNameToHighCPUList(List<Integer> list, List<Integer> list2, Map<Integer, String> map) {
        if (this.verbose) {
            System.out.println(this.getLogLinePrefix() + "Use a regular expression pattern that matches the application thread's name to set affinity to high");
        }
        String string = this.threadRegExpHigh;
        for (int n : map.keySet()) {
            String string2 = map.get(n);
            if (this.verboseThreadName) {
                System.out.println(this.getLogLinePrefix() + "addRegExpMatchingNameToHighCPUList: Seaching for match for regular expression to move to high: " + string + " in candidate: " + string2);
            }
            try {
                if (!string2.matches(string)) continue;
                Integer n2 = new Integer(n);
                if (!list2.contains(n2)) {
                    list2.add(n2);
                }
                if (list.contains(n2)) {
                    list.remove(n2);
                }
                if (!this.verbose) continue;
                System.out.println(this.getLogLinePrefix() + "addRegExpMatchingNameToHighCPUList: Match found for (to high): " + string + " Thread id: " + n + " name: " + string2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public boolean testInitializationOnly() {
        return this.testInitialization;
    }

    private void processOptions(String string) {
        String[] stringArray = null;
        if (string != null && string.length() > 0) {
            stringArray = string.split("\\s+|%");
        }
        this.processOptions(stringArray);
    }

    private void processOptions(String[] stringArray) {
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        CommandLineOptions commandLineOptions = CommandLineOptions.getInstance();
        if (!commandLineOptions.isCommandLineOptionsInitialized()) {
            commandLineOptions.initializeCommandLineOptions(stringArray);
        }
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                block102: {
                    Integer n;
                    String string;
                    int n2;
                    boolean bl4;
                    String[] stringArray2;
                    ArrayList<Integer> arrayList;
                    Object object;
                    String string2 = stringArray[i].toLowerCase();
                    if (string2.matches("^low=.*")) {
                        bl2 = true;
                        object = string2.substring(4).trim();
                        arrayList = new ArrayList<Integer>();
                        if (((String)object).length() > 0) {
                            stringArray2 = ((String)object).split(",");
                            bl4 = true;
                            for (n2 = 0; n2 < stringArray2.length; ++n2) {
                                string = stringArray2[n2];
                                try {
                                    n = Integer.parseInt(string);
                                    if (!string.matches("\\d+")) {
                                        bl4 = false;
                                        commandLineOptions.processedOptionHasError(string2, "Non-numeric value found: >" + stringArray2[n2] + "<");
                                        continue;
                                    }
                                    if (machineArchitecture == null) {
                                        bl4 = false;
                                        commandLineOptions.processedOptionHasError(string2, "Incorrect initialization sequence in ThreadOpt - please contact support for a version of ThreadOpt with a fix. Try using other options with this version.");
                                        continue;
                                    }
                                    if (!machineArchitecture.isCPUThreadInArrayOfAllCPUThreads(n)) {
                                        bl4 = false;
                                        commandLineOptions.processedOptionHasError(string2, "< Value provided: >" + stringArray2[n2] + "< is not in the set of all CPU threads: " + machineArchitecture.getCSVListOfAllCPUThreads());
                                        continue;
                                    }
                                    arrayList.add(n);
                                    continue;
                                }
                                catch (Exception exception) {
                                    bl4 = false;
                                    commandLineOptions.processedOptionHasError(string2, "Non-numeric value found: >" + stringArray2[n2] + "<");
                                }
                            }
                            if (bl4) {
                                this.parameterCSVListOfCPUThreadsForLowCPUConsumers = object;
                                this.parameterArrayListOfCPUThreadsForLowCPUConsumers = arrayList;
                                this.listOfCPUThreadsToUseForLowCPUConsumersAffinityIsProvided = true;
                                this.assignAffinityPerPhysicalCore = false;
                                this.assignAffinityPerCPUThread = false;
                                this.assignAffinityPerCPUThreadsOnPhysicalCore = false;
                                commandLineOptions.processedOption(string2);
                            }
                        } else {
                            commandLineOptions.processedOptionHasError(string2, "Processing option: >" + string2 + "< Required list of comma-separated values representing CPU threads identifiers not found.");
                        }
                    } else if (string2.matches("^high=.*")) {
                        bl2 = true;
                        object = string2.substring(5).trim();
                        arrayList = new ArrayList();
                        if (((String)object).length() > 0) {
                            stringArray2 = ((String)object).split(",");
                            bl4 = true;
                            for (n2 = 0; n2 < stringArray2.length; ++n2) {
                                string = stringArray2[n2];
                                try {
                                    n = Integer.parseInt(string);
                                    if (!string.matches("\\d+")) {
                                        bl4 = false;
                                        commandLineOptions.processedOptionHasError(string2, "Non-numeric value found: >" + stringArray2[n2] + "<");
                                        continue;
                                    }
                                    if (machineArchitecture == null) {
                                        bl4 = false;
                                        commandLineOptions.processedOptionHasError(string2, "Incorrect initialization sequence in ThreadOpt - please contact support for a version of ThreadOpt with a fix. Try using other options with this version.");
                                        continue;
                                    }
                                    if (!machineArchitecture.isCPUThreadInArrayOfAllCPUThreads(n)) {
                                        bl4 = false;
                                        commandLineOptions.processedOptionHasError(string2, "< Value provided: >" + stringArray2[n2] + "< is not in the set of all CPU threads: " + machineArchitecture.getCSVListOfAllCPUThreads());
                                        continue;
                                    }
                                    arrayList.add(n);
                                    continue;
                                }
                                catch (Exception exception) {
                                    bl4 = false;
                                    commandLineOptions.processedOptionHasError(string2, "Non-numeric value found: >" + stringArray2[n2] + "<");
                                }
                            }
                            if (bl4) {
                                this.parameterCSVListOfCPUThreadsForHighCPUConsumers = object;
                                this.parameterArrayListOfCPUThreadsForHighCPUConsumers = arrayList;
                                this.listOfCPUThreadsToUseForHighCPUConsumersAffinityIsProvided = true;
                                this.assignAffinityPerPhysicalCore = false;
                                this.assignAffinityPerCPUThread = false;
                                this.assignAffinityPerCPUThreadsOnPhysicalCore = false;
                                commandLineOptions.processedOption(string2);
                            }
                        } else {
                            commandLineOptions.processedOptionHasError(string2, "Processing option: >" + string2 + "< Required list of comma-separated values representing CPU threads identifiers not found.");
                        }
                    } else if (string2.matches("^usethreadnames=.*")) {
                        object = string2.substring(15);
                        this.useThreadNames = commandLineOptions.checkBooleanValue(string2, (String)object);
                    } else if (string2.matches("^threadregexplow=.*")) {
                        this.threadRegExpLow = stringArray[i].substring(16);
                        if (this.verbose || this.verboseOn) {
                            System.out.println(this.getLogLinePrefix() + "Found parameter: " + stringArray[i] + " regular expression: " + this.threadRegExpLow);
                        }
                        if (this.threadRegExpLow == null || this.threadRegExpLow.length() == 0) {
                            commandLineOptions.processedOptionHasError(string2, "Invalid value specified for regular expression");
                        } else {
                            commandLineOptions.processedOption(string2);
                        }
                    } else if (string2.matches("^threadregexphigh=.*")) {
                        this.threadRegExpHigh = stringArray[i].substring(17);
                        if (this.verbose || this.verboseOn) {
                            System.out.println(this.getLogLinePrefix() + "Found parameter: " + stringArray[i] + " regular expression: " + this.threadRegExpHigh);
                        }
                        if (this.threadRegExpHigh == null || this.threadRegExpHigh.length() == 0) {
                            commandLineOptions.processedOptionHasError(string2, "Invalid value specified for regular expression");
                        } else {
                            commandLineOptions.processedOption(string2);
                        }
                    } else if (string2.matches("^affinitypercore")) {
                        bl3 = true;
                        this.assignAffinityPerPhysicalCore = true;
                        this.assignAffinityPerCPUThread = false;
                        this.assignAffinityPerCPUThreadsOnPhysicalCore = false;
                        this.parameterCSVListOfCPUThreadsForLowCPUConsumers = "";
                        this.parameterCSVListOfCPUThreadsForHighCPUConsumers = "";
                        this.parameterArrayListOfCPUThreadsForLowCPUConsumers = null;
                        this.parameterArrayListOfCPUThreadsForHighCPUConsumers = null;
                        commandLineOptions.processedOption(string2);
                    } else if (string2.matches("^affinitypercputhread")) {
                        bl3 = true;
                        this.assignAffinityPerPhysicalCore = false;
                        this.assignAffinityPerCPUThread = true;
                        this.assignAffinityPerCPUThreadsOnPhysicalCore = false;
                        this.parameterCSVListOfCPUThreadsForLowCPUConsumers = "";
                        this.parameterCSVListOfCPUThreadsForHighCPUConsumers = "";
                        this.parameterArrayListOfCPUThreadsForLowCPUConsumers = null;
                        this.parameterArrayListOfCPUThreadsForHighCPUConsumers = null;
                        commandLineOptions.processedOption(string2);
                    } else if (string2.matches("^affinitypercputhreadsonphysicalcore")) {
                        bl3 = true;
                        this.assignAffinityPerPhysicalCore = false;
                        this.assignAffinityPerCPUThread = false;
                        this.assignAffinityPerCPUThreadsOnPhysicalCore = true;
                        this.parameterCSVListOfCPUThreadsForLowCPUConsumers = "";
                        this.parameterCSVListOfCPUThreadsForHighCPUConsumers = "";
                        this.parameterArrayListOfCPUThreadsForLowCPUConsumers = null;
                        this.parameterArrayListOfCPUThreadsForHighCPUConsumers = null;
                        commandLineOptions.processedOption(string2);
                    } else if (string2.matches("^threshsecs=\\d+")) {
                        try {
                            object = Integer.parseInt(string2.substring(11));
                            if (object == null || (Integer)object < 0) {
                                commandLineOptions.processedOptionHasError(string2, "Invalid value for threshsecs (low to high CPU time use threshold secs): " + object + " Value must be greater than or equal to 0.");
                                break block102;
                            }
                            this.lowToHighCPUUseThresholdSecs = (Integer)object;
                            commandLineOptions.processedOption(string2);
                        }
                        catch (Exception exception) {
                            commandLineOptions.processedOptionHasError(string2, "Non-numeric value found: >" + string2.substring(11) + "<");
                        }
                    } else if (string2.matches("^r")) {
                        this.repeatOnCommandLine = true;
                        commandLineOptions.processedOption(string2);
                    } else if (string2.matches("^i=.*")) {
                        try {
                            object = Integer.parseInt(string2.substring(2));
                            if (object == null || (Integer)object < 1) {
                                commandLineOptions.processedOptionHasError(string2, "Invalid value for i (number of iterations): " + object + " Value must be greater than 0.");
                                break block102;
                            }
                            this.numberOfIterations = (Integer)object;
                            commandLineOptions.processedOption(string2);
                        }
                        catch (Exception exception) {
                            commandLineOptions.processedOptionHasError(string2, "Non-numeric value found: >" + string2.substring(2) + "<");
                        }
                    } else if (string2.matches("^tibas=.*")) {
                        try {
                            object = Integer.parseInt(string2.substring(6));
                            if (object == null || (Integer)object < 1) {
                                commandLineOptions.processedOptionHasError(string2, "Invalid value for tibas (time interval between affinity settings): " + object + " Value must be greater than 0.");
                                break block102;
                            }
                            this.timeIntervalBetweenAffinitySettingsSecs = (Integer)object;
                            commandLineOptions.processedOption(string2);
                        }
                        catch (Exception exception) {
                            commandLineOptions.processedOptionHasError(string2, "Non-numeric value found: >" + string2.substring(6) + "<");
                        }
                    } else if (string2.matches("^skipfirstaffinitysetting")) {
                        this.skipFirstAffinitySetting = true;
                        commandLineOptions.processedOption(string2);
                    } else if (string2.matches("^dtodate=.*")) {
                        object = string2.substring(8);
                        this.delayStartTimeMS = commandLineOptions.dateAndTimeToMilliseconds(string2, (String)object);
                    } else if (string2.matches("^dhms=.*")) {
                        object = string2.substring(5);
                        this.delayStartTimeMS = commandLineOptions.hoursMinutesSecondsToMilliseconds(string2, (String)object);
                    } else if (string2.matches("^delaysecs=.*")) {
                        object = string2.substring(10);
                        this.delayStartTimeMS = commandLineOptions.stringFloatInSecondsToMilliseconds(string2, (String)object);
                    } else if (string2.matches("^moncpuuse")) {
                        this.useCPUMonitoring = true;
                        commandLineOptions.processedOption(string2);
                    } else if (string2.matches("^voc")) {
                        this.verboseOptionsCheck = true;
                        commandLineOptions.processedOption(string2);
                    } else if (string2.matches("^vtn")) {
                        this.verboseThreadName = true;
                        commandLineOptions.processedOption(string2);
                    } else if (string2.matches("^vdt")) {
                        this.verboseDisplayThreads = true;
                        commandLineOptions.processedOption(string2);
                    } else if (string2.matches("^vc")) {
                        this.verboseCommand = true;
                        commandLineOptions.processedOption(string2);
                    } else if (string2.matches("^verbose=.*")) {
                        object = string2.substring(8);
                        this.verboseOn = commandLineOptions.checkBooleanValue(string2, (String)object);
                    } else if (string2.matches("^v")) {
                        this.verbose = true;
                        commandLineOptions.processedOption(string2);
                    } else if (string2.matches("^vp")) {
                        this.verboseProgress = true;
                        commandLineOptions.processedOption(string2);
                    } else if (string2.matches("^vprogress")) {
                        this.verboseProgress = true;
                        commandLineOptions.processedOption(string2);
                    } else if (string2.matches("^details")) {
                        this.printDetailedInfo = true;
                        commandLineOptions.processedOption(string2);
                    } else if (string2.matches("^debug")) {
                        this.debug = true;
                        commandLineOptions.processedOption(string2);
                    } else if (string2.matches("^log")) {
                        this.log = true;
                        commandLineOptions.processedOption(string2);
                    } else if (string2.matches("^logfile")) {
                        this.logfile = "threadOpt.log";
                        System.out.println(this.getLogLinePrefix() + "LOG p " + stringArray[i].substring(1) + " Log " + this.logfile);
                        commandLineOptions.processedOption(string2);
                    } else if (string2.matches("^testinitialization")) {
                        this.testInitialization = true;
                        this.verbose = true;
                        commandLineOptions.processedOption(string2);
                    }
                }
                if (!this.verboseOn && !this.verbose) continue;
                if (bl) {
                    bl = false;
                    System.out.println(this.getLogLinePrefix() + "Process ThreadOpt options");
                }
                System.out.println(this.getLogLinePrefix() + "Option to ThreadOpt (TO): " + i + " = " + stringArray[i]);
            }
        }
        this.originalNumberOfIterations = this.numberOfIterations;
        if (this.verboseOn || this.verbose) {
            this.verboseProgress = true;
        }
        if (this.listOfCPUThreadsToUseForLowCPUConsumersAffinityIsProvided && !this.listOfCPUThreadsToUseForHighCPUConsumersAffinityIsProvided || !this.listOfCPUThreadsToUseForLowCPUConsumersAffinityIsProvided && this.listOfCPUThreadsToUseForHighCPUConsumersAffinityIsProvided) {
            this.parameterCSVListOfCPUThreadsForLowCPUConsumers = "";
            this.parameterCSVListOfCPUThreadsForHighCPUConsumers = "";
            this.parameterArrayListOfCPUThreadsForLowCPUConsumers = null;
            this.parameterArrayListOfCPUThreadsForHighCPUConsumers = null;
            commandLineOptions.processedOptionHasError("low= and high=", "If one option is specified then both options must be specified and no AffinityPer* option can be specified.");
        }
        if (bl2 && bl3) {
            commandLineOptions.processedOptionHasError("\"low= and high=\" and AffinityPer*", "Command line options \"low= and high=\" cannot be used together with AffinityPer* options.");
        }
        if (!this.listOfCPUThreadsToUseForLowCPUConsumersAffinityIsProvided && !this.listOfCPUThreadsToUseForHighCPUConsumersAffinityIsProvided) {
            this.parameterCSVListOfCPUThreadsForLowCPUConsumers = "";
            this.parameterCSVListOfCPUThreadsForHighCPUConsumers = "";
            this.parameterArrayListOfCPUThreadsForLowCPUConsumers = null;
            this.parameterArrayListOfCPUThreadsForHighCPUConsumers = null;
        }
        if (this.verboseOn || this.verbose) {
            String string = this.getLogLinePrefix() + "Options and internal variables settings: ";
            System.out.println(string + "Verbose [" + false + "] (v): " + this.verbose);
            if (this.verboseOptionsCheck) {
                System.out.println(string + "Print detailed info [" + false + "] (details): " + this.printDetailedInfo);
                System.out.println(string + "Debug info printing [" + false + "] (debug): " + this.debug);
                System.out.println(string + "Initialize and exit [" + false + "] (testinitialization): " + this.testInitialization);
                System.out.println(string + "Logging on [" + false + "] (log): " + this.log);
                System.out.println(string + "Logfile name []: " + this.logfile);
                System.out.println(string + "Print delay message at start of ThreadOpt work [" + this.printDelayStartMessageDefaultValue + "]: " + this.printDelayStartMessage);
            }
            System.out.println(string + "Delay start time [" + 12.0f + "] seconds (delaysecs=<float>): " + (float)this.delayStartTimeMS / 1000.0f);
            System.out.println(string + "Single Snapshot: Low to high thread CPU use threshold [" + 20 + "] seconds (threshsecs=<int>): " + this.lowToHighCPUUseThresholdSecs);
            System.out.println(string + "Repeat indefinitely [" + false + "] (r): " + this.repeatOnCommandLine);
            System.out.println(string + "Number of iterations to repeat [" + 1 + "] (i=<int>): " + this.numberOfIterations);
            System.out.println(string + "Time interval between affinity settings[" + 60 + "] seconds (tibas=<int>): " + this.timeIntervalBetweenAffinitySettingsSecs);
            System.out.println(string + "Assign affinity to high CPU consuming set of physical CPU cores [" + false + "] (affinitypercore): " + this.assignAffinityPerPhysicalCore);
            System.out.println(string + "Assign affinity to high CPU consuming set of CPU threads [" + false + "] (affinitypercputhread: " + this.assignAffinityPerCPUThread);
            System.out.println(string + "Assign affinity to high CPU consuming set of CPU threads on a single physical core [" + false + "] (affinitypercputhreadsonphysicalcore): " + this.assignAffinityPerCPUThreadsOnPhysicalCore);
            System.out.println(string + "Use thread names (requires access to jstack in java.home/../bin) [" + true + "] (usethreadnames=<true|false>): " + this.useThreadNames);
            System.out.println(string + "Use application thread CPU use monitoring to make affinity decisions [" + false + "] (moncpuuse): " + this.useCPUMonitoring);
            System.out.println(string + "Use regular expression to force named threads that match to low CPU time set [\"\"] (threadRegExpLow): " + this.threadRegExpLow);
            System.out.println(string + "Use regular expression to force named threads that match to high CPU time set [\"\"] (threadRegExpHigh): " + this.threadRegExpHigh);
        }
    }

    private void doThreadAffinitySetting() {
        if (this.verboseProgress) {
            System.out.println(this.getLogLinePrefix() + "Starting phase to set application threads' affinities");
        }
        if (this.repeatAnotherIteration() && Utils.userHasIndicatedThreadOptShouldExit()) {
            return;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        if (!this.useCPUMonitoring) {
            this.processThreads.constructListsOfHighAndLowCPUConsumingAppThreadsBasedOnThreshold(arrayList, arrayList2);
        } else {
            this.monitorProcessCPUUse.constructListsOfLowCPUAndHighCPUConsumingAppThreads(arrayList, arrayList2);
        }
        if ((arrayList == null || arrayList2 == null) && this.verbose) {
            System.out.println(this.getLogLinePrefix() + "setThreadAffinities: Low and high CPU consuming application thread lists are null");
        }
        Map<Integer, String> map = null;
        if (this.useThreadNames || this.threadRegExpLow.length() > 0 || this.threadRegExpHigh.length() > 0) {
            map = this.processThreads.getJavaProcessThreadNames();
            if (this.threadRegExpLow.length() > 0) {
                this.addRegExpMatchingNameToLowCPUList(arrayList, arrayList2, map);
            }
            if (this.threadRegExpHigh.length() > 0) {
                this.addRegExpMatchingNameToHighCPUList(arrayList, arrayList2, map);
            }
        }
        this.setThreadAffinities(arrayList, arrayList2, map);
        Utils.printDetailedThreadStatusInfo();
    }

    @Override
    public void run() {
        if (this.timeIntervalBetweenAffinitySettingsSecs < 1) {
            this.timeIntervalBetweenAffinitySettingsSecs = 1;
        }
        long l = this.timeIntervalBetweenAffinitySettingsSecs;
        if (this.skipFirstAffinitySetting) {
            l = 0L;
        }
        while (true) {
            if (!Thread.currentThread().isDaemon()) {
                continue;
            }
            if (this.printDelayStartMessage && this.delayStartTimeMS > 0L) {
                if (this.verboseProgress) {
                    System.out.println(this.getLogLinePrefix() + "Delaying setting application threads' affinities for " + this.delayStartTimeMS + " ms");
                }
                try {
                    Thread.sleep(this.delayStartTimeMS);
                }
                catch (InterruptedException interruptedException) {
                    System.err.println(this.getLogLinePrefix() + "Interrupt during delay time of: " + this.delayStartTimeMS + " ms during start-up");
                }
                this.printDelayStartMessage = false;
            }
            this.threadRegExpLow = this.threadRegExpLowMXBean;
            this.threadRegExpHigh = this.threadRegExpHighMXBean;
            if (l >= (long)this.timeIntervalBetweenAffinitySettingsSecs || this.doThreadAffinitySettingsNow) {
                long l2;
                l = 0L;
                if (this.doThreadAffinitySettingsNow) {
                    this.doThreadAffinitySettingsNow = false;
                    this.setAffinityToAllCPUThreads = this.setAffinityToAllCPUThreadsMXBeans;
                }
                this.doThreadAffinitySetting();
                if (!this.repeatAnotherIteration()) {
                    if (!this.verboseProgress) break;
                    System.out.println(this.getLogLinePrefix() + "ThreadOpt has completed its work and its thread will exit");
                    break;
                }
                --this.numberOfIterations;
                if (!this.repeatAnotherIteration()) {
                    if (!this.verboseProgress) break;
                    System.out.println(this.getLogLinePrefix() + "Maximum number of user-specified iterations (" + this.originalNumberOfIterations + ") reached. ThreadOpt has completed its work and its thread will exit");
                    break;
                }
                if (this.repeatOnCommandLine) {
                    if (this.verboseProgress) {
                        if (this.useCPUMonitoring) {
                            int n = 0;
                            l2 = 0L;
                            if (this.monitorProcessCPUUse != null) {
                                n = this.monitorProcessCPUUse.getLowToHighPercentCPUTimeUseThreshold();
                                l2 = this.monitorProcessCPUUse.getMostRecentlyCalculatedThresholdForLowToHighSecs();
                            }
                            System.out.println(this.getLogLinePrefix() + "Will repeat evaluation and assignent of affinities in: " + this.timeIntervalBetweenAffinitySettingsSecs + " seconds with CPU time use threshold: " + n + " percent, " + (l2 == 0L ? "(not yet calculated)" : Long.valueOf(l2)) + " seconds, repeating indefinitely");
                        } else {
                            System.out.println(this.getLogLinePrefix() + "Will repeat evaluation and assignent of affinities in: " + this.timeIntervalBetweenAffinitySettingsSecs + " seconds with elapsed CPU time threshold: " + this.lowToHighCPUUseThresholdSecs + " seconds, repeating indefinitely");
                        }
                    }
                } else if (this.verboseProgress) {
                    if (this.useCPUMonitoring) {
                        int n = 0;
                        l2 = 0L;
                        if (this.monitorProcessCPUUse != null) {
                            n = this.monitorProcessCPUUse.getLowToHighPercentCPUTimeUseThreshold();
                            l2 = this.monitorProcessCPUUse.getMostRecentlyCalculatedThresholdForLowToHighSecs();
                        }
                        System.out.println(this.getLogLinePrefix() + "Will repeat evaluation and assignent of affinities in: " + this.timeIntervalBetweenAffinitySettingsSecs + " seconds with CPU time use threshold: " + n + " percent, " + (l2 == 0L ? "(not yet calculated)" : Long.valueOf(l2)) + " seconds with remaining number of iterations: " + this.numberOfIterations);
                    } else {
                        System.out.println(this.getLogLinePrefix() + "Will repeat evaluation and assignment of affinities in: " + this.timeIntervalBetweenAffinitySettingsSecs + " seconds with elapsed CPU time threshold: " + this.lowToHighCPUUseThresholdSecs + " seconds with remaining number of iterations: " + this.numberOfIterations);
                    }
                }
            }
            ++l;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                System.err.println(this.getLogLinePrefix() + "Interrupt of the main loop in the program.");
                interruptedException.printStackTrace();
            }
        }
    }

    public ThreadOpt(String string) {
        thisThreadOptInstance = this;
        this.timeMXBean = TimeMXBeanImpl.getInstance();
        Utils.processOptions(string);
        machineArchitecture = new MachineArchitecture(string);
        this.processThreads = new ProcessThreads(string);
        if (this.verboseOn || this.verbose) {
            System.out.println(this.getLogLinePrefix() + "Start hardware analysis phase: " + " ThreadOpt Version: " + Version.getVersion() + " ThreadOpt Version Date: " + Version.getVersion_Date() + " ThreadOpt Interface Version: " + Version.getMajorVersion() + "." + Version.getMinorVersion());
        }
        machineArchitecture.getCPUNodeAndCPUThreadConfiguration();
        machineArchitecture.partitionCPUThreadsBetweenLowCPUConsumingAndHighCPUConsumingPartitions();
        machineArchitecture.identifyCPUThreadsRunningOnSameCore();
        if (this.verboseOn || this.verbose) {
            System.out.println(this.getLogLinePrefix() + "End hardware analysis phase");
        }
        this.processOptions(string);
        this.threadRegExpLowMXBean = this.threadRegExpLow;
        this.threadRegExpHighMXBean = this.threadRegExpHigh;
        if (this.useCPUMonitoring) {
            try {
                this.monitorProcessCPUUse = new MonitorProcessCPUUse(string);
                this.monitorProcessCPUUse.setName("ThreadOpt-Monitoring");
                this.monitorProcessCPUUse.setDaemon(true);
                this.monitorProcessCPUUse.start();
            }
            catch (Exception exception) {
                System.err.println(this.getLogLinePrefix() + "ERROR in initialization of MonitorProcessCPUUse object");
                exception.printStackTrace();
            }
        }
        CommandLineOptions commandLineOptions = CommandLineOptions.getInstance();
        commandLineOptions.finalProcessingOfCommandLineOptions();
        try {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            ThreadOptMXBeanImpl threadOptMXBeanImpl = ThreadOptMXBeanImpl.getInstance();
            ObjectName objectName = ThreadOptMXBeanImpl.getObjectName();
            mBeanServer.registerMBean(threadOptMXBeanImpl, objectName);
            objectName = TimeMXBeanImpl.getObjectName();
            mBeanServer.registerMBean(this.timeMXBean, objectName);
        }
        catch (Exception exception) {
            System.err.println(this.getLogLinePrefix() + "ERROR in registration of the ThreadOptMXBean or TimeMXBean");
            exception.printStackTrace();
        }
        Utils.displayProcessThreads();
    }

    private static String getSystemOutPrefix() {
        if (timeMXBeanSt != null) {
            return timeMXBeanSt.getElapsedTimeSinceJVMStartSecStr() + " [ThreadOpt] ";
        }
        return System.currentTimeMillis() + "[ThreadOpt] ";
    }

    public static void premain(String string, Instrumentation instrumentation) throws IOException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, ParseException {
        String string2 = System.getProperty("com.azul.threadopt.runningJstackAsSubprocess");
        if (string2 != null) {
            System.out.println(ThreadOpt.getSystemOutPrefix() + "Value of com.azul.threadopt.runningJstackAsSubprocess: " + string2);
            return;
        }
        ThreadOpt threadOpt = new ThreadOpt(string);
        if (threadOpt.testInitializationOnly()) {
            System.out.println(ThreadOpt.getSystemOutPrefix() + "ThreadOpt: Initialization complete. Returning to caller because testInitialization option is true.");
            System.exit(0);
        }
        if (threadOpt.verboseProgress()) {
            System.out.println(ThreadOpt.getSystemOutPrefix() + "ThreadOpt: Initialized and running.");
        }
        try {
            threadOpt.setName("ZingThreadOpt");
            threadOpt.setDaemon(true);
            threadOpt.start();
        }
        catch (Exception exception) {
            System.err.println(ThreadOpt.getSystemOutPrefix() + "ERROR in initialization of Zing ThreadOpt object that was requested when -XX:+UseThreadOpt was used on the command line.");
            exception.printStackTrace();
            System.exit(1);
        }
    }

    public static void main(String[] stringArray) {
        System.out.println("ThreadOpt runs as a javaagent only!");
        System.out.println("Add -javaagent:ThreadOpt.jar to the Zing VM's command line.");
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i].toLowerCase().trim();
            if (!string.equals("-v") && !string.equals("-version")) continue;
            System.out.println("[ThreadOpt] Version: " + Version.getVersion());
            System.out.println("[ThreadOpt] Version Interface: " + Version.getMajorVersion() + "." + Version.getMinorVersion());
            System.out.println("[ThreadOpt] Version Date: " + Version.getVersion_Date());
            System.out.println("[ThreadOpt] Version of ZVM Build: " + Version.getZVM_Version());
            System.exit(0);
        }
        String string = "";
        if (stringArray != null && stringArray.length > 0 && stringArray[0] != null) {
            string = stringArray[0];
        }
        System.out.println("[ThreadOpt] " + System.currentTimeMillis() + "In main() with arguments: " + string);
        try {
            ThreadOpt.premain(string, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        while (true) {
            System.out.println("[ThreadOpt] " + System.currentTimeMillis() + "Process's main thread is running (process is alive message repeated every 20 seconds)");
            try {
                Thread.sleep(20000L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public class CPUThreadSetRunning {
        private int _notRunning = 0;
        private int _lowCPUConsumerCPUThreads = 0;
        private int _highCPUConsumerCPUThreads = 0;
        private int _allCPUThreads = 0;

        public int getNotRunning() {
            return this._notRunning;
        }

        public int getLowCPUConsumerCPUThreads() {
            return this._lowCPUConsumerCPUThreads;
        }

        public int getHighCPUConsumerCPUThreads() {
            return this._highCPUConsumerCPUThreads;
        }

        public int getAllCPUThreads() {
            return this._allCPUThreads;
        }

        public void addOneThreadNotRunning() {
            ++this._notRunning;
        }

        public void addOneThreadRunningInLowCPUConsumerCPUThreads() {
            ++this._lowCPUConsumerCPUThreads;
        }

        public void addOneThreadRunningInHighCPUConsumerCPUThreads() {
            ++this._highCPUConsumerCPUThreads;
        }

        public void addOneThreadRunningInAllCPUThreads() {
            ++this._allCPUThreads;
        }
    }
}

