/*
 * Decompiled with CFR 0.152.
 */
package com.azul.threadopt;

import com.azul.threadopt.CommandLineOptions;
import com.azul.threadopt.MachineArchitecture;
import com.azul.threadopt.ProcessThreads;
import com.azul.threadopt.ProcessThreadsCPUUse;
import com.azul.threadopt.ThreadOpt;
import com.azul.threadopt.ThreadOptMonitoringMXBeanImpl;
import com.azul.threadopt.TimeMXBeanImpl;
import com.azul.threadopt.Utils;
import com.azul.threadopt.Version;
import com.azul.threadopt.mxbeans.TimeMXBean;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class MonitorProcessCPUUse
extends Thread {
    private final boolean verboseOnDefaultValue = false;
    private final boolean verboseDefaultValue = false;
    private final boolean verboseMonitoringDefaultValue = false;
    private final boolean verboseDisplayThreadsDefaultValue = false;
    private final boolean verboseThreadNameDefaultValue = false;
    private final boolean verboseOptionsCheckDefaultValue = false;
    private final boolean verboseProgressDefaultValue = false;
    private final boolean logDefaultValue = false;
    private final boolean savePerformanceSnapshotsToFileDefaultValue = false;
    private final boolean skipFirstPerformanceSnapshotDefaultValue = false;
    private final boolean useCPUMonitoringDefaultValue = false;
    private final boolean useThreadNamesDefaultValue = true;
    private final long monitoringDelayStartTimeMSDefaultValue = 12000L;
    private final int monitoringTimeIntervalBetweenSnapshotsSecsDefaultValue = 60;
    private final boolean monitoringTimeIntervalBetweenWritingThreadsNamesSecsSetOnCommandLineDefaultValue = false;
    private final int monitoringTimeIntervalBetweenWritingThreadsNamesSecsDefaultValue = 600;
    private final int monitoringTimeIntervalBetweenWritingThreadsThreadCPUAffinitySecsDefaultValue = 300;
    private boolean verboseOn = false;
    private boolean verbose = false;
    private boolean verboseMonitoring = false;
    private boolean verboseDisplayThreads = false;
    private boolean verboseThreadName = false;
    private boolean verboseOptionsCheck = false;
    private boolean verboseProgress = false;
    private boolean log = false;
    private boolean savePerformanceSnapshotsToFile = false;
    private boolean skipFirstPerformanceSnapshot = false;
    private boolean useCPUMonitoring = false;
    private boolean useThreadNames = true;
    private long monitoringDelayStartTimeMS = 12000L;
    private int monitoringTimeIntervalBetweenSnapshotsSecs;
    private int monitoringTimeIntervalBetweenSnapshotsSecsMXBeans = this.monitoringTimeIntervalBetweenSnapshotsSecs = 60;
    private boolean monitoringTimeIntervalBetweenWritingThreadsNamesSecsSetOnCommandLine = false;
    private int monitoringTimeIntervalBetweenWritingThreadsNamesSecs = 600;
    private int monitoringTimeIntervalBetweenWritingThreadsThreadCPUAffinitySecs = 300;
    private boolean listOfCPUThreadsToUseForLowCPUConsumersAffinityIsProvided = false;
    private boolean listOfCPUThreadsToUseForHighCPUConsumersAffinityIsProvided = false;
    private static boolean performanceSnapshotsFileOpen = false;
    private int historicalThreadCPUDataNumberOfElementsDefaultValue = 6;
    private String commandLineOptionsForMonitoring = "";
    private ProcessThreads processThreads = null;
    private int mLowToHighPercentCPUTimeUseThresholdDefaultValue;
    private int mLowToHighPercentCPUTimeUseThreshold = this.mLowToHighPercentCPUTimeUseThresholdDefaultValue = 20;
    private long mostRecentlyCalculatedThresholdForLowToHighSecs = 0L;
    private int historicalThreadCPUDataNumberOfElements;
    private int historicalThreadCPUDataNumberOfElementsMXBeans = this.historicalThreadCPUDataNumberOfElements = this.historicalThreadCPUDataNumberOfElementsDefaultValue;
    private ArrayBlockingQueue<ProcessThreadsCPUUse> historicalThreadCPUData = new ArrayBlockingQueue(this.historicalThreadCPUDataNumberOfElements);
    private TimeMXBean timeMXBean = null;
    private long numberOfLinesWrittenToMonitoringSnapshotLogFile = 0L;
    private long numberOfLinesToWriteBetweenHeadersInTheMonitoringSnapshotLogFile = 100L;
    private long numberOfThreadIDAndThreadNameLines = 0L;
    private boolean isTheMonitoringSnapshotLogFileHeaderWritten = false;
    private boolean printThreadIDAndNameToSnapshotLogFile = true;
    private double timeOfPreviousPrintingThreadIDToThreadNameSec = 0.0;
    private double timeOfPreviousPrintingThreadsThreadCPUAffinity = 0.0;
    private double intervalBetweenPrintingThreadIDToThreadNameSec = 60.0;
    private static MonitorProcessCPUUse thisMonitorProcessCPUUseInstance = null;
    boolean firstTime = true;
    BufferedWriter bufferedWriterForThreadCPUSnapshotLogging = null;

    private String getLogLinePrefix() {
        if (this.timeMXBean != null) {
            return this.timeMXBean.getElapsedTimeSinceJVMStartSecStr() + " [ThreadOpt] ";
        }
        return "[ThreadOpt] ";
    }

    private String getThreadOptMonitoringLogLinePrefix() {
        if (this.timeMXBean != null) {
            return this.timeMXBean.getElapsedTimeSinceJVMStartSecStr() + " [ThreadOptMonitoring] ";
        }
        return "[ThreadOptMonitoring] ";
    }

    static MonitorProcessCPUUse getInstance() {
        return thisMonitorProcessCPUUseInstance;
    }

    public void setTimeIntervalBetweenPerfSnapshotsSecs(int n) {
        if (n < 1) {
            System.err.println(this.getLogLinePrefix() + "MonitorProcessCPUUse.setTimeIntervalBetweenPerfSnapshotsSecs() is less than one. Value will be set to one.");
            n = 1;
        }
        this.monitoringTimeIntervalBetweenSnapshotsSecsMXBeans = n;
    }

    public int getTimeIntervalBetweenPerfSnapshotsSecs() {
        return this.monitoringTimeIntervalBetweenSnapshotsSecsMXBeans;
    }

    public void setNumberOfHistoricalThreadCPUSnapshotsToSave(int n) {
        if (n < 2) {
            System.err.println(this.getLogLinePrefix() + "MonitorProcessCPUUse.setNumberOfHstoricalThreadCPUSnapshotsToSave() is less than two. Value will be set to two because we need two for comparison.");
            n = 2;
        }
        this.historicalThreadCPUDataNumberOfElementsMXBeans = n;
    }

    public int getNumberOfHistoricalThreadCPUSnapshotsToSave() {
        return this.historicalThreadCPUDataNumberOfElementsMXBeans;
    }

    public void setLowToHighPercentCPUTimeUseThreshold(int n) {
        if (n < 1) {
            System.err.println(this.getLogLinePrefix() + "MonitorProcessCPUUse.setLowToHighPercentCPUTimeUseThreshold(int): Value of input parameter is not valid: " + n + " value will remain unchanged: " + this.mLowToHighPercentCPUTimeUseThreshold);
        } else {
            this.mLowToHighPercentCPUTimeUseThreshold = n;
            if (this.verboseMonitoring) {
                System.out.println(this.getLogLinePrefix() + "MonitoringProcessCPUUse.setLowToHighPercentCPUTimeUseThreshold resetting valule to: " + n);
            }
        }
    }

    public int getLowToHighPercentCPUTimeUseThreshold() {
        return this.mLowToHighPercentCPUTimeUseThreshold;
    }

    long getMostRecentlyCalculatedThresholdForLowToHighSecs() {
        return this.mostRecentlyCalculatedThresholdForLowToHighSecs;
    }

    int historicalThreadCPUDataNumberOfDataElements() {
        return this.historicalThreadCPUData.size();
    }

    public synchronized void addAMeasurement(ProcessThreadsCPUUse processThreadsCPUUse) {
        if (processThreadsCPUUse == null) {
            System.err.println(this.getThreadOptMonitoringLogLinePrefix() + "addAMeasurement: null input parameter.");
            return;
        }
        boolean bl = this.historicalThreadCPUData.offer(processThreadsCPUUse);
        if (!bl) {
            this.historicalThreadCPUData.poll();
            bl = this.historicalThreadCPUData.offer(processThreadsCPUUse);
            if (!bl) {
                System.err.println(this.getThreadOptMonitoringLogLinePrefix() + "addAMeasurement: ERROR: Unable to add elements to data structure.");
            }
        }
    }

    public synchronized void updateHistoricalThreadCPUDataStructures() {
        if (this.historicalThreadCPUDataNumberOfElements == this.historicalThreadCPUDataNumberOfElementsMXBeans) {
            return;
        }
        if (this.historicalThreadCPUDataNumberOfElementsMXBeans < 2) {
            this.historicalThreadCPUDataNumberOfElementsMXBeans = 2;
        }
        ArrayBlockingQueue<ProcessThreadsCPUUse> arrayBlockingQueue = new ArrayBlockingQueue<ProcessThreadsCPUUse>(this.historicalThreadCPUDataNumberOfElementsMXBeans, true, this.historicalThreadCPUData);
        this.historicalThreadCPUData = arrayBlockingQueue;
        this.historicalThreadCPUDataNumberOfElements = this.historicalThreadCPUDataNumberOfElementsMXBeans;
    }

    public synchronized void constructListsOfLowCPUAndHighCPUConsumingAppThreads(List<Integer> list, List<Integer> list2) {
        String string;
        long l;
        int n = this.historicalThreadCPUData.size();
        if (n == 0) {
            if (this.verboseMonitoring) {
                System.out.println(this.getThreadOptMonitoringLogLinePrefix() + "constructListsOfLowCPUAndHighCPUConsumingAppThreads: Method is returning because no performance information collected.");
                System.out.println(this.getThreadOptMonitoringLogLinePrefix() + "constructListsOfLowCPUAndHighCPUConsumingAppThreads: Consider decreasing the monitoring start delay time or increasing the ThreadOpt start delay time.");
            }
            return;
        }
        ProcessThreadsCPUUse[] processThreadsCPUUseArray = new ProcessThreadsCPUUse[this.historicalThreadCPUDataNumberOfElements];
        processThreadsCPUUseArray = this.historicalThreadCPUData.toArray(processThreadsCPUUseArray);
        int n2 = n - 1;
        int n3 = 0;
        ProcessThreadsCPUUse processThreadsCPUUse = processThreadsCPUUseArray[n3];
        long l2 = processThreadsCPUUse.totalCPUTime();
        long l3 = processThreadsCPUUse.sequenceNumber();
        long l4 = processThreadsCPUUse.elapsedMilliseconds();
        ProcessThreadsCPUUse processThreadsCPUUse2 = processThreadsCPUUseArray[n2];
        long l5 = processThreadsCPUUse2.totalCPUTime();
        long l6 = processThreadsCPUUse2.sequenceNumber();
        long l7 = processThreadsCPUUse2.elapsedMilliseconds();
        long l8 = 0L;
        l8 = l6 == l3 ? l4 : l7 - l4;
        if (this.verboseMonitoring) {
            l = System.currentTimeMillis();
            System.out.println(this.getThreadOptMonitoringLogLinePrefix() + "HighOrLowAppThreads: Oldest CPU use data (sequence:      " + l3 + ") Elapsed time (ms): " + l4 + " Total CPU time (sec): " + l2);
            if (l6 != l3) {
                System.out.println(this.getLogLinePrefix() + "HighOrLowAppThreads: Most recent CPU use data (sequence: " + l6 + ") Elapsed time (ms): " + l7 + " Total CPU time (sec): " + l5);
            }
            long l9 = 0L;
            string = "";
            if (l6 == l3) {
                l9 = l2;
                string = "program start and " + l3;
            } else {
                l9 = l5 - l2;
                string = l3 + " and " + l6;
            }
            System.out.println(this.getLogLinePrefix() + "HighOrLowAppThreads: Differences for snapshots: " + string + " Time interval between: " + l8 + " (ms) CPU time: " + l9 + " (sec)");
            System.out.println(this.getLogLinePrefix() + "HighOrLowAppThreads: Low to high percent CPU time use threshold: " + this.mLowToHighPercentCPUTimeUseThreshold);
        }
        this.mostRecentlyCalculatedThresholdForLowToHighSecs = l = (long)((float)l8 * (float)this.mLowToHighPercentCPUTimeUseThreshold / 100000.0f + 0.5f);
        if (this.verboseMonitoring) {
            System.out.println(this.getLogLinePrefix() + "Monitoring: Percent CPU time use threshold = " + l + " seconds over interval " + (float)l8 / 1000.0f + " seconds.");
        }
        Map<Integer, Integer> map = processThreadsCPUUse.threadCPUUse();
        Map<Integer, Integer> map2 = processThreadsCPUUse2.threadCPUUse();
        string = this.getLogLinePrefix() + "HighOrLowAppThreads: Add low: ";
        String string2 = this.getLogLinePrefix() + "HighOrLowAppThreads: Add HIGH: ";
        for (Integer n4 : map2.keySet()) {
            Integer n5 = map2.get(n4);
            Integer n6 = map.get(n4);
            int n7 = 0;
            n7 = l6 == l3 || n6 == null ? n5 : n5 - n6;
            if ((long)n7 >= l) {
                list2.add(n4);
                if (!this.verboseMonitoring) continue;
                System.out.println(string2 + n4 + " " + n7);
                continue;
            }
            list.add(n4);
            if (!this.verboseMonitoring) continue;
            System.out.println(string + n4 + " " + n7);
        }
    }

    private void initializeApplicationThreadCPUTimeUseLogging() {
        String string = null;
        if (this.savePerformanceSnapshotsToFile && !performanceSnapshotsFileOpen) {
            try {
                string = Utils.createSlashTmpSlashFileName("monitor", 0.0);
                File file = new File(string);
                performanceSnapshotsFileOpen = true;
                if (!file.exists()) {
                    // empty if block
                }
                FileWriter fileWriter = new FileWriter(file.getAbsoluteFile());
                this.bufferedWriterForThreadCPUSnapshotLogging = new BufferedWriter(fileWriter);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void writeHeaderLinesToLogFile() {
        if (this.isTheMonitoringSnapshotLogFileHeaderWritten) {
            return;
        }
        try {
            List<Integer> list;
            Object object;
            this.bufferedWriterForThreadCPUSnapshotLogging.write("[ThreadOpt: Zing Thread Performance Monitoring ]\n");
            this.bufferedWriterForThreadCPUSnapshotLogging.write("[ThreadOpt: StartDate: " + this.timeMXBean.getUnixTimeOfJVMStartAsDateTimeString() + " ]\n");
            this.bufferedWriterForThreadCPUSnapshotLogging.write("[ThreadOpt: StartTimeMillis: " + this.timeMXBean.getUnixTimeOfJVMStartMillis() + " ]\n");
            try {
                object = ManagementFactory.getOperatingSystemMXBean();
                this.bufferedWriterForThreadCPUSnapshotLogging.write("[ThreadOpt: OSArchitecture: " + object.getArch() + " ]\n");
                this.bufferedWriterForThreadCPUSnapshotLogging.write("[ThreadOpt: OSName: " + object.getName() + " ]\n");
                this.bufferedWriterForThreadCPUSnapshotLogging.write("[ThreadOpt: OSVersion: " + object.getVersion() + " ]\n");
                this.bufferedWriterForThreadCPUSnapshotLogging.write("[ThreadOpt: OSAvailableProcessors: " + object.getAvailableProcessors() + " ]\n");
                list = ManagementFactory.getRuntimeMXBean();
                this.bufferedWriterForThreadCPUSnapshotLogging.write("[ThreadOpt: VMVendor: " + list.getVmVendor() + " ]\n");
                this.bufferedWriterForThreadCPUSnapshotLogging.write("[ThreadOpt: VMName: " + list.getVmName() + " ]\n");
                this.bufferedWriterForThreadCPUSnapshotLogging.write("[ThreadOpt: VMVersion: " + list.getVmVersion() + " ]\n");
                this.bufferedWriterForThreadCPUSnapshotLogging.write("[ThreadOpt: VMInputArguments: " + list.getInputArguments() + " ]\n");
            }
            catch (Exception exception) {
                System.err.println(this.getLogLinePrefix() + "ERROR in writing the header for the monitoring log file");
                exception.printStackTrace();
            }
            this.bufferedWriterForThreadCPUSnapshotLogging.write("[ThreadOpt: ThreadOptVersion: " + Version.getVersion() + " ]\n");
            this.bufferedWriterForThreadCPUSnapshotLogging.write("[ThreadOpt: ThreadOptInterfaceVersion: " + Version.getMajorVersion() + "." + Version.getMinorVersion() + " ]\n");
            this.bufferedWriterForThreadCPUSnapshotLogging.write("[ThreadOpt: ThreadOptVersionDate: " + Version.getVersion_Date() + " ]\n");
            this.bufferedWriterForThreadCPUSnapshotLogging.write("[ThreadOpt: ThreadOptZingVMCobuildVersion: " + Version.getZVM_Version() + " ]\n");
            this.bufferedWriterForThreadCPUSnapshotLogging.write("[ThreadOpt: ThreadOptMonitoringCommandLineOptions: " + this.commandLineOptionsForMonitoring + " ]\n");
            object = ThreadOpt.getMachineArchitecture();
            if (object != null) {
                list = ((MachineArchitecture)object).getArrayOfAllCPUThreads();
                if (list != null) {
                    this.bufferedWriterForThreadCPUSnapshotLogging.write("[ThreadOpt: AllCPUThreadsOnMachine: " + ((MachineArchitecture)object).getNumberOfCPUThreads() + " " + list + " ]\n");
                }
                if ((list = ((MachineArchitecture)object).getArrayOfCPUThreadsForLowCPUConsumers()) != null) {
                    this.bufferedWriterForThreadCPUSnapshotLogging.write("[ThreadOpt: CPUThreadsForLowCPUConsumersOnMachine: " + ((MachineArchitecture)object).getNumberOfCPUThreadsForLowCPUConsumers() + " " + list + " ]\n");
                }
                if ((list = ((MachineArchitecture)object).getArrayOfCPUThreadsForHighCPUConsumers()) != null) {
                    this.bufferedWriterForThreadCPUSnapshotLogging.write("[ThreadOpt: CPUThreadsForHighCPUConsumersOnMachine: " + ((MachineArchitecture)object).getNumberOfCPUThreadsForHighCPUConsumers() + " " + list + " ]\n");
                }
                if ((list = ((MachineArchitecture)object).getArrayOfCPUCoresForHighCPUConsumers()) != null) {
                    this.bufferedWriterForThreadCPUSnapshotLogging.write("[ThreadOpt: PhysicalCoresForHighCPUConsumersOnMachine: " + ((MachineArchitecture)object).getNumberOfCPUCoresForHighCPUConsumers() + " " + list + " ]\n");
                }
            }
            if (this.useCPUMonitoring) {
                this.bufferedWriterForThreadCPUSnapshotLogging.write("[ThreadOpt: ThreadOptThresholdDecisionData: MonitorCPUTimeUse ]\n");
            } else {
                this.bufferedWriterForThreadCPUSnapshotLogging.write("[ThreadOpt: ThreadOptThresholdDecisionData: SingleCPUTimeUseSnapshot ]\n");
            }
            list = ThreadOpt.getInstance();
            if (list != null) {
                this.bufferedWriterForThreadCPUSnapshotLogging.write("[ThreadOpt: CPUThreadsForLowCPUConsumersSpecifiedByUserOption: " + ((ThreadOpt)((Object)list)).getParameterCSVListOfCPUThreadsForLowCPUConsumers() + " ]\n");
                this.bufferedWriterForThreadCPUSnapshotLogging.write("[ThreadOpt: CPUThreadsForHighCPUConsumersSpecifiedByUserOption: " + ((ThreadOpt)((Object)list)).getParameterCSVListOfCPUThreadsForHighCPUConsumers() + " ]\n");
            }
            this.bufferedWriterForThreadCPUSnapshotLogging.write("[ThreadOpt: MonitoringPercentCPUTimeUseThresholdForLowToHigh [" + this.mLowToHighPercentCPUTimeUseThresholdDefaultValue + "]: " + this.mLowToHighPercentCPUTimeUseThreshold + " ]\n");
            if (list != null) {
                this.bufferedWriterForThreadCPUSnapshotLogging.write("[ThreadOpt: SingleSnapshotCPUTimeUseThresholdForLowToHigh [" + ((ThreadOpt)((Object)list)).getLowToHighCPUTimeUseThresholdSecsDefaultValue() + "]: " + ((ThreadOpt)((Object)list)).getLowToHighCPUTimeUseThresholdSecs() + " ]\n");
            }
            this.bufferedWriterForThreadCPUSnapshotLogging.flush();
            this.isTheMonitoringSnapshotLogFileHeaderWritten = true;
        }
        catch (IOException iOException) {
            System.err.println(this.getLogLinePrefix() + "ERROR in writing to the monitoring log file");
            iOException.printStackTrace();
        }
    }

    private void writeSnapshotToLogFile(ProcessThreadsCPUUse processThreadsCPUUse) {
        if (!this.savePerformanceSnapshotsToFile || this.bufferedWriterForThreadCPUSnapshotLogging == null) {
            return;
        }
        this.writeHeaderLinesToLogFile();
        try {
            if (this.numberOfLinesWrittenToMonitoringSnapshotLogFile++ % this.numberOfLinesToWriteBetweenHeadersInTheMonitoringSnapshotLogFile == 0L) {
                this.bufferedWriterForThreadCPUSnapshotLogging.write(processThreadsCPUUse.logLineHeader());
            }
            this.bufferedWriterForThreadCPUSnapshotLogging.write(processThreadsCPUUse.toLogLine());
            this.bufferedWriterForThreadCPUSnapshotLogging.flush();
            double d = this.timeMXBean.getElapsedTimeSinceJVMStartSec();
            double d2 = d - this.timeOfPreviousPrintingThreadIDToThreadNameSec;
            if (this.printThreadIDAndNameToSnapshotLogFile && this.monitoringTimeIntervalBetweenWritingThreadsNamesSecsSetOnCommandLine && d2 > (double)this.monitoringTimeIntervalBetweenWritingThreadsNamesSecs || !this.monitoringTimeIntervalBetweenWritingThreadsNamesSecsSetOnCommandLine && d2 > this.intervalBetweenPrintingThreadIDToThreadNameSec) {
                if (!this.monitoringTimeIntervalBetweenWritingThreadsNamesSecsSetOnCommandLine) {
                    if (this.intervalBetweenPrintingThreadIDToThreadNameSec <= 60.0) {
                        this.intervalBetweenPrintingThreadIDToThreadNameSec = 240.0;
                    } else if (this.intervalBetweenPrintingThreadIDToThreadNameSec <= 240.0) {
                        this.intervalBetweenPrintingThreadIDToThreadNameSec = 300.0;
                    } else if (this.intervalBetweenPrintingThreadIDToThreadNameSec <= 300.0) {
                        this.intervalBetweenPrintingThreadIDToThreadNameSec = 600.0;
                    }
                }
                Map<Integer, String> map = this.processThreads.getJavaProcessThreadNames();
                String string = "\n";
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(string);
                for (Map.Entry<Integer, String> entry : map.entrySet()) {
                    Integer n = entry.getKey();
                    String string2 = entry.getValue();
                    if (string2 == null || string2.length() == 0) {
                        string2 = "thread-name-not-found-" + n;
                    }
                    stringBuffer.append(n);
                    stringBuffer.append(string);
                    stringBuffer.append(string2);
                    stringBuffer.append(string);
                }
                long l = System.currentTimeMillis();
                this.bufferedWriterForThreadCPUSnapshotLogging.write("[ThreadOptPTNAME: " + ++this.numberOfThreadIDAndThreadNameLines + " " + (l - this.timeMXBean.getUnixTimeOfJVMStartMillis()) + " " + l + " " + stringBuffer.toString() + " ]\n");
                this.timeOfPreviousPrintingThreadIDToThreadNameSec = d;
            }
            if ((d2 = (d = this.timeMXBean.getElapsedTimeSinceJVMStartSec()) - this.timeOfPreviousPrintingThreadsThreadCPUAffinity) > (double)this.monitoringTimeIntervalBetweenWritingThreadsThreadCPUAffinitySecs) {
                ThreadOpt.getInstance().printProcessThreadToCPUThreads(this.bufferedWriterForThreadCPUSnapshotLogging);
                this.timeOfPreviousPrintingThreadsThreadCPUAffinity = d;
            }
        }
        catch (IOException iOException) {
            System.err.println(this.getLogLinePrefix() + "ERROR in writing to the monitoring log file");
            iOException.printStackTrace();
        }
    }

    private void processOptions(String string) {
        String[] stringArray = null;
        if (string != null && string.length() > 0) {
            stringArray = string.split("\\s+|%");
        }
        this.processOptions(stringArray);
    }

    private void processOptions(String[] stringArray) {
        CharSequence charSequence;
        boolean bl = true;
        CommandLineOptions commandLineOptions = CommandLineOptions.getInstance();
        if (!commandLineOptions.isCommandLineOptionsInitialized()) {
            commandLineOptions.initializeCommandLineOptions(stringArray);
        }
        if (stringArray != null && stringArray.length > 0) {
            int n;
            charSequence = new StringBuffer();
            for (n = 0; n < stringArray.length; ++n) {
                ((StringBuffer)charSequence).append(stringArray[n]);
                ((StringBuffer)charSequence).append(" ");
            }
            this.commandLineOptionsForMonitoring = ((StringBuffer)charSequence).toString();
            for (n = 0; n < stringArray.length; ++n) {
                block64: {
                    Object object;
                    String string = stringArray[n].toLowerCase();
                    if (string.matches("^moncpuuse")) {
                        this.useCPUMonitoring = true;
                        commandLineOptions.processedOption(string);
                    } else if (string.matches("^monsaveperfdata")) {
                        this.savePerformanceSnapshotsToFile = true;
                        commandLineOptions.processedOption(string);
                    } else if (string.matches("^monwritethreadnamestoperfdata=.*")) {
                        object = stringArray[n].substring(30);
                        this.printThreadIDAndNameToSnapshotLogFile = commandLineOptions.checkBooleanValue(string, (String)object);
                    } else if (string.matches("^usethreadnames=.*")) {
                        object = stringArray[n].substring(15);
                        this.useThreadNames = commandLineOptions.checkBooleanValue(string, (String)object);
                    } else if (string.matches("^monpercentcputimeusethresh=\\d+")) {
                        try {
                            object = Integer.parseInt(stringArray[n].substring(27));
                            if ((Integer)object < 0) {
                                commandLineOptions.processedOptionHasError(string, "Value must be greater than or equal to zero");
                                break block64;
                            }
                            this.mLowToHighPercentCPUTimeUseThreshold = (Integer)object;
                            commandLineOptions.processedOption(string);
                        }
                        catch (Exception exception) {
                            commandLineOptions.processedOptionHasError(string, "Non-numeric value found: >" + string.substring(24) + "<");
                        }
                    } else if (string.matches("^montibs=\\d+")) {
                        try {
                            object = Integer.parseInt(stringArray[n].substring(8));
                            if (object == null || (Integer)object < 1) {
                                commandLineOptions.processedOptionHasError(string, "Invalid value for montibs (monitoring's time interval between snapshots): " + object + " Value must be greater than or equal to 1.");
                                break block64;
                            }
                            this.monitoringTimeIntervalBetweenSnapshotsSecs = (Integer)object;
                            this.monitoringTimeIntervalBetweenSnapshotsSecsMXBeans = (Integer)object;
                            commandLineOptions.processedOption(string);
                        }
                        catch (Exception exception) {
                            commandLineOptions.processedOptionHasError(string, "Non-numeric value found: >" + string.substring(8) + "<");
                        }
                    } else if (string.matches("^montibwtn=\\d+")) {
                        try {
                            object = Integer.parseInt(stringArray[n].substring(10));
                            if (object == null || (Integer)object < 10) {
                                commandLineOptions.processedOptionHasError(string, "Invalid value for montibwtn (monitoring's time interval between writing threads' names): " + stringArray[n].substring(10) + " Value must be greater than or equal to 10.");
                                break block64;
                            }
                            this.monitoringTimeIntervalBetweenWritingThreadsNamesSecs = (Integer)object;
                            this.monitoringTimeIntervalBetweenWritingThreadsNamesSecsSetOnCommandLine = true;
                            commandLineOptions.processedOption(string);
                        }
                        catch (Exception exception) {
                            commandLineOptions.processedOptionHasError(string, "Non-numeric value found: >" + string.substring(10) + "<");
                        }
                    } else if (string.matches("^montibwttca=\\d+")) {
                        try {
                            object = Integer.parseInt(stringArray[n].substring(12));
                            if (object == null || (Integer)object < 10) {
                                commandLineOptions.processedOptionHasError(string, "Invalid value for montibwttca (monitoring's time interval between writing threads' thread CPU affinity): " + stringArray[n].substring(12) + " Value must be greater than or equal to 10.");
                                break block64;
                            }
                            this.monitoringTimeIntervalBetweenWritingThreadsThreadCPUAffinitySecs = (Integer)object;
                            commandLineOptions.processedOption(string);
                        }
                        catch (Exception exception) {
                            commandLineOptions.processedOptionHasError(string, "Non-numeric value found: >" + string.substring(12) + "<");
                        }
                    } else if (string.matches("^moncpuhistsize=\\d+")) {
                        try {
                            object = Integer.parseInt(stringArray[n].substring(15));
                            if (object == null || (Integer)object < 2) {
                                commandLineOptions.processedOptionHasError(string, "Invalid value for monCPUHistSize: " + object + " Value must be greater than or equal to 2.");
                                break block64;
                            }
                            this.historicalThreadCPUDataNumberOfElements = (Integer)object;
                            commandLineOptions.processedOption(string);
                        }
                        catch (Exception exception) {
                            commandLineOptions.processedOptionHasError(string, "Non-numeric value found: >" + string.substring(15) + "<");
                        }
                    } else if (string.matches("^mondelaytodate=.*")) {
                        object = string.substring(15);
                        this.monitoringDelayStartTimeMS = commandLineOptions.dateAndTimeToMilliseconds(string, (String)object);
                    } else if (string.matches("^mondelayhms=.*")) {
                        object = string.substring(12);
                        this.monitoringDelayStartTimeMS = commandLineOptions.hoursMinutesSecondsToMilliseconds(string, (String)object);
                    } else if (string.matches("^mondelaysecs=.*")) {
                        object = string.substring(13);
                        this.monitoringDelayStartTimeMS = commandLineOptions.stringFloatInSecondsToMilliseconds(string, (String)object);
                    } else if (string.matches("^voc")) {
                        this.verboseOptionsCheck = true;
                        commandLineOptions.processedOption(string);
                    } else if (string.matches("^vtn")) {
                        this.verboseThreadName = true;
                        commandLineOptions.processedOption(string);
                    } else if (string.matches("^vdt")) {
                        this.verboseDisplayThreads = true;
                        commandLineOptions.processedOption(string);
                    } else if (string.matches("^verbose=.*")) {
                        object = string.substring(8);
                        this.verboseOn = commandLineOptions.checkBooleanValue(string, (String)object);
                    } else if (string.matches("^v")) {
                        this.verbose = true;
                        commandLineOptions.processedOption(string);
                    } else if (string.matches("^vmon")) {
                        this.verboseMonitoring = true;
                        commandLineOptions.processedOption(string);
                    } else if (string.matches("^vp")) {
                        this.verboseProgress = true;
                        commandLineOptions.processedOption(string);
                    } else if (string.matches("^vprogress")) {
                        this.verboseProgress = true;
                        commandLineOptions.processedOption(string);
                    } else if (string.matches("^log")) {
                        this.log = true;
                        commandLineOptions.processedOption(string);
                    }
                }
                if (!this.verboseOn && !this.verbose) continue;
                if (bl) {
                    bl = false;
                    System.out.println(this.getLogLinePrefix() + "Process MonitorProcessCPUUse options");
                }
                System.out.println(this.getLogLinePrefix() + "Option to ThreadOpt (MP): " + n + " = " + stringArray[n]);
            }
        }
        if (this.verboseOn || this.verbose) {
            this.verboseProgress = true;
        }
        if (this.verboseOn || this.verbose) {
            charSequence = this.getLogLinePrefix() + "Options and internal variables settings: ";
            System.out.println((String)charSequence + "Verbose [" + false + "] (v): " + this.verbose);
            System.out.println((String)charSequence + "Verbose for monitoring [" + false + "] (vmon): " + this.verboseMonitoring);
            if (this.verboseOptionsCheck) {
                System.out.println((String)charSequence + "Logging on [" + false + "] (log): " + this.log);
            }
            System.out.println((String)charSequence + "Use application thread CPU use monitoring to make affinity decisions [" + false + "] (moncpuuse): " + this.useCPUMonitoring);
            System.out.println((String)charSequence + "Monitoring: delay start time [" + 12.0f + "] seconds (mondelaysecs=<float>): " + (float)this.monitoringDelayStartTimeMS / 1000.0f);
            System.out.println((String)charSequence + "Monitoring: time interval between iterations [" + 60 + "] seconds (montibs=<int>): " + this.monitoringTimeIntervalBetweenSnapshotsSecs);
            System.out.println((String)charSequence + "Monitoring: time interval between writing threads' names on command line? [" + false + "] (montibwtn=<int>): " + this.monitoringTimeIntervalBetweenWritingThreadsNamesSecsSetOnCommandLine);
            System.out.println((String)charSequence + "Monitoring: time interval between writing threads' names (valid only if on command line) [" + 600 + "] seconds (montibwtn=<int>): " + this.monitoringTimeIntervalBetweenWritingThreadsNamesSecs);
            System.out.println((String)charSequence + "Monitoring: time interval between writing application threads' thread CPU affinity settings [" + 300 + "] seconds (montibwttca=<int>): " + this.monitoringTimeIntervalBetweenWritingThreadsThreadCPUAffinitySecs);
            System.out.println((String)charSequence + "Monitoring: CPU time percent use threshold for low to high CPU use [" + this.mLowToHighPercentCPUTimeUseThresholdDefaultValue + "] percent of CPU time (monPercentCPUTimeUseThresh=<int>): " + this.mLowToHighPercentCPUTimeUseThreshold);
            System.out.println((String)charSequence + "Monitoring: Number of historical snapshots to save and access for analysis [" + this.historicalThreadCPUDataNumberOfElementsDefaultValue + "] (moncpuhistsize=<int>): " + this.historicalThreadCPUDataNumberOfElements);
            System.out.println((String)charSequence + "Monitoring: Save the performance snapshots to a file [" + false + "] (monsaveperfdata): " + this.savePerformanceSnapshotsToFile);
        }
    }

    @Override
    public void run() {
        if (this.monitoringTimeIntervalBetweenSnapshotsSecs < 1) {
            this.monitoringTimeIntervalBetweenSnapshotsSecs = 1;
        }
        if (this.historicalThreadCPUDataNumberOfElements < 2) {
            this.historicalThreadCPUDataNumberOfElements = 2;
        }
        this.monitoringTimeIntervalBetweenSnapshotsSecsMXBeans = this.monitoringTimeIntervalBetweenSnapshotsSecs;
        this.historicalThreadCPUDataNumberOfElementsMXBeans = this.historicalThreadCPUDataNumberOfElements;
        long l = this.monitoringTimeIntervalBetweenSnapshotsSecs;
        if (this.skipFirstPerformanceSnapshot) {
            l = 0L;
        }
        this.initializeApplicationThreadCPUTimeUseLogging();
        while (true) {
            if (!Thread.currentThread().isDaemon()) {
                continue;
            }
            if (this.firstTime) {
                if (this.verboseProgress) {
                    System.out.println(this.getLogLinePrefix() + "Starting thread to monitor each thread's CPU consumption after " + this.monitoringDelayStartTimeMS + " milliseconds.");
                }
                try {
                    Thread.sleep(this.monitoringDelayStartTimeMS);
                }
                catch (InterruptedException interruptedException) {
                    System.out.println(this.getLogLinePrefix() + "MonitorProcessCPUUse: Sleep interrupted.");
                }
                this.firstTime = false;
            }
            this.monitoringTimeIntervalBetweenSnapshotsSecs = this.monitoringTimeIntervalBetweenSnapshotsSecsMXBeans;
            this.updateHistoricalThreadCPUDataStructures();
            if (l >= (long)this.monitoringTimeIntervalBetweenSnapshotsSecs) {
                l = 0L;
                ProcessThreadsCPUUse processThreadsCPUUse = this.processThreads.collectThreadCPUUseInfo();
                this.addAMeasurement(processThreadsCPUUse);
                this.writeSnapshotToLogFile(processThreadsCPUUse);
            }
            ++l;
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                System.out.println(this.getLogLinePrefix() + "MonitorProcessCPUUse: Sleep interrupted.");
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void Finalize() throws Throwable {
        try {
            if (this.bufferedWriterForThreadCPUSnapshotLogging != null) {
                this.bufferedWriterForThreadCPUSnapshotLogging.flush();
                this.bufferedWriterForThreadCPUSnapshotLogging.close();
            }
        }
        catch (IOException iOException) {
        }
        finally {
            super.finalize();
        }
    }

    private MonitorProcessCPUUse() {
        System.err.println("[MonitorProcessCPUUse] " + System.currentTimeMillis() + "ERROR: MonitorProcessCPUUse should never execute this private parameterless constructor");
        System.err.println("[MonitorProcessCPUUse] " + System.currentTimeMillis() + "ERROR: Process exiting");
        System.exit(1);
    }

    public MonitorProcessCPUUse(String string) {
        thisMonitorProcessCPUUseInstance = this;
        this.timeMXBean = TimeMXBeanImpl.getInstance();
        this.processOptions(string);
        this.processThreads = new ProcessThreads(string);
        if (this.processThreads == null) {
            System.err.println(this.getLogLinePrefix() + "ERROR: MonitorProcessCPUUse: Object creation error.");
        }
        try {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            ThreadOptMonitoringMXBeanImpl threadOptMonitoringMXBeanImpl = ThreadOptMonitoringMXBeanImpl.getInstance();
            ObjectName objectName = ThreadOptMonitoringMXBeanImpl.getObjectName();
            mBeanServer.registerMBean(threadOptMonitoringMXBeanImpl, objectName);
        }
        catch (Exception exception) {
            System.err.println(this.getLogLinePrefix() + "ERROR in registration of the ThreadOptMonitoringMXBean");
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        String string = "";
        if (stringArray != null && stringArray.length > 0 && stringArray[0] != null) {
            string = stringArray[0];
        }
        System.out.println("[MonitorProcessCPUUse] " + System.currentTimeMillis() + " In main() with arguments: " + string);
        MonitorProcessCPUUse monitorProcessCPUUse = null;
        try {
            monitorProcessCPUUse = new MonitorProcessCPUUse(string);
            monitorProcessCPUUse.setName("ZingThreadOpt-Monitoring");
            monitorProcessCPUUse.setDaemon(true);
            monitorProcessCPUUse.start();
        }
        catch (Exception exception) {
            System.err.println("MonitorProcessCPUUse: ERROR in initialization of MonitorProcessCPUUse object");
            exception.printStackTrace();
            System.exit(1);
        }
        while (true) {
            System.out.println("[MonitorProcessCPUUse] " + System.currentTimeMillis() + " Process's main thread is running (process is alive message repeated every 20 seconds)");
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            monitorProcessCPUUse.constructListsOfLowCPUAndHighCPUConsumingAppThreads(arrayList, arrayList2);
            System.out.println("[MonitorProcessCPUUse] " + System.currentTimeMillis() + " main: low and high CPU consumption app threads");
            System.out.println("[MonitorProcessCPUUse] " + System.currentTimeMillis() + "  Low: " + arrayList);
            System.out.println("[MonitorProcessCPUUse] " + System.currentTimeMillis() + "  High: " + arrayList2);
            try {
                Thread.sleep(20000L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }
}

