/*
 * Decompiled with CFR 0.152.
 */
package com.azul.threadopt;

import com.azul.threadopt.CommandLineOptions;
import com.azul.threadopt.TimeMXBeanImpl;
import com.azul.threadopt.Utils;
import com.azul.threadopt.mxbeans.TimeMXBean;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class MachineArchitecture {
    private final boolean verboseOnDefaultValue = false;
    private final boolean verboseDefaultValue = false;
    private final boolean verboseTopologyMappingDefaultValue = false;
    private final boolean verboseOptionsCheckDefaultValue = false;
    private final boolean verboseCPUDefaultValue = false;
    private final boolean logDefaultValue = false;
    private final boolean printDetailedInfoDefaultValue = false;
    private final String csvListOfCPUThreadsForLowCPUConsumersDefaultValue = "0-1";
    private final String csvListOfCPUThreadsForHighCPUConsumersDefaultValue = "2-3";
    private final String csvListOfAllCPUThreadsDefaultValue = "0,1,2,3";
    private boolean verboseOn = false;
    private boolean verbose = false;
    private boolean verboseTopologyMapping = false;
    private boolean verboseCPU = false;
    private boolean verboseOptionsCheck = false;
    private boolean log = false;
    private boolean printDetailedInfo = false;
    private TimeMXBean timeMXBean = null;
    private String logfile = "";
    private String procSlashcpuinfoFile = "/proc/cpuinfo";
    private String sysSlashdevSlashdevicesSlashsystemSlashcpu_dir = "/sys/devices/system/cpu";
    private List<ArrayList<Integer>> cpuNodeToCPUThreads = new ArrayList<ArrayList<Integer>>();
    private Map<Integer, Integer> cpuThreadToCPUNode = new TreeMap<Integer, Integer>();
    private Map<String, ArrayList<Integer>> sharedCoreMaskToCPUThreads = new TreeMap<String, ArrayList<Integer>>();
    private Map<Integer, String> cpuThreadToSharedCoreMask = new TreeMap<Integer, String>();
    private Map<Integer, ArrayList<Integer>> physicalCoreToCPUThreadsRunningOnCore = new TreeMap<Integer, ArrayList<Integer>>();
    private String csvListOfAllCPUThreads = "0,1,2,3";
    private String csvListOfCPUThreadsForLowCPUConsumers = "0-1";
    private String csvListOfCPUThreadsForHighCPUConsumers = "2-3";
    private List<Integer> arrayOfAllCPUThreads = new ArrayList<Integer>();
    private List<Integer> arrayOfCPUThreadsForLowCPUConsumers = new ArrayList<Integer>();
    private List<Integer> arrayOfCPUThreadsForHighCPUConsumers = new ArrayList<Integer>();
    private List<Integer> arrayOfCPUCoresForHighCPUConsumers = new ArrayList<Integer>();

    private String getLogLinePrefix() {
        if (this.timeMXBean != null) {
            return this.timeMXBean.getElapsedTimeSinceJVMStartSecStr() + " [ThreadOpt] ";
        }
        return "[ThreadOpt] ";
    }

    private void exitFollowingUnrecoverableError() {
        System.err.println(this.getLogLinePrefix() + "ERROR: Exiting after encountering unrecoverable error.");
        System.err.println(this.getLogLinePrefix() + "ERROR: Please rerun and include the options to ThreadOpt: -XX:ThreadOptOptions='v vcpu details' to help diagnose the problem.");
        System.exit(1);
    }

    public String getCSVListOfAllCPUThreads() {
        return this.csvListOfAllCPUThreads;
    }

    public String getCSVListOfCPUThreadsForLowCPUConsumers() {
        return this.csvListOfCPUThreadsForLowCPUConsumers;
    }

    public String getCSVListOfCPUThreadsForHighCPUConsumers() {
        return this.csvListOfCPUThreadsForHighCPUConsumers;
    }

    public List<Integer> getArrayOfAllCPUThreads() {
        return this.arrayOfAllCPUThreads;
    }

    public boolean isCPUThreadInArrayOfAllCPUThreads(Integer n) {
        return this.arrayOfAllCPUThreads == null ? false : this.arrayOfAllCPUThreads.contains(n);
    }

    public List<Integer> getArrayOfCPUThreadsForLowCPUConsumers() {
        return this.arrayOfCPUThreadsForLowCPUConsumers;
    }

    public List<Integer> getArrayOfCPUThreadsForHighCPUConsumers() {
        return this.arrayOfCPUThreadsForHighCPUConsumers;
    }

    public List<Integer> getArrayOfCPUCoresForHighCPUConsumers() {
        return this.arrayOfCPUCoresForHighCPUConsumers;
    }

    public int getNumberOfCPUThreads() {
        return this.arrayOfAllCPUThreads == null ? 0 : this.arrayOfAllCPUThreads.size();
    }

    public int getNumberOfCPUThreadsForLowCPUConsumers() {
        return this.arrayOfCPUThreadsForLowCPUConsumers == null ? 0 : this.arrayOfCPUThreadsForLowCPUConsumers.size();
    }

    public int getNumberOfCPUThreadsForHighCPUConsumers() {
        return this.arrayOfCPUThreadsForHighCPUConsumers == null ? 0 : this.arrayOfCPUThreadsForHighCPUConsumers.size();
    }

    public int getNumberOfCPUCoresForHighCPUConsumers() {
        return this.arrayOfCPUCoresForHighCPUConsumers == null ? 0 : this.arrayOfCPUCoresForHighCPUConsumers.size();
    }

    public List<Integer> physicalCoreToCPUThreadsRunningOnCore(Integer n) {
        List list = this.physicalCoreToCPUThreadsRunningOnCore.get(n);
        return list;
    }

    public void setCPUThreadIDCPUNodeRelationship(String string, String string2, String string3, int n) {
        if (string != "" && string2 != "") {
            if (this.printDetailedInfo) {
                System.out.println(this.getLogLinePrefix() + "getCPUThreadIDCPUNodeRelation ... cpuThreadID: " + string + " cpuNodeID: " + string2);
            }
            Integer n2 = 0;
            try {
                n2 = Integer.parseInt(string);
            }
            catch (Exception exception) {
                System.err.println(this.getLogLinePrefix() + "ERROR: Non-numeric value found for CPU Thread Identifier: >" + string + "<");
                System.err.println(this.getLogLinePrefix() + "ERROR: See " + string3 + " line: " + n);
                this.exitFollowingUnrecoverableError();
            }
            Integer n3 = 0;
            try {
                n3 = Integer.parseInt(string2);
            }
            catch (Exception exception) {
                System.err.println(this.getLogLinePrefix() + "ERROR: Non-numeric value found for CPU Node identifier: >" + string2 + "<");
                System.err.println(this.getLogLinePrefix() + "ERROR: See " + string3 + " line: " + n);
                this.exitFollowingUnrecoverableError();
            }
            int n4 = this.cpuNodeToCPUThreads.size();
            if (n4 < n3 + 1) {
                for (int i = n4; i < n3 + 1; ++i) {
                    if (this.printDetailedInfo) {
                        System.out.println(this.getLogLinePrefix() + "getCPUThreadIDCPUNodeRelation ... adding cpuNodeToCPUThreads array entry: : " + i);
                    }
                    this.cpuNodeToCPUThreads.add(i, new ArrayList());
                }
            }
            if (this.printDetailedInfo) {
                System.out.println(this.getLogLinePrefix() + "getCPUThreadIDCPUNodeRelation ... cpuNodeIDInt: " + n3 + " arrSize: " + n4);
            }
            this.cpuNodeToCPUThreads.get(n3).add(n2);
            this.cpuThreadToCPUNode.put(n2, n3);
        }
    }

    public void getCPUNodeAndCPUThreadConfiguration() {
        int n;
        if (this.verboseCPU) {
            System.out.println(this.getLogLinePrefix() + "Building CPU node and CPU thread list data structures");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Utils.runACommand("cat " + this.procSlashcpuinfoFile, arrayList);
        boolean bl = true;
        if (arrayList.size() < 3) {
            System.err.println(this.getLogLinePrefix() + "ERROR: " + this.procSlashcpuinfoFile + " has no contents to use to determine CPU Thread and CPU Node attributes.");
            this.exitFollowingUnrecoverableError();
        }
        String string = "";
        String string2 = "";
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < arrayList.size(); ++n) {
            boolean bl2;
            String string3 = ((String)arrayList.get(n)).toString();
            boolean bl3 = bl2 = string3.length() > 8 && string3.charAt(0) == 'p';
            if (bl2 && string3.matches("^processor.*")) {
                if (!bl) {
                    if (n3 > 0) {
                        System.err.println(this.getLogLinePrefix() + "ERROR: Inconsistent information in file " + this.procSlashcpuinfoFile);
                        System.err.println(this.getLogLinePrefix() + "ERROR:   CPU Thread Identifier " + string + " is entry " + n2 + " of that type in the file.");
                        System.err.println(this.getLogLinePrefix() + "ERROR: Previously, encountered a line with CPU Node Identifier information - missing for this line.");
                        System.err.println(this.getLogLinePrefix() + "ERROR: Occurs in file " + this.procSlashcpuinfoFile + " before line: " + n);
                        this.exitFollowingUnrecoverableError();
                    }
                    this.setCPUThreadIDCPUNodeRelationship(string, "0", this.procSlashcpuinfoFile, n);
                    string = "";
                    string2 = "";
                }
                ++n2;
                string = string3.substring(string3.lastIndexOf(":") + 2);
                bl = false;
                continue;
            }
            if (!bl2 || !string3.matches("^physical.*")) continue;
            ++n3;
            bl = true;
            string2 = string3.substring(string3.lastIndexOf(":") + 2);
            if (string.equals("")) {
                System.err.println(this.getLogLinePrefix() + "ERROR: Missing CPU Thread Identifier associated with the CPU Node Identifier: " + string2);
                System.err.println(this.getLogLinePrefix() + "ERROR: Occurs at CPU Node Identifier type line number: " + n3 + " in file " + this.procSlashcpuinfoFile + " at overall line number: " + n);
                this.exitFollowingUnrecoverableError();
            }
            if (n2 != n3) {
                System.err.println(this.getLogLinePrefix() + "ERROR: Inconsistent information in file " + this.procSlashcpuinfoFile);
                System.err.println(this.getLogLinePrefix() + "ERROR:   CPU Thread Identifier " + string + " is entry " + n2 + " of that type in the file.");
                System.err.println(this.getLogLinePrefix() + "ERROR:   CPU Node Identifier   " + string2 + " is entry " + n3 + " of that type in the file.");
                System.err.println(this.getLogLinePrefix() + "ERROR: Entry numbers should be the same.");
                System.err.println(this.getLogLinePrefix() + "ERROR: Occurs in file " + this.procSlashcpuinfoFile + " before line: " + n);
                this.exitFollowingUnrecoverableError();
            }
            this.setCPUThreadIDCPUNodeRelationship(string, string2, this.procSlashcpuinfoFile, n);
            string = "";
            string2 = "";
        }
        if (n2 > 1 && !string.equals("") && !bl) {
            this.setCPUThreadIDCPUNodeRelationship(string, "0", this.procSlashcpuinfoFile, n);
        }
        if (this.verboseOn || this.verbose) {
            System.out.println(this.getLogLinePrefix() + "CPU thread to CPU node: " + this.cpuThreadToCPUNode);
            for (int i = 0; i < this.cpuNodeToCPUThreads.size(); ++i) {
                System.out.println(this.getLogLinePrefix() + "CPU node to CPU threads [" + i + "]: " + this.cpuNodeToCPUThreads.get(i));
            }
        }
    }

    public void partitionCPUThreadsBetweenLowCPUConsumingAndHighCPUConsumingPartitions() {
        if (this.verboseCPU) {
            System.out.println(this.getLogLinePrefix() + "Building node list");
        }
        this.csvListOfAllCPUThreads = "";
        this.csvListOfCPUThreadsForLowCPUConsumers = "";
        this.csvListOfCPUThreadsForHighCPUConsumers = "";
        this.arrayOfAllCPUThreads = new ArrayList<Integer>();
        this.arrayOfCPUThreadsForLowCPUConsumers = new ArrayList<Integer>();
        this.arrayOfCPUThreadsForHighCPUConsumers = new ArrayList<Integer>();
        this.arrayOfCPUCoresForHighCPUConsumers = new ArrayList<Integer>();
        for (Map.Entry<Integer, Integer> entry : this.cpuThreadToCPUNode.entrySet()) {
            int n = entry.getKey();
            int n2 = entry.getValue();
            this.arrayOfAllCPUThreads.add(n);
            this.csvListOfAllCPUThreads = this.csvListOfAllCPUThreads.length() > 0 ? this.csvListOfAllCPUThreads + "," + n : Integer.toString(n);
            if (n2 == 0) {
                this.arrayOfCPUThreadsForLowCPUConsumers.add(n);
                if (this.csvListOfCPUThreadsForLowCPUConsumers.length() > 0) {
                    this.csvListOfCPUThreadsForLowCPUConsumers = this.csvListOfCPUThreadsForLowCPUConsumers + "," + n;
                    continue;
                }
                this.csvListOfCPUThreadsForLowCPUConsumers = Integer.toString(n);
                continue;
            }
            this.arrayOfCPUThreadsForHighCPUConsumers.add(n);
            if (this.csvListOfCPUThreadsForHighCPUConsumers.length() > 0) {
                this.csvListOfCPUThreadsForHighCPUConsumers = this.csvListOfCPUThreadsForHighCPUConsumers + "," + n;
                continue;
            }
            this.csvListOfCPUThreadsForHighCPUConsumers = Integer.toString(n);
        }
        if (this.verboseOn || this.verbose) {
            String string = this.getLogLinePrefix();
            System.out.println((String)string + "low_CPU: " + this.csvListOfCPUThreadsForLowCPUConsumers);
            System.out.println((String)string + "high_CPU: " + this.csvListOfCPUThreadsForHighCPUConsumers);
            System.out.println((String)string + "all_CPU: " + this.csvListOfAllCPUThreads);
        }
        if (this.csvListOfCPUThreadsForHighCPUConsumers.equals("")) {
            this.csvListOfCPUThreadsForHighCPUConsumers = this.csvListOfCPUThreadsForLowCPUConsumers;
        }
        if (this.csvListOfCPUThreadsForLowCPUConsumers.equals("")) {
            this.csvListOfCPUThreadsForLowCPUConsumers = this.csvListOfCPUThreadsForHighCPUConsumers;
        }
    }

    public void identifyCPUThreadsRunningOnSameCore() {
        Map.Entry<String, ArrayList<Integer>> entry2;
        String string = Utils.createUniqueTempPathSlashFileName();
        ArrayList<String> arrayList = new ArrayList<String>();
        Utils.runACommand("find " + this.sysSlashdevSlashdevicesSlashsystemSlashcpu_dir + " -iname thread_siblings -print -fprint " + string, arrayList);
        arrayList = new ArrayList();
        Utils.runACommand("xargs -r -n1000 -a " + string + " tail -v ", arrayList);
        Utils.deleteFile(string);
        if (this.verboseCPU) {
            System.out.println(this.getLogLinePrefix() + "identifyCPUThreadsRunningOnSameCore() Entry");
        }
        String string2 = "";
        String string3 = "";
        for (int i = 0; i < arrayList.size(); ++i) {
            if (this.verboseTopologyMapping) {
                System.out.println(this.getLogLinePrefix() + "Process line: " + i + " >" + (String)arrayList.get(i) + "<");
            }
            if (((String)((Object)(entry2 = (String)arrayList.get(i)))).length() <= 0) continue;
            if (((String)((Object)entry2)).matches("^==>.*/cpu/.*")) {
                int n = ((String)((Object)entry2)).lastIndexOf(this.sysSlashdevSlashdevicesSlashsystemSlashcpu_dir + "/cpu") + this.sysSlashdevSlashdevicesSlashsystemSlashcpu_dir.length() + 4;
                int n2 = ((String)((Object)entry2)).lastIndexOf("/topology");
                string2 = ((String)((Object)entry2)).substring(n, n2);
                continue;
            }
            if (!((String)((Object)entry2)).matches("[0-9a-fA-F,]+")) continue;
            Integer n = 0;
            try {
                n = Integer.parseInt(string2);
            }
            catch (Exception exception) {
                System.err.println(this.getLogLinePrefix() + "ERROR: Non-numeric value found for CPU Thread Identifier: >" + string2 + "<");
                this.exitFollowingUnrecoverableError();
            }
            ArrayList<Integer> arrayList2 = this.sharedCoreMaskToCPUThreads.get(entry2);
            if (arrayList2 == null) {
                arrayList2 = new ArrayList(2);
                arrayList2.add(n);
                this.sharedCoreMaskToCPUThreads.put((String)((Object)entry2), arrayList2);
            } else {
                this.sharedCoreMaskToCPUThreads.get(entry2).add(n);
            }
            this.cpuThreadToSharedCoreMask.put(n, (String)((Object)entry2));
            if (!this.verboseTopologyMapping) continue;
            System.out.println(this.getLogLinePrefix() + "Initial mapping core to CPU thread - Core's shared core mask value: " + entry2 + " comma-separated list of CPU threads on core: " + string3);
        }
        if (this.verboseCPU) {
            System.out.println(this.getLogLinePrefix() + "CPU thread to shared core mask: " + this.cpuThreadToSharedCoreMask);
            System.out.println(this.getLogLinePrefix() + "sharedCoreMaskToCPUThreads size: " + this.sharedCoreMaskToCPUThreads.size());
            for (Map.Entry<String, ArrayList<Integer>> entry2 : this.sharedCoreMaskToCPUThreads.entrySet()) {
                System.out.println(this.getLogLinePrefix() + "Shared core mask to CPU threads: " + entry2.getKey() + " " + entry2.getValue());
            }
        }
        Set<Map.Entry<String, ArrayList<Integer>>> set = this.sharedCoreMaskToCPUThreads.entrySet();
        entry2 = set.iterator();
        this.csvListOfCPUThreadsForLowCPUConsumers = "";
        this.csvListOfCPUThreadsForHighCPUConsumers = "";
        this.arrayOfCPUThreadsForLowCPUConsumers = new ArrayList<Integer>();
        this.arrayOfCPUThreadsForHighCPUConsumers = new ArrayList<Integer>();
        this.arrayOfCPUCoresForHighCPUConsumers = new ArrayList<Integer>();
        while (entry2.hasNext()) {
            Serializable serializable2;
            Integer n;
            Map.Entry entry3 = (Map.Entry)entry2.next();
            ArrayList arrayList3 = (ArrayList)entry3.getValue();
            if (arrayList3 == null || arrayList3.size() < 1) {
                System.err.println(this.getLogLinePrefix() + "ERROR: Missing data in CPU mask data structure at: " + (String)entry3.getKey());
                this.exitFollowingUnrecoverableError();
            }
            if ((n = (Integer)arrayList3.get(0)) == null) {
                System.err.println(this.getLogLinePrefix() + "ERROR: Missing data for CPU threads running on one CPU mask data structure for CPU mask: " + (String)entry3.getKey());
                this.exitFollowingUnrecoverableError();
            }
            Integer n3 = n;
            for (Serializable serializable2 : arrayList3) {
                if ((Integer)serializable2 >= n3) continue;
                n3 = serializable2;
            }
            Integer n4 = this.cpuThreadToCPUNode.get(n3);
            serializable2 = new ArrayList();
            String string4 = "";
            for (Integer n5 : arrayList3) {
                ((ArrayList)serializable2).add(n5);
                if (string4.length() > 0) {
                    string4 = string4 + "," + n5;
                    continue;
                }
                string4 = n5.toString();
            }
            this.physicalCoreToCPUThreadsRunningOnCore.put(n3, (ArrayList<Integer>)serializable2);
            if (this.verboseOn || this.verbose) {
                System.out.println(this.getLogLinePrefix() + "Set of all CPU threads: " + (String)entry3.getKey() + " CPU node: " + n4 + " CPU threads: " + string4);
                System.out.println(this.getLogLinePrefix() + "Physical core mapping to CPU threads on physical core: " + n3 + " CPU threads: " + serializable2);
            }
            if (n4 == null) {
                System.err.println(this.getLogLinePrefix() + "ERROR: Serious issue with the processing of the hardware configuration:");
                System.err.println(this.getLogLinePrefix() + "ERROR: CPU Node value is null.");
                this.exitFollowingUnrecoverableError();
            }
            if (n4 == 0) {
                this.csvListOfCPUThreadsForLowCPUConsumers = this.csvListOfCPUThreadsForLowCPUConsumers.length() > 0 ? this.csvListOfCPUThreadsForLowCPUConsumers + "," + string4 : string4;
                for (Integer n5 : arrayList3) {
                    this.arrayOfCPUThreadsForLowCPUConsumers.add(n5);
                }
                continue;
            }
            this.arrayOfCPUCoresForHighCPUConsumers.add(n3);
            this.csvListOfCPUThreadsForHighCPUConsumers = this.csvListOfCPUThreadsForHighCPUConsumers.length() > 0 ? this.csvListOfCPUThreadsForHighCPUConsumers + "," + string4 : string4;
            for (Integer n5 : arrayList3) {
                this.arrayOfCPUThreadsForHighCPUConsumers.add(n5);
            }
        }
        if (this.csvListOfCPUThreadsForHighCPUConsumers.equals("")) {
            System.err.println(this.getLogLinePrefix() + "ERROR: Serious issue with the processing of the hardware configuration:");
            System.err.println(this.getLogLinePrefix() + "ERROR: No CPU threads found to include in the set of CPU threads for the high" + " CPU consuming application threads.");
            System.err.println(this.getLogLinePrefix() + "ERROR: Will try to use all the CPU threads for both low and high CPU consuming application threads.");
            if (this.csvListOfCPUThreadsForLowCPUConsumers.equals("")) {
                System.err.println(this.getLogLinePrefix() + "ERROR: No CPU threads found to include in the set of CPU threads for the low" + " CPU consuming application threads.");
                this.exitFollowingUnrecoverableError();
            } else {
                this.csvListOfCPUThreadsForHighCPUConsumers = this.csvListOfCPUThreadsForLowCPUConsumers;
                for (Integer n : this.arrayOfCPUThreadsForLowCPUConsumers) {
                    this.arrayOfCPUThreadsForHighCPUConsumers.add(n);
                    this.arrayOfCPUCoresForHighCPUConsumers.add(n);
                }
            }
        } else if (this.csvListOfCPUThreadsForLowCPUConsumers.equals("")) {
            System.err.println(this.getLogLinePrefix() + "ERROR: Serious issue with the processing of the hardware configuration:");
            System.err.println(this.getLogLinePrefix() + "ERROR: No CPU threads found to include in the set of CPU threads for the low" + " CPU consuming application threads.");
            System.err.println(this.getLogLinePrefix() + "ERROR: Will try to use all the CPU threads for both low and high CPU consuming application threads.");
            this.csvListOfCPUThreadsForLowCPUConsumers = this.csvListOfCPUThreadsForHighCPUConsumers;
            for (Integer n : this.arrayOfCPUThreadsForHighCPUConsumers) {
                this.arrayOfCPUThreadsForLowCPUConsumers.add(n);
            }
        }
        if (this.verboseOn || this.verbose) {
            System.out.println(this.getLogLinePrefix() + "Initialization: Affinity CPU thread set for low CPU consuming threads: " + this.csvListOfCPUThreadsForLowCPUConsumers);
            System.out.println(this.getLogLinePrefix() + "Initialization: Affinity CPU thread set for high CPU consuming threads: " + this.csvListOfCPUThreadsForHighCPUConsumers);
            System.out.println(this.getLogLinePrefix() + "Initialization: Affinity CPU physical core set for high CPU consuming threads: " + this.arrayOfCPUCoresForHighCPUConsumers);
        }
    }

    public void processOptions(String string) {
        String[] stringArray;
        boolean bl = true;
        if (string != null && string.length() > 0) {
            stringArray = string.split("\\s+|%");
            CommandLineOptions commandLineOptions = CommandLineOptions.getInstance();
            if (!commandLineOptions.isCommandLineOptionsInitialized()) {
                commandLineOptions.initializeCommandLineOptions(stringArray);
            }
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i].toLowerCase();
                if (string2.matches("^voc")) {
                    this.verboseOptionsCheck = true;
                    commandLineOptions.processedOption(string2);
                } else if (string2.matches("^vcpu")) {
                    this.verboseCPU = true;
                    commandLineOptions.processedOption(string2);
                } else if (string2.matches("^vtm")) {
                    this.verboseTopologyMapping = true;
                    commandLineOptions.processedOption(string2);
                } else if (string2.matches("^verbose=.*")) {
                    String string3 = string2.substring(8);
                    this.verboseOn = commandLineOptions.checkBooleanValue(string2, string3);
                } else if (string2.matches("^v")) {
                    this.verbose = true;
                    commandLineOptions.processedOption(string2);
                } else if (string2.matches("^details")) {
                    this.printDetailedInfo = true;
                    commandLineOptions.processedOption(string2);
                } else if (string2.matches("^log")) {
                    this.log = true;
                    commandLineOptions.processedOption(string2);
                } else if (string2.matches("^logfile")) {
                    this.logfile = "threadOpt.log";
                    System.out.println(this.getLogLinePrefix() + "LOG p " + stringArray[i].substring(1) + " Log " + this.logfile);
                    commandLineOptions.processedOption(string2);
                } else if (string2.matches("^proccpuinfo=.*")) {
                    this.procSlashcpuinfoFile = stringArray[i].substring(12);
                    if (this.procSlashcpuinfoFile.length() < 1) {
                        System.err.println(this.getLogLinePrefix() + "ERROR: value of proccpuinfo option must have length greater than zero");
                        this.exitFollowingUnrecoverableError();
                    }
                    commandLineOptions.processedOption(string2);
                } else if (string2.matches("^sysdevicessystemcpudir=.*")) {
                    this.sysSlashdevSlashdevicesSlashsystemSlashcpu_dir = stringArray[i].substring(23);
                    if (this.sysSlashdevSlashdevicesSlashsystemSlashcpu_dir.length() < 1) {
                        System.err.println(this.getLogLinePrefix() + "ERROR: value of sysdevicessystemcpudir option must have length greater than zero");
                        this.exitFollowingUnrecoverableError();
                    }
                    commandLineOptions.processedOption(string2);
                }
                if (!this.verboseOn && !this.verbose) continue;
                if (bl) {
                    bl = false;
                    System.out.println(this.getLogLinePrefix() + "Process MachineArchitecture options");
                }
                System.out.println(this.getLogLinePrefix() + "Option to ThreadOpt (MA): " + i + " = " + stringArray[i]);
            }
        }
        if (this.verboseOn || this.verbose) {
            stringArray = this.getLogLinePrefix() + "Options and internal variables settings: ";
            System.out.println((String)stringArray + "Verbose [" + false + "] (v): " + this.verbose);
            if (this.verboseOptionsCheck) {
                System.out.println((String)stringArray + "Print detailed info [" + false + "] (details): " + this.printDetailedInfo);
                System.out.println((String)stringArray + "Logging on [" + false + "] (log): " + this.log);
                System.out.println((String)stringArray + "Logfile name []: " + this.logfile);
            }
        }
    }

    public MachineArchitecture(String string) {
        this.timeMXBean = TimeMXBeanImpl.getInstance();
        this.processOptions(string);
    }

    public static void main(String[] stringArray) {
        System.out.println("[MachineArchitecture] " + System.currentTimeMillis() + " MachineArchitecture.main() entry");
        System.out.println("[MachineArchitecture] " + System.currentTimeMillis() + " Arguments: " + stringArray);
        String string = "";
        if (stringArray != null && stringArray.length > 0 && stringArray[0] != null) {
            string = stringArray[0];
        }
        MachineArchitecture machineArchitecture = new MachineArchitecture(string);
        machineArchitecture.getCPUNodeAndCPUThreadConfiguration();
        machineArchitecture.partitionCPUThreadsBetweenLowCPUConsumingAndHighCPUConsumingPartitions();
        machineArchitecture.identifyCPUThreadsRunningOnSameCore();
        System.out.println("[MachineArchitecture] " + System.currentTimeMillis() + " MachineArchitecture.main() exit");
    }
}

