/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal.dcmd;

import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import jdk.jfr.Recording;
import jdk.jfr.internal.LogLevel;
import jdk.jfr.internal.LogTag;
import jdk.jfr.internal.Logger;
import jdk.jfr.internal.SecuritySupport;
import jdk.jfr.internal.dcmd.AbstractDCmd;
import jdk.jfr.internal.dcmd.DCmdException;

final class DCmdStop
extends AbstractDCmd {
    DCmdStop() {
    }

    public String[] execute(String string, String string2) throws DCmdException {
        if (Logger.shouldLog(LogTag.JFR_DCMD, LogLevel.DEBUG)) {
            Logger.log(LogTag.JFR_DCMD, LogLevel.DEBUG, "Executing DCmdStart: name=" + string + ", filename=" + string2);
        }
        try {
            SecuritySupport.SafePath safePath = null;
            Recording recording = this.findRecording(string);
            if (string2 != null) {
                try {
                    safePath = this.resolvePath(null, string2);
                    recording.setDestination(Paths.get(string2, new String[0]));
                }
                catch (IOException | InvalidPathException exception) {
                    throw new DCmdException("Failed to stop %s. Could not set destination for \"%s\" to file %s", recording.getName(), string2, exception.getMessage());
                }
            }
            recording.stop();
            this.reportOperationComplete("Stopped", recording.getName(), safePath);
            recording.close();
            return this.getResult();
        }
        catch (InvalidPathException | DCmdException exception) {
            if (string2 != null) {
                throw new DCmdException("Could not write recording \"%s\" to file. %s", string, exception.getMessage());
            }
            throw new DCmdException(exception, "Could not stop recording \"%s\".", string, exception.getMessage());
        }
    }
}

