/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal.dcmd;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import jdk.jfr.EventType;
import jdk.jfr.Recording;
import jdk.jfr.SettingDescriptor;
import jdk.jfr.internal.LogLevel;
import jdk.jfr.internal.LogTag;
import jdk.jfr.internal.Logger;
import jdk.jfr.internal.Utils;
import jdk.jfr.internal.dcmd.AbstractDCmd;
import jdk.jfr.internal.dcmd.DCmdException;

final class DCmdCheck
extends AbstractDCmd {
    DCmdCheck() {
    }

    public String[] execute(String string, Boolean bl) throws DCmdException {
        this.executeInternal(string, bl);
        return this.getResult();
    }

    private void executeInternal(String string, Boolean bl) throws DCmdException {
        if (Logger.shouldLog(LogTag.JFR_DCMD, LogLevel.DEBUG)) {
            Logger.log(LogTag.JFR_DCMD, LogLevel.DEBUG, "Executing DCmdCheck: name=" + string + ", verbose=" + bl);
        }
        if (bl == null) {
            bl = Boolean.FALSE;
        }
        if (string != null) {
            this.printRecording(this.findRecording(string), bl);
            return;
        }
        List<Recording> list = this.getRecordings();
        if (!bl.booleanValue() && list.isEmpty()) {
            this.println("No available recordings.", new Object[0]);
            this.println();
            this.println("Use jcmd " + this.getPid() + " JFR.start to start a recording.", new Object[0]);
            return;
        }
        boolean bl2 = true;
        for (Recording recording : list) {
            if (!bl2) {
                this.println();
                if (Boolean.TRUE.equals(bl)) {
                    this.println();
                }
            }
            bl2 = false;
            this.printRecording(recording, bl);
        }
    }

    private void printRecording(Recording recording, boolean bl) {
        this.printGeneral(recording);
        if (bl) {
            this.println();
            this.printSetttings(recording);
        }
    }

    private void printGeneral(Recording recording) {
        Duration duration;
        long l;
        this.print("Recording " + recording.getId() + ": name=" + recording.getName());
        Duration duration2 = recording.getDuration();
        if (duration2 != null) {
            this.print(" duration=");
            this.printTimespan(duration2, "");
        }
        if ((l = recording.getMaxSize()) != 0L) {
            this.print(" maxsize=");
            this.print(Utils.formatBytesCompact(l));
        }
        if ((duration = recording.getMaxAge()) != null) {
            this.print(" maxage=");
            this.printTimespan(duration, "");
        }
        this.print(" (" + recording.getState().toString().toLowerCase() + ")");
        this.println();
    }

    private void printSetttings(Recording recording) {
        Map<String, String> map = recording.getSettings();
        for (EventType eventType : DCmdCheck.sortByEventPath(this.getFlightRecorder().getEventTypes())) {
            StringJoiner stringJoiner = new StringJoiner(",", "[", "]");
            stringJoiner.setEmptyValue("");
            for (SettingDescriptor settingDescriptor : eventType.getSettingDescriptors()) {
                String string = eventType.getName() + "#" + settingDescriptor.getName();
                if (!map.containsKey(string)) continue;
                stringJoiner.add(settingDescriptor.getName() + "=" + map.get(string));
            }
            String string = stringJoiner.toString();
            if (string.isEmpty()) continue;
            this.print(" %s (%s)", eventType.getLabel(), eventType.getName());
            this.println();
            this.println("   " + (String)string, new Object[0]);
        }
    }

    private static List<EventType> sortByEventPath(Collection<EventType> collection) {
        ArrayList<EventType> arrayList = new ArrayList<EventType>();
        arrayList.addAll(collection);
        Collections.sort(arrayList, new Comparator<EventType>(){

            @Override
            public int compare(EventType eventType, EventType eventType2) {
                return eventType.getName().compareTo(eventType2.getName());
            }
        });
        return arrayList;
    }
}

