/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal.dcmd;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import jdk.jfr.FlightRecorder;
import jdk.jfr.Recording;
import jdk.jfr.internal.JVM;
import jdk.jfr.internal.SecuritySupport;
import jdk.jfr.internal.Utils;
import jdk.jfr.internal.dcmd.DCmdException;

abstract class AbstractDCmd {
    private final StringBuilder currentLine = new StringBuilder(80);
    private final List<String> lines = new ArrayList<String>();

    AbstractDCmd() {
    }

    protected final FlightRecorder getFlightRecorder() {
        return FlightRecorder.getFlightRecorder();
    }

    public final String[] getResult() {
        return this.lines.toArray(new String[this.lines.size()]);
    }

    public String getPid() {
        return JVM.getJVM().getPid();
    }

    protected final SecuritySupport.SafePath resolvePath(Recording recording, String string) throws InvalidPathException {
        if (string == null) {
            return this.makeGenerated(recording, Paths.get(".", new String[0]));
        }
        Path path = Paths.get(string, new String[0]);
        if (Files.isDirectory(path, new LinkOption[0])) {
            return this.makeGenerated(recording, path);
        }
        return new SecuritySupport.SafePath(path.toAbsolutePath().normalize());
    }

    private SecuritySupport.SafePath makeGenerated(Recording recording, Path path) {
        return new SecuritySupport.SafePath(path.toAbsolutePath().resolve(Utils.makeFilename(recording)).normalize());
    }

    protected final Recording findRecording(String string) throws DCmdException {
        try {
            return this.findRecordingById(Integer.parseInt(string));
        }
        catch (NumberFormatException numberFormatException) {
            return this.findRecordingByName(string);
        }
    }

    protected final void reportOperationComplete(String string, String string2, SecuritySupport.SafePath safePath) {
        this.print(string);
        this.print(" recording");
        if (string2 != null) {
            this.print(" \"" + string2 + "\"");
        }
        if (safePath != null) {
            this.print(",");
            try {
                this.print(" ");
                long l = SecuritySupport.getFileSize(safePath);
                this.printBytes(l);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.println(" written to:", new Object[0]);
            this.println();
            this.printPath(safePath);
        } else {
            this.println(".", new Object[0]);
        }
    }

    protected final List<Recording> getRecordings() {
        ArrayList<Recording> arrayList = new ArrayList<Recording>(this.getFlightRecorder().getRecordings());
        Collections.sort(arrayList, Comparator.comparing(Recording::getId));
        return arrayList;
    }

    static String quoteIfNeeded(String string) {
        if (string.contains(" ")) {
            return "\\\"" + string + "\\\"";
        }
        return string;
    }

    protected final void println() {
        this.lines.add(this.currentLine.toString());
        this.currentLine.setLength(0);
    }

    protected final void print(String string) {
        this.currentLine.append(string);
    }

    protected final void print(String string, Object ... objectArray) {
        this.currentLine.append(String.format(string, objectArray));
    }

    protected final void println(String string, Object ... objectArray) {
        this.print(string, objectArray);
        this.println();
    }

    protected final void printBytes(long l) {
        this.print(Utils.formatBytes(l));
    }

    protected final void printTimespan(Duration duration, String string) {
        this.print(Utils.formatTimespan(duration, string));
    }

    protected final void printPath(SecuritySupport.SafePath safePath) {
        if (safePath == null) {
            this.print("N/A");
            return;
        }
        try {
            this.printPath(SecuritySupport.getAbsolutePath(safePath).toPath());
        }
        catch (IOException iOException) {
            this.printPath(safePath.toPath());
        }
    }

    protected final void printPath(Path path) {
        try {
            this.println(path.toAbsolutePath().toString(), new Object[0]);
        }
        catch (SecurityException securityException) {
            this.println(path.toString(), new Object[0]);
        }
    }

    private Recording findRecordingById(int n) throws DCmdException {
        for (Recording recording : this.getFlightRecorder().getRecordings()) {
            if (recording.getId() != (long)n) continue;
            return recording;
        }
        throw new DCmdException("Could not find %d.\n\nUse JFR.check without options to see list of all available recordings.", n);
    }

    private Recording findRecordingByName(String string) throws DCmdException {
        for (Recording recording : this.getFlightRecorder().getRecordings()) {
            if (!string.equals(recording.getName())) continue;
            return recording;
        }
        throw new DCmdException("Could not find %s.\n\nUse JFR.check without options to see list of all available recordings.", string);
    }
}

