/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import jdk.jfr.internal.JVM;
import sun.misc.Unsafe;

public final class StringPool {
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    static final int MIN_LIMIT = 16;
    static final int MAX_LIMIT = 128;
    private static final long DO_NOT_POOL = -1L;
    private static final SimpleStringIdPool sp = new SimpleStringIdPool();

    static long addString(String string) {
        return StringPool.sp.addString(string);
    }

    static void reset() {
        StringPool.sp.reset();
    }

    private static class SimpleStringIdPool {
        private final AtomicLong sidIdx = new AtomicLong(1L);
        private final ConcurrentHashMap<String, Long> cache;
        private final int MAX_SIZE = 32768;
        private final long MAX_SIZE_UTF16 = 0x1000000L;
        private long currentSizeUTF16;
        private final String[] preCache = new String[]{"", "", "", ""};
        private int preCacheOld = 0;
        private static final int preCacheMask = 3;

        SimpleStringIdPool() {
            this.cache = new ConcurrentHashMap(32768, 0.75f);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void reset() {
            this.cache.clear();
            Class<SimpleStringIdPool> clazz = SimpleStringIdPool.class;
            synchronized (SimpleStringIdPool.class) {
                this.currentSizeUTF16 = 0L;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        private long addString(String string) {
            Long l = this.cache.get(string);
            if (l != null) {
                return l;
            }
            if (!this.preCache(string)) {
                return -1L;
            }
            if (this.cache.size() > 32768 || this.currentSizeUTF16 > 0x1000000L) {
                this.reset();
            }
            return this.storeString(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long storeString(String string) {
            long l = this.sidIdx.getAndIncrement();
            this.cache.put(string, l);
            Class<SimpleStringIdPool> clazz = SimpleStringIdPool.class;
            synchronized (SimpleStringIdPool.class) {
                JVM.addStringConstant(l, string);
                this.currentSizeUTF16 += (long)string.length();
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return l;
            }
        }

        private boolean preCache(String string) {
            if (this.preCache[0].equals(string)) {
                return true;
            }
            if (this.preCache[1].equals(string)) {
                return true;
            }
            if (this.preCache[2].equals(string)) {
                return true;
            }
            if (this.preCache[3].equals(string)) {
                return true;
            }
            this.preCacheOld = this.preCacheOld - 1 & 3;
            this.preCache[this.preCacheOld] = string;
            return false;
        }
    }
}

