/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ReflectPermission;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.PropertyPermission;
import java.util.concurrent.Callable;
import jdk.jfr.Event;
import jdk.jfr.FlightRecorder;
import jdk.jfr.FlightRecorderListener;
import jdk.jfr.FlightRecorderPermission;
import jdk.jfr.Recording;
import jdk.jfr.internal.LogLevel;
import jdk.jfr.internal.LogTag;
import jdk.jfr.internal.Logger;
import sun.misc.Unsafe;

public final class SecuritySupport {
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    public static final SafePath JFC_DIRECTORY = SecuritySupport.getPathInProperty("java.home", "lib/jfr");
    static final SafePath USER_HOME = SecuritySupport.getPathInProperty("user.home", null);
    static final SafePath JAVA_IO_TMPDIR = SecuritySupport.getPathInProperty("java.io.tmpdir", null);

    private static <U> U doPrivilegedIOWithReturn(final Callable<U> callable) throws IOException {
        try {
            return (U)AccessController.doPrivileged(new PrivilegedExceptionAction<U>(){

                @Override
                public U run() throws Exception {
                    return callable.call();
                }
            }, null);
        }
        catch (PrivilegedActionException privilegedActionException) {
            Throwable throwable = privilegedActionException.getCause();
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            throw new IOException("Unexpected error during I/O operation. " + throwable.getMessage(), throwable);
        }
    }

    private static void doPriviligedIO(RunnableWithCheckedException runnableWithCheckedException) throws IOException {
        SecuritySupport.doPrivilegedIOWithReturn(() -> {
            runnableWithCheckedException.run();
            return null;
        });
    }

    private static void doPrivileged(final Runnable runnable, Permission ... permissionArray) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                runnable.run();
                return null;
            }
        }, null, permissionArray);
    }

    private static void doPrivileged(final Runnable runnable) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                runnable.run();
                return null;
            }
        });
    }

    private static <T> T doPrivilegedWithReturn(final CallableWithoutCheckException<T> callableWithoutCheckException, Permission ... permissionArray) {
        return AccessController.doPrivileged(new PrivilegedAction<T>(){

            @Override
            public T run() {
                return callableWithoutCheckException.call();
            }
        }, null, permissionArray);
    }

    public static List<SafePath> getPredefinedJFCFiles() {
        ArrayList<SafePath> arrayList = new ArrayList<SafePath>();
        try {
            Iterator iterator = SecuritySupport.doPrivilegedIOWithReturn(() -> Files.newDirectoryStream(JFC_DIRECTORY.toPath(), "*").iterator());
            while (iterator.hasNext()) {
                Path path = (Path)iterator.next();
                if (!path.toString().endsWith(".jfc")) continue;
                arrayList.add(new SafePath(path));
            }
        }
        catch (IOException iOException) {
            Logger.log(LogTag.JFR, LogLevel.WARN, "Could not access .jfc-files in " + JFC_DIRECTORY + ", " + iOException.getMessage());
        }
        return arrayList;
    }

    static void makeVisibleToJFR(Class<?> clazz) {
    }

    static void addHandlerExport(Class<?> clazz) {
    }

    public static void registerEvent(Class<? extends Event> clazz) {
        SecuritySupport.doPrivileged(() -> FlightRecorder.register(clazz), new FlightRecorderPermission("registerEvent"));
    }

    static boolean getBooleanProperty(String string) {
        return SecuritySupport.doPrivilegedWithReturn(() -> Boolean.getBoolean(string), new PropertyPermission(string, "read"));
    }

    private static SafePath getPathInProperty(String string, String string2) {
        return SecuritySupport.doPrivilegedWithReturn(() -> {
            String string3 = System.getProperty(string);
            if (string3 == null) {
                return null;
            }
            File file = string2 == null ? new File(string3) : new File(string3, string2);
            return new SafePath(file.getAbsolutePath());
        }, new PropertyPermission("*", "read"));
    }

    static Thread createThread(ThreadGroup threadGroup, ClassLoader classLoader, String string) {
        Thread thread = SecuritySupport.doPrivilegedWithReturn(() -> new Thread(threadGroup, string), new RuntimePermission("modifyThreadGroup"), new RuntimePermission("modifyThread"));
        SecuritySupport.doPrivileged(() -> thread.setContextClassLoader(classLoader), new RuntimePermission("setContextClassLoader"), new RuntimePermission("modifyThread"));
        return thread;
    }

    static void registerShutdownHook(Thread thread) {
        SecuritySupport.doPrivileged(() -> Runtime.getRuntime().addShutdownHook(thread), new RuntimePermission("shutdownHooks"));
    }

    static void setUncaughtExceptionHandler(Thread thread, Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        SecuritySupport.doPrivileged(() -> thread.setUncaughtExceptionHandler(uncaughtExceptionHandler), new RuntimePermission("modifyThread"));
    }

    static void moveReplace(SafePath safePath, SafePath safePath2) throws IOException {
        SecuritySupport.doPrivilegedIOWithReturn(() -> Files.move(safePath.toPath(), safePath2.toPath(), new CopyOption[0]));
    }

    static void clearDirectory(SafePath safePath) throws IOException {
        SecuritySupport.doPriviligedIO(() -> Files.walkFileTree(safePath.toPath(), new DirectoryCleaner()));
    }

    static SafePath toRealPath(SafePath safePath) throws Exception {
        return new SafePath(SecuritySupport.doPrivilegedIOWithReturn(() -> safePath.toPath().toRealPath(new LinkOption[0])));
    }

    static boolean existDirectory(SafePath safePath) throws IOException {
        return SecuritySupport.doPrivilegedIOWithReturn(() -> Files.exists(safePath.toPath(), new LinkOption[0]));
    }

    static RandomAccessFile createRandomAccessFile(SafePath safePath) throws Exception {
        return SecuritySupport.doPrivilegedIOWithReturn(() -> new RandomAccessFile(safePath.toPath().toFile(), "rw"));
    }

    public static InputStream newFileInputStream(SafePath safePath) throws IOException {
        return SecuritySupport.doPrivilegedIOWithReturn(() -> Files.newInputStream(safePath.toPath(), new OpenOption[0]));
    }

    public static long getFileSize(SafePath safePath) throws IOException {
        return SecuritySupport.doPrivilegedIOWithReturn(() -> Files.size(safePath.toPath()));
    }

    static SafePath createDirectories(SafePath safePath) throws IOException {
        Path path = SecuritySupport.doPrivilegedIOWithReturn(() -> Files.createDirectories(safePath.toPath(), new FileAttribute[0]));
        return new SafePath(path);
    }

    public static boolean exists(SafePath safePath) throws IOException {
        return SecuritySupport.doPrivilegedIOWithReturn(() -> Files.exists(safePath.toPath(), new LinkOption[0]));
    }

    public static boolean isDirectory(SafePath safePath) throws IOException {
        return SecuritySupport.doPrivilegedIOWithReturn(() -> Files.isDirectory(safePath.toPath(), new LinkOption[0]));
    }

    static void delete(SafePath safePath) throws IOException {
        SecuritySupport.doPriviligedIO(() -> Files.delete(safePath.toPath()));
    }

    static boolean isWritable(SafePath safePath) throws IOException {
        return SecuritySupport.doPrivilegedIOWithReturn(() -> Files.isWritable(safePath.toPath()));
    }

    static void deleteOnExit(SafePath safePath) {
        SecuritySupport.doPrivileged(() -> safePath.toPath().toFile().deleteOnExit());
    }

    static ReadableByteChannel newFileChannelToRead(SafePath safePath) throws IOException {
        return SecuritySupport.doPrivilegedIOWithReturn(() -> FileChannel.open(safePath.toPath(), StandardOpenOption.READ));
    }

    public static InputStream getResourceAsStream(String string) throws IOException {
        return SecuritySupport.doPrivilegedIOWithReturn(() -> SecuritySupport.class.getResourceAsStream(string));
    }

    public static Reader newFileReader(SafePath safePath) throws FileNotFoundException, IOException {
        return SecuritySupport.doPrivilegedIOWithReturn(() -> Files.newBufferedReader(safePath.toPath()));
    }

    static void touch(SafePath safePath) throws IOException {
        SecuritySupport.doPriviligedIO(() -> new RandomAccessFile(safePath.toPath().toFile(), "rw").close());
    }

    static void setAccessible(Method method) {
        SecuritySupport.doPrivileged(() -> method.setAccessible(true), new ReflectPermission("suppressAccessChecks"));
    }

    static void setAccessible(Field field) {
        SecuritySupport.doPrivileged(() -> field.setAccessible(true), new ReflectPermission("suppressAccessChecks"));
    }

    static void setAccessible(Constructor<?> constructor) {
        SecuritySupport.doPrivileged(() -> constructor.setAccessible(true), new ReflectPermission("suppressAccessChecks"));
    }

    static void ensureClassIsInitialized(Class<?> clazz) {
        unsafe.ensureClassInitialized(clazz);
    }

    static Class<?> defineClass(String string, byte[] byArray, ClassLoader classLoader) {
        return unsafe.defineClass(string, byArray, 0, byArray.length, classLoader, null);
    }

    static Thread createThreadWitNoPermissions(String string, Runnable runnable) {
        return SecuritySupport.doPrivilegedWithReturn(() -> new Thread(runnable, string), new Permission[0]);
    }

    static void setDaemonThread(Thread thread, boolean bl) {
        SecuritySupport.doPrivileged(() -> thread.setDaemon(bl), new RuntimePermission("modifyThread"));
    }

    public static SafePath getAbsolutePath(SafePath safePath) throws IOException {
        return new SafePath(SecuritySupport.doPrivilegedIOWithReturn(() -> safePath.toPath().toAbsolutePath()));
    }

    private static interface CallableWithoutCheckException<T> {
        public T call();
    }

    private static interface RunnableWithCheckedException {
        public void run() throws Exception;
    }

    public static final class SafePath {
        private final Path path;
        private final String text;

        public SafePath(Path path) {
            this.text = path.toString();
            this.path = Paths.get(this.text, new String[0]);
        }

        public SafePath(String string) {
            this(Paths.get(string, new String[0]));
        }

        public Path toPath() {
            return this.path;
        }

        public String toString() {
            return this.text;
        }
    }

    private static final class DirectoryCleaner
    extends SimpleFileVisitor<Path> {
        private DirectoryCleaner() {
        }

        @Override
        public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
            Files.delete(path);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path path, IOException iOException) throws IOException {
            if (iOException != null) {
                throw iOException;
            }
            Files.delete(path);
            return FileVisitResult.CONTINUE;
        }
    }

    static final class SecureRecorderListener
    implements FlightRecorderListener {
        private final AccessControlContext context;
        private final FlightRecorderListener changeListener;

        SecureRecorderListener(AccessControlContext accessControlContext, FlightRecorderListener flightRecorderListener) {
            this.context = Objects.requireNonNull(accessControlContext);
            this.changeListener = Objects.requireNonNull(flightRecorderListener);
        }

        @Override
        public void recordingStateChanged(Recording recording) {
            AccessController.doPrivileged(() -> {
                try {
                    this.changeListener.recordingStateChanged(recording);
                }
                catch (Throwable throwable) {
                    Logger.log(LogTag.JFR, LogLevel.WARN, "Unexpected exception in listener " + this.changeListener.getClass() + " at recording state change");
                }
                return null;
            }, this.context);
        }

        @Override
        public void recorderInitialized(FlightRecorder flightRecorder) {
            AccessController.doPrivileged(() -> {
                try {
                    this.changeListener.recorderInitialized(flightRecorder);
                }
                catch (Throwable throwable) {
                    Logger.log(LogTag.JFR, LogLevel.WARN, "Unexpected exception in listener " + this.changeListener.getClass() + " when initializing FlightRecorder");
                }
                return null;
            }, this.context);
        }

        public FlightRecorderListener getChangeListener() {
            return this.changeListener;
        }
    }
}

