/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import jdk.internal.org.xml.sax.Attributes;
import jdk.internal.org.xml.sax.EntityResolver;
import jdk.internal.org.xml.sax.SAXException;
import jdk.internal.org.xml.sax.helpers.DefaultHandler;
import jdk.internal.util.xml.SAXParser;
import jdk.internal.util.xml.impl.SAXParserImpl;
import jdk.jfr.AnnotationElement;
import jdk.jfr.Category;
import jdk.jfr.Description;
import jdk.jfr.Enabled;
import jdk.jfr.Experimental;
import jdk.jfr.Label;
import jdk.jfr.Period;
import jdk.jfr.Relational;
import jdk.jfr.StackTrace;
import jdk.jfr.Threshold;
import jdk.jfr.TransitionFrom;
import jdk.jfr.TransitionTo;
import jdk.jfr.Unsigned;
import jdk.jfr.internal.Cutoff;
import jdk.jfr.internal.LogLevel;
import jdk.jfr.internal.LogTag;
import jdk.jfr.internal.Logger;
import jdk.jfr.internal.PlatformEventType;
import jdk.jfr.internal.PrivateAccess;
import jdk.jfr.internal.SecuritySupport;
import jdk.jfr.internal.Type;
import jdk.jfr.internal.TypeLibrary;

final class MetadataHandler
extends DefaultHandler
implements EntityResolver {
    private final long RESERVED_EVENT_COUNT = 2L;
    final Map<String, TypeElement> types = new LinkedHashMap<String, TypeElement>(200);
    final Map<String, XmlType> xmlTypes = new LinkedHashMap<String, XmlType>(20);
    final Map<String, List<AnnotationElement>> xmlContentTypes = new LinkedHashMap<String, List<AnnotationElement>>(20);
    FieldElement currentField;
    TypeElement currentType;
    long eventCount;

    MetadataHandler() {
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        switch (string3) {
            case "XmlType": {
                XmlType xmlType = new XmlType();
                xmlType.name = attributes.getValue("name");
                xmlType.javaType = attributes.getValue("javaType");
                xmlType.contentType = attributes.getValue("contentType");
                xmlType.unsigned = Boolean.valueOf(attributes.getValue("unsigned"));
                this.xmlTypes.put(xmlType.name, xmlType);
                break;
            }
            case "Relation": 
            case "Type": 
            case "Event": {
                this.currentType = new TypeElement();
                this.currentType.name = attributes.getValue("name");
                this.currentType.label = attributes.getValue("label");
                this.currentType.description = attributes.getValue("description");
                this.currentType.category = attributes.getValue("category");
                this.currentType.thread = this.getBoolean(attributes, "thread", false);
                this.currentType.stackTrace = this.getBoolean(attributes, "stackTrace", false);
                this.currentType.startTime = this.getBoolean(attributes, "startTime", true);
                this.currentType.period = attributes.getValue("period");
                this.currentType.cutoff = this.getBoolean(attributes, "cutoff", false);
                this.currentType.experimental = this.getBoolean(attributes, "experimental", false);
                this.currentType.isEvent = string3.equals("Event");
                this.currentType.isRelation = string3.equals("Relation");
                break;
            }
            case "Field": {
                this.currentField = new FieldElement();
                this.currentField.struct = this.getBoolean(attributes, "struct", false);
                this.currentField.array = this.getBoolean(attributes, "array", false);
                this.currentField.name = attributes.getValue("name");
                this.currentField.label = attributes.getValue("label");
                this.currentField.typeName = attributes.getValue("type");
                this.currentField.description = attributes.getValue("description");
                this.currentField.experimental = this.getBoolean(attributes, "experimental", false);
                this.currentField.contentType = attributes.getValue("contentType");
                this.currentField.relation = attributes.getValue("relation");
                this.currentField.transition = attributes.getValue("transition");
                break;
            }
            case "XmlContentType": {
                String string4 = attributes.getValue("name");
                String string5 = attributes.getValue("annotation");
                this.xmlContentTypes.put(string4, this.createAnnotationElements(string5));
            }
        }
    }

    private List<AnnotationElement> createAnnotationElements(String string) throws InternalError {
        String[] stringArray = string.split(",");
        ArrayList<AnnotationElement> arrayList = new ArrayList<AnnotationElement>();
        for (String string2 : stringArray) {
            int n = (string2 = string2.trim()).indexOf("(");
            if (n == -1) {
                arrayList.add(new AnnotationElement(this.createAnnotationClass(string2)));
                continue;
            }
            int n2 = string2.lastIndexOf(")");
            if (n2 == -1) {
                throw new InternalError("Expected closing parenthesis for 'XMLContentType'");
            }
            String string3 = string2.substring(n + 1, n2);
            String string4 = string2.substring(0, n);
            arrayList.add(new AnnotationElement(this.createAnnotationClass(string4), string3));
        }
        return arrayList;
    }

    private Class<? extends Annotation> createAnnotationClass(String string) {
        try {
            if (!string.startsWith("jdk.jfr.")) {
                throw new IllegalStateException("Incorrect type " + string + ". Annotation class must be located in jdk.jfr package.");
            }
            Class<?> clazz = Class.forName(string, true, null);
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalStateException(classNotFoundException);
        }
    }

    private boolean getBoolean(Attributes attributes, String string, boolean bl) {
        String string2 = attributes.getValue(string);
        return string2 == null ? bl : Boolean.valueOf(string2);
    }

    @Override
    public void endElement(String string, String string2, String string3) {
        switch (string3) {
            case "Type": 
            case "Event": 
            case "Relation": {
                this.types.put(this.currentType.name, this.currentType);
                if (this.currentType.isEvent) {
                    ++this.eventCount;
                }
                this.currentType = null;
                break;
            }
            case "Field": {
                this.currentType.fields.add(this.currentField);
                this.currentField = null;
            }
        }
    }

    public static List<Type> createTypes() throws IOException {
        SAXParserImpl sAXParserImpl = new SAXParserImpl();
        MetadataHandler metadataHandler = new MetadataHandler();
        Throwable throwable = null;
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(SecuritySupport.getResourceAsStream("/jdk/jfr/internal/types/metadata.xml"));){
            Logger.log(LogTag.JFR_SYSTEM, LogLevel.DEBUG, () -> "Parsing metadata.xml");
            try {
                ((SAXParser)sAXParserImpl).parse(bufferedInputStream, (DefaultHandler)metadataHandler);
                List<Type> list = metadataHandler.buildTypes();
                return list;
            }
            catch (Exception exception) {
                try {
                    throw new IOException(exception);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
    }

    private List<Type> buildTypes() {
        this.removeXMLConvenience();
        Map<String, Type> map = this.buildTypeMap();
        Map<String, AnnotationElement> map2 = this.buildRelationMap(map);
        this.addFields(map, map2);
        return this.trimTypes(map);
    }

    private Map<String, AnnotationElement> buildRelationMap(Map<String, Type> map) {
        HashMap<String, AnnotationElement> hashMap = new HashMap<String, AnnotationElement>();
        for (TypeElement typeElement : this.types.values()) {
            if (!typeElement.isRelation) continue;
            Type type = map.get(typeElement.name);
            AnnotationElement annotationElement = PrivateAccess.getInstance().newAnnotation(type, Collections.emptyList(), true);
            hashMap.put(typeElement.name, annotationElement);
        }
        return hashMap;
    }

    private List<Type> trimTypes(Map<String, Type> map) {
        ArrayList<Type> arrayList = new ArrayList<Type>(map.size());
        for (Type type : map.values()) {
            type.trimFields();
            arrayList.add(type);
        }
        return arrayList;
    }

    private void addFields(Map<String, Type> map, Map<String, AnnotationElement> map2) {
        for (TypeElement typeElement : this.types.values()) {
            Type type = map.get(typeElement.name);
            if (typeElement.isEvent) {
                boolean bl = typeElement.period != null;
                TypeLibrary.addImplicitFields(type, bl, typeElement.startTime && !bl, typeElement.thread, typeElement.stackTrace && !bl, typeElement.cutoff);
            }
            for (FieldElement fieldElement : typeElement.fields) {
                Type type2 = Type.getKnownType(fieldElement.typeName);
                if (type2 == null) {
                    type2 = Objects.requireNonNull(map.get(fieldElement.referenceType.name));
                }
                ArrayList<AnnotationElement> arrayList = new ArrayList<AnnotationElement>();
                if (fieldElement.unsigned) {
                    arrayList.add(new AnnotationElement(Unsigned.class));
                }
                if (fieldElement.contentType != null) {
                    arrayList.addAll((Collection)Objects.requireNonNull(this.xmlContentTypes.get(fieldElement.contentType)));
                }
                if (fieldElement.relation != null) {
                    String string = "jdk.types." + fieldElement.relation;
                    AnnotationElement annotationElement = map2.get(string);
                    arrayList.add(Objects.requireNonNull(annotationElement));
                }
                if (fieldElement.label != null) {
                    arrayList.add(new AnnotationElement(Label.class, fieldElement.label));
                }
                if (fieldElement.experimental) {
                    arrayList.add(new AnnotationElement(Experimental.class));
                }
                if (fieldElement.description != null) {
                    arrayList.add(new AnnotationElement(Description.class, fieldElement.description));
                }
                if ("from".equals(fieldElement.transition)) {
                    arrayList.add(new AnnotationElement(TransitionFrom.class));
                }
                if ("to".equals(fieldElement.transition)) {
                    arrayList.add(new AnnotationElement(TransitionTo.class));
                }
                boolean bl = !fieldElement.struct && fieldElement.referenceType != null;
                type.add(PrivateAccess.getInstance().newValueDescriptor(fieldElement.name, type2, arrayList, fieldElement.array ? 1 : 0, bl, null));
            }
        }
    }

    private Map<String, Type> buildTypeMap() {
        HashMap<String, Type> hashMap = new HashMap<String, Type>();
        HashMap<String, Type> hashMap2 = new HashMap<String, Type>();
        for (Type type : Type.getKnownTypes()) {
            hashMap.put(type.getName(), type);
            hashMap2.put(type.getName(), type);
        }
        long l = 2L;
        long l2 = 2L + this.eventCount + (long)hashMap2.size();
        for (TypeElement typeElement : this.types.values()) {
            Type type;
            ArrayList<AnnotationElement> arrayList = new ArrayList<AnnotationElement>();
            if (typeElement.category != null) {
                arrayList.add(new AnnotationElement(Category.class, this.buildCategoryArray(typeElement.category)));
            }
            if (typeElement.label != null) {
                arrayList.add(new AnnotationElement(Label.class, typeElement.label));
            }
            if (typeElement.description != null) {
                arrayList.add(new AnnotationElement(Description.class, typeElement.description));
            }
            if (typeElement.isEvent) {
                if (typeElement.period != null) {
                    arrayList.add(new AnnotationElement(Period.class, typeElement.period));
                } else {
                    if (typeElement.startTime) {
                        arrayList.add(new AnnotationElement(Threshold.class, "0 ns"));
                    }
                    if (typeElement.stackTrace) {
                        arrayList.add(new AnnotationElement(StackTrace.class, true));
                    }
                }
                if (typeElement.cutoff) {
                    arrayList.add(new AnnotationElement(Cutoff.class, "infinity"));
                }
            }
            if (typeElement.experimental) {
                arrayList.add(new AnnotationElement(Experimental.class));
            }
            if (typeElement.isEvent) {
                arrayList.add(new AnnotationElement(Enabled.class, false));
                type = new PlatformEventType(typeElement.name, l++, false, true);
            } else if (hashMap2.containsKey(typeElement.name)) {
                type = (Type)hashMap2.get(typeElement.name);
            } else if (typeElement.isRelation) {
                type = new Type(typeElement.name, Type.SUPER_TYPE_ANNOTATION, l2++);
                arrayList.add(new AnnotationElement(Relational.class));
            } else {
                type = new Type(typeElement.name, null, l2++);
            }
            type.setAnnotations(arrayList);
            hashMap.put(typeElement.name, type);
        }
        return hashMap;
    }

    private String[] buildCategoryArray(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        for (char c : string.toCharArray()) {
            if (c == ',') {
                arrayList.add(stringBuilder.toString().trim());
                stringBuilder.setLength(0);
                continue;
            }
            stringBuilder.append(c);
        }
        arrayList.add(stringBuilder.toString().trim());
        return arrayList.toArray(new String[0]);
    }

    private void removeXMLConvenience() {
        for (TypeElement typeElement : this.types.values()) {
            XmlType xmlType = this.xmlTypes.get(typeElement.name);
            if (xmlType != null && xmlType.javaType != null) {
                typeElement.name = xmlType.javaType;
                continue;
            }
            if (typeElement.isEvent) {
                typeElement.name = "jdk." + typeElement.name;
                continue;
            }
            typeElement.name = "jdk.types." + typeElement.name;
        }
        for (TypeElement typeElement : this.types.values()) {
            for (FieldElement fieldElement : typeElement.fields) {
                fieldElement.referenceType = this.types.get(fieldElement.typeName);
                XmlType xmlType = this.xmlTypes.get(fieldElement.typeName);
                if (xmlType != null) {
                    if (xmlType.javaType != null) {
                        fieldElement.typeName = xmlType.javaType;
                    }
                    if (xmlType.contentType != null) {
                        fieldElement.contentType = xmlType.contentType;
                    }
                    if (xmlType.unsigned) {
                        fieldElement.unsigned = true;
                    }
                }
                if (!fieldElement.struct || fieldElement.referenceType == null) continue;
                fieldElement.referenceType.valueType = true;
            }
        }
    }

    static class XmlType {
        String name;
        String javaType;
        String contentType;
        boolean unsigned;

        XmlType() {
        }
    }

    static class FieldElement {
        TypeElement referenceType;
        String name;
        String label;
        String description;
        String contentType;
        String typeName;
        String transition;
        String relation;
        boolean struct;
        boolean array;
        boolean experimental;
        boolean unsigned;

        FieldElement() {
        }
    }

    static class TypeElement {
        List<FieldElement> fields = new ArrayList<FieldElement>();
        String name;
        String label;
        String description;
        String category;
        String superType;
        String period;
        boolean thread;
        boolean startTime;
        boolean stackTrace;
        boolean cutoff;
        boolean isEvent;
        boolean isRelation;
        boolean experimental;
        boolean valueType;

        TypeElement() {
        }
    }
}

