/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal;

import java.util.function.Supplier;
import jdk.jfr.internal.JVM;
import jdk.jfr.internal.JVMSupport;
import jdk.jfr.internal.LogLevel;
import jdk.jfr.internal.LogTag;

public final class Logger {
    private static final int MAX_SIZE = 10000;

    public static void log(LogTag logTag, LogLevel logLevel, String string) {
        if (Logger.shouldLog(logTag, logLevel)) {
            Logger.logInternal(logTag, logLevel, string);
        }
    }

    public static void log(LogTag logTag, LogLevel logLevel, Supplier<String> supplier) {
        if (Logger.shouldLog(logTag, logLevel)) {
            Logger.logInternal(logTag, logLevel, supplier.get());
        }
    }

    private static void logInternal(LogTag logTag, LogLevel logLevel, String string) {
        if (string == null || string.length() < 10000) {
            JVM.log(logTag.id, logLevel.level, string);
        } else {
            JVM.log(logTag.id, logLevel.level, string.substring(0, 10000));
        }
    }

    public static boolean shouldLog(LogTag logTag, LogLevel logLevel) {
        return logLevel.level >= logTag.tagSetLevel;
    }

    static {
        JVMSupport.tryToInitializeJVM();
    }
}

