/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal;

import java.lang.reflect.Modifier;
import jdk.jfr.Event;
import jdk.jfr.internal.ASMToolkit;
import jdk.jfr.internal.EventHandlerCreator;
import jdk.jfr.internal.EventHandlerProxyCreator;
import jdk.jfr.internal.EventInstrumentation;
import jdk.jfr.internal.JVMSupport;
import jdk.jfr.internal.LogLevel;
import jdk.jfr.internal.LogTag;
import jdk.jfr.internal.Logger;
import jdk.jfr.internal.MetadataRepository;
import jdk.jfr.internal.SecuritySupport;
import jdk.jfr.internal.Utils;
import jdk.jfr.internal.handlers.EventHandler;
import jdk.jfr.internal.instrument.JDKEvents;

final class JVMUpcalls {
    JVMUpcalls() {
    }

    static byte[] onRetransform(long l, boolean bl, Class<?> clazz, byte[] byArray) throws Throwable {
        try {
            if (Event.class.isAssignableFrom(clazz) && !Modifier.isAbstract(clazz.getModifiers())) {
                EventHandler eventHandler = Utils.getHandler(clazz.asSubclass(Event.class));
                if (eventHandler == null) {
                    Logger.log(LogTag.JFR_SYSTEM, LogLevel.INFO, "No event handler found for " + clazz.getName() + ". Ignoring instrumentation request.");
                    return byArray;
                }
                Logger.log(LogTag.JFR_SYSTEM, LogLevel.INFO, "Adding instrumentation to event class " + clazz.getName() + " using retransform");
                EventInstrumentation eventInstrumentation = new EventInstrumentation(clazz.getSuperclass(), byArray, l);
                byte[] byArray2 = eventInstrumentation.buildInstrumented();
                ASMToolkit.logASM(clazz.getName(), byArray2);
                return byArray2;
            }
            return JDKEvents.retransformCallback(clazz, byArray);
        }
        catch (Throwable throwable) {
            Logger.log(LogTag.JFR_SYSTEM, LogLevel.WARN, "Unexpected error when adding instrumentation to event class " + clazz.getName());
            return byArray;
        }
    }

    static byte[] bytesForEagerInstrumentation(long l, boolean bl, Class<?> clazz, byte[] byArray) throws Throwable {
        if (JVMSupport.isNotAvailable()) {
            return byArray;
        }
        String string = "<Unknown>";
        try {
            Object object;
            EventInstrumentation eventInstrumentation = new EventInstrumentation(clazz, byArray, l);
            string = eventInstrumentation.getEventName();
            if (!(bl || (((MetadataRepository)(object = MetadataRepository.getInstance())).isEnabled(eventInstrumentation.getEventName()) || eventInstrumentation.isEnabled()) && eventInstrumentation.isRegistered())) {
                Logger.log(LogTag.JFR_SYSTEM, LogLevel.INFO, "Skipping instrumentation for event type " + string + " since event was disabled on class load");
                return byArray;
            }
            eventInstrumentation.setGuardHandler(true);
            Logger.log(LogTag.JFR_SYSTEM, LogLevel.INFO, "Adding " + (bl ? "forced " : "") + "instrumentation for event type " + string + " during initial class load");
            object = new EventHandlerCreator(l, eventInstrumentation.getSettingInfos(), eventInstrumentation.getFieldInfos());
            ((EventHandlerCreator)object).makeEventHandlerClass();
            byte[] byArray2 = eventInstrumentation.buildInstrumented();
            ASMToolkit.logASM(eventInstrumentation.getClassName() + "(" + l + ")", byArray2);
            return byArray2;
        }
        catch (Throwable throwable) {
            Logger.log(LogTag.JFR_SYSTEM, LogLevel.WARN, "Unexpected error when adding instrumentation for event type " + string);
            return byArray;
        }
    }

    static Thread createThread(ThreadGroup threadGroup, ClassLoader classLoader, String string) {
        return SecuritySupport.createThread(threadGroup, classLoader, string);
    }

    static Class<? extends EventHandler> getEventHandlerProxyClass() {
        return EventHandlerProxyCreator.proxyClass;
    }
}

