/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal;

import jdk.jfr.internal.Bits;
import jdk.jfr.internal.JVM;
import jdk.jfr.internal.LogLevel;
import jdk.jfr.internal.LogTag;
import jdk.jfr.internal.Logger;
import jdk.jfr.internal.PlatformEventType;
import jdk.jfr.internal.StringPool;
import sun.misc.Unsafe;

public final class EventWriter {
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static final JVM jvm = JVM.getJVM();
    private long startPosition;
    private long startPositionAddress;
    private long currentPosition;
    private long maxPosition;
    private final long threadID;
    private PlatformEventType eventType;
    private int maxEventSize;
    private boolean started;
    private boolean valid;
    private boolean flushOnEnd;
    boolean notified;

    public static EventWriter getEventWriter() {
        EventWriter eventWriter = (EventWriter)JVM.getEventWriter();
        return eventWriter != null ? eventWriter : JVM.newEventWriter();
    }

    public void putBoolean(boolean bl) {
        if (this.isValidForSize(1)) {
            this.currentPosition += (long)Bits.putBoolean(this.currentPosition, bl);
        }
    }

    public void putByte(byte by) {
        if (this.isValidForSize(1)) {
            unsafe.putByte(this.currentPosition, by);
            ++this.currentPosition;
        }
    }

    public void putChar(char c) {
        if (this.isValidForSize(3)) {
            this.putUncheckedLong(c);
        }
    }

    private void putUncheckedChar(char c) {
        this.putUncheckedLong(c);
    }

    public void putShort(short s) {
        if (this.isValidForSize(3)) {
            this.putUncheckedLong(s & 0xFFFF);
        }
    }

    public void putInt(int n) {
        if (this.isValidForSize(5)) {
            this.putUncheckedLong((long)n & 0xFFFFFFFFL);
        }
    }

    private void putUncheckedInt(int n) {
        this.putUncheckedLong((long)n & 0xFFFFFFFFL);
    }

    public void putFloat(float f) {
        if (this.isValidForSize(4)) {
            this.currentPosition += (long)Bits.putFloat(this.currentPosition, f);
        }
    }

    public void putLong(long l) {
        if (this.isValidForSize(9)) {
            this.putUncheckedLong(l);
        }
    }

    public void putDouble(double d) {
        if (this.isValidForSize(8)) {
            this.currentPosition += (long)Bits.putDouble(this.currentPosition, d);
        }
    }

    public void putString(String string, StringPool stringPool) {
        long l;
        if (string == null) {
            this.putByte((byte)0);
            return;
        }
        int n = string.length();
        if (n == 0) {
            this.putByte((byte)1);
            return;
        }
        if (n > 16 && n < 128 && (l = StringPool.addString(string)) > 0L) {
            this.putByte((byte)2);
            this.putLong(l);
            return;
        }
        this.putStringValue(string);
    }

    private void putStringValue(String string) {
        int n = string.length();
        if (this.isValidForSize(6 + 3 * n)) {
            this.putUncheckedByte((byte)4);
            this.putUncheckedInt(n);
            for (int i = 0; i < n; ++i) {
                this.putUncheckedChar(string.charAt(i));
            }
        }
    }

    public void putEventThread() {
        this.putLong(this.threadID);
    }

    public void putThread(Thread thread) {
        if (thread == null) {
            this.putLong(0L);
        } else {
            this.putLong(jvm.getThreadId(thread));
        }
    }

    public void putClass(Class<?> clazz) {
        if (clazz == null) {
            this.putLong(0L);
        } else {
            this.putLong(JVM.getClassIdNonIntrinsic(clazz));
        }
    }

    public void putStackTrace() {
        if (this.eventType.getStackTraceEnabled()) {
            this.putLong(jvm.getStackTraceId(this.eventType.getStackTraceOffset()));
        } else {
            this.putLong(0L);
        }
    }

    private void reserveEventSizeField() {
        if (this.isValidForSize(4)) {
            this.currentPosition += 4L;
        }
    }

    private void reset() {
        this.currentPosition = this.startPosition;
        if (this.flushOnEnd) {
            this.flushOnEnd = this.flush();
        }
        this.valid = true;
        this.started = false;
    }

    private boolean isValidForSize(int n) {
        if (!this.valid) {
            return false;
        }
        if (this.currentPosition + (long)n > this.maxPosition) {
            this.flushOnEnd = this.flush(this.usedSize(), n);
            if (this.currentPosition + (long)n > this.maxPosition) {
                Logger.log(LogTag.JFR_SYSTEM, LogLevel.WARN, () -> "Unable to commit. Requested size " + n + " too large");
                this.valid = false;
                return false;
            }
        }
        return true;
    }

    private boolean isNotified() {
        return this.notified;
    }

    private void resetNotified() {
        this.notified = false;
    }

    private void resetStringPool() {
        StringPool.reset();
    }

    private int usedSize() {
        return (int)(this.currentPosition - this.startPosition);
    }

    private boolean flush() {
        return this.flush(this.usedSize(), 0);
    }

    private boolean flush(int n, int n2) {
        return JVM.flush(this, n, n2);
    }

    public boolean beginEvent(PlatformEventType platformEventType) {
        if (this.started) {
            return false;
        }
        this.started = true;
        this.eventType = platformEventType;
        this.reserveEventSizeField();
        this.putLong(platformEventType.getId());
        return true;
    }

    public boolean endEvent() {
        if (!this.valid) {
            this.reset();
            return true;
        }
        int n = this.usedSize();
        if (n > this.maxEventSize) {
            this.reset();
            return true;
        }
        Bits.putInt(this.startPosition, EventWriter.makePaddedInt(n));
        if (this.isNotified()) {
            this.resetNotified();
            this.resetStringPool();
            this.reset();
            return false;
        }
        this.startPosition = this.currentPosition;
        unsafe.putAddress(this.startPositionAddress, this.startPosition);
        if (this.flushOnEnd) {
            this.flushOnEnd = this.flush();
        }
        this.started = false;
        return true;
    }

    private EventWriter(long l, long l2, long l3, long l4, boolean bl) {
        this.startPosition = this.currentPosition = l;
        this.maxPosition = l2;
        this.startPositionAddress = l3;
        this.threadID = l4;
        this.started = false;
        this.flushOnEnd = false;
        this.valid = bl;
        this.notified = false;
        this.maxEventSize = 0xFFFFFFF;
    }

    private static int makePaddedInt(int n) {
        long l = (n >>> 0 & 0x7F | 0x80) << 24;
        long l2 = (n >>> 7 & 0x7F | 0x80) << 16;
        long l3 = (n >>> 14 & 0x7F | 0x80) << 8;
        long l4 = (n >>> 21 & 0x7F) << 0;
        return (int)(l + l2 + l3 + l4);
    }

    private void putUncheckedLong(long l) {
        if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
            this.putUncheckedByte((byte)l);
            return;
        }
        this.putUncheckedByte((byte)(l | 0x80L));
        if (((l >>>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            this.putUncheckedByte((byte)l);
            return;
        }
        this.putUncheckedByte((byte)(l | 0x80L));
        if (((l >>>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            this.putUncheckedByte((byte)l);
            return;
        }
        this.putUncheckedByte((byte)(l | 0x80L));
        if (((l >>>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            this.putUncheckedByte((byte)l);
            return;
        }
        this.putUncheckedByte((byte)(l | 0x80L));
        if (((l >>>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            this.putUncheckedByte((byte)l);
            return;
        }
        this.putUncheckedByte((byte)(l | 0x80L));
        if (((l >>>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            this.putUncheckedByte((byte)l);
            return;
        }
        this.putUncheckedByte((byte)(l | 0x80L));
        if (((l >>>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            this.putUncheckedByte((byte)l);
            return;
        }
        this.putUncheckedByte((byte)(l | 0x80L));
        if (((l >>>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            this.putUncheckedByte((byte)l);
            return;
        }
        this.putUncheckedByte((byte)(l | 0x80L));
        this.putUncheckedByte((byte)(l >>> 7));
    }

    private void putUncheckedByte(byte by) {
        unsafe.putByte(this.currentPosition, by);
        ++this.currentPosition;
    }
}

