/*
 * Decompiled with CFR 0.152.
 */
package com.azul.zing.management;

import com.azul.zing.management.MemoryPoolSizeType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.InvalidKeyException;

public class MemoryUsage {
    private final MemoryPoolSizeType memoryPoolSizeType;
    private final long initialReserved;
    private final long size;
    private final long used;
    private final double elapsedTimeSinceJVMStartSec;

    public MemoryUsage(MemoryPoolSizeType memoryPoolSizeType, long l, long l2, long l3, double d) {
        if (l < 0L || l2 < 0L || l3 < 0L || l3 > l2) {
            throw new IllegalArgumentException("MemoryUsage ERROR: initialReserved " + l + " size " + l2 + " used " + l3 + " elapsedTimeSinceJVMStartSec " + d);
        }
        if (d < 0.0) {
            throw new IllegalArgumentException("MemoryUsage ERROR: initialReserved " + l + " size " + l2 + " used " + l3 + " elapsedTimeSinceJVMStartSec " + d);
        }
        this.memoryPoolSizeType = memoryPoolSizeType;
        this.initialReserved = l;
        this.size = l2;
        this.used = l3;
        this.elapsedTimeSinceJVMStartSec = d;
    }

    public MemoryPoolSizeType getMemoryPoolSizeType() {
        return this.memoryPoolSizeType;
    }

    public long getInitialReserved() {
        return this.initialReserved;
    }

    public long getSize() {
        return this.size;
    }

    public long getUsed() {
        return this.used;
    }

    public double getElapsedTimeSinceJVMStartSec() {
        return this.elapsedTimeSinceJVMStartSec;
    }

    public String toString() {
        return "MemoryPoolSizeType = " + (Object)((Object)this.memoryPoolSizeType) + " initialReserved = " + this.initialReserved + " size = " + this.size + " used = " + this.used + " elapsedTimeSinceJVMStartSec = " + this.elapsedTimeSinceJVMStartSec;
    }

    public static MemoryUsage from(CompositeData compositeData) {
        if (compositeData == null) {
            return null;
        }
        try {
            String string = (String)compositeData.get("memoryPoolSizeType");
            MemoryPoolSizeType memoryPoolSizeType = MemoryPoolSizeType.enumValue(string);
            long l = (Long)compositeData.get("initialReserved");
            long l2 = (Long)compositeData.get("size");
            long l3 = (Long)compositeData.get("used");
            double d = (Double)compositeData.get("elapsedTimeSinceJVMStartSec");
            return new MemoryUsage(memoryPoolSizeType, l, l2, l3, d);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IllegalArgumentException(invalidKeyException);
        }
    }
}

