/*
 * Decompiled with CFR 0.152.
 */
package com.azul.zing.management;

import com.azul.zing.impl.management.ManagementFactoryHelper;
import com.azul.zing.impl.management.ManagementMXBeanUtils;
import com.azul.zing.impl.management.ManagementUtils;
import com.azul.zing.impl.management.MemoryManagerMXBeanImpl;
import com.azul.zing.impl.management.OpenTypeMappingIHandler;
import com.azul.zing.impl.management.internal.nls.Messages;
import com.azul.zing.management.CompilationMXBean;
import com.azul.zing.management.GarbageCollectorMXBean;
import com.azul.zing.management.MemoryMXBean;
import com.azul.zing.management.MemoryManagerMXBean;
import com.azul.zing.management.MemoryPoolMXBean;
import com.azul.zing.management.PersistentProfileMXBean;
import com.azul.zing.management.TimeMXBean;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerPermission;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationEmitter;
import javax.management.ObjectName;
import javax.management.RuntimeMBeanException;

public class ManagementFactory {
    public static final String GARBAGE_COLLECTOR_MXBEAN_DOMAIN_TYPE = "com.azul.zing:type=GarbageCollector";
    public static final String MEMORY_MANAGER_MXBEAN_DOMAIN_TYPE = "com.azul.zing:type=MemoryManager";
    public static final String MEMORY_MXBEAN_NAME = "com.azul.zing:type=Memory";
    public static final String MEMORY_POOL_MXBEAN_DOMAIN_TYPE = "com.azul.zing:type=MemoryPool";
    public static final String TIME_MXBEAN_NAME = "com.azul.zing:type=Time";
    public static final String PERSISTENT_PROFILE_MXBEAN_NAME = "com.azul.zing:type=PersistentProfile";
    public static final String CONNECTED_COMPILER_CLIENT_MXBEAN_NAME = "com.azul.zing:type=ConnectedCompilerClient";
    public static final String COMPILATION_MXBEAN_NAME = "com.azul.zing:type=Compilation";
    private static MBeanServer platformServer;
    private static Map<String, String> interfaceNameLookupTable;
    private static Set<String> multiInstanceBeanNames;
    private static boolean USE_ZING_MXBEANS;
    private static boolean comAzulZingManagementIsInitialized;

    private ManagementFactory() {
    }

    public static List<GarbageCollectorMXBean> getGarbageCollectorMXBeans() {
        ManagementFactory.checkAndReturnIfUseZingMXBeansNotSpecified();
        return ManagementMXBeanUtils.getGarbageCollectorMXBeans();
    }

    public static List<MemoryManagerMXBean> getMemoryManagerMXBeans() {
        ManagementFactory.checkAndReturnIfUseZingMXBeansNotSpecified();
        return ManagementMXBeanUtils.getMemoryManagerMXBeans();
    }

    public static MemoryMXBean getMemoryMXBean() {
        ManagementFactory.checkAndReturnIfUseZingMXBeansNotSpecified();
        return ManagementMXBeanUtils.getMemoryBean();
    }

    public static List<MemoryPoolMXBean> getMemoryPoolMXBeans() {
        ManagementFactory.checkAndReturnIfUseZingMXBeansNotSpecified();
        return ManagementMXBeanUtils.getMemoryPoolMXBeans();
    }

    public static TimeMXBean getTimeMXBean() {
        ManagementFactory.checkAndReturnIfUseZingMXBeansNotSpecified();
        return ManagementMXBeanUtils.getTimeBean();
    }

    public static PersistentProfileMXBean getPersistentProfileMXBean() {
        ManagementFactory.checkAndReturnIfUseZingMXBeansNotSpecified();
        return ManagementMXBeanUtils.getPersistentProfileBean();
    }

    public static Object getConnectedCompilerClientMXBean() {
        ManagementFactory.checkAndReturnIfUseZingMXBeansNotSpecified();
        return ManagementMXBeanUtils.getConnectedCompilerClientBean();
    }

    public static CompilationMXBean getCompilationMXBean() {
        ManagementFactory.checkAndReturnIfUseZingMXBeansNotSpecified();
        return ManagementMXBeanUtils.getCompilationBean();
    }

    private static boolean isUseZingMXBeansSetToTrue() {
        return USE_ZING_MXBEANS;
    }

    private static boolean checkZingMXBeanProperty() {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                try {
                    String string = System.getProperty("com.azul.zing.management.useZingMXBeans");
                    if (ManagementUtils.TRACE) {
                        System.out.println("INITIALIZATION: com.azul.zing.management.useZingMXBeans: " + string);
                    }
                    if (string == null) {
                        return false;
                    }
                    if (string.equals("true") || string.equals("")) {
                        return true;
                    }
                    return false;
                }
                catch (Exception exception) {
                    System.err.println("ManagementFactory.checkZingMXBeanProperty failed");
                    return false;
                }
            }
        });
    }

    private static boolean checkAndReturnIfUseZingMXBeansNotSpecified() {
        if (!ManagementFactory.isUseZingMXBeansSetToTrue()) {
            throw new RuntimeMBeanException(new RuntimeException(new Throwable(Messages.getString("lm.30"))));
        }
        return true;
    }

    private static void printPermissionsProblemSolutionMessage() {
        Object object2;
        System.err.println("THIS INFORMATION IS ONLY REQUIRED WHEN THERE IS A PROBLEM STARTING THE ZING");
        System.err.println("VM THAT HAS BEEN SHOWN TO BE CAUSED BY JAVA SECURITY POLICY ISSUES IN THE");
        System.err.println("ENVIRONMENT RELATED TO THE INITIALIZATION OF ZING MONITORING AND");
        System.err.println("MANAGEMENT'S MXBEANS.");
        System.err.println("");
        System.err.println("If you want to use the Zing Monitoring and Management MXBeans then you");
        System.err.println("can follow the following steps, but also be aware of the impact of the.");
        System.err.println("required changes on your current security policies.");
        System.err.println("");
        System.err.println("You will need to create a ~/.java.policy file (or add to it, if the file");
        System.err.println("already exists) or make similar changes elsewhere in your environment.");
        System.err.println("If using a .java.policy file then you will also need to check to ensure");
        System.err.println("that you have an entry:");
        System.err.println("  policy.url.2=file:${user.home}/.java.policy");
        System.err.println("in the $JAVA_HOME/jre/lib/security/java.security file.");
        System.err.println("");
        System.err.println("Here are the permissions required to be added to the .java.policy file to");
        System.err.println("enable Zing Monitoring and Mangement MXBeans:");
        System.err.println("");
        System.err.println("grant codeBase \"file:<$JAVA_HOME>/etc/extensions/mxbeans/agents/ZingJMM.jar\" {");
        System.err.println("  // 1. ** YOU MUST MAKE THE FOLLOWING SUBSTITUTION **");
        System.err.println("  //    Substitute the string '<$JAVA_HOME>' with the value of JAVA_HOME");
        System.err.println("  // 2. Add the contents of the modified version of this file to: ~/.java.policy for testing");
        System.err.println("  // 3. Add to the appropriate file controlling security for your application's environment after testing.");
        System.err.println("");
        System.err.println("  // Required for start-up of Zing Monitoring and Management's Zing MXBeans");
        String string = "permission javax.management";
        System.err.format("  %s.MBeanServerPermission %s;%n", string, "\"createMBeanServer\"");
        System.err.format("  %s.MBeanTrustPermission %s;%n", string, "\"register\"");
        String string2 = "permission javax.management.MBeanPermission \"com.azul.zing.impl.management.";
        String[] stringArray = new String[]{"Memory", "MemoryPool", "GarbageCollector", "MemoryManager"};
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
        for (String object22 : arrayList) {
            System.err.format("  %sMemoryMXBeanImpl#-[com.azul.zing:type=%s]\", \"registerMBean\";%n", string2, object22);
        }
        System.err.format("  %sTimeMXBeanImpl#-[com.azul.zing:type=Time]\", \"registerMBean\";%n", string2);
        System.err.format("  %sPersistentProfileMXBeanImpl#-[com.azul.zing:type=PersistentProfile]\", \"registerMBean\";%n", string2);
        System.err.format("  %sConnectedCompilerClientMXBeanImpl#-[com.azul.zing:type=ConnectedCompilerClient]\", \"registerMBean\";%n", string2);
        System.err.format("  %%sCompilationMXBeanImpl#-[%s]\", \"registerMBean\";%n", string2, COMPILATION_MXBEAN_NAME);
        String[] stringArray2 = new String[]{"System Total Memory", "System Linux Memory", "System Zing Memory", "Native Heap", "Java Heap", "Code Cache", "GenPauseless New Gen", "GenPauseless Old Gen", "GenPauseless Perm Gen", "Java Internal", "Java System"};
        ArrayList<String> arrayList2 = new ArrayList<String>(Arrays.asList(stringArray2));
        for (Object object2 : arrayList2) {
            System.err.format("  %sMemoryPoolMXBeanImpl#-[com.azul.zing:name=%s,type=MemoryPool]\", \"registerMBean\";%n", string2, object2);
        }
        System.err.format("  %sGarbageCollectorMXBeanImpl#-[com.azul.zing:name=GPGC New,type=GarbageCollector]\", \"registerMBean\";%n", string2);
        System.err.format("  %sGarbageCollectorMXBeanImpl#-[com.azul.zing:name=GPGC Old,type=GarbageCollector]\", \"registerMBean\";%n", string2);
        String[] stringArray3 = new String[]{"CodeCache", "JavaInternal", "JavaSystem", "JavaHeap", "SystemTotal", "SystemLinux", "ZingSystemTools", "NativeHeap"};
        object2 = new ArrayList<String>(Arrays.asList(stringArray3));
        Iterator iterator = object2.iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            System.err.format("  %sMemoryManagerMXBeanImpl#-[com.azul.zing:name=%s,type=MemoryManager]\", \"registerMBean\";%n", string2, string3);
        }
        System.err.println("");
        System.err.println("  // Required to allow Zing Monitoring and Management's Zing MXBeans operations");
        System.err.println("  permission com.azul.zing.management.ManagementPermission \"control\";");
        System.err.println("};");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MBeanServer getPlatformMBeanServer() {
        SecurityManager securityManager;
        ManagementFactory.checkAndReturnIfUseZingMXBeansNotSpecified();
        if (ManagementUtils.TRACE) {
            System.out.println("com.azul.zing.management.ManagementFactory.getPlatformMBeanServer: INITIALIZATION enter");
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            try {
                securityManager.checkPermission(new MBeanServerPermission("createMBeanServer"));
            }
            catch (Exception exception) {
                System.err.println("com.azul.zing.management.ManagementFactory.getPlatformMBeanServer check for permissions for creating the MBean Server failed");
                System.err.println("Message: " + exception.getMessage());
                exception.printStackTrace(System.err);
                System.err.println("");
                ManagementFactory.printPermissionsProblemSolutionMessage();
                System.exit(1);
            }
        }
        Class<ManagementFactory> clazz = ManagementFactory.class;
        synchronized (ManagementFactory.class) {
            if (platformServer == null) {
                try {
                    platformServer = java.lang.management.ManagementFactory.getPlatformMBeanServer();
                }
                catch (Exception exception) {
                    System.err.println("com.azul.zing.management.ManagementFactory.getPlatformMBeanServer call to obtain server reference to the MBean Server failed");
                    System.err.println("Message: " + exception.getMessage());
                    exception.printStackTrace(System.err);
                    System.err.println("");
                    ManagementFactory.printPermissionsProblemSolutionMessage();
                    System.exit(1);
                }
            }
            if (!comAzulZingManagementIsInitialized) {
                if (ManagementUtils.TRACE) {
                    System.out.println("com.azul.zing.management.ManagementFactory.getPlatformMBeanServer: INITIALIZATION Preparing to register the PlatformServer");
                }
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        ManagementFactory.registerPlatformBeans(platformServer);
                        return null;
                    }
                });
            }
            // ** MonitorExit[var1_2] (shouldn't be in output)
            if (ManagementUtils.TRACE) {
                System.out.println("com.azul.zing.management.ManagementFactory.getPlatformMBeanServer: INITIALIZATION normal exit");
            }
            return platformServer;
        }
    }

    public static <T> T newPlatformMXBeanProxy(MBeanServerConnection mBeanServerConnection, String string, Class<T> clazz) throws IOException {
        ManagementFactory.checkAndReturnIfUseZingMXBeansNotSpecified();
        ManagementFactory.verifyNamedMXBean(string, clazz);
        Object object = null;
        Class[] classArray = null;
        classArray = ManagementMXBeanUtils.isANotificationEmitter(clazz) ? new Class[]{clazz, NotificationEmitter.class} : new Class[]{clazz};
        object = Proxy.newProxyInstance(classArray[0].getClassLoader(), classArray, (InvocationHandler)new OpenTypeMappingIHandler(mBeanServerConnection, clazz.getName(), string));
        return (T)object;
    }

    private static void verifyNamedMXBean(String string, Class<?> clazz) {
        ManagementFactory.checkAndReturnIfUseZingMXBeansNotSpecified();
        String string2 = clazz.getName();
        String string3 = interfaceNameLookupTable.get(string2);
        if (multiInstanceBeanNames.contains(string2) ? !string.startsWith(string3) : !string3.equals(string)) {
            throw new IllegalArgumentException(Messages.getString("lm.02", string, string2));
        }
    }

    private static void registerPlatformBeans(MBeanServer mBeanServer) {
        block32: {
            if (ManagementUtils.TRACE) {
                System.out.println("com.azul.zing.management.ManagementFactory.getPlatformMBeans: enter");
            }
            if (comAzulZingManagementIsInitialized) {
                return;
            }
            try {
                ObjectName objectName;
                ObjectName objectName2;
                Object object;
                Object object2;
                Object object3;
                List<MemoryPoolMXBean> list2;
                ObjectName objectName3 = new ObjectName(MEMORY_MXBEAN_NAME);
                if (!mBeanServer.isRegistered(objectName3)) {
                    if (ManagementUtils.TRACE) {
                        System.out.println("com.azul.zing.management.ManagementFactory.getPlatformMBeans: Registering with MBeanPlatformServer: " + objectName3);
                    }
                    mBeanServer.registerMBean(ManagementMXBeanUtils.getMemoryBean(), objectName3);
                }
                if ((list2 = ManagementFactory.getMemoryPoolMXBeans()) == null) {
                    return;
                }
                for (MemoryPoolMXBean list3 : list2) {
                    object3 = new ObjectName("com.azul.zing:type=MemoryPool,name=" + list3.getName());
                    if (mBeanServer.isRegistered((ObjectName)object3)) continue;
                    if (ManagementUtils.TRACE) {
                        System.out.println("com.azul.zing.management.ManagementFactory.getPlatformMBeans: Registering with MBeanPlatformServer: " + object3);
                    }
                    mBeanServer.registerMBean(list3, (ObjectName)object3);
                }
                List<GarbageCollectorMXBean> list = ManagementMXBeanUtils.getGarbageCollectorMXBeans();
                if (list != null) {
                    object3 = list.iterator();
                    while (object3.hasNext()) {
                        object2 = (GarbageCollectorMXBean)object3.next();
                        object = new ObjectName("com.azul.zing:type=GarbageCollector,name=" + object2.getName());
                        if (mBeanServer.isRegistered((ObjectName)object)) continue;
                        if (ManagementUtils.TRACE) {
                            System.out.println("com.azul.zing.management.ManagementFactory.getPlatformMBeans: Registering with MBeanPlatformServer: " + object);
                        }
                        mBeanServer.registerMBean(object2, (ObjectName)object);
                    }
                }
                if ((object3 = ManagementMXBeanUtils.getMemoryManagerMXBeans()) != null) {
                    object2 = object3.iterator();
                    while (object2.hasNext()) {
                        object = (MemoryManagerMXBean)object2.next();
                        if (!object.getClass().equals(MemoryManagerMXBeanImpl.class) || mBeanServer.isRegistered(objectName2 = new ObjectName("com.azul.zing:type=MemoryManager,name=" + object.getName()))) continue;
                        if (ManagementUtils.TRACE) {
                            System.out.println("com.azul.zing.management.ManagementFactory.getPlatformMBeans: Registering with MBeanPlatformServer: " + objectName2);
                        }
                        mBeanServer.registerMBean(object, objectName2);
                    }
                }
                if (!mBeanServer.isRegistered((ObjectName)(object2 = new ObjectName(TIME_MXBEAN_NAME)))) {
                    if (ManagementUtils.TRACE) {
                        System.out.println("com.azul.zing.management.ManagementFactory.getPlatformMBeans: Registering with MBeanPlatformServer: " + object2);
                    }
                    mBeanServer.registerMBean(ManagementMXBeanUtils.getTimeBean(), (ObjectName)object2);
                }
                if (!mBeanServer.isRegistered((ObjectName)(object = new ObjectName(PERSISTENT_PROFILE_MXBEAN_NAME)))) {
                    if (ManagementUtils.TRACE) {
                        System.out.println("com.azul.zing.management.ManagementFactory.getPlatformMBeans: Registering with MBeanPlatformServer: " + object);
                    }
                    mBeanServer.registerMBean(ManagementMXBeanUtils.getPersistentProfileBean(), (ObjectName)object);
                }
                if (!mBeanServer.isRegistered(objectName2 = new ObjectName(COMPILATION_MXBEAN_NAME))) {
                    if (ManagementUtils.TRACE) {
                        System.out.println("com.azul.zing.management.ManagementFactory.getPlatformMBeans: Registering with MBeanPlatformServer: " + objectName2);
                    }
                    mBeanServer.registerMBean(ManagementMXBeanUtils.getCompilationBean(), objectName2);
                }
                if (!mBeanServer.isRegistered(objectName = new ObjectName(CONNECTED_COMPILER_CLIENT_MXBEAN_NAME))) {
                    Object object4;
                    if (ManagementUtils.TRACE) {
                        System.out.println("com.azul.zing.management.ManagementFactory.getPlatformMBeans: Registering with MBeanPlatformServer: " + objectName);
                    }
                    if ((object4 = ManagementMXBeanUtils.getConnectedCompilerClientBean()) != null) {
                        mBeanServer.registerMBean(ManagementMXBeanUtils.getConnectedCompilerClientBean(), objectName);
                    }
                }
            }
            catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
                if (ManagementUtils.VERBOSE_MODE) {
                    instanceAlreadyExistsException.printStackTrace(System.err);
                }
            }
            catch (MBeanRegistrationException mBeanRegistrationException) {
                if (ManagementUtils.VERBOSE_MODE) {
                    mBeanRegistrationException.printStackTrace(System.err);
                }
            }
            catch (NotCompliantMBeanException notCompliantMBeanException) {
                if (ManagementUtils.VERBOSE_MODE) {
                    notCompliantMBeanException.printStackTrace(System.err);
                }
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                if (ManagementUtils.VERBOSE_MODE) {
                    malformedObjectNameException.printStackTrace(System.err);
                }
            }
            catch (NullPointerException nullPointerException) {
                if (!ManagementUtils.VERBOSE_MODE) break block32;
                nullPointerException.printStackTrace(System.err);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializeZingMXBeans() {
        ManagementFactory.checkAndReturnIfUseZingMXBeansNotSpecified();
        if (!ManagementFactoryHelper.verifyZingMXBeanVersion()) {
            System.err.println("com.azul.zing.management.initializeZingMXBeans: INITIALIZATION FAILED with mismatch JDK/JVM versions");
            return;
        }
        if (ManagementUtils.TRACE) {
            System.err.println("com.azul.zing.management.initializeZingMXBeans: INITIALIZATION START isInitialized: " + comAzulZingManagementIsInitialized);
            System.err.println("com.azul.zing.management.initializeZingMXBeans: INITIALIZATION LOCATION: call to Thread.dumpStack()");
            Thread.dumpStack();
            System.err.println("com.azul.zing.management.initializeZingMXBeans: INITIALIZATION initial message end");
        }
        Class<ManagementFactory> clazz = ManagementFactory.class;
        synchronized (ManagementFactory.class) {
            if (!comAzulZingManagementIsInitialized) {
                try {
                    Class<MemoryMXBean> clazz2 = MemoryMXBean.class;
                    Class.forName(clazz2.getName(), true, clazz2.getClassLoader());
                    Class<MemoryManagerMXBean> clazz3 = MemoryManagerMXBean.class;
                    Class.forName(clazz3.getName(), true, clazz3.getClassLoader());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (ManagementUtils.TRACE) {
                        System.out.println("com.azul.zing.management.initializeZingMXBeans: INITIALIZATION exception:");
                        classNotFoundException.printStackTrace(System.out);
                    }
                    throw new AssertionError((Object)classNotFoundException);
                }
                ManagementFactory.getPlatformMBeanServer();
                comAzulZingManagementIsInitialized = true;
                if (ManagementUtils.TRACE) {
                    System.out.println("com.azul.zing.management.initializeZingMXBeans: INITIALIZATION completed");
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static void premain(String string) {
        ManagementFactory.initializeZingMXBeans();
    }

    static {
        interfaceNameLookupTable = new HashMap<String, String>();
        interfaceNameLookupTable.put("com.azul.zing.management.MemoryMXBean", MEMORY_MXBEAN_NAME);
        interfaceNameLookupTable.put("com.azul.zing.management.GarbageCollectorMXBean", GARBAGE_COLLECTOR_MXBEAN_DOMAIN_TYPE);
        interfaceNameLookupTable.put("com.azul.zing.management.MemoryManagerMXBean", MEMORY_MANAGER_MXBEAN_DOMAIN_TYPE);
        interfaceNameLookupTable.put("com.azul.zing.management.MemoryPoolMXBean", MEMORY_POOL_MXBEAN_DOMAIN_TYPE);
        interfaceNameLookupTable.put("com.azul.zing.management.TimeMXBean", TIME_MXBEAN_NAME);
        interfaceNameLookupTable.put("com.azul.zing.management.PersistentProfileMXBean", PERSISTENT_PROFILE_MXBEAN_NAME);
        interfaceNameLookupTable.put("com.azul.zing.management.ConnectedCompilerClientMXBean", CONNECTED_COMPILER_CLIENT_MXBEAN_NAME);
        interfaceNameLookupTable.put("com.azul.zing.management.CompilationMXBean", COMPILATION_MXBEAN_NAME);
        multiInstanceBeanNames = new HashSet<String>();
        multiInstanceBeanNames.add("com.azul.zing.management.GarbageCollectorMXBean");
        multiInstanceBeanNames.add("com.azul.zing.management.MemoryManagerMXBean");
        multiInstanceBeanNames.add("com.azul.zing.management.MemoryPoolMXBean");
        USE_ZING_MXBEANS = ManagementFactory.checkZingMXBeanProperty();
        comAzulZingManagementIsInitialized = false;
    }
}

