/*
 * Decompiled with CFR 0.152.
 */
package com.azul.zing.impl.management;

import com.azul.zing.impl.management.DynamicMXBeanImpl;
import com.azul.zing.impl.management.ManagementMXBeanUtils;
import com.azul.zing.impl.management.ManagementUtils;
import com.azul.zing.internal.management.TimeMXBeanInternal;
import com.azul.zing.management.ManagementPermission;
import com.azul.zing.management.TimeMXBean;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class TimeMXBeanImpl
extends DynamicMXBeanImpl
implements TimeMXBean {
    private static TimeMXBeanImpl instance = new TimeMXBeanImpl();
    private static final String timeMXBeanVersion = "1.0.0";
    public static final String TIME_MXBEAN_DOMAIN_TYPE = "com.azul.zing:type=Time";
    private static final String defaultDateTimeFormatString = "EEE MMM dd HH:mm:ss.SSS zzz yyyy";
    private static String dateTimeFormatString = "EEE MMM dd HH:mm:ss.SSS zzz yyyy";

    @Override
    public String getVersion() {
        return timeMXBeanVersion;
    }

    public ObjectName getObjectName() {
        try {
            return ObjectName.getInstance("com.azul.zing:type=Time,name=time");
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw new IllegalArgumentException(malformedObjectNameException);
        }
    }

    static TimeMXBeanImpl getInstance() {
        return instance;
    }

    protected void initializeInfo() {
        if (ManagementUtils.TRACE) {
            System.out.println("TimeMXBeanImpl.initializeInfo");
        }
        this.setMBeanInfo(ManagementMXBeanUtils.getMBeanInfo(TimeMXBean.class.getName()));
    }

    private TimeMXBeanImpl() {
        this.initializeInfo();
    }

    @Override
    public double getElapsedTimeSinceJVMStartSec() {
        return TimeMXBeanInternal.getElapsedTimeSinceJVMStartSec("ProcessTime");
    }

    @Override
    public long getUnixTimeOfJVMStartMillis() {
        return TimeMXBeanInternal.getUnixTimeOfJVMStartMillis("ProcessTime");
    }

    @Override
    public String getUnixTimeOfJVMStartAsDateTimeString() {
        try {
            long l = TimeMXBeanInternal.getUnixTimeOfJVMStartMillis("ProcessTime");
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dateTimeFormatString);
            Date date = new Date(l);
            return simpleDateFormat.format(date);
        }
        catch (Exception exception) {
            return "";
        }
    }

    @Override
    public String convertElapsedTimeSinceJVMStartSecToDateTimeString(double d) {
        try {
            long l = TimeMXBeanInternal.getUnixTimeOfJVMStartMillis("ProcessTime");
            if (d >= 0.0 && d < (9.223372036854776E18 - (double)l - 1.0) / 1000.0) {
                long l2 = (long)(d * 1000.0 + (double)5.0E-4f);
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dateTimeFormatString);
                Date date = new Date(l + l2);
                return simpleDateFormat.format(date);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    @Override
    public boolean setFormatForDateTimeString(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new ManagementPermission("control"));
        }
        if (string != null && string.length() > 2) {
            dateTimeFormatString = string;
            return true;
        }
        return false;
    }

    @Override
    public boolean setFormatForDateTimeStringToDefaultValue() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new ManagementPermission("control"));
        }
        dateTimeFormatString = defaultDateTimeFormatString;
        return true;
    }
}

