/*
 * Decompiled with CFR 0.152.
 */
package com.azul.zing.impl.management;

import com.azul.zing.impl.management.ManagementCompositeData;
import com.azul.zing.impl.management.ManagementMXBeanUtils;
import com.azul.zing.impl.management.ManagementUtils;
import com.azul.zing.impl.management.MemoryMXBeanImpl;
import com.azul.zing.impl.management.MemoryManagerMXBeanImpl;
import com.azul.zing.impl.management.internal.nls.Messages;
import com.azul.zing.internal.management.GarbageCollectorMXBeanInternal;
import com.azul.zing.management.GCDetails;
import com.azul.zing.management.GarbageCollectorMXBean;
import com.azul.zing.management.GarbageCollectorNotificationInfo;
import com.azul.zing.management.ManagementPermission;
import com.azul.zing.management.PauseDetails;
import java.util.ArrayList;
import java.util.List;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;

public final class GarbageCollectorMXBeanImpl
extends MemoryManagerMXBeanImpl
implements GarbageCollectorMXBean {
    private static final String garbageCollectorMXBeanVersion = "1.0.0";
    private GarbageCollectorMXBeanInternal garbageCollectorMXBeanInternal = null;
    private static List<GCNameObjectPair> gcNameObjectPairCollectors = new ArrayList<GCNameObjectPair>(2);
    private static final String fromJVMCreateGarbageCollectorNotification = "fromJVMCreateGarbageCollectorNotification";
    private boolean setNotificationCallbackRegistered = false;

    @Override
    public String getVersion() {
        return garbageCollectorMXBeanVersion;
    }

    public GarbageCollectorMXBeanImpl(String string, int n, MemoryMXBeanImpl memoryMXBeanImpl) {
        super(string, n, memoryMXBeanImpl, new GarbageCollectorMXBeanInternal());
        if (ManagementUtils.TRACE) {
            System.out.println("GarbageCollectorMXBeanImpl.GarbageCollectorMXBeanImpl \"" + string + "\" | " + n + " | " + memoryMXBeanImpl);
        }
        this.garbageCollectorMXBeanInternal = (GarbageCollectorMXBeanInternal)this.memoryManagerMXBeanInternal;
        GCNameObjectPair gCNameObjectPair = new GCNameObjectPair(string, this);
        GarbageCollectorMXBeanImpl.addCollectorToListOfCollectors(gCNameObjectPair);
    }

    @Override
    protected void initializeInfo() {
        if (ManagementUtils.TRACE) {
            System.out.println("GarbageCollectorMXBeanImpl.initializeInfo");
        }
        this.setMBeanInfo(ManagementMXBeanUtils.getMBeanInfo(GarbageCollectorMXBean.class.getName()));
    }

    @Override
    public ObjectName getObjectName() {
        try {
            return ObjectName.getInstance("com.azul.zing:type=GarbageCollector,name=" + this.getName());
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw new IllegalArgumentException(malformedObjectNameException);
        }
    }

    @Override
    public long getCollectionCount() {
        return this.garbageCollectorMXBeanInternal.getCollectionCount(this.name);
    }

    @Override
    public double getCollectorCumulativeRunningTimeSec() {
        return this.garbageCollectorMXBeanInternal.getCollectorCumulativeRunningTimeSec(this.name);
    }

    @Override
    public double getDurationOfLastCompletedCollection() {
        return this.garbageCollectorMXBeanInternal.getDurationOfLastCompletedCollection(this.name);
    }

    @Override
    public double getTimeOfLastCollectionEnd() {
        return this.garbageCollectorMXBeanInternal.getTimeOfLastCollectionEnd(this.name);
    }

    @Override
    public double getTimeOfPenultimateCollectionEnd() {
        return this.garbageCollectorMXBeanInternal.getTimeOfPenultimateCollectionEnd(this.name);
    }

    @Override
    public double getCollectorCumulativePauseTimeSec() {
        return this.garbageCollectorMXBeanInternal.getCollectorCumulativePauseTimeSec(this.name);
    }

    @Override
    public double resetCollectorCumulativeCounters() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new ManagementPermission("control"));
        }
        return this.garbageCollectorMXBeanInternal.resetCollectorCumulativeCounters(this.name);
    }

    @Override
    public double getTimeOfLastResetCollectorCumulativeCounters() {
        return this.garbageCollectorMXBeanInternal.getTimeOfLastResetCollectorCumulativeCounters(this.name);
    }

    @Override
    public double getPercentageOfTimeCollectorIsRunning() {
        return this.garbageCollectorMXBeanInternal.getPercentageOfTimeCollectorIsRunning(this.name);
    }

    @Override
    public double getHighestPercentageOfTimeCollectorIsRunning() {
        return this.garbageCollectorMXBeanInternal.getHighestPercentageOfTimeCollectorIsRunning(this.name);
    }

    @Override
    public double resetHighestPercentageOfTimeCollectorIsRunning() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new ManagementPermission("control"));
        }
        return this.garbageCollectorMXBeanInternal.resetHighestPercentageOfTimeCollectorIsRunning(this.name);
    }

    @Override
    public double getTimeOfLastResetHighestPercentageOfTimeCollectorIsRunning() {
        return this.garbageCollectorMXBeanInternal.getTimeOfLastResetHighestPercentageOfTimeCollectorIsRunning(this.name);
    }

    @Override
    public boolean setPercentageOfTimeCollectorIsRunningThreshold(double d) {
        if (d < 0.0 || d > 100.0) {
            throw new IllegalArgumentException(Messages.getString("lm.26", "GarbageCollectorMXBeanImpl.setPercentageOfTimeCollectorIsRunningThreshold", "threshold", d));
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new ManagementPermission("control"));
        }
        return this.garbageCollectorMXBeanInternal.setPercentageOfTimeCollectorIsRunningThreshold(this.name, d);
    }

    @Override
    public double getPercentageOfTimeCollectorIsRunningThreshold() {
        return this.garbageCollectorMXBeanInternal.getPercentageOfTimeCollectorIsRunningThreshold(this.name);
    }

    @Override
    public long getPercentageOfTimeCollectorIsRunningThresholdExceededCount() {
        return this.garbageCollectorMXBeanInternal.getPercentageOfTimeCollectorIsRunningThresholdExceededCount(this.name);
    }

    @Override
    public boolean isPercentageOfTimeCollectorIsRunningThresholdExceeded() {
        return this.garbageCollectorMXBeanInternal.isPercentageOfTimeCollectorIsRunningThresholdExceeded(this.name);
    }

    @Override
    public boolean setGarbageCollectionPauseDurationThreshold(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException(Messages.getString("lm.27", "GarbageCollectorMXBeanImpl.setGarbageCollectionPauseDurationThreshold", "threshold", d));
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new ManagementPermission("control"));
        }
        return this.garbageCollectorMXBeanInternal.setGarbageCollectionPauseDurationThreshold(this.name, d);
    }

    @Override
    public double getGarbageCollectionPauseDurationThreshold() {
        return this.garbageCollectorMXBeanInternal.getGarbageCollectionPauseDurationThreshold(this.name);
    }

    @Override
    public long getGarbageCollectionPauseDurationThresholdExceededCount() {
        return this.garbageCollectorMXBeanInternal.getGarbageCollectionPauseDurationThresholdExceededCount(this.name);
    }

    @Override
    public boolean isGarbageCollectionPauseDurationThresholdExceeded() {
        return this.garbageCollectorMXBeanInternal.isGarbageCollectionPauseDurationThresholdExceeded(this.name);
    }

    @Override
    public boolean setGarbageCollectionDurationThreshold(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException(Messages.getString("lm.27", "GarbageCollectorMXBeanImpl.setGarbageCollectionDurationThreshold", "threshold", d));
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new ManagementPermission("control"));
        }
        return this.garbageCollectorMXBeanInternal.setGarbageCollectionDurationThreshold(this.name, d);
    }

    @Override
    public double getGarbageCollectionDurationThreshold() {
        return this.garbageCollectorMXBeanInternal.getGarbageCollectionDurationThreshold(this.name);
    }

    @Override
    public long getGarbageCollectionDurationThresholdExceededCount() {
        return this.garbageCollectorMXBeanInternal.getGarbageCollectionDurationThresholdExceededCount(this.name);
    }

    @Override
    public boolean isGarbageCollectionDurationThresholdExceeded() {
        return this.garbageCollectorMXBeanInternal.isGarbageCollectionDurationThresholdExceeded(this.name);
    }

    @Override
    public PauseDetails[] getCollectorMaxPauseDetails() {
        return this.garbageCollectorMXBeanInternal.getCollectorMaxPauseDetails(this.name);
    }

    @Override
    public double resetCollectorMaxPauseDetails() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new ManagementPermission("control"));
        }
        return this.garbageCollectorMXBeanInternal.resetCollectorMaxPauseDetails(this.name);
    }

    @Override
    public double getTimeOfLastResetCollectorMaxPauseDetails() {
        return this.garbageCollectorMXBeanInternal.getTimeOfLastResetCollectorMaxPauseDetails(this.name);
    }

    @Override
    public int getGarbageCollectorThreadCount() {
        return this.garbageCollectorMXBeanInternal.getGarbageCollectorThreadCount(this.name);
    }

    @Override
    public GCDetails getLastGCDetails() {
        return this.garbageCollectorMXBeanInternal.getLastGCDetails(this.name);
    }

    @Override
    public boolean setIntervalToWaitBeforeRenotifyWhenThresholdContinuouslyExceeded(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException(Messages.getString("lm.27", "GarbageCollectorMXBean.setIntervalToWaitBeforeRenotifyWhenThresholdContinuouslyExceeded", "secondsToWaitBeforeRenotify", l));
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new ManagementPermission("control"));
        }
        return this.garbageCollectorMXBeanInternal.setIntervalToWaitBeforeRenotifyWhenThresholdContinuouslyExceeded(this.name, l);
    }

    @Override
    public long getIntervalToWaitBeforeRenotifyWhenThresholdContinuouslyExceeded() {
        return this.garbageCollectorMXBeanInternal.getIntervalToWaitBeforeRenotifyWhenThresholdContinuouslyExceeded(this.name);
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        String[] stringArray = new String[]{"com.azul.zing.management.garbage.collector.collection.notification", "com.azul.zing.management.garbage.collector.application_thread_allocation_delayed.notification", "com.azul.zing.management.garbage.collector.percentage_of_time_collector_is_running.threshold.exceeded", "com.azul.zing.management.garbage.collector.pause_duration.threshold.exceeded", "com.azul.zing.management.garbage.collector.collection_duration.threshold.exceeded"};
        String string = Notification.class.getName();
        String string2 = "Garbage Collector " + this.getName() + " Notification for Exceeding Threshold";
        MBeanNotificationInfo mBeanNotificationInfo = new MBeanNotificationInfo(stringArray, string, string2);
        return new MBeanNotificationInfo[]{mBeanNotificationInfo};
    }

    private static void addCollectorToListOfCollectors(GCNameObjectPair gCNameObjectPair) {
        for (GCNameObjectPair gCNameObjectPair2 : gcNameObjectPairCollectors) {
            if (gCNameObjectPair2.doesNameMatch(gCNameObjectPair.getName()) == null) continue;
            System.err.println("GarbageCollectorMXBeanImpl.addCollectorToListOfCollectors attempt to add duplicate collector: " + gCNameObjectPair.getName());
            return;
        }
        gcNameObjectPairCollectors.add(gCNameObjectPair);
    }

    private static GarbageCollectorMXBeanImpl getGCMXBeanImplFromName(String string) {
        for (GCNameObjectPair gCNameObjectPair : gcNameObjectPairCollectors) {
            if (gCNameObjectPair.doesNameMatch(string) == null) continue;
            return gCNameObjectPair.getGCMXBeanImpl();
        }
        return null;
    }

    public static void fromJVMCreateGarbageCollectorNotification(long l, String string, String string2, long l2, Object object) {
        GarbageCollectorMXBeanImpl garbageCollectorMXBeanImpl = GarbageCollectorMXBeanImpl.getGCMXBeanImplFromName(string);
        if (garbageCollectorMXBeanImpl == null) {
            return;
        }
        garbageCollectorMXBeanImpl.createGarbageCollectorNotification(l, string2, l2, object);
    }

    private void createGarbageCollectorNotification(long l, String string, long l2, Object object) {
        if (ManagementUtils.TRACE_NOTIFICATIONS) {
            System.out.println("GarbageCollectorMXBeanImpl.createGarbageCollectorNotification " + l + " listeners: " + this.hasListeners() + " " + this.getName() + " Reason: " + string + " Times threshold crossed: " + l2);
        }
        if (!this.hasListeners()) {
            return;
        }
        Notification notification = new Notification(string, this.getObjectName(), l2, l, this.getName());
        GCDetails gCDetails = null;
        try {
            gCDetails = this.garbageCollectorMXBeanInternal.convertToGCDetails(this.getName(), object);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (ManagementUtils.TRACE_NOTIFICATIONS) {
            if (gCDetails != null) {
                System.out.println("MemoryPoolMXBeanImpl.createMemoryPoolNotification " + gCDetails.toString());
            } else {
                System.out.println("MemoryPoolMXBeanImpl.createMemoryPoolNotification converion of GCDetails data from VM failed.");
            }
        }
        GarbageCollectorNotificationInfo garbageCollectorNotificationInfo = new GarbageCollectorNotificationInfo(this.getName(), string, l2, gCDetails);
        CompositeData compositeData = ManagementCompositeData.toGarbageCollectorNotificationInfoCompositeData(garbageCollectorNotificationInfo);
        notification.setUserData(compositeData);
        this.sendNotification(notification);
    }

    @Override
    public synchronized void addNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) {
        boolean bl = this.hasListeners();
        this.sAddNotificationListener(notificationListener, notificationFilter, object);
        boolean bl2 = this.hasListeners();
        if (!bl && bl2) {
            this.setNotificationEnabled(true);
        }
    }

    @Override
    public synchronized void removeNotificationListener(NotificationListener notificationListener) throws ListenerNotFoundException {
        boolean bl = this.hasListeners();
        this.sRemoveNotificationListener(notificationListener);
        boolean bl2 = this.hasListeners();
        if (bl && !bl2) {
            this.setNotificationEnabled(false);
        }
    }

    @Override
    public synchronized void removeNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws ListenerNotFoundException {
        boolean bl = this.hasListeners();
        this.sRemoveNotificationListener(notificationListener, notificationFilter, object);
        boolean bl2 = this.hasListeners();
        if (bl && !bl2) {
            this.setNotificationEnabled(false);
        }
    }

    private synchronized boolean setNotificationEnabled(boolean bl) {
        if (ManagementUtils.TRACE_NOTIFICATIONS) {
            System.out.println("garbageCollectorMXBeanImpl.setNotificationEnabled called enable: " + bl + " " + this.getName() + " com/azul/zing/impl/management/GarbageCollectorMXBeanImpl " + fromJVMCreateGarbageCollectorNotification + " (JLjava/lang/String;Ljava/lang/String;JLjava/lang/Object;)V");
        }
        if (bl) {
            if (!this.setNotificationCallbackRegistered) {
                boolean bl2 = this.garbageCollectorMXBeanInternal.setNotificationCallback(this.getName(), "com/azul/zing/impl/management/GarbageCollectorMXBeanImpl", fromJVMCreateGarbageCollectorNotification, "(JLjava/lang/String;Ljava/lang/String;JLjava/lang/Object;)V");
                if (!bl2) {
                    System.err.println("ERROR: Zing MXBeans: GarbageCollectorMXBeanImpl.setNotificationEnabled failed to register callback");
                    System.err.println("ERROR: Zing MXBeans: Notifications will not work");
                    return false;
                }
                this.setNotificationCallbackRegistered = true;
            }
            return this.garbageCollectorMXBeanInternal.setNotificationEnabled(this.getName());
        }
        return this.garbageCollectorMXBeanInternal.setNotificationDisabled(this.getName());
    }

    class GCNameObjectPair {
        private String name;
        private GarbageCollectorMXBeanImpl gcMXBeanImpl;

        GCNameObjectPair(String string, GarbageCollectorMXBeanImpl garbageCollectorMXBeanImpl2) {
            this.name = string;
            this.gcMXBeanImpl = garbageCollectorMXBeanImpl2;
        }

        String getName() {
            return this.name;
        }

        GarbageCollectorMXBeanImpl getGCMXBeanImpl() {
            return this.gcMXBeanImpl;
        }

        GarbageCollectorMXBeanImpl doesNameMatch(String string) {
            if (this.name.equals(string)) {
                return this.gcMXBeanImpl;
            }
            return null;
        }
    }
}

