/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util.math.intpoly;

import java.math.BigInteger;
import sun.security.util.math.intpoly.IntegerPolynomial;

public class P384OrderField
extends IntegerPolynomial {
    private static final int BITS_PER_LIMB = 28;
    private static final int NUM_LIMBS = 14;
    private static final int MAX_ADDS = 1;
    public static final BigInteger MODULUS = P384OrderField.evaluateModulus();
    private static final long CARRY_ADD = 0x8000000L;
    private static final int LIMB_MASK = 0xFFFFFFF;

    public P384OrderField() {
        super(28, 14, 1, MODULUS);
    }

    private static BigInteger evaluateModulus() {
        BigInteger bigInteger = BigInteger.valueOf(2L).pow(384);
        bigInteger = bigInteger.subtract(BigInteger.valueOf(54187661L));
        bigInteger = bigInteger.subtract(BigInteger.valueOf(2L).pow(28).multiply(BigInteger.valueOf(20867411L)));
        bigInteger = bigInteger.add(BigInteger.valueOf(2L).pow(56).multiply(BigInteger.valueOf(10975981L)));
        bigInteger = bigInteger.add(BigInteger.valueOf(2L).pow(84).multiply(BigInteger.valueOf(14361739L)));
        bigInteger = bigInteger.subtract(BigInteger.valueOf(2L).pow(112).multiply(BigInteger.valueOf(35694566L)));
        bigInteger = bigInteger.subtract(BigInteger.valueOf(2L).pow(140).multiply(BigInteger.valueOf(132168845L)));
        bigInteger = bigInteger.subtract(BigInteger.valueOf(2L).pow(168).multiply(BigInteger.valueOf(3710130L)));
        return bigInteger;
    }

    @Override
    protected void reduceIn(long[] lArray, long l, int n) {
        long l2 = 54187661L * l;
        int n2 = n - 14;
        lArray[n2] = lArray[n2] + (l2 << 8 & 0xFFFFFFFL);
        int n3 = n - 13;
        lArray[n3] = lArray[n3] + (l2 >> 20);
        long l3 = 20867411L * l;
        int n4 = n - 13;
        lArray[n4] = lArray[n4] + (l3 << 8 & 0xFFFFFFFL);
        int n5 = n - 12;
        lArray[n5] = lArray[n5] + (l3 >> 20);
        long l4 = -10975981L * l;
        int n6 = n - 12;
        lArray[n6] = lArray[n6] + (l4 << 8 & 0xFFFFFFFL);
        int n7 = n - 11;
        lArray[n7] = lArray[n7] + (l4 >> 20);
        long l5 = -14361739L * l;
        int n8 = n - 11;
        lArray[n8] = lArray[n8] + (l5 << 8 & 0xFFFFFFFL);
        int n9 = n - 10;
        lArray[n9] = lArray[n9] + (l5 >> 20);
        long l6 = 35694566L * l;
        int n10 = n - 10;
        lArray[n10] = lArray[n10] + (l6 << 8 & 0xFFFFFFFL);
        int n11 = n - 9;
        lArray[n11] = lArray[n11] + (l6 >> 20);
        long l7 = 132168845L * l;
        int n12 = n - 9;
        lArray[n12] = lArray[n12] + (l7 << 8 & 0xFFFFFFFL);
        int n13 = n - 8;
        lArray[n13] = lArray[n13] + (l7 >> 20);
        long l8 = 3710130L * l;
        int n14 = n - 8;
        lArray[n14] = lArray[n14] + (l8 << 8 & 0xFFFFFFFL);
        int n15 = n - 7;
        lArray[n15] = lArray[n15] + (l8 >> 20);
    }

    @Override
    protected void finalCarryReduceLast(long[] lArray) {
        long l = lArray[13] >> 20;
        lArray[13] = lArray[13] - (l << 20);
        long l2 = 54187661L * l;
        lArray[0] = lArray[0] + l2;
        l2 = 20867411L * l;
        lArray[1] = lArray[1] + l2;
        l2 = -10975981L * l;
        lArray[2] = lArray[2] + l2;
        l2 = -14361739L * l;
        lArray[3] = lArray[3] + l2;
        l2 = 35694566L * l;
        lArray[4] = lArray[4] + l2;
        l2 = 132168845L * l;
        lArray[5] = lArray[5] + l2;
        l2 = 3710130L * l;
        lArray[6] = lArray[6] + l2;
    }

    private void carryReduce(long[] lArray, long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8, long l9, long l10, long l11, long l12, long l13, long l14, long l15, long l16, long l17, long l18, long l19, long l20, long l21, long l22, long l23, long l24, long l25, long l26, long l27) {
        long l28 = 0L;
        long l29 = l + 0x8000000L >> 28;
        l -= l29 << 28;
        l2 += l29;
        l29 = l2 + 0x8000000L >> 28;
        l2 -= l29 << 28;
        l3 += l29;
        l29 = l3 + 0x8000000L >> 28;
        l3 -= l29 << 28;
        l4 += l29;
        l29 = l4 + 0x8000000L >> 28;
        l4 -= l29 << 28;
        l5 += l29;
        l29 = l5 + 0x8000000L >> 28;
        l5 -= l29 << 28;
        l6 += l29;
        l29 = l6 + 0x8000000L >> 28;
        l6 -= l29 << 28;
        l7 += l29;
        l29 = l7 + 0x8000000L >> 28;
        l7 -= l29 << 28;
        l8 += l29;
        l29 = l8 + 0x8000000L >> 28;
        l8 -= l29 << 28;
        l9 += l29;
        l29 = l9 + 0x8000000L >> 28;
        l9 -= l29 << 28;
        l10 += l29;
        l29 = l10 + 0x8000000L >> 28;
        l10 -= l29 << 28;
        l11 += l29;
        l29 = l11 + 0x8000000L >> 28;
        l11 -= l29 << 28;
        l12 += l29;
        l29 = l12 + 0x8000000L >> 28;
        l12 -= l29 << 28;
        l13 += l29;
        l29 = l13 + 0x8000000L >> 28;
        l13 -= l29 << 28;
        l14 += l29;
        l29 = l14 + 0x8000000L >> 28;
        l14 -= l29 << 28;
        l15 += l29;
        l29 = l15 + 0x8000000L >> 28;
        l15 -= l29 << 28;
        l16 += l29;
        l29 = l16 + 0x8000000L >> 28;
        l16 -= l29 << 28;
        l17 += l29;
        l29 = l17 + 0x8000000L >> 28;
        l17 -= l29 << 28;
        l18 += l29;
        l29 = l18 + 0x8000000L >> 28;
        l18 -= l29 << 28;
        l19 += l29;
        l29 = l19 + 0x8000000L >> 28;
        l19 -= l29 << 28;
        l20 += l29;
        l29 = l20 + 0x8000000L >> 28;
        l20 -= l29 << 28;
        l21 += l29;
        l29 = l21 + 0x8000000L >> 28;
        l21 -= l29 << 28;
        l22 += l29;
        l29 = l22 + 0x8000000L >> 28;
        l22 -= l29 << 28;
        l23 += l29;
        l29 = l23 + 0x8000000L >> 28;
        l23 -= l29 << 28;
        l24 += l29;
        l29 = l24 + 0x8000000L >> 28;
        l24 -= l29 << 28;
        l25 += l29;
        l29 = l25 + 0x8000000L >> 28;
        l25 -= l29 << 28;
        l26 += l29;
        l29 = l26 + 0x8000000L >> 28;
        l26 -= l29 << 28;
        l27 += l29;
        l29 = l27 + 0x8000000L >> 28;
        this.carryReduce0(lArray, l, l2, l3, l4, l5, l6, l7, l8, l9, l10, l11, l12, l13, l14, l15, l16, l17, l18, l19, l20, l21, l22, l23, l24, l25, l26, l27 -= l29 << 28, l28 += l29);
    }

    void carryReduce0(long[] lArray, long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8, long l9, long l10, long l11, long l12, long l13, long l14, long l15, long l16, long l17, long l18, long l19, long l20, long l21, long l22, long l23, long l24, long l25, long l26, long l27, long l28) {
        long l29 = 54187661L * l28;
        l14 += l29 << 8 & 0xFFFFFFFL;
        l15 += l29 >> 20;
        l29 = 20867411L * l28;
        l15 += l29 << 8 & 0xFFFFFFFL;
        l16 += l29 >> 20;
        l29 = -10975981L * l28;
        l16 += l29 << 8 & 0xFFFFFFFL;
        l17 += l29 >> 20;
        l29 = -14361739L * l28;
        l17 += l29 << 8 & 0xFFFFFFFL;
        l18 += l29 >> 20;
        l29 = 35694566L * l28;
        l18 += l29 << 8 & 0xFFFFFFFL;
        l19 += l29 >> 20;
        l29 = 132168845L * l28;
        l19 += l29 << 8 & 0xFFFFFFFL;
        l20 += l29 >> 20;
        l29 = 3710130L * l28;
        l20 += l29 << 8 & 0xFFFFFFFL;
        l21 += l29 >> 20;
        l29 = 54187661L * l27;
        l13 += l29 << 8 & 0xFFFFFFFL;
        l14 += l29 >> 20;
        l29 = 20867411L * l27;
        l14 += l29 << 8 & 0xFFFFFFFL;
        l15 += l29 >> 20;
        l29 = -10975981L * l27;
        l15 += l29 << 8 & 0xFFFFFFFL;
        l16 += l29 >> 20;
        l29 = -14361739L * l27;
        l16 += l29 << 8 & 0xFFFFFFFL;
        l17 += l29 >> 20;
        l29 = 35694566L * l27;
        l17 += l29 << 8 & 0xFFFFFFFL;
        l18 += l29 >> 20;
        l29 = 132168845L * l27;
        l18 += l29 << 8 & 0xFFFFFFFL;
        l19 += l29 >> 20;
        l29 = 3710130L * l27;
        l19 += l29 << 8 & 0xFFFFFFFL;
        l20 += l29 >> 20;
        l29 = 54187661L * l26;
        l12 += l29 << 8 & 0xFFFFFFFL;
        l13 += l29 >> 20;
        l29 = 20867411L * l26;
        l13 += l29 << 8 & 0xFFFFFFFL;
        l14 += l29 >> 20;
        l29 = -10975981L * l26;
        l14 += l29 << 8 & 0xFFFFFFFL;
        l15 += l29 >> 20;
        l29 = -14361739L * l26;
        l15 += l29 << 8 & 0xFFFFFFFL;
        l16 += l29 >> 20;
        l29 = 35694566L * l26;
        l16 += l29 << 8 & 0xFFFFFFFL;
        l17 += l29 >> 20;
        l29 = 132168845L * l26;
        l17 += l29 << 8 & 0xFFFFFFFL;
        l18 += l29 >> 20;
        l29 = 3710130L * l26;
        l18 += l29 << 8 & 0xFFFFFFFL;
        l19 += l29 >> 20;
        l29 = 54187661L * l25;
        l11 += l29 << 8 & 0xFFFFFFFL;
        l12 += l29 >> 20;
        l29 = 20867411L * l25;
        l12 += l29 << 8 & 0xFFFFFFFL;
        l13 += l29 >> 20;
        l29 = -10975981L * l25;
        l13 += l29 << 8 & 0xFFFFFFFL;
        l14 += l29 >> 20;
        l29 = -14361739L * l25;
        l14 += l29 << 8 & 0xFFFFFFFL;
        l15 += l29 >> 20;
        l29 = 35694566L * l25;
        l15 += l29 << 8 & 0xFFFFFFFL;
        l16 += l29 >> 20;
        l29 = 132168845L * l25;
        l16 += l29 << 8 & 0xFFFFFFFL;
        l17 += l29 >> 20;
        l29 = 3710130L * l25;
        l17 += l29 << 8 & 0xFFFFFFFL;
        l18 += l29 >> 20;
        l29 = 54187661L * l24;
        l10 += l29 << 8 & 0xFFFFFFFL;
        l11 += l29 >> 20;
        l29 = 20867411L * l24;
        l11 += l29 << 8 & 0xFFFFFFFL;
        l12 += l29 >> 20;
        l29 = -10975981L * l24;
        l12 += l29 << 8 & 0xFFFFFFFL;
        l13 += l29 >> 20;
        l29 = -14361739L * l24;
        l13 += l29 << 8 & 0xFFFFFFFL;
        l14 += l29 >> 20;
        l29 = 35694566L * l24;
        l14 += l29 << 8 & 0xFFFFFFFL;
        l15 += l29 >> 20;
        l29 = 132168845L * l24;
        l15 += l29 << 8 & 0xFFFFFFFL;
        l16 += l29 >> 20;
        l29 = 3710130L * l24;
        l16 += l29 << 8 & 0xFFFFFFFL;
        l17 += l29 >> 20;
        l29 = 54187661L * l23;
        l9 += l29 << 8 & 0xFFFFFFFL;
        l10 += l29 >> 20;
        l29 = 20867411L * l23;
        l10 += l29 << 8 & 0xFFFFFFFL;
        l11 += l29 >> 20;
        l29 = -10975981L * l23;
        l11 += l29 << 8 & 0xFFFFFFFL;
        l12 += l29 >> 20;
        l29 = -14361739L * l23;
        l12 += l29 << 8 & 0xFFFFFFFL;
        l13 += l29 >> 20;
        l29 = 35694566L * l23;
        l13 += l29 << 8 & 0xFFFFFFFL;
        l14 += l29 >> 20;
        l29 = 132168845L * l23;
        l14 += l29 << 8 & 0xFFFFFFFL;
        l15 += l29 >> 20;
        l29 = 3710130L * l23;
        l15 += l29 << 8 & 0xFFFFFFFL;
        l16 += l29 >> 20;
        l29 = 54187661L * l22;
        l8 += l29 << 8 & 0xFFFFFFFL;
        l9 += l29 >> 20;
        l29 = 20867411L * l22;
        l9 += l29 << 8 & 0xFFFFFFFL;
        l10 += l29 >> 20;
        l29 = -10975981L * l22;
        l10 += l29 << 8 & 0xFFFFFFFL;
        l11 += l29 >> 20;
        l29 = -14361739L * l22;
        l11 += l29 << 8 & 0xFFFFFFFL;
        l12 += l29 >> 20;
        l29 = 35694566L * l22;
        l12 += l29 << 8 & 0xFFFFFFFL;
        l13 += l29 >> 20;
        l29 = 132168845L * l22;
        l13 += l29 << 8 & 0xFFFFFFFL;
        l14 += l29 >> 20;
        l29 = 3710130L * l22;
        l14 += l29 << 8 & 0xFFFFFFFL;
        l15 += l29 >> 20;
        l29 = 54187661L * l21;
        l7 += l29 << 8 & 0xFFFFFFFL;
        l8 += l29 >> 20;
        l29 = 20867411L * l21;
        l8 += l29 << 8 & 0xFFFFFFFL;
        l9 += l29 >> 20;
        l29 = -10975981L * l21;
        l9 += l29 << 8 & 0xFFFFFFFL;
        l10 += l29 >> 20;
        l29 = -14361739L * l21;
        l10 += l29 << 8 & 0xFFFFFFFL;
        l11 += l29 >> 20;
        l29 = 35694566L * l21;
        l11 += l29 << 8 & 0xFFFFFFFL;
        l12 += l29 >> 20;
        l29 = 132168845L * l21;
        l12 += l29 << 8 & 0xFFFFFFFL;
        l13 += l29 >> 20;
        l29 = 3710130L * l21;
        l13 += l29 << 8 & 0xFFFFFFFL;
        l14 += l29 >> 20;
        l29 = 54187661L * l20;
        l6 += l29 << 8 & 0xFFFFFFFL;
        l7 += l29 >> 20;
        l29 = 20867411L * l20;
        l7 += l29 << 8 & 0xFFFFFFFL;
        l8 += l29 >> 20;
        l29 = -10975981L * l20;
        l8 += l29 << 8 & 0xFFFFFFFL;
        l9 += l29 >> 20;
        l29 = -14361739L * l20;
        l9 += l29 << 8 & 0xFFFFFFFL;
        l10 += l29 >> 20;
        l29 = 35694566L * l20;
        l10 += l29 << 8 & 0xFFFFFFFL;
        l11 += l29 >> 20;
        l29 = 132168845L * l20;
        l11 += l29 << 8 & 0xFFFFFFFL;
        l12 += l29 >> 20;
        l29 = 3710130L * l20;
        l12 += l29 << 8 & 0xFFFFFFFL;
        l13 += l29 >> 20;
        l29 = 54187661L * l19;
        l5 += l29 << 8 & 0xFFFFFFFL;
        l6 += l29 >> 20;
        l29 = 20867411L * l19;
        l6 += l29 << 8 & 0xFFFFFFFL;
        l7 += l29 >> 20;
        l29 = -10975981L * l19;
        l7 += l29 << 8 & 0xFFFFFFFL;
        l8 += l29 >> 20;
        l29 = -14361739L * l19;
        l8 += l29 << 8 & 0xFFFFFFFL;
        l9 += l29 >> 20;
        l29 = 35694566L * l19;
        l9 += l29 << 8 & 0xFFFFFFFL;
        l10 += l29 >> 20;
        l29 = 132168845L * l19;
        l10 += l29 << 8 & 0xFFFFFFFL;
        l11 += l29 >> 20;
        l29 = 3710130L * l19;
        l11 += l29 << 8 & 0xFFFFFFFL;
        l12 += l29 >> 20;
        l29 = 54187661L * l18;
        l4 += l29 << 8 & 0xFFFFFFFL;
        l5 += l29 >> 20;
        l29 = 20867411L * l18;
        l5 += l29 << 8 & 0xFFFFFFFL;
        l6 += l29 >> 20;
        l29 = -10975981L * l18;
        l6 += l29 << 8 & 0xFFFFFFFL;
        l7 += l29 >> 20;
        l29 = -14361739L * l18;
        l7 += l29 << 8 & 0xFFFFFFFL;
        l8 += l29 >> 20;
        l29 = 35694566L * l18;
        l8 += l29 << 8 & 0xFFFFFFFL;
        l9 += l29 >> 20;
        l29 = 132168845L * l18;
        l9 += l29 << 8 & 0xFFFFFFFL;
        l10 += l29 >> 20;
        l29 = 3710130L * l18;
        l10 += l29 << 8 & 0xFFFFFFFL;
        l11 += l29 >> 20;
        l29 = 54187661L * l17;
        l3 += l29 << 8 & 0xFFFFFFFL;
        l4 += l29 >> 20;
        l29 = 20867411L * l17;
        l4 += l29 << 8 & 0xFFFFFFFL;
        l5 += l29 >> 20;
        l29 = -10975981L * l17;
        l5 += l29 << 8 & 0xFFFFFFFL;
        l6 += l29 >> 20;
        l29 = -14361739L * l17;
        l6 += l29 << 8 & 0xFFFFFFFL;
        l7 += l29 >> 20;
        l29 = 35694566L * l17;
        l7 += l29 << 8 & 0xFFFFFFFL;
        l8 += l29 >> 20;
        l29 = 132168845L * l17;
        l8 += l29 << 8 & 0xFFFFFFFL;
        l9 += l29 >> 20;
        l29 = 3710130L * l17;
        l9 += l29 << 8 & 0xFFFFFFFL;
        l10 += l29 >> 20;
        l29 = 54187661L * l16;
        l2 += l29 << 8 & 0xFFFFFFFL;
        l3 += l29 >> 20;
        l29 = 20867411L * l16;
        l3 += l29 << 8 & 0xFFFFFFFL;
        l4 += l29 >> 20;
        l29 = -10975981L * l16;
        l4 += l29 << 8 & 0xFFFFFFFL;
        l5 += l29 >> 20;
        l29 = -14361739L * l16;
        l5 += l29 << 8 & 0xFFFFFFFL;
        l6 += l29 >> 20;
        l29 = 35694566L * l16;
        l6 += l29 << 8 & 0xFFFFFFFL;
        l7 += l29 >> 20;
        l29 = 132168845L * l16;
        l7 += l29 << 8 & 0xFFFFFFFL;
        l8 += l29 >> 20;
        l29 = 3710130L * l16;
        l8 += l29 << 8 & 0xFFFFFFFL;
        l9 += l29 >> 20;
        l29 = 54187661L * l15;
        l += l29 << 8 & 0xFFFFFFFL;
        l2 += l29 >> 20;
        l29 = 20867411L * l15;
        l2 += l29 << 8 & 0xFFFFFFFL;
        l3 += l29 >> 20;
        l29 = -10975981L * l15;
        l3 += l29 << 8 & 0xFFFFFFFL;
        l4 += l29 >> 20;
        l29 = -14361739L * l15;
        l4 += l29 << 8 & 0xFFFFFFFL;
        l5 += l29 >> 20;
        l29 = 35694566L * l15;
        l5 += l29 << 8 & 0xFFFFFFFL;
        l6 += l29 >> 20;
        l29 = 132168845L * l15;
        l6 += l29 << 8 & 0xFFFFFFFL;
        l7 += l29 >> 20;
        l29 = 3710130L * l15;
        l15 = 0L;
        this.carryReduce1(lArray, l, l2, l3, l4, l5, l6, l7 += l29 << 8 & 0xFFFFFFFL, l8 += l29 >> 20, l9, l10, l11, l12, l13, l14, l15, l16, l17, l18, l19, l20, l21, l22, l23, l24, l25, l26, l27, l28);
    }

    void carryReduce1(long[] lArray, long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8, long l9, long l10, long l11, long l12, long l13, long l14, long l15, long l16, long l17, long l18, long l19, long l20, long l21, long l22, long l23, long l24, long l25, long l26, long l27, long l28) {
        long l29 = l + 0x8000000L >> 28;
        l -= l29 << 28;
        l2 += l29;
        l29 = l2 + 0x8000000L >> 28;
        l2 -= l29 << 28;
        l3 += l29;
        l29 = l3 + 0x8000000L >> 28;
        l3 -= l29 << 28;
        l4 += l29;
        l29 = l4 + 0x8000000L >> 28;
        l4 -= l29 << 28;
        l5 += l29;
        l29 = l5 + 0x8000000L >> 28;
        l5 -= l29 << 28;
        l6 += l29;
        l29 = l6 + 0x8000000L >> 28;
        l6 -= l29 << 28;
        l7 += l29;
        l29 = l7 + 0x8000000L >> 28;
        l7 -= l29 << 28;
        l8 += l29;
        l29 = l8 + 0x8000000L >> 28;
        l8 -= l29 << 28;
        l9 += l29;
        l29 = l9 + 0x8000000L >> 28;
        l9 -= l29 << 28;
        l10 += l29;
        l29 = l10 + 0x8000000L >> 28;
        l10 -= l29 << 28;
        l11 += l29;
        l29 = l11 + 0x8000000L >> 28;
        l11 -= l29 << 28;
        l12 += l29;
        l29 = l12 + 0x8000000L >> 28;
        l12 -= l29 << 28;
        l13 += l29;
        l29 = l13 + 0x8000000L >> 28;
        l13 -= l29 << 28;
        l14 += l29;
        l29 = l14 + 0x8000000L >> 28;
        this.carryReduce2(lArray, l, l2, l3, l4, l5, l6, l7, l8, l9, l10, l11, l12, l13, l14 -= l29 << 28, l15 += l29, l16, l17, l18, l19, l20, l21, l22, l23, l24, l25, l26, l27, l28);
    }

    void carryReduce2(long[] lArray, long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8, long l9, long l10, long l11, long l12, long l13, long l14, long l15, long l16, long l17, long l18, long l19, long l20, long l21, long l22, long l23, long l24, long l25, long l26, long l27, long l28) {
        long l29 = 54187661L * l15;
        l += l29 << 8 & 0xFFFFFFFL;
        l2 += l29 >> 20;
        l29 = 20867411L * l15;
        l2 += l29 << 8 & 0xFFFFFFFL;
        l3 += l29 >> 20;
        l29 = -10975981L * l15;
        l3 += l29 << 8 & 0xFFFFFFFL;
        l4 += l29 >> 20;
        l29 = -14361739L * l15;
        l4 += l29 << 8 & 0xFFFFFFFL;
        l5 += l29 >> 20;
        l29 = 35694566L * l15;
        l5 += l29 << 8 & 0xFFFFFFFL;
        l6 += l29 >> 20;
        l29 = 132168845L * l15;
        l6 += l29 << 8 & 0xFFFFFFFL;
        l7 += l29 >> 20;
        l29 = 3710130L * l15;
        l7 += l29 << 8 & 0xFFFFFFFL;
        l8 += l29 >> 20;
        l29 = l + 0x8000000L >> 28;
        l -= l29 << 28;
        l2 += l29;
        l29 = l2 + 0x8000000L >> 28;
        l2 -= l29 << 28;
        l3 += l29;
        l29 = l3 + 0x8000000L >> 28;
        l3 -= l29 << 28;
        l4 += l29;
        l29 = l4 + 0x8000000L >> 28;
        l4 -= l29 << 28;
        l5 += l29;
        l29 = l5 + 0x8000000L >> 28;
        l5 -= l29 << 28;
        l6 += l29;
        l29 = l6 + 0x8000000L >> 28;
        l6 -= l29 << 28;
        l7 += l29;
        l29 = l7 + 0x8000000L >> 28;
        l7 -= l29 << 28;
        l8 += l29;
        l29 = l8 + 0x8000000L >> 28;
        l8 -= l29 << 28;
        l9 += l29;
        l29 = l9 + 0x8000000L >> 28;
        l9 -= l29 << 28;
        l10 += l29;
        l29 = l10 + 0x8000000L >> 28;
        l10 -= l29 << 28;
        l11 += l29;
        l29 = l11 + 0x8000000L >> 28;
        l11 -= l29 << 28;
        l12 += l29;
        l29 = l12 + 0x8000000L >> 28;
        l12 -= l29 << 28;
        l13 += l29;
        l29 = l13 + 0x8000000L >> 28;
        l13 -= l29 << 28;
        l14 += l29;
        lArray[0] = l;
        lArray[1] = l2;
        lArray[2] = l3;
        lArray[3] = l4;
        lArray[4] = l5;
        lArray[5] = l6;
        lArray[6] = l7;
        lArray[7] = l8;
        lArray[8] = l9;
        lArray[9] = l10;
        lArray[10] = l11;
        lArray[11] = l12;
        lArray[12] = l13;
        lArray[13] = l14;
    }

    private void carryReduce(long[] lArray, long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8, long l9, long l10, long l11, long l12, long l13, long l14) {
        long l15 = 0L;
        long l16 = l + 0x8000000L >> 28;
        l -= l16 << 28;
        l2 += l16;
        l16 = l2 + 0x8000000L >> 28;
        l2 -= l16 << 28;
        l3 += l16;
        l16 = l3 + 0x8000000L >> 28;
        l3 -= l16 << 28;
        l4 += l16;
        l16 = l4 + 0x8000000L >> 28;
        l4 -= l16 << 28;
        l5 += l16;
        l16 = l5 + 0x8000000L >> 28;
        l5 -= l16 << 28;
        l6 += l16;
        l16 = l6 + 0x8000000L >> 28;
        l6 -= l16 << 28;
        l7 += l16;
        l16 = l7 + 0x8000000L >> 28;
        l7 -= l16 << 28;
        l8 += l16;
        l16 = l8 + 0x8000000L >> 28;
        l8 -= l16 << 28;
        l9 += l16;
        l16 = l9 + 0x8000000L >> 28;
        l9 -= l16 << 28;
        l10 += l16;
        l16 = l10 + 0x8000000L >> 28;
        l10 -= l16 << 28;
        l11 += l16;
        l16 = l11 + 0x8000000L >> 28;
        l11 -= l16 << 28;
        l12 += l16;
        l16 = l12 + 0x8000000L >> 28;
        l12 -= l16 << 28;
        l13 += l16;
        l16 = l13 + 0x8000000L >> 28;
        l13 -= l16 << 28;
        l14 += l16;
        l16 = l14 + 0x8000000L >> 28;
        this.carryReduce0(lArray, l, l2, l3, l4, l5, l6, l7, l8, l9, l10, l11, l12, l13, l14 -= l16 << 28, l15 += l16);
    }

    void carryReduce0(long[] lArray, long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8, long l9, long l10, long l11, long l12, long l13, long l14, long l15) {
        long l16 = 54187661L * l15;
        l += l16 << 8 & 0xFFFFFFFL;
        l2 += l16 >> 20;
        l16 = 20867411L * l15;
        l2 += l16 << 8 & 0xFFFFFFFL;
        l3 += l16 >> 20;
        l16 = -10975981L * l15;
        l3 += l16 << 8 & 0xFFFFFFFL;
        l4 += l16 >> 20;
        l16 = -14361739L * l15;
        l4 += l16 << 8 & 0xFFFFFFFL;
        l5 += l16 >> 20;
        l16 = 35694566L * l15;
        l5 += l16 << 8 & 0xFFFFFFFL;
        l6 += l16 >> 20;
        l16 = 132168845L * l15;
        l6 += l16 << 8 & 0xFFFFFFFL;
        l7 += l16 >> 20;
        l16 = 3710130L * l15;
        l7 += l16 << 8 & 0xFFFFFFFL;
        l8 += l16 >> 20;
        l16 = l + 0x8000000L >> 28;
        l -= l16 << 28;
        l2 += l16;
        l16 = l2 + 0x8000000L >> 28;
        l2 -= l16 << 28;
        l3 += l16;
        l16 = l3 + 0x8000000L >> 28;
        l3 -= l16 << 28;
        l4 += l16;
        l16 = l4 + 0x8000000L >> 28;
        l4 -= l16 << 28;
        l5 += l16;
        l16 = l5 + 0x8000000L >> 28;
        l5 -= l16 << 28;
        l6 += l16;
        l16 = l6 + 0x8000000L >> 28;
        l6 -= l16 << 28;
        l7 += l16;
        l16 = l7 + 0x8000000L >> 28;
        l7 -= l16 << 28;
        l8 += l16;
        l16 = l8 + 0x8000000L >> 28;
        l8 -= l16 << 28;
        l9 += l16;
        l16 = l9 + 0x8000000L >> 28;
        l9 -= l16 << 28;
        l10 += l16;
        l16 = l10 + 0x8000000L >> 28;
        l10 -= l16 << 28;
        l11 += l16;
        l16 = l11 + 0x8000000L >> 28;
        l11 -= l16 << 28;
        l12 += l16;
        l16 = l12 + 0x8000000L >> 28;
        l12 -= l16 << 28;
        l13 += l16;
        l16 = l13 + 0x8000000L >> 28;
        l13 -= l16 << 28;
        l14 += l16;
        lArray[0] = l;
        lArray[1] = l2;
        lArray[2] = l3;
        lArray[3] = l4;
        lArray[4] = l5;
        lArray[5] = l6;
        lArray[6] = l7;
        lArray[7] = l8;
        lArray[8] = l9;
        lArray[9] = l10;
        lArray[10] = l11;
        lArray[11] = l12;
        lArray[12] = l13;
        lArray[13] = l14;
    }

    @Override
    protected void mult(long[] lArray, long[] lArray2, long[] lArray3) {
        long l = lArray[0] * lArray2[0];
        long l2 = lArray[0] * lArray2[1] + lArray[1] * lArray2[0];
        long l3 = lArray[0] * lArray2[2] + lArray[1] * lArray2[1] + lArray[2] * lArray2[0];
        long l4 = lArray[0] * lArray2[3] + lArray[1] * lArray2[2] + lArray[2] * lArray2[1] + lArray[3] * lArray2[0];
        long l5 = lArray[0] * lArray2[4] + lArray[1] * lArray2[3] + lArray[2] * lArray2[2] + lArray[3] * lArray2[1] + lArray[4] * lArray2[0];
        long l6 = lArray[0] * lArray2[5] + lArray[1] * lArray2[4] + lArray[2] * lArray2[3] + lArray[3] * lArray2[2] + lArray[4] * lArray2[1] + lArray[5] * lArray2[0];
        long l7 = lArray[0] * lArray2[6] + lArray[1] * lArray2[5] + lArray[2] * lArray2[4] + lArray[3] * lArray2[3] + lArray[4] * lArray2[2] + lArray[5] * lArray2[1] + lArray[6] * lArray2[0];
        long l8 = lArray[0] * lArray2[7] + lArray[1] * lArray2[6] + lArray[2] * lArray2[5] + lArray[3] * lArray2[4] + lArray[4] * lArray2[3] + lArray[5] * lArray2[2] + lArray[6] * lArray2[1] + lArray[7] * lArray2[0];
        long l9 = lArray[0] * lArray2[8] + lArray[1] * lArray2[7] + lArray[2] * lArray2[6] + lArray[3] * lArray2[5] + lArray[4] * lArray2[4] + lArray[5] * lArray2[3] + lArray[6] * lArray2[2] + lArray[7] * lArray2[1] + lArray[8] * lArray2[0];
        long l10 = lArray[0] * lArray2[9] + lArray[1] * lArray2[8] + lArray[2] * lArray2[7] + lArray[3] * lArray2[6] + lArray[4] * lArray2[5] + lArray[5] * lArray2[4] + lArray[6] * lArray2[3] + lArray[7] * lArray2[2] + lArray[8] * lArray2[1] + lArray[9] * lArray2[0];
        long l11 = lArray[0] * lArray2[10] + lArray[1] * lArray2[9] + lArray[2] * lArray2[8] + lArray[3] * lArray2[7] + lArray[4] * lArray2[6] + lArray[5] * lArray2[5] + lArray[6] * lArray2[4] + lArray[7] * lArray2[3] + lArray[8] * lArray2[2] + lArray[9] * lArray2[1] + lArray[10] * lArray2[0];
        long l12 = lArray[0] * lArray2[11] + lArray[1] * lArray2[10] + lArray[2] * lArray2[9] + lArray[3] * lArray2[8] + lArray[4] * lArray2[7] + lArray[5] * lArray2[6] + lArray[6] * lArray2[5] + lArray[7] * lArray2[4] + lArray[8] * lArray2[3] + lArray[9] * lArray2[2] + lArray[10] * lArray2[1] + lArray[11] * lArray2[0];
        long l13 = lArray[0] * lArray2[12] + lArray[1] * lArray2[11] + lArray[2] * lArray2[10] + lArray[3] * lArray2[9] + lArray[4] * lArray2[8] + lArray[5] * lArray2[7] + lArray[6] * lArray2[6] + lArray[7] * lArray2[5] + lArray[8] * lArray2[4] + lArray[9] * lArray2[3] + lArray[10] * lArray2[2] + lArray[11] * lArray2[1] + lArray[12] * lArray2[0];
        long l14 = lArray[0] * lArray2[13] + lArray[1] * lArray2[12] + lArray[2] * lArray2[11] + lArray[3] * lArray2[10] + lArray[4] * lArray2[9] + lArray[5] * lArray2[8] + lArray[6] * lArray2[7] + lArray[7] * lArray2[6] + lArray[8] * lArray2[5] + lArray[9] * lArray2[4] + lArray[10] * lArray2[3] + lArray[11] * lArray2[2] + lArray[12] * lArray2[1] + lArray[13] * lArray2[0];
        long l15 = lArray[1] * lArray2[13] + lArray[2] * lArray2[12] + lArray[3] * lArray2[11] + lArray[4] * lArray2[10] + lArray[5] * lArray2[9] + lArray[6] * lArray2[8] + lArray[7] * lArray2[7] + lArray[8] * lArray2[6] + lArray[9] * lArray2[5] + lArray[10] * lArray2[4] + lArray[11] * lArray2[3] + lArray[12] * lArray2[2] + lArray[13] * lArray2[1];
        long l16 = lArray[2] * lArray2[13] + lArray[3] * lArray2[12] + lArray[4] * lArray2[11] + lArray[5] * lArray2[10] + lArray[6] * lArray2[9] + lArray[7] * lArray2[8] + lArray[8] * lArray2[7] + lArray[9] * lArray2[6] + lArray[10] * lArray2[5] + lArray[11] * lArray2[4] + lArray[12] * lArray2[3] + lArray[13] * lArray2[2];
        long l17 = lArray[3] * lArray2[13] + lArray[4] * lArray2[12] + lArray[5] * lArray2[11] + lArray[6] * lArray2[10] + lArray[7] * lArray2[9] + lArray[8] * lArray2[8] + lArray[9] * lArray2[7] + lArray[10] * lArray2[6] + lArray[11] * lArray2[5] + lArray[12] * lArray2[4] + lArray[13] * lArray2[3];
        long l18 = lArray[4] * lArray2[13] + lArray[5] * lArray2[12] + lArray[6] * lArray2[11] + lArray[7] * lArray2[10] + lArray[8] * lArray2[9] + lArray[9] * lArray2[8] + lArray[10] * lArray2[7] + lArray[11] * lArray2[6] + lArray[12] * lArray2[5] + lArray[13] * lArray2[4];
        long l19 = lArray[5] * lArray2[13] + lArray[6] * lArray2[12] + lArray[7] * lArray2[11] + lArray[8] * lArray2[10] + lArray[9] * lArray2[9] + lArray[10] * lArray2[8] + lArray[11] * lArray2[7] + lArray[12] * lArray2[6] + lArray[13] * lArray2[5];
        long l20 = lArray[6] * lArray2[13] + lArray[7] * lArray2[12] + lArray[8] * lArray2[11] + lArray[9] * lArray2[10] + lArray[10] * lArray2[9] + lArray[11] * lArray2[8] + lArray[12] * lArray2[7] + lArray[13] * lArray2[6];
        long l21 = lArray[7] * lArray2[13] + lArray[8] * lArray2[12] + lArray[9] * lArray2[11] + lArray[10] * lArray2[10] + lArray[11] * lArray2[9] + lArray[12] * lArray2[8] + lArray[13] * lArray2[7];
        long l22 = lArray[8] * lArray2[13] + lArray[9] * lArray2[12] + lArray[10] * lArray2[11] + lArray[11] * lArray2[10] + lArray[12] * lArray2[9] + lArray[13] * lArray2[8];
        long l23 = lArray[9] * lArray2[13] + lArray[10] * lArray2[12] + lArray[11] * lArray2[11] + lArray[12] * lArray2[10] + lArray[13] * lArray2[9];
        long l24 = lArray[10] * lArray2[13] + lArray[11] * lArray2[12] + lArray[12] * lArray2[11] + lArray[13] * lArray2[10];
        long l25 = lArray[11] * lArray2[13] + lArray[12] * lArray2[12] + lArray[13] * lArray2[11];
        long l26 = lArray[12] * lArray2[13] + lArray[13] * lArray2[12];
        long l27 = lArray[13] * lArray2[13];
        this.carryReduce(lArray3, l, l2, l3, l4, l5, l6, l7, l8, l9, l10, l11, l12, l13, l14, l15, l16, l17, l18, l19, l20, l21, l22, l23, l24, l25, l26, l27);
    }

    @Override
    protected void reduce(long[] lArray) {
        this.carryReduce(lArray, lArray[0], lArray[1], lArray[2], lArray[3], lArray[4], lArray[5], lArray[6], lArray[7], lArray[8], lArray[9], lArray[10], lArray[11], lArray[12], lArray[13]);
    }

    @Override
    protected void square(long[] lArray, long[] lArray2) {
        long l = lArray[0] * lArray[0];
        long l2 = 2L * (lArray[0] * lArray[1]);
        long l3 = 2L * (lArray[0] * lArray[2]) + lArray[1] * lArray[1];
        long l4 = 2L * (lArray[0] * lArray[3] + lArray[1] * lArray[2]);
        long l5 = 2L * (lArray[0] * lArray[4] + lArray[1] * lArray[3]) + lArray[2] * lArray[2];
        long l6 = 2L * (lArray[0] * lArray[5] + lArray[1] * lArray[4] + lArray[2] * lArray[3]);
        long l7 = 2L * (lArray[0] * lArray[6] + lArray[1] * lArray[5] + lArray[2] * lArray[4]) + lArray[3] * lArray[3];
        long l8 = 2L * (lArray[0] * lArray[7] + lArray[1] * lArray[6] + lArray[2] * lArray[5] + lArray[3] * lArray[4]);
        long l9 = 2L * (lArray[0] * lArray[8] + lArray[1] * lArray[7] + lArray[2] * lArray[6] + lArray[3] * lArray[5]) + lArray[4] * lArray[4];
        long l10 = 2L * (lArray[0] * lArray[9] + lArray[1] * lArray[8] + lArray[2] * lArray[7] + lArray[3] * lArray[6] + lArray[4] * lArray[5]);
        long l11 = 2L * (lArray[0] * lArray[10] + lArray[1] * lArray[9] + lArray[2] * lArray[8] + lArray[3] * lArray[7] + lArray[4] * lArray[6]) + lArray[5] * lArray[5];
        long l12 = 2L * (lArray[0] * lArray[11] + lArray[1] * lArray[10] + lArray[2] * lArray[9] + lArray[3] * lArray[8] + lArray[4] * lArray[7] + lArray[5] * lArray[6]);
        long l13 = 2L * (lArray[0] * lArray[12] + lArray[1] * lArray[11] + lArray[2] * lArray[10] + lArray[3] * lArray[9] + lArray[4] * lArray[8] + lArray[5] * lArray[7]) + lArray[6] * lArray[6];
        long l14 = 2L * (lArray[0] * lArray[13] + lArray[1] * lArray[12] + lArray[2] * lArray[11] + lArray[3] * lArray[10] + lArray[4] * lArray[9] + lArray[5] * lArray[8] + lArray[6] * lArray[7]);
        long l15 = 2L * (lArray[1] * lArray[13] + lArray[2] * lArray[12] + lArray[3] * lArray[11] + lArray[4] * lArray[10] + lArray[5] * lArray[9] + lArray[6] * lArray[8]) + lArray[7] * lArray[7];
        long l16 = 2L * (lArray[2] * lArray[13] + lArray[3] * lArray[12] + lArray[4] * lArray[11] + lArray[5] * lArray[10] + lArray[6] * lArray[9] + lArray[7] * lArray[8]);
        long l17 = 2L * (lArray[3] * lArray[13] + lArray[4] * lArray[12] + lArray[5] * lArray[11] + lArray[6] * lArray[10] + lArray[7] * lArray[9]) + lArray[8] * lArray[8];
        long l18 = 2L * (lArray[4] * lArray[13] + lArray[5] * lArray[12] + lArray[6] * lArray[11] + lArray[7] * lArray[10] + lArray[8] * lArray[9]);
        long l19 = 2L * (lArray[5] * lArray[13] + lArray[6] * lArray[12] + lArray[7] * lArray[11] + lArray[8] * lArray[10]) + lArray[9] * lArray[9];
        long l20 = 2L * (lArray[6] * lArray[13] + lArray[7] * lArray[12] + lArray[8] * lArray[11] + lArray[9] * lArray[10]);
        long l21 = 2L * (lArray[7] * lArray[13] + lArray[8] * lArray[12] + lArray[9] * lArray[11]) + lArray[10] * lArray[10];
        long l22 = 2L * (lArray[8] * lArray[13] + lArray[9] * lArray[12] + lArray[10] * lArray[11]);
        long l23 = 2L * (lArray[9] * lArray[13] + lArray[10] * lArray[12]) + lArray[11] * lArray[11];
        long l24 = 2L * (lArray[10] * lArray[13] + lArray[11] * lArray[12]);
        long l25 = 2L * (lArray[11] * lArray[13]) + lArray[12] * lArray[12];
        long l26 = 2L * (lArray[12] * lArray[13]);
        long l27 = lArray[13] * lArray[13];
        this.carryReduce(lArray2, l, l2, l3, l4, l5, l6, l7, l8, l9, l10, l11, l12, l13, l14, l15, l16, l17, l18, l19, l20, l21, l22, l23, l24, l25, l26, l27);
    }
}

