/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util.math.intpoly;

import java.math.BigInteger;
import sun.security.util.math.intpoly.IntegerPolynomial;

public class IntegerPolynomialP521
extends IntegerPolynomial {
    private static final int BITS_PER_LIMB = 28;
    private static final int NUM_LIMBS = 19;
    private static final int MAX_ADDS = 2;
    public static final BigInteger MODULUS = IntegerPolynomialP521.evaluateModulus();
    private static final long CARRY_ADD = 0x8000000L;
    private static final int LIMB_MASK = 0xFFFFFFF;

    public IntegerPolynomialP521() {
        super(28, 19, 2, MODULUS);
    }

    private static BigInteger evaluateModulus() {
        BigInteger bigInteger = BigInteger.valueOf(2L).pow(521);
        bigInteger = bigInteger.subtract(BigInteger.valueOf(1L));
        return bigInteger;
    }

    @Override
    protected void reduceIn(long[] lArray, long l, int n) {
        int n2 = n - 19;
        lArray[n2] = lArray[n2] + (l << 11 & 0xFFFFFFFL);
        int n3 = n - 18;
        lArray[n3] = lArray[n3] + (l >> 17);
    }

    @Override
    protected void finalCarryReduceLast(long[] lArray) {
        long l = lArray[18] >> 17;
        lArray[18] = lArray[18] - (l << 17);
        lArray[0] = lArray[0] + l;
    }

    private void carryReduce(long[] lArray, long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8, long l9, long l10, long l11, long l12, long l13, long l14, long l15, long l16, long l17, long l18, long l19, long l20, long l21, long l22, long l23, long l24, long l25, long l26, long l27, long l28, long l29, long l30, long l31, long l32, long l33, long l34, long l35, long l36, long l37) {
        long l38 = 0L;
        l18 += l37 << 11 & 0xFFFFFFFL;
        l19 += l37 >> 17;
        l17 += l36 << 11 & 0xFFFFFFFL;
        l18 += l36 >> 17;
        l16 += l35 << 11 & 0xFFFFFFFL;
        l17 += l35 >> 17;
        l15 += l34 << 11 & 0xFFFFFFFL;
        l16 += l34 >> 17;
        l14 += l33 << 11 & 0xFFFFFFFL;
        l15 += l33 >> 17;
        l13 += l32 << 11 & 0xFFFFFFFL;
        l14 += l32 >> 17;
        l12 += l31 << 11 & 0xFFFFFFFL;
        l13 += l31 >> 17;
        l11 += l30 << 11 & 0xFFFFFFFL;
        l12 += l30 >> 17;
        l10 += l29 << 11 & 0xFFFFFFFL;
        l11 += l29 >> 17;
        l9 += l28 << 11 & 0xFFFFFFFL;
        l10 += l28 >> 17;
        l8 += l27 << 11 & 0xFFFFFFFL;
        l9 += l27 >> 17;
        l7 += l26 << 11 & 0xFFFFFFFL;
        l8 += l26 >> 17;
        l6 += l25 << 11 & 0xFFFFFFFL;
        l7 += l25 >> 17;
        l5 += l24 << 11 & 0xFFFFFFFL;
        l6 += l24 >> 17;
        l4 += l23 << 11 & 0xFFFFFFFL;
        l5 += l23 >> 17;
        l3 += l22 << 11 & 0xFFFFFFFL;
        l2 += l21 << 11 & 0xFFFFFFFL;
        l += l20 << 11 & 0xFFFFFFFL;
        l2 += l20 >> 17;
        l20 = 0L;
        this.carryReduce0(lArray, l, l2, l3 += l21 >> 17, l4 += l22 >> 17, l5, l6, l7, l8, l9, l10, l11, l12, l13, l14, l15, l16, l17, l18, l19, l20, l21, l22, l23, l24, l25, l26, l27, l28, l29, l30, l31, l32, l33, l34, l35, l36, l37, l38);
    }

    void carryReduce0(long[] lArray, long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8, long l9, long l10, long l11, long l12, long l13, long l14, long l15, long l16, long l17, long l18, long l19, long l20, long l21, long l22, long l23, long l24, long l25, long l26, long l27, long l28, long l29, long l30, long l31, long l32, long l33, long l34, long l35, long l36, long l37, long l38) {
        long l39 = l18 + 0x8000000L >> 28;
        l18 -= l39 << 28;
        l19 += l39;
        l39 = l19 + 0x8000000L >> 28;
        l19 -= l39 << 28;
        l += (l20 += l39) << 11 & 0xFFFFFFFL;
        l2 += l20 >> 17;
        l39 = l + 0x8000000L >> 28;
        l -= l39 << 28;
        l2 += l39;
        l39 = l2 + 0x8000000L >> 28;
        l2 -= l39 << 28;
        l3 += l39;
        l39 = l3 + 0x8000000L >> 28;
        l3 -= l39 << 28;
        l4 += l39;
        l39 = l4 + 0x8000000L >> 28;
        l4 -= l39 << 28;
        l5 += l39;
        l39 = l5 + 0x8000000L >> 28;
        l5 -= l39 << 28;
        l6 += l39;
        l39 = l6 + 0x8000000L >> 28;
        l6 -= l39 << 28;
        l7 += l39;
        l39 = l7 + 0x8000000L >> 28;
        l7 -= l39 << 28;
        l8 += l39;
        l39 = l8 + 0x8000000L >> 28;
        l8 -= l39 << 28;
        l9 += l39;
        l39 = l9 + 0x8000000L >> 28;
        l9 -= l39 << 28;
        l10 += l39;
        l39 = l10 + 0x8000000L >> 28;
        l10 -= l39 << 28;
        l11 += l39;
        l39 = l11 + 0x8000000L >> 28;
        l11 -= l39 << 28;
        l12 += l39;
        l39 = l12 + 0x8000000L >> 28;
        l12 -= l39 << 28;
        l13 += l39;
        l39 = l13 + 0x8000000L >> 28;
        l13 -= l39 << 28;
        l14 += l39;
        l39 = l14 + 0x8000000L >> 28;
        l14 -= l39 << 28;
        l15 += l39;
        l39 = l15 + 0x8000000L >> 28;
        l15 -= l39 << 28;
        l16 += l39;
        l39 = l16 + 0x8000000L >> 28;
        l16 -= l39 << 28;
        l17 += l39;
        l39 = l17 + 0x8000000L >> 28;
        l17 -= l39 << 28;
        l18 += l39;
        l39 = l18 + 0x8000000L >> 28;
        l18 -= l39 << 28;
        l19 += l39;
        lArray[0] = l;
        lArray[1] = l2;
        lArray[2] = l3;
        lArray[3] = l4;
        lArray[4] = l5;
        lArray[5] = l6;
        lArray[6] = l7;
        lArray[7] = l8;
        lArray[8] = l9;
        lArray[9] = l10;
        lArray[10] = l11;
        lArray[11] = l12;
        lArray[12] = l13;
        lArray[13] = l14;
        lArray[14] = l15;
        lArray[15] = l16;
        lArray[16] = l17;
        lArray[17] = l18;
        lArray[18] = l19;
    }

    private void carryReduce(long[] lArray, long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8, long l9, long l10, long l11, long l12, long l13, long l14, long l15, long l16, long l17, long l18, long l19) {
        long l20 = 0L;
        long l21 = l18 + 0x8000000L >> 28;
        l18 -= l21 << 28;
        l19 += l21;
        l21 = l19 + 0x8000000L >> 28;
        l19 -= l21 << 28;
        l += (l20 += l21) << 11 & 0xFFFFFFFL;
        l2 += l20 >> 17;
        l21 = l + 0x8000000L >> 28;
        l -= l21 << 28;
        l2 += l21;
        l21 = l2 + 0x8000000L >> 28;
        l2 -= l21 << 28;
        l3 += l21;
        l21 = l3 + 0x8000000L >> 28;
        l3 -= l21 << 28;
        l4 += l21;
        l21 = l4 + 0x8000000L >> 28;
        l4 -= l21 << 28;
        l5 += l21;
        l21 = l5 + 0x8000000L >> 28;
        l5 -= l21 << 28;
        l6 += l21;
        l21 = l6 + 0x8000000L >> 28;
        l6 -= l21 << 28;
        l7 += l21;
        l21 = l7 + 0x8000000L >> 28;
        l7 -= l21 << 28;
        l8 += l21;
        l21 = l8 + 0x8000000L >> 28;
        l8 -= l21 << 28;
        l9 += l21;
        l21 = l9 + 0x8000000L >> 28;
        l9 -= l21 << 28;
        l10 += l21;
        l21 = l10 + 0x8000000L >> 28;
        l10 -= l21 << 28;
        l11 += l21;
        l21 = l11 + 0x8000000L >> 28;
        l11 -= l21 << 28;
        l12 += l21;
        l21 = l12 + 0x8000000L >> 28;
        l12 -= l21 << 28;
        l13 += l21;
        l21 = l13 + 0x8000000L >> 28;
        l13 -= l21 << 28;
        l14 += l21;
        l21 = l14 + 0x8000000L >> 28;
        l14 -= l21 << 28;
        l15 += l21;
        l21 = l15 + 0x8000000L >> 28;
        l15 -= l21 << 28;
        l16 += l21;
        l21 = l16 + 0x8000000L >> 28;
        l16 -= l21 << 28;
        l17 += l21;
        l21 = l17 + 0x8000000L >> 28;
        l17 -= l21 << 28;
        l18 += l21;
        l21 = l18 + 0x8000000L >> 28;
        l18 -= l21 << 28;
        l19 += l21;
        lArray[0] = l;
        lArray[1] = l2;
        lArray[2] = l3;
        lArray[3] = l4;
        lArray[4] = l5;
        lArray[5] = l6;
        lArray[6] = l7;
        lArray[7] = l8;
        lArray[8] = l9;
        lArray[9] = l10;
        lArray[10] = l11;
        lArray[11] = l12;
        lArray[12] = l13;
        lArray[13] = l14;
        lArray[14] = l15;
        lArray[15] = l16;
        lArray[16] = l17;
        lArray[17] = l18;
        lArray[18] = l19;
    }

    @Override
    protected void mult(long[] lArray, long[] lArray2, long[] lArray3) {
        long l = lArray[0] * lArray2[0];
        long l2 = lArray[0] * lArray2[1] + lArray[1] * lArray2[0];
        long l3 = lArray[0] * lArray2[2] + lArray[1] * lArray2[1] + lArray[2] * lArray2[0];
        long l4 = lArray[0] * lArray2[3] + lArray[1] * lArray2[2] + lArray[2] * lArray2[1] + lArray[3] * lArray2[0];
        long l5 = lArray[0] * lArray2[4] + lArray[1] * lArray2[3] + lArray[2] * lArray2[2] + lArray[3] * lArray2[1] + lArray[4] * lArray2[0];
        long l6 = lArray[0] * lArray2[5] + lArray[1] * lArray2[4] + lArray[2] * lArray2[3] + lArray[3] * lArray2[2] + lArray[4] * lArray2[1] + lArray[5] * lArray2[0];
        long l7 = lArray[0] * lArray2[6] + lArray[1] * lArray2[5] + lArray[2] * lArray2[4] + lArray[3] * lArray2[3] + lArray[4] * lArray2[2] + lArray[5] * lArray2[1] + lArray[6] * lArray2[0];
        long l8 = lArray[0] * lArray2[7] + lArray[1] * lArray2[6] + lArray[2] * lArray2[5] + lArray[3] * lArray2[4] + lArray[4] * lArray2[3] + lArray[5] * lArray2[2] + lArray[6] * lArray2[1] + lArray[7] * lArray2[0];
        long l9 = lArray[0] * lArray2[8] + lArray[1] * lArray2[7] + lArray[2] * lArray2[6] + lArray[3] * lArray2[5] + lArray[4] * lArray2[4] + lArray[5] * lArray2[3] + lArray[6] * lArray2[2] + lArray[7] * lArray2[1] + lArray[8] * lArray2[0];
        long l10 = lArray[0] * lArray2[9] + lArray[1] * lArray2[8] + lArray[2] * lArray2[7] + lArray[3] * lArray2[6] + lArray[4] * lArray2[5] + lArray[5] * lArray2[4] + lArray[6] * lArray2[3] + lArray[7] * lArray2[2] + lArray[8] * lArray2[1] + lArray[9] * lArray2[0];
        long l11 = lArray[0] * lArray2[10] + lArray[1] * lArray2[9] + lArray[2] * lArray2[8] + lArray[3] * lArray2[7] + lArray[4] * lArray2[6] + lArray[5] * lArray2[5] + lArray[6] * lArray2[4] + lArray[7] * lArray2[3] + lArray[8] * lArray2[2] + lArray[9] * lArray2[1] + lArray[10] * lArray2[0];
        long l12 = lArray[0] * lArray2[11] + lArray[1] * lArray2[10] + lArray[2] * lArray2[9] + lArray[3] * lArray2[8] + lArray[4] * lArray2[7] + lArray[5] * lArray2[6] + lArray[6] * lArray2[5] + lArray[7] * lArray2[4] + lArray[8] * lArray2[3] + lArray[9] * lArray2[2] + lArray[10] * lArray2[1] + lArray[11] * lArray2[0];
        long l13 = lArray[0] * lArray2[12] + lArray[1] * lArray2[11] + lArray[2] * lArray2[10] + lArray[3] * lArray2[9] + lArray[4] * lArray2[8] + lArray[5] * lArray2[7] + lArray[6] * lArray2[6] + lArray[7] * lArray2[5] + lArray[8] * lArray2[4] + lArray[9] * lArray2[3] + lArray[10] * lArray2[2] + lArray[11] * lArray2[1] + lArray[12] * lArray2[0];
        long l14 = lArray[0] * lArray2[13] + lArray[1] * lArray2[12] + lArray[2] * lArray2[11] + lArray[3] * lArray2[10] + lArray[4] * lArray2[9] + lArray[5] * lArray2[8] + lArray[6] * lArray2[7] + lArray[7] * lArray2[6] + lArray[8] * lArray2[5] + lArray[9] * lArray2[4] + lArray[10] * lArray2[3] + lArray[11] * lArray2[2] + lArray[12] * lArray2[1] + lArray[13] * lArray2[0];
        long l15 = lArray[0] * lArray2[14] + lArray[1] * lArray2[13] + lArray[2] * lArray2[12] + lArray[3] * lArray2[11] + lArray[4] * lArray2[10] + lArray[5] * lArray2[9] + lArray[6] * lArray2[8] + lArray[7] * lArray2[7] + lArray[8] * lArray2[6] + lArray[9] * lArray2[5] + lArray[10] * lArray2[4] + lArray[11] * lArray2[3] + lArray[12] * lArray2[2] + lArray[13] * lArray2[1] + lArray[14] * lArray2[0];
        long l16 = lArray[0] * lArray2[15] + lArray[1] * lArray2[14] + lArray[2] * lArray2[13] + lArray[3] * lArray2[12] + lArray[4] * lArray2[11] + lArray[5] * lArray2[10] + lArray[6] * lArray2[9] + lArray[7] * lArray2[8] + lArray[8] * lArray2[7] + lArray[9] * lArray2[6] + lArray[10] * lArray2[5] + lArray[11] * lArray2[4] + lArray[12] * lArray2[3] + lArray[13] * lArray2[2] + lArray[14] * lArray2[1] + lArray[15] * lArray2[0];
        long l17 = lArray[0] * lArray2[16] + lArray[1] * lArray2[15] + lArray[2] * lArray2[14] + lArray[3] * lArray2[13] + lArray[4] * lArray2[12] + lArray[5] * lArray2[11] + lArray[6] * lArray2[10] + lArray[7] * lArray2[9] + lArray[8] * lArray2[8] + lArray[9] * lArray2[7] + lArray[10] * lArray2[6] + lArray[11] * lArray2[5] + lArray[12] * lArray2[4] + lArray[13] * lArray2[3] + lArray[14] * lArray2[2] + lArray[15] * lArray2[1] + lArray[16] * lArray2[0];
        long l18 = lArray[0] * lArray2[17] + lArray[1] * lArray2[16] + lArray[2] * lArray2[15] + lArray[3] * lArray2[14] + lArray[4] * lArray2[13] + lArray[5] * lArray2[12] + lArray[6] * lArray2[11] + lArray[7] * lArray2[10] + lArray[8] * lArray2[9] + lArray[9] * lArray2[8] + lArray[10] * lArray2[7] + lArray[11] * lArray2[6] + lArray[12] * lArray2[5] + lArray[13] * lArray2[4] + lArray[14] * lArray2[3] + lArray[15] * lArray2[2] + lArray[16] * lArray2[1] + lArray[17] * lArray2[0];
        long l19 = lArray[0] * lArray2[18] + lArray[1] * lArray2[17] + lArray[2] * lArray2[16] + lArray[3] * lArray2[15] + lArray[4] * lArray2[14] + lArray[5] * lArray2[13] + lArray[6] * lArray2[12] + lArray[7] * lArray2[11] + lArray[8] * lArray2[10] + lArray[9] * lArray2[9] + lArray[10] * lArray2[8] + lArray[11] * lArray2[7] + lArray[12] * lArray2[6] + lArray[13] * lArray2[5] + lArray[14] * lArray2[4] + lArray[15] * lArray2[3] + lArray[16] * lArray2[2] + lArray[17] * lArray2[1] + lArray[18] * lArray2[0];
        long l20 = lArray[1] * lArray2[18] + lArray[2] * lArray2[17] + lArray[3] * lArray2[16] + lArray[4] * lArray2[15] + lArray[5] * lArray2[14] + lArray[6] * lArray2[13] + lArray[7] * lArray2[12] + lArray[8] * lArray2[11] + lArray[9] * lArray2[10] + lArray[10] * lArray2[9] + lArray[11] * lArray2[8] + lArray[12] * lArray2[7] + lArray[13] * lArray2[6] + lArray[14] * lArray2[5] + lArray[15] * lArray2[4] + lArray[16] * lArray2[3] + lArray[17] * lArray2[2] + lArray[18] * lArray2[1];
        long l21 = lArray[2] * lArray2[18] + lArray[3] * lArray2[17] + lArray[4] * lArray2[16] + lArray[5] * lArray2[15] + lArray[6] * lArray2[14] + lArray[7] * lArray2[13] + lArray[8] * lArray2[12] + lArray[9] * lArray2[11] + lArray[10] * lArray2[10] + lArray[11] * lArray2[9] + lArray[12] * lArray2[8] + lArray[13] * lArray2[7] + lArray[14] * lArray2[6] + lArray[15] * lArray2[5] + lArray[16] * lArray2[4] + lArray[17] * lArray2[3] + lArray[18] * lArray2[2];
        long l22 = lArray[3] * lArray2[18] + lArray[4] * lArray2[17] + lArray[5] * lArray2[16] + lArray[6] * lArray2[15] + lArray[7] * lArray2[14] + lArray[8] * lArray2[13] + lArray[9] * lArray2[12] + lArray[10] * lArray2[11] + lArray[11] * lArray2[10] + lArray[12] * lArray2[9] + lArray[13] * lArray2[8] + lArray[14] * lArray2[7] + lArray[15] * lArray2[6] + lArray[16] * lArray2[5] + lArray[17] * lArray2[4] + lArray[18] * lArray2[3];
        long l23 = lArray[4] * lArray2[18] + lArray[5] * lArray2[17] + lArray[6] * lArray2[16] + lArray[7] * lArray2[15] + lArray[8] * lArray2[14] + lArray[9] * lArray2[13] + lArray[10] * lArray2[12] + lArray[11] * lArray2[11] + lArray[12] * lArray2[10] + lArray[13] * lArray2[9] + lArray[14] * lArray2[8] + lArray[15] * lArray2[7] + lArray[16] * lArray2[6] + lArray[17] * lArray2[5] + lArray[18] * lArray2[4];
        long l24 = lArray[5] * lArray2[18] + lArray[6] * lArray2[17] + lArray[7] * lArray2[16] + lArray[8] * lArray2[15] + lArray[9] * lArray2[14] + lArray[10] * lArray2[13] + lArray[11] * lArray2[12] + lArray[12] * lArray2[11] + lArray[13] * lArray2[10] + lArray[14] * lArray2[9] + lArray[15] * lArray2[8] + lArray[16] * lArray2[7] + lArray[17] * lArray2[6] + lArray[18] * lArray2[5];
        long l25 = lArray[6] * lArray2[18] + lArray[7] * lArray2[17] + lArray[8] * lArray2[16] + lArray[9] * lArray2[15] + lArray[10] * lArray2[14] + lArray[11] * lArray2[13] + lArray[12] * lArray2[12] + lArray[13] * lArray2[11] + lArray[14] * lArray2[10] + lArray[15] * lArray2[9] + lArray[16] * lArray2[8] + lArray[17] * lArray2[7] + lArray[18] * lArray2[6];
        long l26 = lArray[7] * lArray2[18] + lArray[8] * lArray2[17] + lArray[9] * lArray2[16] + lArray[10] * lArray2[15] + lArray[11] * lArray2[14] + lArray[12] * lArray2[13] + lArray[13] * lArray2[12] + lArray[14] * lArray2[11] + lArray[15] * lArray2[10] + lArray[16] * lArray2[9] + lArray[17] * lArray2[8] + lArray[18] * lArray2[7];
        long l27 = lArray[8] * lArray2[18] + lArray[9] * lArray2[17] + lArray[10] * lArray2[16] + lArray[11] * lArray2[15] + lArray[12] * lArray2[14] + lArray[13] * lArray2[13] + lArray[14] * lArray2[12] + lArray[15] * lArray2[11] + lArray[16] * lArray2[10] + lArray[17] * lArray2[9] + lArray[18] * lArray2[8];
        long l28 = lArray[9] * lArray2[18] + lArray[10] * lArray2[17] + lArray[11] * lArray2[16] + lArray[12] * lArray2[15] + lArray[13] * lArray2[14] + lArray[14] * lArray2[13] + lArray[15] * lArray2[12] + lArray[16] * lArray2[11] + lArray[17] * lArray2[10] + lArray[18] * lArray2[9];
        long l29 = lArray[10] * lArray2[18] + lArray[11] * lArray2[17] + lArray[12] * lArray2[16] + lArray[13] * lArray2[15] + lArray[14] * lArray2[14] + lArray[15] * lArray2[13] + lArray[16] * lArray2[12] + lArray[17] * lArray2[11] + lArray[18] * lArray2[10];
        long l30 = lArray[11] * lArray2[18] + lArray[12] * lArray2[17] + lArray[13] * lArray2[16] + lArray[14] * lArray2[15] + lArray[15] * lArray2[14] + lArray[16] * lArray2[13] + lArray[17] * lArray2[12] + lArray[18] * lArray2[11];
        long l31 = lArray[12] * lArray2[18] + lArray[13] * lArray2[17] + lArray[14] * lArray2[16] + lArray[15] * lArray2[15] + lArray[16] * lArray2[14] + lArray[17] * lArray2[13] + lArray[18] * lArray2[12];
        long l32 = lArray[13] * lArray2[18] + lArray[14] * lArray2[17] + lArray[15] * lArray2[16] + lArray[16] * lArray2[15] + lArray[17] * lArray2[14] + lArray[18] * lArray2[13];
        long l33 = lArray[14] * lArray2[18] + lArray[15] * lArray2[17] + lArray[16] * lArray2[16] + lArray[17] * lArray2[15] + lArray[18] * lArray2[14];
        long l34 = lArray[15] * lArray2[18] + lArray[16] * lArray2[17] + lArray[17] * lArray2[16] + lArray[18] * lArray2[15];
        long l35 = lArray[16] * lArray2[18] + lArray[17] * lArray2[17] + lArray[18] * lArray2[16];
        long l36 = lArray[17] * lArray2[18] + lArray[18] * lArray2[17];
        long l37 = lArray[18] * lArray2[18];
        this.carryReduce(lArray3, l, l2, l3, l4, l5, l6, l7, l8, l9, l10, l11, l12, l13, l14, l15, l16, l17, l18, l19, l20, l21, l22, l23, l24, l25, l26, l27, l28, l29, l30, l31, l32, l33, l34, l35, l36, l37);
    }

    @Override
    protected void reduce(long[] lArray) {
        this.carryReduce(lArray, lArray[0], lArray[1], lArray[2], lArray[3], lArray[4], lArray[5], lArray[6], lArray[7], lArray[8], lArray[9], lArray[10], lArray[11], lArray[12], lArray[13], lArray[14], lArray[15], lArray[16], lArray[17], lArray[18]);
    }

    @Override
    protected void square(long[] lArray, long[] lArray2) {
        long l = lArray[0] * lArray[0];
        long l2 = 2L * (lArray[0] * lArray[1]);
        long l3 = 2L * (lArray[0] * lArray[2]) + lArray[1] * lArray[1];
        long l4 = 2L * (lArray[0] * lArray[3] + lArray[1] * lArray[2]);
        long l5 = 2L * (lArray[0] * lArray[4] + lArray[1] * lArray[3]) + lArray[2] * lArray[2];
        long l6 = 2L * (lArray[0] * lArray[5] + lArray[1] * lArray[4] + lArray[2] * lArray[3]);
        long l7 = 2L * (lArray[0] * lArray[6] + lArray[1] * lArray[5] + lArray[2] * lArray[4]) + lArray[3] * lArray[3];
        long l8 = 2L * (lArray[0] * lArray[7] + lArray[1] * lArray[6] + lArray[2] * lArray[5] + lArray[3] * lArray[4]);
        long l9 = 2L * (lArray[0] * lArray[8] + lArray[1] * lArray[7] + lArray[2] * lArray[6] + lArray[3] * lArray[5]) + lArray[4] * lArray[4];
        long l10 = 2L * (lArray[0] * lArray[9] + lArray[1] * lArray[8] + lArray[2] * lArray[7] + lArray[3] * lArray[6] + lArray[4] * lArray[5]);
        long l11 = 2L * (lArray[0] * lArray[10] + lArray[1] * lArray[9] + lArray[2] * lArray[8] + lArray[3] * lArray[7] + lArray[4] * lArray[6]) + lArray[5] * lArray[5];
        long l12 = 2L * (lArray[0] * lArray[11] + lArray[1] * lArray[10] + lArray[2] * lArray[9] + lArray[3] * lArray[8] + lArray[4] * lArray[7] + lArray[5] * lArray[6]);
        long l13 = 2L * (lArray[0] * lArray[12] + lArray[1] * lArray[11] + lArray[2] * lArray[10] + lArray[3] * lArray[9] + lArray[4] * lArray[8] + lArray[5] * lArray[7]) + lArray[6] * lArray[6];
        long l14 = 2L * (lArray[0] * lArray[13] + lArray[1] * lArray[12] + lArray[2] * lArray[11] + lArray[3] * lArray[10] + lArray[4] * lArray[9] + lArray[5] * lArray[8] + lArray[6] * lArray[7]);
        long l15 = 2L * (lArray[0] * lArray[14] + lArray[1] * lArray[13] + lArray[2] * lArray[12] + lArray[3] * lArray[11] + lArray[4] * lArray[10] + lArray[5] * lArray[9] + lArray[6] * lArray[8]) + lArray[7] * lArray[7];
        long l16 = 2L * (lArray[0] * lArray[15] + lArray[1] * lArray[14] + lArray[2] * lArray[13] + lArray[3] * lArray[12] + lArray[4] * lArray[11] + lArray[5] * lArray[10] + lArray[6] * lArray[9] + lArray[7] * lArray[8]);
        long l17 = 2L * (lArray[0] * lArray[16] + lArray[1] * lArray[15] + lArray[2] * lArray[14] + lArray[3] * lArray[13] + lArray[4] * lArray[12] + lArray[5] * lArray[11] + lArray[6] * lArray[10] + lArray[7] * lArray[9]) + lArray[8] * lArray[8];
        long l18 = 2L * (lArray[0] * lArray[17] + lArray[1] * lArray[16] + lArray[2] * lArray[15] + lArray[3] * lArray[14] + lArray[4] * lArray[13] + lArray[5] * lArray[12] + lArray[6] * lArray[11] + lArray[7] * lArray[10] + lArray[8] * lArray[9]);
        long l19 = 2L * (lArray[0] * lArray[18] + lArray[1] * lArray[17] + lArray[2] * lArray[16] + lArray[3] * lArray[15] + lArray[4] * lArray[14] + lArray[5] * lArray[13] + lArray[6] * lArray[12] + lArray[7] * lArray[11] + lArray[8] * lArray[10]) + lArray[9] * lArray[9];
        long l20 = 2L * (lArray[1] * lArray[18] + lArray[2] * lArray[17] + lArray[3] * lArray[16] + lArray[4] * lArray[15] + lArray[5] * lArray[14] + lArray[6] * lArray[13] + lArray[7] * lArray[12] + lArray[8] * lArray[11] + lArray[9] * lArray[10]);
        long l21 = 2L * (lArray[2] * lArray[18] + lArray[3] * lArray[17] + lArray[4] * lArray[16] + lArray[5] * lArray[15] + lArray[6] * lArray[14] + lArray[7] * lArray[13] + lArray[8] * lArray[12] + lArray[9] * lArray[11]) + lArray[10] * lArray[10];
        long l22 = 2L * (lArray[3] * lArray[18] + lArray[4] * lArray[17] + lArray[5] * lArray[16] + lArray[6] * lArray[15] + lArray[7] * lArray[14] + lArray[8] * lArray[13] + lArray[9] * lArray[12] + lArray[10] * lArray[11]);
        long l23 = 2L * (lArray[4] * lArray[18] + lArray[5] * lArray[17] + lArray[6] * lArray[16] + lArray[7] * lArray[15] + lArray[8] * lArray[14] + lArray[9] * lArray[13] + lArray[10] * lArray[12]) + lArray[11] * lArray[11];
        long l24 = 2L * (lArray[5] * lArray[18] + lArray[6] * lArray[17] + lArray[7] * lArray[16] + lArray[8] * lArray[15] + lArray[9] * lArray[14] + lArray[10] * lArray[13] + lArray[11] * lArray[12]);
        long l25 = 2L * (lArray[6] * lArray[18] + lArray[7] * lArray[17] + lArray[8] * lArray[16] + lArray[9] * lArray[15] + lArray[10] * lArray[14] + lArray[11] * lArray[13]) + lArray[12] * lArray[12];
        long l26 = 2L * (lArray[7] * lArray[18] + lArray[8] * lArray[17] + lArray[9] * lArray[16] + lArray[10] * lArray[15] + lArray[11] * lArray[14] + lArray[12] * lArray[13]);
        long l27 = 2L * (lArray[8] * lArray[18] + lArray[9] * lArray[17] + lArray[10] * lArray[16] + lArray[11] * lArray[15] + lArray[12] * lArray[14]) + lArray[13] * lArray[13];
        long l28 = 2L * (lArray[9] * lArray[18] + lArray[10] * lArray[17] + lArray[11] * lArray[16] + lArray[12] * lArray[15] + lArray[13] * lArray[14]);
        long l29 = 2L * (lArray[10] * lArray[18] + lArray[11] * lArray[17] + lArray[12] * lArray[16] + lArray[13] * lArray[15]) + lArray[14] * lArray[14];
        long l30 = 2L * (lArray[11] * lArray[18] + lArray[12] * lArray[17] + lArray[13] * lArray[16] + lArray[14] * lArray[15]);
        long l31 = 2L * (lArray[12] * lArray[18] + lArray[13] * lArray[17] + lArray[14] * lArray[16]) + lArray[15] * lArray[15];
        long l32 = 2L * (lArray[13] * lArray[18] + lArray[14] * lArray[17] + lArray[15] * lArray[16]);
        long l33 = 2L * (lArray[14] * lArray[18] + lArray[15] * lArray[17]) + lArray[16] * lArray[16];
        long l34 = 2L * (lArray[15] * lArray[18] + lArray[16] * lArray[17]);
        long l35 = 2L * (lArray[16] * lArray[18]) + lArray[17] * lArray[17];
        long l36 = 2L * (lArray[17] * lArray[18]);
        long l37 = lArray[18] * lArray[18];
        this.carryReduce(lArray2, l, l2, l3, l4, l5, l6, l7, l8, l9, l10, l11, l12, l13, l14, l15, l16, l17, l18, l19, l20, l21, l22, l23, l24, l25, l26, l27, l28, l29, l30, l31, l32, l33, l34, l35, l36, l37);
    }
}

