/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util.math.intpoly;

import java.math.BigInteger;
import sun.security.util.math.intpoly.IntegerPolynomial;

public class IntegerPolynomialP384
extends IntegerPolynomial {
    private static final int BITS_PER_LIMB = 28;
    private static final int NUM_LIMBS = 14;
    private static final int MAX_ADDS = 2;
    public static final BigInteger MODULUS = IntegerPolynomialP384.evaluateModulus();
    private static final long CARRY_ADD = 0x8000000L;
    private static final int LIMB_MASK = 0xFFFFFFF;

    public IntegerPolynomialP384() {
        super(28, 14, 2, MODULUS);
    }

    private static BigInteger evaluateModulus() {
        BigInteger bigInteger = BigInteger.valueOf(2L).pow(384);
        bigInteger = bigInteger.subtract(BigInteger.valueOf(2L).pow(128));
        bigInteger = bigInteger.subtract(BigInteger.valueOf(2L).pow(96));
        bigInteger = bigInteger.add(BigInteger.valueOf(2L).pow(32));
        bigInteger = bigInteger.subtract(BigInteger.valueOf(1L));
        return bigInteger;
    }

    @Override
    protected void reduceIn(long[] lArray, long l, int n) {
        int n2 = n - 10;
        lArray[n2] = lArray[n2] + (l << 24 & 0xFFFFFFFL);
        int n3 = n - 9;
        lArray[n3] = lArray[n3] + (l >> 4);
        int n4 = n - 11;
        lArray[n4] = lArray[n4] + (l << 20 & 0xFFFFFFFL);
        int n5 = n - 10;
        lArray[n5] = lArray[n5] + (l >> 8);
        int n6 = n - 13;
        lArray[n6] = lArray[n6] - (l << 12 & 0xFFFFFFFL);
        int n7 = n - 12;
        lArray[n7] = lArray[n7] - (l >> 16);
        int n8 = n - 14;
        lArray[n8] = lArray[n8] + (l << 8 & 0xFFFFFFFL);
        int n9 = n - 13;
        lArray[n9] = lArray[n9] + (l >> 20);
    }

    @Override
    protected void finalCarryReduceLast(long[] lArray) {
        long l = lArray[13] >> 20;
        lArray[13] = lArray[13] - (l << 20);
        lArray[4] = lArray[4] + (l << 16 & 0xFFFFFFFL);
        lArray[5] = lArray[5] + (l >> 12);
        lArray[3] = lArray[3] + (l << 12 & 0xFFFFFFFL);
        lArray[4] = lArray[4] + (l >> 16);
        lArray[1] = lArray[1] - (l << 4 & 0xFFFFFFFL);
        lArray[2] = lArray[2] - (l >> 24);
        lArray[0] = lArray[0] + l;
    }

    private void carryReduce(long[] lArray, long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8, long l9, long l10, long l11, long l12, long l13, long l14, long l15, long l16, long l17, long l18, long l19, long l20, long l21, long l22, long l23, long l24, long l25, long l26, long l27) {
        long l28 = 0L;
        l17 += l27 << 24 & 0xFFFFFFFL;
        l18 += l27 >> 4;
        l16 += l27 << 20 & 0xFFFFFFFL;
        l17 += l27 >> 8;
        l14 -= l27 << 12 & 0xFFFFFFFL;
        l15 -= l27 >> 16;
        l13 += l27 << 8 & 0xFFFFFFFL;
        l14 += l27 >> 20;
        l16 += l26 << 24 & 0xFFFFFFFL;
        l17 += l26 >> 4;
        l15 += l26 << 20 & 0xFFFFFFFL;
        l16 += l26 >> 8;
        l13 -= l26 << 12 & 0xFFFFFFFL;
        l14 -= l26 >> 16;
        l12 += l26 << 8 & 0xFFFFFFFL;
        l13 += l26 >> 20;
        l15 += l25 << 24 & 0xFFFFFFFL;
        l16 += l25 >> 4;
        l14 += l25 << 20 & 0xFFFFFFFL;
        l15 += l25 >> 8;
        l12 -= l25 << 12 & 0xFFFFFFFL;
        l13 -= l25 >> 16;
        l11 += l25 << 8 & 0xFFFFFFFL;
        l12 += l25 >> 20;
        l14 += l24 << 24 & 0xFFFFFFFL;
        l15 += l24 >> 4;
        l13 += l24 << 20 & 0xFFFFFFFL;
        l14 += l24 >> 8;
        l11 -= l24 << 12 & 0xFFFFFFFL;
        l12 -= l24 >> 16;
        l10 += l24 << 8 & 0xFFFFFFFL;
        l11 += l24 >> 20;
        l13 += l23 << 24 & 0xFFFFFFFL;
        l14 += l23 >> 4;
        l12 += l23 << 20 & 0xFFFFFFFL;
        l13 += l23 >> 8;
        l10 -= l23 << 12 & 0xFFFFFFFL;
        l11 -= l23 >> 16;
        l9 += l23 << 8 & 0xFFFFFFFL;
        l10 += l23 >> 20;
        l12 += l22 << 24 & 0xFFFFFFFL;
        l13 += l22 >> 4;
        l11 += l22 << 20 & 0xFFFFFFFL;
        l12 += l22 >> 8;
        l9 -= l22 << 12 & 0xFFFFFFFL;
        l10 -= l22 >> 16;
        l8 += l22 << 8 & 0xFFFFFFFL;
        l9 += l22 >> 20;
        l11 += l21 << 24 & 0xFFFFFFFL;
        l12 += l21 >> 4;
        l10 += l21 << 20 & 0xFFFFFFFL;
        l11 += l21 >> 8;
        l8 -= l21 << 12 & 0xFFFFFFFL;
        l9 -= l21 >> 16;
        l7 += l21 << 8 & 0xFFFFFFFL;
        l8 += l21 >> 20;
        l10 += l20 << 24 & 0xFFFFFFFL;
        l11 += l20 >> 4;
        l9 += l20 << 20 & 0xFFFFFFFL;
        l10 += l20 >> 8;
        l7 -= l20 << 12 & 0xFFFFFFFL;
        l8 -= l20 >> 16;
        l6 += l20 << 8 & 0xFFFFFFFL;
        l7 += l20 >> 20;
        l9 += l19 << 24 & 0xFFFFFFFL;
        l10 += l19 >> 4;
        l8 += l19 << 20 & 0xFFFFFFFL;
        l9 += l19 >> 8;
        l6 -= l19 << 12 & 0xFFFFFFFL;
        l7 -= l19 >> 16;
        l5 += l19 << 8 & 0xFFFFFFFL;
        l6 += l19 >> 20;
        l8 += l18 << 24 & 0xFFFFFFFL;
        l9 += l18 >> 4;
        l7 += l18 << 20 & 0xFFFFFFFL;
        l8 += l18 >> 8;
        l5 -= l18 << 12 & 0xFFFFFFFL;
        l6 -= l18 >> 16;
        l4 += l18 << 8 & 0xFFFFFFFL;
        l5 += l18 >> 20;
        l7 += l17 << 24 & 0xFFFFFFFL;
        l8 += l17 >> 4;
        l6 += l17 << 20 & 0xFFFFFFFL;
        l7 += l17 >> 8;
        l4 -= l17 << 12 & 0xFFFFFFFL;
        l5 -= l17 >> 16;
        l3 += l17 << 8 & 0xFFFFFFFL;
        l4 += l17 >> 20;
        l6 += l16 << 24 & 0xFFFFFFFL;
        l7 += l16 >> 4;
        l5 += l16 << 20 & 0xFFFFFFFL;
        l6 += l16 >> 8;
        l3 -= l16 << 12 & 0xFFFFFFFL;
        l4 -= l16 >> 16;
        l2 += l16 << 8 & 0xFFFFFFFL;
        l3 += l16 >> 20;
        l5 += l15 << 24 & 0xFFFFFFFL;
        l6 += l15 >> 4;
        l4 += l15 << 20 & 0xFFFFFFFL;
        l5 += l15 >> 8;
        l2 -= l15 << 12 & 0xFFFFFFFL;
        l3 -= l15 >> 16;
        l += l15 << 8 & 0xFFFFFFFL;
        l2 += l15 >> 20;
        l15 = 0L;
        this.carryReduce0(lArray, l, l2, l3, l4, l5, l6, l7, l8, l9, l10, l11, l12, l13, l14, l15, l16, l17, l18, l19, l20, l21, l22, l23, l24, l25, l26, l27, l28);
    }

    void carryReduce0(long[] lArray, long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8, long l9, long l10, long l11, long l12, long l13, long l14, long l15, long l16, long l17, long l18, long l19, long l20, long l21, long l22, long l23, long l24, long l25, long l26, long l27, long l28) {
        long l29 = l13 + 0x8000000L >> 28;
        l13 -= l29 << 28;
        l14 += l29;
        l29 = l14 + 0x8000000L >> 28;
        l14 -= l29 << 28;
        l5 += (l15 += l29) << 24 & 0xFFFFFFFL;
        l6 += l15 >> 4;
        l4 += l15 << 20 & 0xFFFFFFFL;
        l5 += l15 >> 8;
        l2 -= l15 << 12 & 0xFFFFFFFL;
        l3 -= l15 >> 16;
        l2 += l15 >> 20;
        l29 = (l += l15 << 8 & 0xFFFFFFFL) + 0x8000000L >> 28;
        l -= l29 << 28;
        l2 += l29;
        l29 = l2 + 0x8000000L >> 28;
        l2 -= l29 << 28;
        l3 += l29;
        l29 = l3 + 0x8000000L >> 28;
        l3 -= l29 << 28;
        l4 += l29;
        l29 = l4 + 0x8000000L >> 28;
        l4 -= l29 << 28;
        l5 += l29;
        l29 = l5 + 0x8000000L >> 28;
        l5 -= l29 << 28;
        l6 += l29;
        l29 = l6 + 0x8000000L >> 28;
        l6 -= l29 << 28;
        l7 += l29;
        l29 = l7 + 0x8000000L >> 28;
        l7 -= l29 << 28;
        l8 += l29;
        l29 = l8 + 0x8000000L >> 28;
        l8 -= l29 << 28;
        l9 += l29;
        l29 = l9 + 0x8000000L >> 28;
        l9 -= l29 << 28;
        l10 += l29;
        l29 = l10 + 0x8000000L >> 28;
        l10 -= l29 << 28;
        l11 += l29;
        l29 = l11 + 0x8000000L >> 28;
        l11 -= l29 << 28;
        l12 += l29;
        l29 = l12 + 0x8000000L >> 28;
        l12 -= l29 << 28;
        l13 += l29;
        l29 = l13 + 0x8000000L >> 28;
        l13 -= l29 << 28;
        l14 += l29;
        lArray[0] = l;
        lArray[1] = l2;
        lArray[2] = l3;
        lArray[3] = l4;
        lArray[4] = l5;
        lArray[5] = l6;
        lArray[6] = l7;
        lArray[7] = l8;
        lArray[8] = l9;
        lArray[9] = l10;
        lArray[10] = l11;
        lArray[11] = l12;
        lArray[12] = l13;
        lArray[13] = l14;
    }

    private void carryReduce(long[] lArray, long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8, long l9, long l10, long l11, long l12, long l13, long l14) {
        long l15 = 0L;
        long l16 = l13 + 0x8000000L >> 28;
        l13 -= l16 << 28;
        l14 += l16;
        l16 = l14 + 0x8000000L >> 28;
        l14 -= l16 << 28;
        l5 += (l15 += l16) << 24 & 0xFFFFFFFL;
        l6 += l15 >> 4;
        l4 += l15 << 20 & 0xFFFFFFFL;
        l5 += l15 >> 8;
        l2 -= l15 << 12 & 0xFFFFFFFL;
        l3 -= l15 >> 16;
        l2 += l15 >> 20;
        l16 = (l += l15 << 8 & 0xFFFFFFFL) + 0x8000000L >> 28;
        l -= l16 << 28;
        l2 += l16;
        l16 = l2 + 0x8000000L >> 28;
        l2 -= l16 << 28;
        l3 += l16;
        l16 = l3 + 0x8000000L >> 28;
        l3 -= l16 << 28;
        l4 += l16;
        l16 = l4 + 0x8000000L >> 28;
        l4 -= l16 << 28;
        l5 += l16;
        l16 = l5 + 0x8000000L >> 28;
        l5 -= l16 << 28;
        l6 += l16;
        l16 = l6 + 0x8000000L >> 28;
        l6 -= l16 << 28;
        l7 += l16;
        l16 = l7 + 0x8000000L >> 28;
        l7 -= l16 << 28;
        l8 += l16;
        l16 = l8 + 0x8000000L >> 28;
        l8 -= l16 << 28;
        l9 += l16;
        l16 = l9 + 0x8000000L >> 28;
        l9 -= l16 << 28;
        l10 += l16;
        l16 = l10 + 0x8000000L >> 28;
        l10 -= l16 << 28;
        l11 += l16;
        l16 = l11 + 0x8000000L >> 28;
        l11 -= l16 << 28;
        l12 += l16;
        l16 = l12 + 0x8000000L >> 28;
        l12 -= l16 << 28;
        l13 += l16;
        l16 = l13 + 0x8000000L >> 28;
        l13 -= l16 << 28;
        l14 += l16;
        lArray[0] = l;
        lArray[1] = l2;
        lArray[2] = l3;
        lArray[3] = l4;
        lArray[4] = l5;
        lArray[5] = l6;
        lArray[6] = l7;
        lArray[7] = l8;
        lArray[8] = l9;
        lArray[9] = l10;
        lArray[10] = l11;
        lArray[11] = l12;
        lArray[12] = l13;
        lArray[13] = l14;
    }

    @Override
    protected void mult(long[] lArray, long[] lArray2, long[] lArray3) {
        long l = lArray[0] * lArray2[0];
        long l2 = lArray[0] * lArray2[1] + lArray[1] * lArray2[0];
        long l3 = lArray[0] * lArray2[2] + lArray[1] * lArray2[1] + lArray[2] * lArray2[0];
        long l4 = lArray[0] * lArray2[3] + lArray[1] * lArray2[2] + lArray[2] * lArray2[1] + lArray[3] * lArray2[0];
        long l5 = lArray[0] * lArray2[4] + lArray[1] * lArray2[3] + lArray[2] * lArray2[2] + lArray[3] * lArray2[1] + lArray[4] * lArray2[0];
        long l6 = lArray[0] * lArray2[5] + lArray[1] * lArray2[4] + lArray[2] * lArray2[3] + lArray[3] * lArray2[2] + lArray[4] * lArray2[1] + lArray[5] * lArray2[0];
        long l7 = lArray[0] * lArray2[6] + lArray[1] * lArray2[5] + lArray[2] * lArray2[4] + lArray[3] * lArray2[3] + lArray[4] * lArray2[2] + lArray[5] * lArray2[1] + lArray[6] * lArray2[0];
        long l8 = lArray[0] * lArray2[7] + lArray[1] * lArray2[6] + lArray[2] * lArray2[5] + lArray[3] * lArray2[4] + lArray[4] * lArray2[3] + lArray[5] * lArray2[2] + lArray[6] * lArray2[1] + lArray[7] * lArray2[0];
        long l9 = lArray[0] * lArray2[8] + lArray[1] * lArray2[7] + lArray[2] * lArray2[6] + lArray[3] * lArray2[5] + lArray[4] * lArray2[4] + lArray[5] * lArray2[3] + lArray[6] * lArray2[2] + lArray[7] * lArray2[1] + lArray[8] * lArray2[0];
        long l10 = lArray[0] * lArray2[9] + lArray[1] * lArray2[8] + lArray[2] * lArray2[7] + lArray[3] * lArray2[6] + lArray[4] * lArray2[5] + lArray[5] * lArray2[4] + lArray[6] * lArray2[3] + lArray[7] * lArray2[2] + lArray[8] * lArray2[1] + lArray[9] * lArray2[0];
        long l11 = lArray[0] * lArray2[10] + lArray[1] * lArray2[9] + lArray[2] * lArray2[8] + lArray[3] * lArray2[7] + lArray[4] * lArray2[6] + lArray[5] * lArray2[5] + lArray[6] * lArray2[4] + lArray[7] * lArray2[3] + lArray[8] * lArray2[2] + lArray[9] * lArray2[1] + lArray[10] * lArray2[0];
        long l12 = lArray[0] * lArray2[11] + lArray[1] * lArray2[10] + lArray[2] * lArray2[9] + lArray[3] * lArray2[8] + lArray[4] * lArray2[7] + lArray[5] * lArray2[6] + lArray[6] * lArray2[5] + lArray[7] * lArray2[4] + lArray[8] * lArray2[3] + lArray[9] * lArray2[2] + lArray[10] * lArray2[1] + lArray[11] * lArray2[0];
        long l13 = lArray[0] * lArray2[12] + lArray[1] * lArray2[11] + lArray[2] * lArray2[10] + lArray[3] * lArray2[9] + lArray[4] * lArray2[8] + lArray[5] * lArray2[7] + lArray[6] * lArray2[6] + lArray[7] * lArray2[5] + lArray[8] * lArray2[4] + lArray[9] * lArray2[3] + lArray[10] * lArray2[2] + lArray[11] * lArray2[1] + lArray[12] * lArray2[0];
        long l14 = lArray[0] * lArray2[13] + lArray[1] * lArray2[12] + lArray[2] * lArray2[11] + lArray[3] * lArray2[10] + lArray[4] * lArray2[9] + lArray[5] * lArray2[8] + lArray[6] * lArray2[7] + lArray[7] * lArray2[6] + lArray[8] * lArray2[5] + lArray[9] * lArray2[4] + lArray[10] * lArray2[3] + lArray[11] * lArray2[2] + lArray[12] * lArray2[1] + lArray[13] * lArray2[0];
        long l15 = lArray[1] * lArray2[13] + lArray[2] * lArray2[12] + lArray[3] * lArray2[11] + lArray[4] * lArray2[10] + lArray[5] * lArray2[9] + lArray[6] * lArray2[8] + lArray[7] * lArray2[7] + lArray[8] * lArray2[6] + lArray[9] * lArray2[5] + lArray[10] * lArray2[4] + lArray[11] * lArray2[3] + lArray[12] * lArray2[2] + lArray[13] * lArray2[1];
        long l16 = lArray[2] * lArray2[13] + lArray[3] * lArray2[12] + lArray[4] * lArray2[11] + lArray[5] * lArray2[10] + lArray[6] * lArray2[9] + lArray[7] * lArray2[8] + lArray[8] * lArray2[7] + lArray[9] * lArray2[6] + lArray[10] * lArray2[5] + lArray[11] * lArray2[4] + lArray[12] * lArray2[3] + lArray[13] * lArray2[2];
        long l17 = lArray[3] * lArray2[13] + lArray[4] * lArray2[12] + lArray[5] * lArray2[11] + lArray[6] * lArray2[10] + lArray[7] * lArray2[9] + lArray[8] * lArray2[8] + lArray[9] * lArray2[7] + lArray[10] * lArray2[6] + lArray[11] * lArray2[5] + lArray[12] * lArray2[4] + lArray[13] * lArray2[3];
        long l18 = lArray[4] * lArray2[13] + lArray[5] * lArray2[12] + lArray[6] * lArray2[11] + lArray[7] * lArray2[10] + lArray[8] * lArray2[9] + lArray[9] * lArray2[8] + lArray[10] * lArray2[7] + lArray[11] * lArray2[6] + lArray[12] * lArray2[5] + lArray[13] * lArray2[4];
        long l19 = lArray[5] * lArray2[13] + lArray[6] * lArray2[12] + lArray[7] * lArray2[11] + lArray[8] * lArray2[10] + lArray[9] * lArray2[9] + lArray[10] * lArray2[8] + lArray[11] * lArray2[7] + lArray[12] * lArray2[6] + lArray[13] * lArray2[5];
        long l20 = lArray[6] * lArray2[13] + lArray[7] * lArray2[12] + lArray[8] * lArray2[11] + lArray[9] * lArray2[10] + lArray[10] * lArray2[9] + lArray[11] * lArray2[8] + lArray[12] * lArray2[7] + lArray[13] * lArray2[6];
        long l21 = lArray[7] * lArray2[13] + lArray[8] * lArray2[12] + lArray[9] * lArray2[11] + lArray[10] * lArray2[10] + lArray[11] * lArray2[9] + lArray[12] * lArray2[8] + lArray[13] * lArray2[7];
        long l22 = lArray[8] * lArray2[13] + lArray[9] * lArray2[12] + lArray[10] * lArray2[11] + lArray[11] * lArray2[10] + lArray[12] * lArray2[9] + lArray[13] * lArray2[8];
        long l23 = lArray[9] * lArray2[13] + lArray[10] * lArray2[12] + lArray[11] * lArray2[11] + lArray[12] * lArray2[10] + lArray[13] * lArray2[9];
        long l24 = lArray[10] * lArray2[13] + lArray[11] * lArray2[12] + lArray[12] * lArray2[11] + lArray[13] * lArray2[10];
        long l25 = lArray[11] * lArray2[13] + lArray[12] * lArray2[12] + lArray[13] * lArray2[11];
        long l26 = lArray[12] * lArray2[13] + lArray[13] * lArray2[12];
        long l27 = lArray[13] * lArray2[13];
        this.carryReduce(lArray3, l, l2, l3, l4, l5, l6, l7, l8, l9, l10, l11, l12, l13, l14, l15, l16, l17, l18, l19, l20, l21, l22, l23, l24, l25, l26, l27);
    }

    @Override
    protected void reduce(long[] lArray) {
        this.carryReduce(lArray, lArray[0], lArray[1], lArray[2], lArray[3], lArray[4], lArray[5], lArray[6], lArray[7], lArray[8], lArray[9], lArray[10], lArray[11], lArray[12], lArray[13]);
    }

    @Override
    protected void square(long[] lArray, long[] lArray2) {
        long l = lArray[0] * lArray[0];
        long l2 = 2L * (lArray[0] * lArray[1]);
        long l3 = 2L * (lArray[0] * lArray[2]) + lArray[1] * lArray[1];
        long l4 = 2L * (lArray[0] * lArray[3] + lArray[1] * lArray[2]);
        long l5 = 2L * (lArray[0] * lArray[4] + lArray[1] * lArray[3]) + lArray[2] * lArray[2];
        long l6 = 2L * (lArray[0] * lArray[5] + lArray[1] * lArray[4] + lArray[2] * lArray[3]);
        long l7 = 2L * (lArray[0] * lArray[6] + lArray[1] * lArray[5] + lArray[2] * lArray[4]) + lArray[3] * lArray[3];
        long l8 = 2L * (lArray[0] * lArray[7] + lArray[1] * lArray[6] + lArray[2] * lArray[5] + lArray[3] * lArray[4]);
        long l9 = 2L * (lArray[0] * lArray[8] + lArray[1] * lArray[7] + lArray[2] * lArray[6] + lArray[3] * lArray[5]) + lArray[4] * lArray[4];
        long l10 = 2L * (lArray[0] * lArray[9] + lArray[1] * lArray[8] + lArray[2] * lArray[7] + lArray[3] * lArray[6] + lArray[4] * lArray[5]);
        long l11 = 2L * (lArray[0] * lArray[10] + lArray[1] * lArray[9] + lArray[2] * lArray[8] + lArray[3] * lArray[7] + lArray[4] * lArray[6]) + lArray[5] * lArray[5];
        long l12 = 2L * (lArray[0] * lArray[11] + lArray[1] * lArray[10] + lArray[2] * lArray[9] + lArray[3] * lArray[8] + lArray[4] * lArray[7] + lArray[5] * lArray[6]);
        long l13 = 2L * (lArray[0] * lArray[12] + lArray[1] * lArray[11] + lArray[2] * lArray[10] + lArray[3] * lArray[9] + lArray[4] * lArray[8] + lArray[5] * lArray[7]) + lArray[6] * lArray[6];
        long l14 = 2L * (lArray[0] * lArray[13] + lArray[1] * lArray[12] + lArray[2] * lArray[11] + lArray[3] * lArray[10] + lArray[4] * lArray[9] + lArray[5] * lArray[8] + lArray[6] * lArray[7]);
        long l15 = 2L * (lArray[1] * lArray[13] + lArray[2] * lArray[12] + lArray[3] * lArray[11] + lArray[4] * lArray[10] + lArray[5] * lArray[9] + lArray[6] * lArray[8]) + lArray[7] * lArray[7];
        long l16 = 2L * (lArray[2] * lArray[13] + lArray[3] * lArray[12] + lArray[4] * lArray[11] + lArray[5] * lArray[10] + lArray[6] * lArray[9] + lArray[7] * lArray[8]);
        long l17 = 2L * (lArray[3] * lArray[13] + lArray[4] * lArray[12] + lArray[5] * lArray[11] + lArray[6] * lArray[10] + lArray[7] * lArray[9]) + lArray[8] * lArray[8];
        long l18 = 2L * (lArray[4] * lArray[13] + lArray[5] * lArray[12] + lArray[6] * lArray[11] + lArray[7] * lArray[10] + lArray[8] * lArray[9]);
        long l19 = 2L * (lArray[5] * lArray[13] + lArray[6] * lArray[12] + lArray[7] * lArray[11] + lArray[8] * lArray[10]) + lArray[9] * lArray[9];
        long l20 = 2L * (lArray[6] * lArray[13] + lArray[7] * lArray[12] + lArray[8] * lArray[11] + lArray[9] * lArray[10]);
        long l21 = 2L * (lArray[7] * lArray[13] + lArray[8] * lArray[12] + lArray[9] * lArray[11]) + lArray[10] * lArray[10];
        long l22 = 2L * (lArray[8] * lArray[13] + lArray[9] * lArray[12] + lArray[10] * lArray[11]);
        long l23 = 2L * (lArray[9] * lArray[13] + lArray[10] * lArray[12]) + lArray[11] * lArray[11];
        long l24 = 2L * (lArray[10] * lArray[13] + lArray[11] * lArray[12]);
        long l25 = 2L * (lArray[11] * lArray[13]) + lArray[12] * lArray[12];
        long l26 = 2L * (lArray[12] * lArray[13]);
        long l27 = lArray[13] * lArray[13];
        this.carryReduce(lArray2, l, l2, l3, l4, l5, l6, l7, l8, l9, l10, l11, l12, l13, l14, l15, l16, l17, l18, l19, l20, l21, l22, l23, l24, l25, l26, l27);
    }
}

