/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util.math.intpoly;

import java.math.BigInteger;
import sun.security.util.math.intpoly.IntegerPolynomial;

public class IntegerPolynomial25519
extends IntegerPolynomial {
    private static final int POWER = 255;
    private static final int SUBTRAHEND = 19;
    private static final int NUM_LIMBS = 10;
    private static final int BITS_PER_LIMB = 26;
    public static final BigInteger MODULUS = TWO.pow(255).subtract(BigInteger.valueOf(19L));
    private static final int BIT_OFFSET = 5;
    private static final int LIMB_MASK = 0x3FFFFFF;
    private static final int RIGHT_BIT_OFFSET = 21;

    public IntegerPolynomial25519() {
        super(26, 10, 1, MODULUS);
    }

    @Override
    protected void reduceIn(long[] lArray, long l, int n) {
        long l2 = 19L * l;
        int n2 = n - 10;
        lArray[n2] = lArray[n2] + (l2 << 5 & 0x3FFFFFFL);
        int n3 = n - 9;
        lArray[n3] = lArray[n3] + (l2 >> 21);
    }

    @Override
    protected void finalCarryReduceLast(long[] lArray) {
        long l = lArray[this.numLimbs - 1] >> 21;
        int n = this.numLimbs - 1;
        lArray[n] = lArray[n] - (l << 21);
        lArray[0] = lArray[0] + l * 19L;
    }

    @Override
    protected void reduce(long[] lArray) {
        long l = this.carryValue(lArray[8]);
        lArray[8] = lArray[8] - (l << 26);
        lArray[9] = lArray[9] + l;
        long l2 = this.carryValue(lArray[9]);
        lArray[9] = lArray[9] - (l2 << 26);
        long l3 = l2 * 19L;
        lArray[0] = lArray[0] + (l3 << 5 & 0x3FFFFFFL);
        lArray[1] = lArray[1] + (l3 >> 21);
        this.carry(lArray, 0, 9);
    }

    @Override
    protected void mult(long[] lArray, long[] lArray2, long[] lArray3) {
        long l = lArray[0] * lArray2[0];
        long l2 = lArray[0] * lArray2[1] + lArray[1] * lArray2[0];
        long l3 = lArray[0] * lArray2[2] + lArray[1] * lArray2[1] + lArray[2] * lArray2[0];
        long l4 = lArray[0] * lArray2[3] + lArray[1] * lArray2[2] + lArray[2] * lArray2[1] + lArray[3] * lArray2[0];
        long l5 = lArray[0] * lArray2[4] + lArray[1] * lArray2[3] + lArray[2] * lArray2[2] + lArray[3] * lArray2[1] + lArray[4] * lArray2[0];
        long l6 = lArray[0] * lArray2[5] + lArray[1] * lArray2[4] + lArray[2] * lArray2[3] + lArray[3] * lArray2[2] + lArray[4] * lArray2[1] + lArray[5] * lArray2[0];
        long l7 = lArray[0] * lArray2[6] + lArray[1] * lArray2[5] + lArray[2] * lArray2[4] + lArray[3] * lArray2[3] + lArray[4] * lArray2[2] + lArray[5] * lArray2[1] + lArray[6] * lArray2[0];
        long l8 = lArray[0] * lArray2[7] + lArray[1] * lArray2[6] + lArray[2] * lArray2[5] + lArray[3] * lArray2[4] + lArray[4] * lArray2[3] + lArray[5] * lArray2[2] + lArray[6] * lArray2[1] + lArray[7] * lArray2[0];
        long l9 = lArray[0] * lArray2[8] + lArray[1] * lArray2[7] + lArray[2] * lArray2[6] + lArray[3] * lArray2[5] + lArray[4] * lArray2[4] + lArray[5] * lArray2[3] + lArray[6] * lArray2[2] + lArray[7] * lArray2[1] + lArray[8] * lArray2[0];
        long l10 = lArray[0] * lArray2[9] + lArray[1] * lArray2[8] + lArray[2] * lArray2[7] + lArray[3] * lArray2[6] + lArray[4] * lArray2[5] + lArray[5] * lArray2[4] + lArray[6] * lArray2[3] + lArray[7] * lArray2[2] + lArray[8] * lArray2[1] + lArray[9] * lArray2[0];
        long l11 = lArray[1] * lArray2[9] + lArray[2] * lArray2[8] + lArray[3] * lArray2[7] + lArray[4] * lArray2[6] + lArray[5] * lArray2[5] + lArray[6] * lArray2[4] + lArray[7] * lArray2[3] + lArray[8] * lArray2[2] + lArray[9] * lArray2[1];
        long l12 = lArray[2] * lArray2[9] + lArray[3] * lArray2[8] + lArray[4] * lArray2[7] + lArray[5] * lArray2[6] + lArray[6] * lArray2[5] + lArray[7] * lArray2[4] + lArray[8] * lArray2[3] + lArray[9] * lArray2[2];
        long l13 = lArray[3] * lArray2[9] + lArray[4] * lArray2[8] + lArray[5] * lArray2[7] + lArray[6] * lArray2[6] + lArray[7] * lArray2[5] + lArray[8] * lArray2[4] + lArray[9] * lArray2[3];
        long l14 = lArray[4] * lArray2[9] + lArray[5] * lArray2[8] + lArray[6] * lArray2[7] + lArray[7] * lArray2[6] + lArray[8] * lArray2[5] + lArray[9] * lArray2[4];
        long l15 = lArray[5] * lArray2[9] + lArray[6] * lArray2[8] + lArray[7] * lArray2[7] + lArray[8] * lArray2[6] + lArray[9] * lArray2[5];
        long l16 = lArray[6] * lArray2[9] + lArray[7] * lArray2[8] + lArray[8] * lArray2[7] + lArray[9] * lArray2[6];
        long l17 = lArray[7] * lArray2[9] + lArray[8] * lArray2[8] + lArray[9] * lArray2[7];
        long l18 = lArray[8] * lArray2[9] + lArray[9] * lArray2[8];
        long l19 = lArray[9] * lArray2[9];
        this.carryReduce(lArray3, l, l2, l3, l4, l5, l6, l7, l8, l9, l10, l11, l12, l13, l14, l15, l16, l17, l18, l19);
    }

    private void carryReduce(long[] lArray, long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8, long l9, long l10, long l11, long l12, long l13, long l14, long l15, long l16, long l17, long l18, long l19) {
        long l20 = l18 * 19L;
        l8 += l20 << 5 & 0x3FFFFFFL;
        l9 += l20 >> 21;
        long l21 = l19 * 19L;
        l10 += l21 >> 21;
        long l22 = this.carryValue(l9 += l21 << 5 & 0x3FFFFFFL);
        lArray[8] = l9 - (l22 << 26);
        long l23 = this.carryValue(l10 += l22);
        lArray[9] = l10 - (l23 << 26);
        long l24 = (l11 += l23) * 19L;
        lArray[0] = l + (l24 << 5 & 0x3FFFFFFL);
        long l25 = l12 * 19L;
        lArray[1] = (l2 += l24 >> 21) + (l25 << 5 & 0x3FFFFFFL);
        long l26 = l13 * 19L;
        lArray[2] = (l3 += l25 >> 21) + (l26 << 5 & 0x3FFFFFFL);
        long l27 = l14 * 19L;
        lArray[3] = (l4 += l26 >> 21) + (l27 << 5 & 0x3FFFFFFL);
        long l28 = l15 * 19L;
        lArray[4] = (l5 += l27 >> 21) + (l28 << 5 & 0x3FFFFFFL);
        long l29 = l16 * 19L;
        lArray[5] = (l6 += l28 >> 21) + (l29 << 5 & 0x3FFFFFFL);
        long l30 = l17 * 19L;
        lArray[6] = (l7 += l29 >> 21) + (l30 << 5 & 0x3FFFFFFL);
        lArray[7] = l8 + (l30 >> 21);
        this.carry(lArray, 0, 9);
    }

    @Override
    protected void square(long[] lArray, long[] lArray2) {
        long l = lArray[0] * lArray[0];
        long l2 = 2L * lArray[0] * lArray[1];
        long l3 = lArray[1] * lArray[1] + 2L * lArray[0] * lArray[2];
        long l4 = 2L * (lArray[0] * lArray[3] + lArray[1] * lArray[2]);
        long l5 = lArray[2] * lArray[2] + 2L * (lArray[0] * lArray[4] + lArray[1] * lArray[3]);
        long l6 = 2L * (lArray[0] * lArray[5] + lArray[1] * lArray[4] + lArray[2] * lArray[3]);
        long l7 = lArray[3] * lArray[3] + 2L * (lArray[0] * lArray[6] + lArray[1] * lArray[5] + lArray[2] * lArray[4]);
        long l8 = 2L * (lArray[0] * lArray[7] + lArray[1] * lArray[6] + lArray[2] * lArray[5] + lArray[3] * lArray[4]);
        long l9 = lArray[4] * lArray[4] + 2L * (lArray[0] * lArray[8] + lArray[1] * lArray[7] + lArray[2] * lArray[6] + lArray[3] * lArray[5]);
        long l10 = 2L * (lArray[0] * lArray[9] + lArray[1] * lArray[8] + lArray[2] * lArray[7] + lArray[3] * lArray[6] + lArray[4] * lArray[5]);
        long l11 = lArray[5] * lArray[5] + 2L * (lArray[1] * lArray[9] + lArray[2] * lArray[8] + lArray[3] * lArray[7] + lArray[4] * lArray[6]);
        long l12 = 2L * (lArray[2] * lArray[9] + lArray[3] * lArray[8] + lArray[4] * lArray[7] + lArray[5] * lArray[6]);
        long l13 = lArray[6] * lArray[6] + 2L * (lArray[3] * lArray[9] + lArray[4] * lArray[8] + lArray[5] * lArray[7]);
        long l14 = 2L * (lArray[4] * lArray[9] + lArray[5] * lArray[8] + lArray[6] * lArray[7]);
        long l15 = lArray[7] * lArray[7] + 2L * (lArray[5] * lArray[9] + lArray[6] * lArray[8]);
        long l16 = 2L * (lArray[6] * lArray[9] + lArray[7] * lArray[8]);
        long l17 = lArray[8] * lArray[8] + 2L * lArray[7] * lArray[9];
        long l18 = 2L * lArray[8] * lArray[9];
        long l19 = lArray[9] * lArray[9];
        this.carryReduce(lArray2, l, l2, l3, l4, l5, l6, l7, l8, l9, l10, l11, l12, l13, l14, l15, l16, l17, l18, l19);
    }
}

