/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util.math.intpoly;

import java.math.BigInteger;
import sun.security.util.math.intpoly.IntegerPolynomial;

public class Curve448OrderField
extends IntegerPolynomial {
    private static final int BITS_PER_LIMB = 28;
    private static final int NUM_LIMBS = 16;
    private static final int MAX_ADDS = 1;
    public static final BigInteger MODULUS = Curve448OrderField.evaluateModulus();
    private static final long CARRY_ADD = 0x8000000L;
    private static final int LIMB_MASK = 0xFFFFFFF;

    public Curve448OrderField() {
        super(28, 16, 1, MODULUS);
    }

    private static BigInteger evaluateModulus() {
        BigInteger bigInteger = BigInteger.valueOf(2L).pow(446);
        bigInteger = bigInteger.subtract(BigInteger.valueOf(78101261L));
        bigInteger = bigInteger.add(BigInteger.valueOf(2L).pow(28).multiply(BigInteger.valueOf(126626091L)));
        bigInteger = bigInteger.add(BigInteger.valueOf(2L).pow(56).multiply(BigInteger.valueOf(93279523L)));
        bigInteger = bigInteger.subtract(BigInteger.valueOf(2L).pow(84).multiply(BigInteger.valueOf(64542500L)));
        bigInteger = bigInteger.add(BigInteger.valueOf(2L).pow(112).multiply(BigInteger.valueOf(110109037L)));
        bigInteger = bigInteger.add(BigInteger.valueOf(2L).pow(140).multiply(BigInteger.valueOf(77262179L)));
        bigInteger = bigInteger.subtract(BigInteger.valueOf(2L).pow(168).multiply(BigInteger.valueOf(104575269L)));
        bigInteger = bigInteger.add(BigInteger.valueOf(2L).pow(196).multiply(BigInteger.valueOf(130851391L)));
        bigInteger = bigInteger.subtract(BigInteger.valueOf(2L).pow(224));
        return bigInteger;
    }

    @Override
    protected void reduceIn(long[] lArray, long l, int n) {
        long l2 = 78101261L * l;
        int n2 = n - 16;
        lArray[n2] = lArray[n2] + (l2 << 2 & 0xFFFFFFFL);
        int n3 = n - 15;
        lArray[n3] = lArray[n3] + (l2 >> 26);
        long l3 = -126626091L * l;
        int n4 = n - 15;
        lArray[n4] = lArray[n4] + (l3 << 2 & 0xFFFFFFFL);
        int n5 = n - 14;
        lArray[n5] = lArray[n5] + (l3 >> 26);
        long l4 = -93279523L * l;
        int n6 = n - 14;
        lArray[n6] = lArray[n6] + (l4 << 2 & 0xFFFFFFFL);
        int n7 = n - 13;
        lArray[n7] = lArray[n7] + (l4 >> 26);
        long l5 = 64542500L * l;
        int n8 = n - 13;
        lArray[n8] = lArray[n8] + (l5 << 2 & 0xFFFFFFFL);
        int n9 = n - 12;
        lArray[n9] = lArray[n9] + (l5 >> 26);
        long l6 = -110109037L * l;
        int n10 = n - 12;
        lArray[n10] = lArray[n10] + (l6 << 2 & 0xFFFFFFFL);
        int n11 = n - 11;
        lArray[n11] = lArray[n11] + (l6 >> 26);
        long l7 = -77262179L * l;
        int n12 = n - 11;
        lArray[n12] = lArray[n12] + (l7 << 2 & 0xFFFFFFFL);
        int n13 = n - 10;
        lArray[n13] = lArray[n13] + (l7 >> 26);
        long l8 = 104575269L * l;
        int n14 = n - 10;
        lArray[n14] = lArray[n14] + (l8 << 2 & 0xFFFFFFFL);
        int n15 = n - 9;
        lArray[n15] = lArray[n15] + (l8 >> 26);
        long l9 = -130851391L * l;
        int n16 = n - 9;
        lArray[n16] = lArray[n16] + (l9 << 2 & 0xFFFFFFFL);
        int n17 = n - 8;
        lArray[n17] = lArray[n17] + (l9 >> 26);
        int n18 = n - 8;
        lArray[n18] = lArray[n18] + (l << 2 & 0xFFFFFFFL);
        int n19 = n - 7;
        lArray[n19] = lArray[n19] + (l >> 26);
    }

    @Override
    protected void finalCarryReduceLast(long[] lArray) {
        long l = lArray[15] >> 26;
        lArray[15] = lArray[15] - (l << 26);
        long l2 = 78101261L * l;
        lArray[0] = lArray[0] + l2;
        l2 = -126626091L * l;
        lArray[1] = lArray[1] + l2;
        l2 = -93279523L * l;
        lArray[2] = lArray[2] + l2;
        l2 = 64542500L * l;
        lArray[3] = lArray[3] + l2;
        l2 = -110109037L * l;
        lArray[4] = lArray[4] + l2;
        l2 = -77262179L * l;
        lArray[5] = lArray[5] + l2;
        l2 = 104575269L * l;
        lArray[6] = lArray[6] + l2;
        l2 = -130851391L * l;
        lArray[7] = lArray[7] + l2;
        lArray[8] = lArray[8] + l;
    }

    private void carryReduce(long[] lArray, long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8, long l9, long l10, long l11, long l12, long l13, long l14, long l15, long l16, long l17, long l18, long l19, long l20, long l21, long l22, long l23, long l24, long l25, long l26, long l27, long l28, long l29, long l30, long l31) {
        long l32 = 0L;
        long l33 = l + 0x8000000L >> 28;
        l -= l33 << 28;
        l2 += l33;
        l33 = l2 + 0x8000000L >> 28;
        l2 -= l33 << 28;
        l3 += l33;
        l33 = l3 + 0x8000000L >> 28;
        l3 -= l33 << 28;
        l4 += l33;
        l33 = l4 + 0x8000000L >> 28;
        l4 -= l33 << 28;
        l5 += l33;
        l33 = l5 + 0x8000000L >> 28;
        l5 -= l33 << 28;
        l6 += l33;
        l33 = l6 + 0x8000000L >> 28;
        l6 -= l33 << 28;
        l7 += l33;
        l33 = l7 + 0x8000000L >> 28;
        l7 -= l33 << 28;
        l8 += l33;
        l33 = l8 + 0x8000000L >> 28;
        l8 -= l33 << 28;
        l9 += l33;
        l33 = l9 + 0x8000000L >> 28;
        l9 -= l33 << 28;
        l10 += l33;
        l33 = l10 + 0x8000000L >> 28;
        l10 -= l33 << 28;
        l11 += l33;
        l33 = l11 + 0x8000000L >> 28;
        l11 -= l33 << 28;
        l12 += l33;
        l33 = l12 + 0x8000000L >> 28;
        l12 -= l33 << 28;
        l13 += l33;
        l33 = l13 + 0x8000000L >> 28;
        l13 -= l33 << 28;
        l14 += l33;
        l33 = l14 + 0x8000000L >> 28;
        l14 -= l33 << 28;
        l15 += l33;
        l33 = l15 + 0x8000000L >> 28;
        l15 -= l33 << 28;
        l16 += l33;
        l33 = l16 + 0x8000000L >> 28;
        l16 -= l33 << 28;
        l17 += l33;
        l33 = l17 + 0x8000000L >> 28;
        l17 -= l33 << 28;
        l18 += l33;
        l33 = l18 + 0x8000000L >> 28;
        l18 -= l33 << 28;
        l19 += l33;
        l33 = l19 + 0x8000000L >> 28;
        l19 -= l33 << 28;
        l20 += l33;
        l33 = l20 + 0x8000000L >> 28;
        l20 -= l33 << 28;
        l21 += l33;
        l33 = l21 + 0x8000000L >> 28;
        l21 -= l33 << 28;
        l22 += l33;
        l33 = l22 + 0x8000000L >> 28;
        l22 -= l33 << 28;
        l23 += l33;
        l33 = l23 + 0x8000000L >> 28;
        l23 -= l33 << 28;
        l24 += l33;
        l33 = l24 + 0x8000000L >> 28;
        l24 -= l33 << 28;
        l25 += l33;
        l33 = l25 + 0x8000000L >> 28;
        l25 -= l33 << 28;
        l26 += l33;
        l33 = l26 + 0x8000000L >> 28;
        l26 -= l33 << 28;
        l27 += l33;
        l33 = l27 + 0x8000000L >> 28;
        l27 -= l33 << 28;
        l28 += l33;
        l33 = l28 + 0x8000000L >> 28;
        l28 -= l33 << 28;
        l29 += l33;
        l33 = l29 + 0x8000000L >> 28;
        l29 -= l33 << 28;
        l30 += l33;
        l33 = l30 + 0x8000000L >> 28;
        l30 -= l33 << 28;
        l31 += l33;
        l33 = l31 + 0x8000000L >> 28;
        this.carryReduce0(lArray, l, l2, l3, l4, l5, l6, l7, l8, l9, l10, l11, l12, l13, l14, l15, l16, l17, l18, l19, l20, l21, l22, l23, l24, l25, l26, l27, l28, l29, l30, l31 -= l33 << 28, l32 += l33);
    }

    void carryReduce0(long[] lArray, long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8, long l9, long l10, long l11, long l12, long l13, long l14, long l15, long l16, long l17, long l18, long l19, long l20, long l21, long l22, long l23, long l24, long l25, long l26, long l27, long l28, long l29, long l30, long l31, long l32) {
        long l33 = 78101261L * l32;
        l16 += l33 << 2 & 0xFFFFFFFL;
        l17 += l33 >> 26;
        l33 = -126626091L * l32;
        l17 += l33 << 2 & 0xFFFFFFFL;
        l18 += l33 >> 26;
        l33 = -93279523L * l32;
        l18 += l33 << 2 & 0xFFFFFFFL;
        l19 += l33 >> 26;
        l33 = 64542500L * l32;
        l19 += l33 << 2 & 0xFFFFFFFL;
        l20 += l33 >> 26;
        l33 = -110109037L * l32;
        l20 += l33 << 2 & 0xFFFFFFFL;
        l21 += l33 >> 26;
        l33 = -77262179L * l32;
        l21 += l33 << 2 & 0xFFFFFFFL;
        l22 += l33 >> 26;
        l33 = 104575269L * l32;
        l22 += l33 << 2 & 0xFFFFFFFL;
        l23 += l33 >> 26;
        l33 = -130851391L * l32;
        l23 += l33 << 2 & 0xFFFFFFFL;
        l24 += l33 >> 26;
        l24 += l32 << 2 & 0xFFFFFFFL;
        l25 += l32 >> 26;
        l33 = 78101261L * l31;
        l15 += l33 << 2 & 0xFFFFFFFL;
        l16 += l33 >> 26;
        l33 = -126626091L * l31;
        l16 += l33 << 2 & 0xFFFFFFFL;
        l17 += l33 >> 26;
        l33 = -93279523L * l31;
        l17 += l33 << 2 & 0xFFFFFFFL;
        l18 += l33 >> 26;
        l33 = 64542500L * l31;
        l18 += l33 << 2 & 0xFFFFFFFL;
        l19 += l33 >> 26;
        l33 = -110109037L * l31;
        l19 += l33 << 2 & 0xFFFFFFFL;
        l20 += l33 >> 26;
        l33 = -77262179L * l31;
        l20 += l33 << 2 & 0xFFFFFFFL;
        l21 += l33 >> 26;
        l33 = 104575269L * l31;
        l21 += l33 << 2 & 0xFFFFFFFL;
        l22 += l33 >> 26;
        l33 = -130851391L * l31;
        l22 += l33 << 2 & 0xFFFFFFFL;
        l23 += l33 >> 26;
        l23 += l31 << 2 & 0xFFFFFFFL;
        l24 += l31 >> 26;
        l33 = 78101261L * l30;
        l14 += l33 << 2 & 0xFFFFFFFL;
        l15 += l33 >> 26;
        l33 = -126626091L * l30;
        l15 += l33 << 2 & 0xFFFFFFFL;
        l16 += l33 >> 26;
        l33 = -93279523L * l30;
        l16 += l33 << 2 & 0xFFFFFFFL;
        l17 += l33 >> 26;
        l33 = 64542500L * l30;
        l17 += l33 << 2 & 0xFFFFFFFL;
        l18 += l33 >> 26;
        l33 = -110109037L * l30;
        l18 += l33 << 2 & 0xFFFFFFFL;
        l19 += l33 >> 26;
        l33 = -77262179L * l30;
        l19 += l33 << 2 & 0xFFFFFFFL;
        l20 += l33 >> 26;
        l33 = 104575269L * l30;
        l20 += l33 << 2 & 0xFFFFFFFL;
        l21 += l33 >> 26;
        l33 = -130851391L * l30;
        l21 += l33 << 2 & 0xFFFFFFFL;
        l22 += l33 >> 26;
        l22 += l30 << 2 & 0xFFFFFFFL;
        l23 += l30 >> 26;
        l33 = 78101261L * l29;
        l13 += l33 << 2 & 0xFFFFFFFL;
        l14 += l33 >> 26;
        l33 = -126626091L * l29;
        l14 += l33 << 2 & 0xFFFFFFFL;
        l15 += l33 >> 26;
        l33 = -93279523L * l29;
        l15 += l33 << 2 & 0xFFFFFFFL;
        l16 += l33 >> 26;
        l33 = 64542500L * l29;
        l16 += l33 << 2 & 0xFFFFFFFL;
        l17 += l33 >> 26;
        l33 = -110109037L * l29;
        l17 += l33 << 2 & 0xFFFFFFFL;
        l18 += l33 >> 26;
        l33 = -77262179L * l29;
        l18 += l33 << 2 & 0xFFFFFFFL;
        l19 += l33 >> 26;
        l33 = 104575269L * l29;
        l19 += l33 << 2 & 0xFFFFFFFL;
        l20 += l33 >> 26;
        l33 = -130851391L * l29;
        l20 += l33 << 2 & 0xFFFFFFFL;
        l21 += l33 >> 26;
        l21 += l29 << 2 & 0xFFFFFFFL;
        l22 += l29 >> 26;
        l33 = 78101261L * l28;
        l12 += l33 << 2 & 0xFFFFFFFL;
        l13 += l33 >> 26;
        l33 = -126626091L * l28;
        l13 += l33 << 2 & 0xFFFFFFFL;
        l14 += l33 >> 26;
        l33 = -93279523L * l28;
        l14 += l33 << 2 & 0xFFFFFFFL;
        l15 += l33 >> 26;
        l33 = 64542500L * l28;
        l15 += l33 << 2 & 0xFFFFFFFL;
        l16 += l33 >> 26;
        l33 = -110109037L * l28;
        l16 += l33 << 2 & 0xFFFFFFFL;
        l17 += l33 >> 26;
        l33 = -77262179L * l28;
        l17 += l33 << 2 & 0xFFFFFFFL;
        l18 += l33 >> 26;
        l33 = 104575269L * l28;
        l18 += l33 << 2 & 0xFFFFFFFL;
        l19 += l33 >> 26;
        l33 = -130851391L * l28;
        l19 += l33 << 2 & 0xFFFFFFFL;
        l20 += l33 >> 26;
        l20 += l28 << 2 & 0xFFFFFFFL;
        l21 += l28 >> 26;
        l33 = 78101261L * l27;
        l11 += l33 << 2 & 0xFFFFFFFL;
        l12 += l33 >> 26;
        l33 = -126626091L * l27;
        l12 += l33 << 2 & 0xFFFFFFFL;
        l13 += l33 >> 26;
        l33 = -93279523L * l27;
        l13 += l33 << 2 & 0xFFFFFFFL;
        l14 += l33 >> 26;
        l33 = 64542500L * l27;
        l14 += l33 << 2 & 0xFFFFFFFL;
        l15 += l33 >> 26;
        l33 = -110109037L * l27;
        l15 += l33 << 2 & 0xFFFFFFFL;
        l16 += l33 >> 26;
        l33 = -77262179L * l27;
        l16 += l33 << 2 & 0xFFFFFFFL;
        l17 += l33 >> 26;
        l33 = 104575269L * l27;
        l17 += l33 << 2 & 0xFFFFFFFL;
        l18 += l33 >> 26;
        l33 = -130851391L * l27;
        l18 += l33 << 2 & 0xFFFFFFFL;
        l19 += l33 >> 26;
        l19 += l27 << 2 & 0xFFFFFFFL;
        l20 += l27 >> 26;
        l33 = 78101261L * l26;
        l10 += l33 << 2 & 0xFFFFFFFL;
        l11 += l33 >> 26;
        l33 = -126626091L * l26;
        l11 += l33 << 2 & 0xFFFFFFFL;
        l12 += l33 >> 26;
        l33 = -93279523L * l26;
        l12 += l33 << 2 & 0xFFFFFFFL;
        l13 += l33 >> 26;
        l33 = 64542500L * l26;
        l13 += l33 << 2 & 0xFFFFFFFL;
        l14 += l33 >> 26;
        l33 = -110109037L * l26;
        l14 += l33 << 2 & 0xFFFFFFFL;
        l15 += l33 >> 26;
        l33 = -77262179L * l26;
        l15 += l33 << 2 & 0xFFFFFFFL;
        l16 += l33 >> 26;
        l33 = 104575269L * l26;
        l16 += l33 << 2 & 0xFFFFFFFL;
        l17 += l33 >> 26;
        l33 = -130851391L * l26;
        l17 += l33 << 2 & 0xFFFFFFFL;
        l18 += l33 >> 26;
        l18 += l26 << 2 & 0xFFFFFFFL;
        l19 += l26 >> 26;
        l33 = 78101261L * l25;
        l9 += l33 << 2 & 0xFFFFFFFL;
        l10 += l33 >> 26;
        l33 = -126626091L * l25;
        l10 += l33 << 2 & 0xFFFFFFFL;
        l11 += l33 >> 26;
        l33 = -93279523L * l25;
        l11 += l33 << 2 & 0xFFFFFFFL;
        l12 += l33 >> 26;
        l33 = 64542500L * l25;
        l12 += l33 << 2 & 0xFFFFFFFL;
        l13 += l33 >> 26;
        l33 = -110109037L * l25;
        l13 += l33 << 2 & 0xFFFFFFFL;
        l14 += l33 >> 26;
        l33 = -77262179L * l25;
        l14 += l33 << 2 & 0xFFFFFFFL;
        l15 += l33 >> 26;
        l33 = 104575269L * l25;
        l15 += l33 << 2 & 0xFFFFFFFL;
        l16 += l33 >> 26;
        l33 = -130851391L * l25;
        l16 += l33 << 2 & 0xFFFFFFFL;
        l17 += l33 >> 26;
        l17 += l25 << 2 & 0xFFFFFFFL;
        l18 += l25 >> 26;
        l33 = 78101261L * l24;
        l8 += l33 << 2 & 0xFFFFFFFL;
        l9 += l33 >> 26;
        l33 = -126626091L * l24;
        l9 += l33 << 2 & 0xFFFFFFFL;
        l10 += l33 >> 26;
        l33 = -93279523L * l24;
        l10 += l33 << 2 & 0xFFFFFFFL;
        l11 += l33 >> 26;
        l33 = 64542500L * l24;
        l11 += l33 << 2 & 0xFFFFFFFL;
        l12 += l33 >> 26;
        l33 = -110109037L * l24;
        l12 += l33 << 2 & 0xFFFFFFFL;
        l13 += l33 >> 26;
        l33 = -77262179L * l24;
        l13 += l33 << 2 & 0xFFFFFFFL;
        l14 += l33 >> 26;
        l33 = 104575269L * l24;
        l14 += l33 << 2 & 0xFFFFFFFL;
        l15 += l33 >> 26;
        l33 = -130851391L * l24;
        l15 += l33 << 2 & 0xFFFFFFFL;
        l16 += l33 >> 26;
        l16 += l24 << 2 & 0xFFFFFFFL;
        l17 += l24 >> 26;
        l33 = 78101261L * l23;
        l7 += l33 << 2 & 0xFFFFFFFL;
        l8 += l33 >> 26;
        l33 = -126626091L * l23;
        l8 += l33 << 2 & 0xFFFFFFFL;
        l9 += l33 >> 26;
        l33 = -93279523L * l23;
        l9 += l33 << 2 & 0xFFFFFFFL;
        l10 += l33 >> 26;
        l33 = 64542500L * l23;
        l10 += l33 << 2 & 0xFFFFFFFL;
        l11 += l33 >> 26;
        l33 = -110109037L * l23;
        l11 += l33 << 2 & 0xFFFFFFFL;
        l12 += l33 >> 26;
        l33 = -77262179L * l23;
        l12 += l33 << 2 & 0xFFFFFFFL;
        l13 += l33 >> 26;
        l33 = 104575269L * l23;
        l13 += l33 << 2 & 0xFFFFFFFL;
        l14 += l33 >> 26;
        l33 = -130851391L * l23;
        l14 += l33 << 2 & 0xFFFFFFFL;
        l15 += l33 >> 26;
        l15 += l23 << 2 & 0xFFFFFFFL;
        l16 += l23 >> 26;
        l33 = 78101261L * l22;
        l6 += l33 << 2 & 0xFFFFFFFL;
        l7 += l33 >> 26;
        l33 = -126626091L * l22;
        l7 += l33 << 2 & 0xFFFFFFFL;
        l8 += l33 >> 26;
        l33 = -93279523L * l22;
        l8 += l33 << 2 & 0xFFFFFFFL;
        l9 += l33 >> 26;
        l33 = 64542500L * l22;
        l9 += l33 << 2 & 0xFFFFFFFL;
        l10 += l33 >> 26;
        l33 = -110109037L * l22;
        l10 += l33 << 2 & 0xFFFFFFFL;
        l11 += l33 >> 26;
        l33 = -77262179L * l22;
        l11 += l33 << 2 & 0xFFFFFFFL;
        l12 += l33 >> 26;
        l33 = 104575269L * l22;
        l12 += l33 << 2 & 0xFFFFFFFL;
        l13 += l33 >> 26;
        l33 = -130851391L * l22;
        l13 += l33 << 2 & 0xFFFFFFFL;
        l14 += l33 >> 26;
        l14 += l22 << 2 & 0xFFFFFFFL;
        l15 += l22 >> 26;
        l33 = 78101261L * l21;
        l5 += l33 << 2 & 0xFFFFFFFL;
        l6 += l33 >> 26;
        l33 = -126626091L * l21;
        l6 += l33 << 2 & 0xFFFFFFFL;
        l7 += l33 >> 26;
        l33 = -93279523L * l21;
        l7 += l33 << 2 & 0xFFFFFFFL;
        l8 += l33 >> 26;
        l33 = 64542500L * l21;
        l8 += l33 << 2 & 0xFFFFFFFL;
        l9 += l33 >> 26;
        l33 = -110109037L * l21;
        l9 += l33 << 2 & 0xFFFFFFFL;
        l10 += l33 >> 26;
        l33 = -77262179L * l21;
        l10 += l33 << 2 & 0xFFFFFFFL;
        l11 += l33 >> 26;
        l33 = 104575269L * l21;
        l11 += l33 << 2 & 0xFFFFFFFL;
        l12 += l33 >> 26;
        l33 = -130851391L * l21;
        l12 += l33 << 2 & 0xFFFFFFFL;
        l13 += l33 >> 26;
        l13 += l21 << 2 & 0xFFFFFFFL;
        l14 += l21 >> 26;
        l33 = 78101261L * l20;
        l4 += l33 << 2 & 0xFFFFFFFL;
        l5 += l33 >> 26;
        l33 = -126626091L * l20;
        l5 += l33 << 2 & 0xFFFFFFFL;
        l6 += l33 >> 26;
        l33 = -93279523L * l20;
        l6 += l33 << 2 & 0xFFFFFFFL;
        l7 += l33 >> 26;
        l33 = 64542500L * l20;
        l7 += l33 << 2 & 0xFFFFFFFL;
        l8 += l33 >> 26;
        l33 = -110109037L * l20;
        l8 += l33 << 2 & 0xFFFFFFFL;
        l9 += l33 >> 26;
        l33 = -77262179L * l20;
        l9 += l33 << 2 & 0xFFFFFFFL;
        l10 += l33 >> 26;
        l33 = 104575269L * l20;
        l10 += l33 << 2 & 0xFFFFFFFL;
        l11 += l33 >> 26;
        l33 = -130851391L * l20;
        l11 += l33 << 2 & 0xFFFFFFFL;
        l12 += l33 >> 26;
        l12 += l20 << 2 & 0xFFFFFFFL;
        l13 += l20 >> 26;
        l33 = 78101261L * l19;
        l3 += l33 << 2 & 0xFFFFFFFL;
        l4 += l33 >> 26;
        l33 = -126626091L * l19;
        l4 += l33 << 2 & 0xFFFFFFFL;
        l5 += l33 >> 26;
        l33 = -93279523L * l19;
        l5 += l33 << 2 & 0xFFFFFFFL;
        l6 += l33 >> 26;
        l33 = 64542500L * l19;
        l6 += l33 << 2 & 0xFFFFFFFL;
        l7 += l33 >> 26;
        l33 = -110109037L * l19;
        l7 += l33 << 2 & 0xFFFFFFFL;
        l8 += l33 >> 26;
        l33 = -77262179L * l19;
        l8 += l33 << 2 & 0xFFFFFFFL;
        l9 += l33 >> 26;
        l33 = 104575269L * l19;
        l9 += l33 << 2 & 0xFFFFFFFL;
        l10 += l33 >> 26;
        l33 = -130851391L * l19;
        l10 += l33 << 2 & 0xFFFFFFFL;
        l11 += l33 >> 26;
        l11 += l19 << 2 & 0xFFFFFFFL;
        l12 += l19 >> 26;
        l33 = 78101261L * l18;
        l2 += l33 << 2 & 0xFFFFFFFL;
        l3 += l33 >> 26;
        l33 = -126626091L * l18;
        l3 += l33 << 2 & 0xFFFFFFFL;
        l4 += l33 >> 26;
        l33 = -93279523L * l18;
        l4 += l33 << 2 & 0xFFFFFFFL;
        l5 += l33 >> 26;
        l33 = 64542500L * l18;
        l5 += l33 << 2 & 0xFFFFFFFL;
        l6 += l33 >> 26;
        l33 = -110109037L * l18;
        l6 += l33 << 2 & 0xFFFFFFFL;
        l7 += l33 >> 26;
        l33 = -77262179L * l18;
        l7 += l33 << 2 & 0xFFFFFFFL;
        l8 += l33 >> 26;
        l33 = 104575269L * l18;
        l8 += l33 << 2 & 0xFFFFFFFL;
        l9 += l33 >> 26;
        l33 = -130851391L * l18;
        l9 += l33 << 2 & 0xFFFFFFFL;
        l10 += l33 >> 26;
        l10 += l18 << 2 & 0xFFFFFFFL;
        l11 += l18 >> 26;
        l33 = 78101261L * l17;
        l += l33 << 2 & 0xFFFFFFFL;
        l2 += l33 >> 26;
        l33 = -126626091L * l17;
        l2 += l33 << 2 & 0xFFFFFFFL;
        l3 += l33 >> 26;
        l33 = -93279523L * l17;
        l3 += l33 << 2 & 0xFFFFFFFL;
        l4 += l33 >> 26;
        l33 = 64542500L * l17;
        l4 += l33 << 2 & 0xFFFFFFFL;
        l5 += l33 >> 26;
        l33 = -110109037L * l17;
        l5 += l33 << 2 & 0xFFFFFFFL;
        l6 += l33 >> 26;
        l33 = -77262179L * l17;
        l6 += l33 << 2 & 0xFFFFFFFL;
        l7 += l33 >> 26;
        l33 = 104575269L * l17;
        l7 += l33 << 2 & 0xFFFFFFFL;
        l8 += l33 >> 26;
        l33 = -130851391L * l17;
        l9 += l33 >> 26;
        l9 += l17 << 2 & 0xFFFFFFFL;
        l10 += l17 >> 26;
        l17 = 0L;
        this.carryReduce1(lArray, l, l2, l3, l4, l5, l6, l7, l8 += l33 << 2 & 0xFFFFFFFL, l9, l10, l11, l12, l13, l14, l15, l16, l17, l18, l19, l20, l21, l22, l23, l24, l25, l26, l27, l28, l29, l30, l31, l32);
    }

    void carryReduce1(long[] lArray, long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8, long l9, long l10, long l11, long l12, long l13, long l14, long l15, long l16, long l17, long l18, long l19, long l20, long l21, long l22, long l23, long l24, long l25, long l26, long l27, long l28, long l29, long l30, long l31, long l32) {
        long l33 = l + 0x8000000L >> 28;
        l -= l33 << 28;
        l2 += l33;
        l33 = l2 + 0x8000000L >> 28;
        l2 -= l33 << 28;
        l3 += l33;
        l33 = l3 + 0x8000000L >> 28;
        l3 -= l33 << 28;
        l4 += l33;
        l33 = l4 + 0x8000000L >> 28;
        l4 -= l33 << 28;
        l5 += l33;
        l33 = l5 + 0x8000000L >> 28;
        l5 -= l33 << 28;
        l6 += l33;
        l33 = l6 + 0x8000000L >> 28;
        l6 -= l33 << 28;
        l7 += l33;
        l33 = l7 + 0x8000000L >> 28;
        l7 -= l33 << 28;
        l8 += l33;
        l33 = l8 + 0x8000000L >> 28;
        l8 -= l33 << 28;
        l9 += l33;
        l33 = l9 + 0x8000000L >> 28;
        l9 -= l33 << 28;
        l10 += l33;
        l33 = l10 + 0x8000000L >> 28;
        l10 -= l33 << 28;
        l11 += l33;
        l33 = l11 + 0x8000000L >> 28;
        l11 -= l33 << 28;
        l12 += l33;
        l33 = l12 + 0x8000000L >> 28;
        l12 -= l33 << 28;
        l13 += l33;
        l33 = l13 + 0x8000000L >> 28;
        l13 -= l33 << 28;
        l14 += l33;
        l33 = l14 + 0x8000000L >> 28;
        l14 -= l33 << 28;
        l15 += l33;
        l33 = l15 + 0x8000000L >> 28;
        l15 -= l33 << 28;
        l16 += l33;
        l33 = l16 + 0x8000000L >> 28;
        this.carryReduce2(lArray, l, l2, l3, l4, l5, l6, l7, l8, l9, l10, l11, l12, l13, l14, l15, l16 -= l33 << 28, l17 += l33, l18, l19, l20, l21, l22, l23, l24, l25, l26, l27, l28, l29, l30, l31, l32);
    }

    void carryReduce2(long[] lArray, long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8, long l9, long l10, long l11, long l12, long l13, long l14, long l15, long l16, long l17, long l18, long l19, long l20, long l21, long l22, long l23, long l24, long l25, long l26, long l27, long l28, long l29, long l30, long l31, long l32) {
        long l33 = 78101261L * l17;
        l += l33 << 2 & 0xFFFFFFFL;
        l2 += l33 >> 26;
        l33 = -126626091L * l17;
        l2 += l33 << 2 & 0xFFFFFFFL;
        l3 += l33 >> 26;
        l33 = -93279523L * l17;
        l3 += l33 << 2 & 0xFFFFFFFL;
        l4 += l33 >> 26;
        l33 = 64542500L * l17;
        l4 += l33 << 2 & 0xFFFFFFFL;
        l5 += l33 >> 26;
        l33 = -110109037L * l17;
        l5 += l33 << 2 & 0xFFFFFFFL;
        l6 += l33 >> 26;
        l33 = -77262179L * l17;
        l6 += l33 << 2 & 0xFFFFFFFL;
        l7 += l33 >> 26;
        l33 = 104575269L * l17;
        l7 += l33 << 2 & 0xFFFFFFFL;
        l8 += l33 >> 26;
        l33 = -130851391L * l17;
        l8 += l33 << 2 & 0xFFFFFFFL;
        l9 += l33 >> 26;
        l9 += l17 << 2 & 0xFFFFFFFL;
        l10 += l17 >> 26;
        l33 = l + 0x8000000L >> 28;
        l -= l33 << 28;
        l2 += l33;
        l33 = l2 + 0x8000000L >> 28;
        l2 -= l33 << 28;
        l3 += l33;
        l33 = l3 + 0x8000000L >> 28;
        l3 -= l33 << 28;
        l4 += l33;
        l33 = l4 + 0x8000000L >> 28;
        l4 -= l33 << 28;
        l5 += l33;
        l33 = l5 + 0x8000000L >> 28;
        l5 -= l33 << 28;
        l6 += l33;
        l33 = l6 + 0x8000000L >> 28;
        l6 -= l33 << 28;
        l7 += l33;
        l33 = l7 + 0x8000000L >> 28;
        l7 -= l33 << 28;
        l8 += l33;
        l33 = l8 + 0x8000000L >> 28;
        l8 -= l33 << 28;
        l9 += l33;
        l33 = l9 + 0x8000000L >> 28;
        l9 -= l33 << 28;
        l10 += l33;
        l33 = l10 + 0x8000000L >> 28;
        l10 -= l33 << 28;
        l11 += l33;
        l33 = l11 + 0x8000000L >> 28;
        l11 -= l33 << 28;
        l12 += l33;
        l33 = l12 + 0x8000000L >> 28;
        l12 -= l33 << 28;
        l13 += l33;
        l33 = l13 + 0x8000000L >> 28;
        l13 -= l33 << 28;
        l14 += l33;
        l33 = l14 + 0x8000000L >> 28;
        l14 -= l33 << 28;
        l15 += l33;
        l33 = l15 + 0x8000000L >> 28;
        l15 -= l33 << 28;
        l16 += l33;
        lArray[0] = l;
        lArray[1] = l2;
        lArray[2] = l3;
        lArray[3] = l4;
        lArray[4] = l5;
        lArray[5] = l6;
        lArray[6] = l7;
        lArray[7] = l8;
        lArray[8] = l9;
        lArray[9] = l10;
        lArray[10] = l11;
        lArray[11] = l12;
        lArray[12] = l13;
        lArray[13] = l14;
        lArray[14] = l15;
        lArray[15] = l16;
    }

    private void carryReduce(long[] lArray, long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8, long l9, long l10, long l11, long l12, long l13, long l14, long l15, long l16) {
        long l17 = 0L;
        long l18 = l + 0x8000000L >> 28;
        l -= l18 << 28;
        l2 += l18;
        l18 = l2 + 0x8000000L >> 28;
        l2 -= l18 << 28;
        l3 += l18;
        l18 = l3 + 0x8000000L >> 28;
        l3 -= l18 << 28;
        l4 += l18;
        l18 = l4 + 0x8000000L >> 28;
        l4 -= l18 << 28;
        l5 += l18;
        l18 = l5 + 0x8000000L >> 28;
        l5 -= l18 << 28;
        l6 += l18;
        l18 = l6 + 0x8000000L >> 28;
        l6 -= l18 << 28;
        l7 += l18;
        l18 = l7 + 0x8000000L >> 28;
        l7 -= l18 << 28;
        l8 += l18;
        l18 = l8 + 0x8000000L >> 28;
        l8 -= l18 << 28;
        l9 += l18;
        l18 = l9 + 0x8000000L >> 28;
        l9 -= l18 << 28;
        l10 += l18;
        l18 = l10 + 0x8000000L >> 28;
        l10 -= l18 << 28;
        l11 += l18;
        l18 = l11 + 0x8000000L >> 28;
        l11 -= l18 << 28;
        l12 += l18;
        l18 = l12 + 0x8000000L >> 28;
        l12 -= l18 << 28;
        l13 += l18;
        l18 = l13 + 0x8000000L >> 28;
        l13 -= l18 << 28;
        l14 += l18;
        l18 = l14 + 0x8000000L >> 28;
        l14 -= l18 << 28;
        l15 += l18;
        l18 = l15 + 0x8000000L >> 28;
        l15 -= l18 << 28;
        l16 += l18;
        l18 = l16 + 0x8000000L >> 28;
        this.carryReduce0(lArray, l, l2, l3, l4, l5, l6, l7, l8, l9, l10, l11, l12, l13, l14, l15, l16 -= l18 << 28, l17 += l18);
    }

    void carryReduce0(long[] lArray, long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8, long l9, long l10, long l11, long l12, long l13, long l14, long l15, long l16, long l17) {
        long l18 = 78101261L * l17;
        l += l18 << 2 & 0xFFFFFFFL;
        l2 += l18 >> 26;
        l18 = -126626091L * l17;
        l2 += l18 << 2 & 0xFFFFFFFL;
        l3 += l18 >> 26;
        l18 = -93279523L * l17;
        l3 += l18 << 2 & 0xFFFFFFFL;
        l4 += l18 >> 26;
        l18 = 64542500L * l17;
        l4 += l18 << 2 & 0xFFFFFFFL;
        l5 += l18 >> 26;
        l18 = -110109037L * l17;
        l5 += l18 << 2 & 0xFFFFFFFL;
        l6 += l18 >> 26;
        l18 = -77262179L * l17;
        l6 += l18 << 2 & 0xFFFFFFFL;
        l7 += l18 >> 26;
        l18 = 104575269L * l17;
        l7 += l18 << 2 & 0xFFFFFFFL;
        l8 += l18 >> 26;
        l18 = -130851391L * l17;
        l8 += l18 << 2 & 0xFFFFFFFL;
        l9 += l18 >> 26;
        l9 += l17 << 2 & 0xFFFFFFFL;
        l10 += l17 >> 26;
        l18 = l + 0x8000000L >> 28;
        l -= l18 << 28;
        l2 += l18;
        l18 = l2 + 0x8000000L >> 28;
        l2 -= l18 << 28;
        l3 += l18;
        l18 = l3 + 0x8000000L >> 28;
        l3 -= l18 << 28;
        l4 += l18;
        l18 = l4 + 0x8000000L >> 28;
        l4 -= l18 << 28;
        l5 += l18;
        l18 = l5 + 0x8000000L >> 28;
        l5 -= l18 << 28;
        l6 += l18;
        l18 = l6 + 0x8000000L >> 28;
        l6 -= l18 << 28;
        l7 += l18;
        l18 = l7 + 0x8000000L >> 28;
        l7 -= l18 << 28;
        l8 += l18;
        l18 = l8 + 0x8000000L >> 28;
        l8 -= l18 << 28;
        l9 += l18;
        l18 = l9 + 0x8000000L >> 28;
        l9 -= l18 << 28;
        l10 += l18;
        l18 = l10 + 0x8000000L >> 28;
        l10 -= l18 << 28;
        l11 += l18;
        l18 = l11 + 0x8000000L >> 28;
        l11 -= l18 << 28;
        l12 += l18;
        l18 = l12 + 0x8000000L >> 28;
        l12 -= l18 << 28;
        l13 += l18;
        l18 = l13 + 0x8000000L >> 28;
        l13 -= l18 << 28;
        l14 += l18;
        l18 = l14 + 0x8000000L >> 28;
        l14 -= l18 << 28;
        l15 += l18;
        l18 = l15 + 0x8000000L >> 28;
        l15 -= l18 << 28;
        l16 += l18;
        lArray[0] = l;
        lArray[1] = l2;
        lArray[2] = l3;
        lArray[3] = l4;
        lArray[4] = l5;
        lArray[5] = l6;
        lArray[6] = l7;
        lArray[7] = l8;
        lArray[8] = l9;
        lArray[9] = l10;
        lArray[10] = l11;
        lArray[11] = l12;
        lArray[12] = l13;
        lArray[13] = l14;
        lArray[14] = l15;
        lArray[15] = l16;
    }

    @Override
    protected void mult(long[] lArray, long[] lArray2, long[] lArray3) {
        long l = lArray[0] * lArray2[0];
        long l2 = lArray[0] * lArray2[1] + lArray[1] * lArray2[0];
        long l3 = lArray[0] * lArray2[2] + lArray[1] * lArray2[1] + lArray[2] * lArray2[0];
        long l4 = lArray[0] * lArray2[3] + lArray[1] * lArray2[2] + lArray[2] * lArray2[1] + lArray[3] * lArray2[0];
        long l5 = lArray[0] * lArray2[4] + lArray[1] * lArray2[3] + lArray[2] * lArray2[2] + lArray[3] * lArray2[1] + lArray[4] * lArray2[0];
        long l6 = lArray[0] * lArray2[5] + lArray[1] * lArray2[4] + lArray[2] * lArray2[3] + lArray[3] * lArray2[2] + lArray[4] * lArray2[1] + lArray[5] * lArray2[0];
        long l7 = lArray[0] * lArray2[6] + lArray[1] * lArray2[5] + lArray[2] * lArray2[4] + lArray[3] * lArray2[3] + lArray[4] * lArray2[2] + lArray[5] * lArray2[1] + lArray[6] * lArray2[0];
        long l8 = lArray[0] * lArray2[7] + lArray[1] * lArray2[6] + lArray[2] * lArray2[5] + lArray[3] * lArray2[4] + lArray[4] * lArray2[3] + lArray[5] * lArray2[2] + lArray[6] * lArray2[1] + lArray[7] * lArray2[0];
        long l9 = lArray[0] * lArray2[8] + lArray[1] * lArray2[7] + lArray[2] * lArray2[6] + lArray[3] * lArray2[5] + lArray[4] * lArray2[4] + lArray[5] * lArray2[3] + lArray[6] * lArray2[2] + lArray[7] * lArray2[1] + lArray[8] * lArray2[0];
        long l10 = lArray[0] * lArray2[9] + lArray[1] * lArray2[8] + lArray[2] * lArray2[7] + lArray[3] * lArray2[6] + lArray[4] * lArray2[5] + lArray[5] * lArray2[4] + lArray[6] * lArray2[3] + lArray[7] * lArray2[2] + lArray[8] * lArray2[1] + lArray[9] * lArray2[0];
        long l11 = lArray[0] * lArray2[10] + lArray[1] * lArray2[9] + lArray[2] * lArray2[8] + lArray[3] * lArray2[7] + lArray[4] * lArray2[6] + lArray[5] * lArray2[5] + lArray[6] * lArray2[4] + lArray[7] * lArray2[3] + lArray[8] * lArray2[2] + lArray[9] * lArray2[1] + lArray[10] * lArray2[0];
        long l12 = lArray[0] * lArray2[11] + lArray[1] * lArray2[10] + lArray[2] * lArray2[9] + lArray[3] * lArray2[8] + lArray[4] * lArray2[7] + lArray[5] * lArray2[6] + lArray[6] * lArray2[5] + lArray[7] * lArray2[4] + lArray[8] * lArray2[3] + lArray[9] * lArray2[2] + lArray[10] * lArray2[1] + lArray[11] * lArray2[0];
        long l13 = lArray[0] * lArray2[12] + lArray[1] * lArray2[11] + lArray[2] * lArray2[10] + lArray[3] * lArray2[9] + lArray[4] * lArray2[8] + lArray[5] * lArray2[7] + lArray[6] * lArray2[6] + lArray[7] * lArray2[5] + lArray[8] * lArray2[4] + lArray[9] * lArray2[3] + lArray[10] * lArray2[2] + lArray[11] * lArray2[1] + lArray[12] * lArray2[0];
        long l14 = lArray[0] * lArray2[13] + lArray[1] * lArray2[12] + lArray[2] * lArray2[11] + lArray[3] * lArray2[10] + lArray[4] * lArray2[9] + lArray[5] * lArray2[8] + lArray[6] * lArray2[7] + lArray[7] * lArray2[6] + lArray[8] * lArray2[5] + lArray[9] * lArray2[4] + lArray[10] * lArray2[3] + lArray[11] * lArray2[2] + lArray[12] * lArray2[1] + lArray[13] * lArray2[0];
        long l15 = lArray[0] * lArray2[14] + lArray[1] * lArray2[13] + lArray[2] * lArray2[12] + lArray[3] * lArray2[11] + lArray[4] * lArray2[10] + lArray[5] * lArray2[9] + lArray[6] * lArray2[8] + lArray[7] * lArray2[7] + lArray[8] * lArray2[6] + lArray[9] * lArray2[5] + lArray[10] * lArray2[4] + lArray[11] * lArray2[3] + lArray[12] * lArray2[2] + lArray[13] * lArray2[1] + lArray[14] * lArray2[0];
        long l16 = lArray[0] * lArray2[15] + lArray[1] * lArray2[14] + lArray[2] * lArray2[13] + lArray[3] * lArray2[12] + lArray[4] * lArray2[11] + lArray[5] * lArray2[10] + lArray[6] * lArray2[9] + lArray[7] * lArray2[8] + lArray[8] * lArray2[7] + lArray[9] * lArray2[6] + lArray[10] * lArray2[5] + lArray[11] * lArray2[4] + lArray[12] * lArray2[3] + lArray[13] * lArray2[2] + lArray[14] * lArray2[1] + lArray[15] * lArray2[0];
        long l17 = lArray[1] * lArray2[15] + lArray[2] * lArray2[14] + lArray[3] * lArray2[13] + lArray[4] * lArray2[12] + lArray[5] * lArray2[11] + lArray[6] * lArray2[10] + lArray[7] * lArray2[9] + lArray[8] * lArray2[8] + lArray[9] * lArray2[7] + lArray[10] * lArray2[6] + lArray[11] * lArray2[5] + lArray[12] * lArray2[4] + lArray[13] * lArray2[3] + lArray[14] * lArray2[2] + lArray[15] * lArray2[1];
        long l18 = lArray[2] * lArray2[15] + lArray[3] * lArray2[14] + lArray[4] * lArray2[13] + lArray[5] * lArray2[12] + lArray[6] * lArray2[11] + lArray[7] * lArray2[10] + lArray[8] * lArray2[9] + lArray[9] * lArray2[8] + lArray[10] * lArray2[7] + lArray[11] * lArray2[6] + lArray[12] * lArray2[5] + lArray[13] * lArray2[4] + lArray[14] * lArray2[3] + lArray[15] * lArray2[2];
        long l19 = lArray[3] * lArray2[15] + lArray[4] * lArray2[14] + lArray[5] * lArray2[13] + lArray[6] * lArray2[12] + lArray[7] * lArray2[11] + lArray[8] * lArray2[10] + lArray[9] * lArray2[9] + lArray[10] * lArray2[8] + lArray[11] * lArray2[7] + lArray[12] * lArray2[6] + lArray[13] * lArray2[5] + lArray[14] * lArray2[4] + lArray[15] * lArray2[3];
        long l20 = lArray[4] * lArray2[15] + lArray[5] * lArray2[14] + lArray[6] * lArray2[13] + lArray[7] * lArray2[12] + lArray[8] * lArray2[11] + lArray[9] * lArray2[10] + lArray[10] * lArray2[9] + lArray[11] * lArray2[8] + lArray[12] * lArray2[7] + lArray[13] * lArray2[6] + lArray[14] * lArray2[5] + lArray[15] * lArray2[4];
        long l21 = lArray[5] * lArray2[15] + lArray[6] * lArray2[14] + lArray[7] * lArray2[13] + lArray[8] * lArray2[12] + lArray[9] * lArray2[11] + lArray[10] * lArray2[10] + lArray[11] * lArray2[9] + lArray[12] * lArray2[8] + lArray[13] * lArray2[7] + lArray[14] * lArray2[6] + lArray[15] * lArray2[5];
        long l22 = lArray[6] * lArray2[15] + lArray[7] * lArray2[14] + lArray[8] * lArray2[13] + lArray[9] * lArray2[12] + lArray[10] * lArray2[11] + lArray[11] * lArray2[10] + lArray[12] * lArray2[9] + lArray[13] * lArray2[8] + lArray[14] * lArray2[7] + lArray[15] * lArray2[6];
        long l23 = lArray[7] * lArray2[15] + lArray[8] * lArray2[14] + lArray[9] * lArray2[13] + lArray[10] * lArray2[12] + lArray[11] * lArray2[11] + lArray[12] * lArray2[10] + lArray[13] * lArray2[9] + lArray[14] * lArray2[8] + lArray[15] * lArray2[7];
        long l24 = lArray[8] * lArray2[15] + lArray[9] * lArray2[14] + lArray[10] * lArray2[13] + lArray[11] * lArray2[12] + lArray[12] * lArray2[11] + lArray[13] * lArray2[10] + lArray[14] * lArray2[9] + lArray[15] * lArray2[8];
        long l25 = lArray[9] * lArray2[15] + lArray[10] * lArray2[14] + lArray[11] * lArray2[13] + lArray[12] * lArray2[12] + lArray[13] * lArray2[11] + lArray[14] * lArray2[10] + lArray[15] * lArray2[9];
        long l26 = lArray[10] * lArray2[15] + lArray[11] * lArray2[14] + lArray[12] * lArray2[13] + lArray[13] * lArray2[12] + lArray[14] * lArray2[11] + lArray[15] * lArray2[10];
        long l27 = lArray[11] * lArray2[15] + lArray[12] * lArray2[14] + lArray[13] * lArray2[13] + lArray[14] * lArray2[12] + lArray[15] * lArray2[11];
        long l28 = lArray[12] * lArray2[15] + lArray[13] * lArray2[14] + lArray[14] * lArray2[13] + lArray[15] * lArray2[12];
        long l29 = lArray[13] * lArray2[15] + lArray[14] * lArray2[14] + lArray[15] * lArray2[13];
        long l30 = lArray[14] * lArray2[15] + lArray[15] * lArray2[14];
        long l31 = lArray[15] * lArray2[15];
        this.carryReduce(lArray3, l, l2, l3, l4, l5, l6, l7, l8, l9, l10, l11, l12, l13, l14, l15, l16, l17, l18, l19, l20, l21, l22, l23, l24, l25, l26, l27, l28, l29, l30, l31);
    }

    @Override
    protected void reduce(long[] lArray) {
        this.carryReduce(lArray, lArray[0], lArray[1], lArray[2], lArray[3], lArray[4], lArray[5], lArray[6], lArray[7], lArray[8], lArray[9], lArray[10], lArray[11], lArray[12], lArray[13], lArray[14], lArray[15]);
    }

    @Override
    protected void square(long[] lArray, long[] lArray2) {
        long l = lArray[0] * lArray[0];
        long l2 = 2L * (lArray[0] * lArray[1]);
        long l3 = 2L * (lArray[0] * lArray[2]) + lArray[1] * lArray[1];
        long l4 = 2L * (lArray[0] * lArray[3] + lArray[1] * lArray[2]);
        long l5 = 2L * (lArray[0] * lArray[4] + lArray[1] * lArray[3]) + lArray[2] * lArray[2];
        long l6 = 2L * (lArray[0] * lArray[5] + lArray[1] * lArray[4] + lArray[2] * lArray[3]);
        long l7 = 2L * (lArray[0] * lArray[6] + lArray[1] * lArray[5] + lArray[2] * lArray[4]) + lArray[3] * lArray[3];
        long l8 = 2L * (lArray[0] * lArray[7] + lArray[1] * lArray[6] + lArray[2] * lArray[5] + lArray[3] * lArray[4]);
        long l9 = 2L * (lArray[0] * lArray[8] + lArray[1] * lArray[7] + lArray[2] * lArray[6] + lArray[3] * lArray[5]) + lArray[4] * lArray[4];
        long l10 = 2L * (lArray[0] * lArray[9] + lArray[1] * lArray[8] + lArray[2] * lArray[7] + lArray[3] * lArray[6] + lArray[4] * lArray[5]);
        long l11 = 2L * (lArray[0] * lArray[10] + lArray[1] * lArray[9] + lArray[2] * lArray[8] + lArray[3] * lArray[7] + lArray[4] * lArray[6]) + lArray[5] * lArray[5];
        long l12 = 2L * (lArray[0] * lArray[11] + lArray[1] * lArray[10] + lArray[2] * lArray[9] + lArray[3] * lArray[8] + lArray[4] * lArray[7] + lArray[5] * lArray[6]);
        long l13 = 2L * (lArray[0] * lArray[12] + lArray[1] * lArray[11] + lArray[2] * lArray[10] + lArray[3] * lArray[9] + lArray[4] * lArray[8] + lArray[5] * lArray[7]) + lArray[6] * lArray[6];
        long l14 = 2L * (lArray[0] * lArray[13] + lArray[1] * lArray[12] + lArray[2] * lArray[11] + lArray[3] * lArray[10] + lArray[4] * lArray[9] + lArray[5] * lArray[8] + lArray[6] * lArray[7]);
        long l15 = 2L * (lArray[0] * lArray[14] + lArray[1] * lArray[13] + lArray[2] * lArray[12] + lArray[3] * lArray[11] + lArray[4] * lArray[10] + lArray[5] * lArray[9] + lArray[6] * lArray[8]) + lArray[7] * lArray[7];
        long l16 = 2L * (lArray[0] * lArray[15] + lArray[1] * lArray[14] + lArray[2] * lArray[13] + lArray[3] * lArray[12] + lArray[4] * lArray[11] + lArray[5] * lArray[10] + lArray[6] * lArray[9] + lArray[7] * lArray[8]);
        long l17 = 2L * (lArray[1] * lArray[15] + lArray[2] * lArray[14] + lArray[3] * lArray[13] + lArray[4] * lArray[12] + lArray[5] * lArray[11] + lArray[6] * lArray[10] + lArray[7] * lArray[9]) + lArray[8] * lArray[8];
        long l18 = 2L * (lArray[2] * lArray[15] + lArray[3] * lArray[14] + lArray[4] * lArray[13] + lArray[5] * lArray[12] + lArray[6] * lArray[11] + lArray[7] * lArray[10] + lArray[8] * lArray[9]);
        long l19 = 2L * (lArray[3] * lArray[15] + lArray[4] * lArray[14] + lArray[5] * lArray[13] + lArray[6] * lArray[12] + lArray[7] * lArray[11] + lArray[8] * lArray[10]) + lArray[9] * lArray[9];
        long l20 = 2L * (lArray[4] * lArray[15] + lArray[5] * lArray[14] + lArray[6] * lArray[13] + lArray[7] * lArray[12] + lArray[8] * lArray[11] + lArray[9] * lArray[10]);
        long l21 = 2L * (lArray[5] * lArray[15] + lArray[6] * lArray[14] + lArray[7] * lArray[13] + lArray[8] * lArray[12] + lArray[9] * lArray[11]) + lArray[10] * lArray[10];
        long l22 = 2L * (lArray[6] * lArray[15] + lArray[7] * lArray[14] + lArray[8] * lArray[13] + lArray[9] * lArray[12] + lArray[10] * lArray[11]);
        long l23 = 2L * (lArray[7] * lArray[15] + lArray[8] * lArray[14] + lArray[9] * lArray[13] + lArray[10] * lArray[12]) + lArray[11] * lArray[11];
        long l24 = 2L * (lArray[8] * lArray[15] + lArray[9] * lArray[14] + lArray[10] * lArray[13] + lArray[11] * lArray[12]);
        long l25 = 2L * (lArray[9] * lArray[15] + lArray[10] * lArray[14] + lArray[11] * lArray[13]) + lArray[12] * lArray[12];
        long l26 = 2L * (lArray[10] * lArray[15] + lArray[11] * lArray[14] + lArray[12] * lArray[13]);
        long l27 = 2L * (lArray[11] * lArray[15] + lArray[12] * lArray[14]) + lArray[13] * lArray[13];
        long l28 = 2L * (lArray[12] * lArray[15] + lArray[13] * lArray[14]);
        long l29 = 2L * (lArray[13] * lArray[15]) + lArray[14] * lArray[14];
        long l30 = 2L * (lArray[14] * lArray[15]);
        long l31 = lArray[15] * lArray[15];
        this.carryReduce(lArray2, l, l2, l3, l4, l5, l6, l7, l8, l9, l10, l11, l12, l13, l14, l15, l16, l17, l18, l19, l20, l21, l22, l23, l24, l25, l26, l27, l28, l29, l30, l31);
    }
}

