/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util.math.intpoly;

import java.math.BigInteger;
import sun.security.util.math.intpoly.IntegerPolynomial;

public class Curve25519OrderField
extends IntegerPolynomial {
    private static final int BITS_PER_LIMB = 26;
    private static final int NUM_LIMBS = 10;
    private static final int MAX_ADDS = 1;
    public static final BigInteger MODULUS = Curve25519OrderField.evaluateModulus();
    private static final long CARRY_ADD = 0x2000000L;
    private static final int LIMB_MASK = 0x3FFFFFF;

    public Curve25519OrderField() {
        super(26, 10, 1, MODULUS);
    }

    private static BigInteger evaluateModulus() {
        BigInteger bigInteger = BigInteger.valueOf(2L).pow(252);
        bigInteger = bigInteger.add(BigInteger.valueOf(16110573L));
        bigInteger = bigInteger.add(BigInteger.valueOf(2L).pow(26).multiply(BigInteger.valueOf(10012311L)));
        bigInteger = bigInteger.add(BigInteger.valueOf(2L).pow(52).multiply(BigInteger.valueOf(30238081L)));
        bigInteger = bigInteger.subtract(BigInteger.valueOf(2L).pow(78).multiply(BigInteger.valueOf(8746018L)));
        bigInteger = bigInteger.add(BigInteger.valueOf(2L).pow(104).multiply(BigInteger.valueOf(1367802L)));
        return bigInteger;
    }

    @Override
    protected void reduceIn(long[] lArray, long l, int n) {
        long l2 = -16110573L * l;
        int n2 = n - 10;
        lArray[n2] = lArray[n2] + (l2 << 8 & 0x3FFFFFFL);
        int n3 = n - 9;
        lArray[n3] = lArray[n3] + (l2 >> 18);
        long l3 = -10012311L * l;
        int n4 = n - 9;
        lArray[n4] = lArray[n4] + (l3 << 8 & 0x3FFFFFFL);
        int n5 = n - 8;
        lArray[n5] = lArray[n5] + (l3 >> 18);
        long l4 = -30238081L * l;
        int n6 = n - 8;
        lArray[n6] = lArray[n6] + (l4 << 8 & 0x3FFFFFFL);
        int n7 = n - 7;
        lArray[n7] = lArray[n7] + (l4 >> 18);
        long l5 = 8746018L * l;
        int n8 = n - 7;
        lArray[n8] = lArray[n8] + (l5 << 8 & 0x3FFFFFFL);
        int n9 = n - 6;
        lArray[n9] = lArray[n9] + (l5 >> 18);
        long l6 = -1367802L * l;
        int n10 = n - 6;
        lArray[n10] = lArray[n10] + (l6 << 8 & 0x3FFFFFFL);
        int n11 = n - 5;
        lArray[n11] = lArray[n11] + (l6 >> 18);
    }

    @Override
    protected void finalCarryReduceLast(long[] lArray) {
        long l = lArray[9] >> 18;
        lArray[9] = lArray[9] - (l << 18);
        long l2 = -16110573L * l;
        lArray[0] = lArray[0] + l2;
        l2 = -10012311L * l;
        lArray[1] = lArray[1] + l2;
        l2 = -30238081L * l;
        lArray[2] = lArray[2] + l2;
        l2 = 8746018L * l;
        lArray[3] = lArray[3] + l2;
        l2 = -1367802L * l;
        lArray[4] = lArray[4] + l2;
    }

    private void carryReduce(long[] lArray, long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8, long l9, long l10, long l11, long l12, long l13, long l14, long l15, long l16, long l17, long l18, long l19) {
        long l20 = 0L;
        long l21 = l + 0x2000000L >> 26;
        l -= l21 << 26;
        l2 += l21;
        l21 = l2 + 0x2000000L >> 26;
        l2 -= l21 << 26;
        l3 += l21;
        l21 = l3 + 0x2000000L >> 26;
        l3 -= l21 << 26;
        l4 += l21;
        l21 = l4 + 0x2000000L >> 26;
        l4 -= l21 << 26;
        l5 += l21;
        l21 = l5 + 0x2000000L >> 26;
        l5 -= l21 << 26;
        l6 += l21;
        l21 = l6 + 0x2000000L >> 26;
        l6 -= l21 << 26;
        l7 += l21;
        l21 = l7 + 0x2000000L >> 26;
        l7 -= l21 << 26;
        l8 += l21;
        l21 = l8 + 0x2000000L >> 26;
        l8 -= l21 << 26;
        l9 += l21;
        l21 = l9 + 0x2000000L >> 26;
        l9 -= l21 << 26;
        l10 += l21;
        l21 = l10 + 0x2000000L >> 26;
        l10 -= l21 << 26;
        l11 += l21;
        l21 = l11 + 0x2000000L >> 26;
        l11 -= l21 << 26;
        l12 += l21;
        l21 = l12 + 0x2000000L >> 26;
        l12 -= l21 << 26;
        l13 += l21;
        l21 = l13 + 0x2000000L >> 26;
        l13 -= l21 << 26;
        l14 += l21;
        l21 = l14 + 0x2000000L >> 26;
        l14 -= l21 << 26;
        l15 += l21;
        l21 = l15 + 0x2000000L >> 26;
        l15 -= l21 << 26;
        l16 += l21;
        l21 = l16 + 0x2000000L >> 26;
        l16 -= l21 << 26;
        l17 += l21;
        l21 = l17 + 0x2000000L >> 26;
        l17 -= l21 << 26;
        l18 += l21;
        l21 = l18 + 0x2000000L >> 26;
        l18 -= l21 << 26;
        l19 += l21;
        l21 = l19 + 0x2000000L >> 26;
        this.carryReduce0(lArray, l, l2, l3, l4, l5, l6, l7, l8, l9, l10, l11, l12, l13, l14, l15, l16, l17, l18, l19 -= l21 << 26, l20 += l21);
    }

    void carryReduce0(long[] lArray, long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8, long l9, long l10, long l11, long l12, long l13, long l14, long l15, long l16, long l17, long l18, long l19, long l20) {
        long l21 = -16110573L * l20;
        l10 += l21 << 8 & 0x3FFFFFFL;
        l11 += l21 >> 18;
        l21 = -10012311L * l20;
        l11 += l21 << 8 & 0x3FFFFFFL;
        l12 += l21 >> 18;
        l21 = -30238081L * l20;
        l12 += l21 << 8 & 0x3FFFFFFL;
        l13 += l21 >> 18;
        l21 = 8746018L * l20;
        l13 += l21 << 8 & 0x3FFFFFFL;
        l14 += l21 >> 18;
        l21 = -1367802L * l20;
        l14 += l21 << 8 & 0x3FFFFFFL;
        l15 += l21 >> 18;
        l21 = -16110573L * l19;
        l9 += l21 << 8 & 0x3FFFFFFL;
        l10 += l21 >> 18;
        l21 = -10012311L * l19;
        l10 += l21 << 8 & 0x3FFFFFFL;
        l11 += l21 >> 18;
        l21 = -30238081L * l19;
        l11 += l21 << 8 & 0x3FFFFFFL;
        l12 += l21 >> 18;
        l21 = 8746018L * l19;
        l12 += l21 << 8 & 0x3FFFFFFL;
        l13 += l21 >> 18;
        l21 = -1367802L * l19;
        l13 += l21 << 8 & 0x3FFFFFFL;
        l14 += l21 >> 18;
        l21 = -16110573L * l18;
        l8 += l21 << 8 & 0x3FFFFFFL;
        l9 += l21 >> 18;
        l21 = -10012311L * l18;
        l9 += l21 << 8 & 0x3FFFFFFL;
        l10 += l21 >> 18;
        l21 = -30238081L * l18;
        l10 += l21 << 8 & 0x3FFFFFFL;
        l11 += l21 >> 18;
        l21 = 8746018L * l18;
        l11 += l21 << 8 & 0x3FFFFFFL;
        l12 += l21 >> 18;
        l21 = -1367802L * l18;
        l12 += l21 << 8 & 0x3FFFFFFL;
        l13 += l21 >> 18;
        l21 = -16110573L * l17;
        l7 += l21 << 8 & 0x3FFFFFFL;
        l8 += l21 >> 18;
        l21 = -10012311L * l17;
        l8 += l21 << 8 & 0x3FFFFFFL;
        l9 += l21 >> 18;
        l21 = -30238081L * l17;
        l9 += l21 << 8 & 0x3FFFFFFL;
        l10 += l21 >> 18;
        l21 = 8746018L * l17;
        l10 += l21 << 8 & 0x3FFFFFFL;
        l11 += l21 >> 18;
        l21 = -1367802L * l17;
        l11 += l21 << 8 & 0x3FFFFFFL;
        l12 += l21 >> 18;
        l21 = -16110573L * l16;
        l6 += l21 << 8 & 0x3FFFFFFL;
        l7 += l21 >> 18;
        l21 = -10012311L * l16;
        l7 += l21 << 8 & 0x3FFFFFFL;
        l8 += l21 >> 18;
        l21 = -30238081L * l16;
        l8 += l21 << 8 & 0x3FFFFFFL;
        l9 += l21 >> 18;
        l21 = 8746018L * l16;
        l9 += l21 << 8 & 0x3FFFFFFL;
        l10 += l21 >> 18;
        l21 = -1367802L * l16;
        l10 += l21 << 8 & 0x3FFFFFFL;
        l11 += l21 >> 18;
        l21 = -16110573L * l15;
        l5 += l21 << 8 & 0x3FFFFFFL;
        l6 += l21 >> 18;
        l21 = -10012311L * l15;
        l6 += l21 << 8 & 0x3FFFFFFL;
        l7 += l21 >> 18;
        l21 = -30238081L * l15;
        l7 += l21 << 8 & 0x3FFFFFFL;
        l8 += l21 >> 18;
        l21 = 8746018L * l15;
        l8 += l21 << 8 & 0x3FFFFFFL;
        l9 += l21 >> 18;
        l21 = -1367802L * l15;
        l9 += l21 << 8 & 0x3FFFFFFL;
        l10 += l21 >> 18;
        l21 = -16110573L * l14;
        l4 += l21 << 8 & 0x3FFFFFFL;
        l5 += l21 >> 18;
        l21 = -10012311L * l14;
        l5 += l21 << 8 & 0x3FFFFFFL;
        l6 += l21 >> 18;
        l21 = -30238081L * l14;
        l6 += l21 << 8 & 0x3FFFFFFL;
        l7 += l21 >> 18;
        l21 = 8746018L * l14;
        l7 += l21 << 8 & 0x3FFFFFFL;
        l8 += l21 >> 18;
        l21 = -1367802L * l14;
        l8 += l21 << 8 & 0x3FFFFFFL;
        l9 += l21 >> 18;
        l21 = -16110573L * l13;
        l3 += l21 << 8 & 0x3FFFFFFL;
        l4 += l21 >> 18;
        l21 = -10012311L * l13;
        l4 += l21 << 8 & 0x3FFFFFFL;
        l5 += l21 >> 18;
        l21 = -30238081L * l13;
        l5 += l21 << 8 & 0x3FFFFFFL;
        l6 += l21 >> 18;
        l21 = 8746018L * l13;
        l6 += l21 << 8 & 0x3FFFFFFL;
        l7 += l21 >> 18;
        l21 = -1367802L * l13;
        l7 += l21 << 8 & 0x3FFFFFFL;
        l8 += l21 >> 18;
        l21 = -16110573L * l12;
        l2 += l21 << 8 & 0x3FFFFFFL;
        l3 += l21 >> 18;
        l21 = -10012311L * l12;
        l3 += l21 << 8 & 0x3FFFFFFL;
        l4 += l21 >> 18;
        l21 = -30238081L * l12;
        l4 += l21 << 8 & 0x3FFFFFFL;
        l5 += l21 >> 18;
        l21 = 8746018L * l12;
        l5 += l21 << 8 & 0x3FFFFFFL;
        l6 += l21 >> 18;
        l21 = -1367802L * l12;
        l6 += l21 << 8 & 0x3FFFFFFL;
        l7 += l21 >> 18;
        l21 = -16110573L * l11;
        l += l21 << 8 & 0x3FFFFFFL;
        l2 += l21 >> 18;
        l21 = -10012311L * l11;
        l2 += l21 << 8 & 0x3FFFFFFL;
        l3 += l21 >> 18;
        l21 = -30238081L * l11;
        l3 += l21 << 8 & 0x3FFFFFFL;
        l4 += l21 >> 18;
        l21 = 8746018L * l11;
        l4 += l21 << 8 & 0x3FFFFFFL;
        l5 += l21 >> 18;
        l21 = -1367802L * l11;
        l11 = 0L;
        this.carryReduce1(lArray, l, l2, l3, l4, l5 += l21 << 8 & 0x3FFFFFFL, l6 += l21 >> 18, l7, l8, l9, l10, l11, l12, l13, l14, l15, l16, l17, l18, l19, l20);
    }

    void carryReduce1(long[] lArray, long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8, long l9, long l10, long l11, long l12, long l13, long l14, long l15, long l16, long l17, long l18, long l19, long l20) {
        long l21 = l + 0x2000000L >> 26;
        l -= l21 << 26;
        l2 += l21;
        l21 = l2 + 0x2000000L >> 26;
        l2 -= l21 << 26;
        l3 += l21;
        l21 = l3 + 0x2000000L >> 26;
        l3 -= l21 << 26;
        l4 += l21;
        l21 = l4 + 0x2000000L >> 26;
        l4 -= l21 << 26;
        l5 += l21;
        l21 = l5 + 0x2000000L >> 26;
        l5 -= l21 << 26;
        l6 += l21;
        l21 = l6 + 0x2000000L >> 26;
        l6 -= l21 << 26;
        l7 += l21;
        l21 = l7 + 0x2000000L >> 26;
        l7 -= l21 << 26;
        l8 += l21;
        l21 = l8 + 0x2000000L >> 26;
        l8 -= l21 << 26;
        l9 += l21;
        l21 = l9 + 0x2000000L >> 26;
        l9 -= l21 << 26;
        l10 += l21;
        l21 = l10 + 0x2000000L >> 26;
        this.carryReduce2(lArray, l, l2, l3, l4, l5, l6, l7, l8, l9, l10 -= l21 << 26, l11 += l21, l12, l13, l14, l15, l16, l17, l18, l19, l20);
    }

    void carryReduce2(long[] lArray, long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8, long l9, long l10, long l11, long l12, long l13, long l14, long l15, long l16, long l17, long l18, long l19, long l20) {
        long l21 = -16110573L * l11;
        l += l21 << 8 & 0x3FFFFFFL;
        l2 += l21 >> 18;
        l21 = -10012311L * l11;
        l2 += l21 << 8 & 0x3FFFFFFL;
        l3 += l21 >> 18;
        l21 = -30238081L * l11;
        l3 += l21 << 8 & 0x3FFFFFFL;
        l4 += l21 >> 18;
        l21 = 8746018L * l11;
        l4 += l21 << 8 & 0x3FFFFFFL;
        l5 += l21 >> 18;
        l21 = -1367802L * l11;
        l5 += l21 << 8 & 0x3FFFFFFL;
        l6 += l21 >> 18;
        l21 = l + 0x2000000L >> 26;
        l -= l21 << 26;
        l2 += l21;
        l21 = l2 + 0x2000000L >> 26;
        l2 -= l21 << 26;
        l3 += l21;
        l21 = l3 + 0x2000000L >> 26;
        l3 -= l21 << 26;
        l4 += l21;
        l21 = l4 + 0x2000000L >> 26;
        l4 -= l21 << 26;
        l5 += l21;
        l21 = l5 + 0x2000000L >> 26;
        l5 -= l21 << 26;
        l6 += l21;
        l21 = l6 + 0x2000000L >> 26;
        l6 -= l21 << 26;
        l7 += l21;
        l21 = l7 + 0x2000000L >> 26;
        l7 -= l21 << 26;
        l8 += l21;
        l21 = l8 + 0x2000000L >> 26;
        l8 -= l21 << 26;
        l9 += l21;
        l21 = l9 + 0x2000000L >> 26;
        l9 -= l21 << 26;
        l10 += l21;
        lArray[0] = l;
        lArray[1] = l2;
        lArray[2] = l3;
        lArray[3] = l4;
        lArray[4] = l5;
        lArray[5] = l6;
        lArray[6] = l7;
        lArray[7] = l8;
        lArray[8] = l9;
        lArray[9] = l10;
    }

    private void carryReduce(long[] lArray, long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8, long l9, long l10) {
        long l11 = 0L;
        long l12 = l + 0x2000000L >> 26;
        l -= l12 << 26;
        l2 += l12;
        l12 = l2 + 0x2000000L >> 26;
        l2 -= l12 << 26;
        l3 += l12;
        l12 = l3 + 0x2000000L >> 26;
        l3 -= l12 << 26;
        l4 += l12;
        l12 = l4 + 0x2000000L >> 26;
        l4 -= l12 << 26;
        l5 += l12;
        l12 = l5 + 0x2000000L >> 26;
        l5 -= l12 << 26;
        l6 += l12;
        l12 = l6 + 0x2000000L >> 26;
        l6 -= l12 << 26;
        l7 += l12;
        l12 = l7 + 0x2000000L >> 26;
        l7 -= l12 << 26;
        l8 += l12;
        l12 = l8 + 0x2000000L >> 26;
        l8 -= l12 << 26;
        l9 += l12;
        l12 = l9 + 0x2000000L >> 26;
        l9 -= l12 << 26;
        l10 += l12;
        l12 = l10 + 0x2000000L >> 26;
        this.carryReduce0(lArray, l, l2, l3, l4, l5, l6, l7, l8, l9, l10 -= l12 << 26, l11 += l12);
    }

    void carryReduce0(long[] lArray, long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8, long l9, long l10, long l11) {
        long l12 = -16110573L * l11;
        l += l12 << 8 & 0x3FFFFFFL;
        l2 += l12 >> 18;
        l12 = -10012311L * l11;
        l2 += l12 << 8 & 0x3FFFFFFL;
        l3 += l12 >> 18;
        l12 = -30238081L * l11;
        l3 += l12 << 8 & 0x3FFFFFFL;
        l4 += l12 >> 18;
        l12 = 8746018L * l11;
        l4 += l12 << 8 & 0x3FFFFFFL;
        l5 += l12 >> 18;
        l12 = -1367802L * l11;
        l5 += l12 << 8 & 0x3FFFFFFL;
        l6 += l12 >> 18;
        l12 = l + 0x2000000L >> 26;
        l -= l12 << 26;
        l2 += l12;
        l12 = l2 + 0x2000000L >> 26;
        l2 -= l12 << 26;
        l3 += l12;
        l12 = l3 + 0x2000000L >> 26;
        l3 -= l12 << 26;
        l4 += l12;
        l12 = l4 + 0x2000000L >> 26;
        l4 -= l12 << 26;
        l5 += l12;
        l12 = l5 + 0x2000000L >> 26;
        l5 -= l12 << 26;
        l6 += l12;
        l12 = l6 + 0x2000000L >> 26;
        l6 -= l12 << 26;
        l7 += l12;
        l12 = l7 + 0x2000000L >> 26;
        l7 -= l12 << 26;
        l8 += l12;
        l12 = l8 + 0x2000000L >> 26;
        l8 -= l12 << 26;
        l9 += l12;
        l12 = l9 + 0x2000000L >> 26;
        l9 -= l12 << 26;
        l10 += l12;
        lArray[0] = l;
        lArray[1] = l2;
        lArray[2] = l3;
        lArray[3] = l4;
        lArray[4] = l5;
        lArray[5] = l6;
        lArray[6] = l7;
        lArray[7] = l8;
        lArray[8] = l9;
        lArray[9] = l10;
    }

    @Override
    protected void mult(long[] lArray, long[] lArray2, long[] lArray3) {
        long l = lArray[0] * lArray2[0];
        long l2 = lArray[0] * lArray2[1] + lArray[1] * lArray2[0];
        long l3 = lArray[0] * lArray2[2] + lArray[1] * lArray2[1] + lArray[2] * lArray2[0];
        long l4 = lArray[0] * lArray2[3] + lArray[1] * lArray2[2] + lArray[2] * lArray2[1] + lArray[3] * lArray2[0];
        long l5 = lArray[0] * lArray2[4] + lArray[1] * lArray2[3] + lArray[2] * lArray2[2] + lArray[3] * lArray2[1] + lArray[4] * lArray2[0];
        long l6 = lArray[0] * lArray2[5] + lArray[1] * lArray2[4] + lArray[2] * lArray2[3] + lArray[3] * lArray2[2] + lArray[4] * lArray2[1] + lArray[5] * lArray2[0];
        long l7 = lArray[0] * lArray2[6] + lArray[1] * lArray2[5] + lArray[2] * lArray2[4] + lArray[3] * lArray2[3] + lArray[4] * lArray2[2] + lArray[5] * lArray2[1] + lArray[6] * lArray2[0];
        long l8 = lArray[0] * lArray2[7] + lArray[1] * lArray2[6] + lArray[2] * lArray2[5] + lArray[3] * lArray2[4] + lArray[4] * lArray2[3] + lArray[5] * lArray2[2] + lArray[6] * lArray2[1] + lArray[7] * lArray2[0];
        long l9 = lArray[0] * lArray2[8] + lArray[1] * lArray2[7] + lArray[2] * lArray2[6] + lArray[3] * lArray2[5] + lArray[4] * lArray2[4] + lArray[5] * lArray2[3] + lArray[6] * lArray2[2] + lArray[7] * lArray2[1] + lArray[8] * lArray2[0];
        long l10 = lArray[0] * lArray2[9] + lArray[1] * lArray2[8] + lArray[2] * lArray2[7] + lArray[3] * lArray2[6] + lArray[4] * lArray2[5] + lArray[5] * lArray2[4] + lArray[6] * lArray2[3] + lArray[7] * lArray2[2] + lArray[8] * lArray2[1] + lArray[9] * lArray2[0];
        long l11 = lArray[1] * lArray2[9] + lArray[2] * lArray2[8] + lArray[3] * lArray2[7] + lArray[4] * lArray2[6] + lArray[5] * lArray2[5] + lArray[6] * lArray2[4] + lArray[7] * lArray2[3] + lArray[8] * lArray2[2] + lArray[9] * lArray2[1];
        long l12 = lArray[2] * lArray2[9] + lArray[3] * lArray2[8] + lArray[4] * lArray2[7] + lArray[5] * lArray2[6] + lArray[6] * lArray2[5] + lArray[7] * lArray2[4] + lArray[8] * lArray2[3] + lArray[9] * lArray2[2];
        long l13 = lArray[3] * lArray2[9] + lArray[4] * lArray2[8] + lArray[5] * lArray2[7] + lArray[6] * lArray2[6] + lArray[7] * lArray2[5] + lArray[8] * lArray2[4] + lArray[9] * lArray2[3];
        long l14 = lArray[4] * lArray2[9] + lArray[5] * lArray2[8] + lArray[6] * lArray2[7] + lArray[7] * lArray2[6] + lArray[8] * lArray2[5] + lArray[9] * lArray2[4];
        long l15 = lArray[5] * lArray2[9] + lArray[6] * lArray2[8] + lArray[7] * lArray2[7] + lArray[8] * lArray2[6] + lArray[9] * lArray2[5];
        long l16 = lArray[6] * lArray2[9] + lArray[7] * lArray2[8] + lArray[8] * lArray2[7] + lArray[9] * lArray2[6];
        long l17 = lArray[7] * lArray2[9] + lArray[8] * lArray2[8] + lArray[9] * lArray2[7];
        long l18 = lArray[8] * lArray2[9] + lArray[9] * lArray2[8];
        long l19 = lArray[9] * lArray2[9];
        this.carryReduce(lArray3, l, l2, l3, l4, l5, l6, l7, l8, l9, l10, l11, l12, l13, l14, l15, l16, l17, l18, l19);
    }

    @Override
    protected void reduce(long[] lArray) {
        this.carryReduce(lArray, lArray[0], lArray[1], lArray[2], lArray[3], lArray[4], lArray[5], lArray[6], lArray[7], lArray[8], lArray[9]);
    }

    @Override
    protected void square(long[] lArray, long[] lArray2) {
        long l = lArray[0] * lArray[0];
        long l2 = 2L * (lArray[0] * lArray[1]);
        long l3 = 2L * (lArray[0] * lArray[2]) + lArray[1] * lArray[1];
        long l4 = 2L * (lArray[0] * lArray[3] + lArray[1] * lArray[2]);
        long l5 = 2L * (lArray[0] * lArray[4] + lArray[1] * lArray[3]) + lArray[2] * lArray[2];
        long l6 = 2L * (lArray[0] * lArray[5] + lArray[1] * lArray[4] + lArray[2] * lArray[3]);
        long l7 = 2L * (lArray[0] * lArray[6] + lArray[1] * lArray[5] + lArray[2] * lArray[4]) + lArray[3] * lArray[3];
        long l8 = 2L * (lArray[0] * lArray[7] + lArray[1] * lArray[6] + lArray[2] * lArray[5] + lArray[3] * lArray[4]);
        long l9 = 2L * (lArray[0] * lArray[8] + lArray[1] * lArray[7] + lArray[2] * lArray[6] + lArray[3] * lArray[5]) + lArray[4] * lArray[4];
        long l10 = 2L * (lArray[0] * lArray[9] + lArray[1] * lArray[8] + lArray[2] * lArray[7] + lArray[3] * lArray[6] + lArray[4] * lArray[5]);
        long l11 = 2L * (lArray[1] * lArray[9] + lArray[2] * lArray[8] + lArray[3] * lArray[7] + lArray[4] * lArray[6]) + lArray[5] * lArray[5];
        long l12 = 2L * (lArray[2] * lArray[9] + lArray[3] * lArray[8] + lArray[4] * lArray[7] + lArray[5] * lArray[6]);
        long l13 = 2L * (lArray[3] * lArray[9] + lArray[4] * lArray[8] + lArray[5] * lArray[7]) + lArray[6] * lArray[6];
        long l14 = 2L * (lArray[4] * lArray[9] + lArray[5] * lArray[8] + lArray[6] * lArray[7]);
        long l15 = 2L * (lArray[5] * lArray[9] + lArray[6] * lArray[8]) + lArray[7] * lArray[7];
        long l16 = 2L * (lArray[6] * lArray[9] + lArray[7] * lArray[8]);
        long l17 = 2L * (lArray[7] * lArray[9]) + lArray[8] * lArray[8];
        long l18 = 2L * (lArray[8] * lArray[9]);
        long l19 = lArray[9] * lArray[9];
        this.carryReduce(lArray2, l, l2, l3, l4, l5, l6, l7, l8, l9, l10, l11, l12, l13, l14, l15, l16, l17, l18, l19);
    }
}

