/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.security.DigestException;
import java.security.MessageDigestSpi;
import java.security.ProviderException;
import java.util.Arrays;
import java.util.Objects;
import sun.security.provider.MD5;
import sun.security.provider.SHA;
import sun.security.provider.SHA2;
import sun.security.provider.SHA5;

abstract class DigestBase
extends MessageDigestSpi
implements Cloneable {
    private byte[] oneByte;
    private final String algorithm;
    private final int digestLength;
    private final int blockSize;
    byte[] buffer;
    private int bufOfs;
    long bytesProcessed;
    static final byte[] padding = new byte[136];

    DigestBase(String string, int n, int n2) {
        this.algorithm = string;
        this.digestLength = n;
        this.blockSize = n2;
        this.buffer = new byte[n2];
    }

    @Override
    protected final int engineGetDigestLength() {
        return this.digestLength;
    }

    @Override
    protected final void engineUpdate(byte by) {
        if (this.oneByte == null) {
            this.oneByte = new byte[1];
        }
        this.oneByte[0] = by;
        this.engineUpdate(this.oneByte, 0, 1);
    }

    @Override
    protected final void engineUpdate(byte[] byArray, int n, int n2) {
        int n3;
        if (n2 == 0) {
            return;
        }
        if (n < 0 || n2 < 0 || n > byArray.length - n2) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (this.bytesProcessed < 0L) {
            this.engineReset();
        }
        this.bytesProcessed += (long)n2;
        if (this.bufOfs != 0) {
            n3 = Math.min(n2, this.blockSize - this.bufOfs);
            System.arraycopy(byArray, n, this.buffer, this.bufOfs, n3);
            this.bufOfs += n3;
            n += n3;
            n2 -= n3;
            if (this.bufOfs >= this.blockSize) {
                this.implCompress(this.buffer, 0);
                this.bufOfs = 0;
            }
        }
        if (n2 >= this.blockSize) {
            n3 = n + n2;
            n = this.implCompressMultiBlock(byArray, n, n3 - this.blockSize);
            n2 = n3 - n;
        }
        if (n2 > 0) {
            System.arraycopy(byArray, n, this.buffer, 0, n2);
            this.bufOfs = n2;
        }
    }

    private int implCompressMultiBlock(byte[] byArray, int n, int n2) {
        this.implCompressMultiBlockCheck(byArray, n, n2);
        if (this instanceof SHA2) {
            int[] nArray = ((SHA2)this).state();
            return this.implCompressMultiBlockSHA2(byArray, n, n2, nArray);
        }
        if (this instanceof SHA5) {
            long[] lArray = ((SHA5)this).state();
            return this.implCompressMultiBlockSHA5(byArray, n, n2, lArray);
        }
        if (this instanceof SHA) {
            int[] nArray = ((SHA)this).state();
            return this.implCompressMultiBlockSHA1(byArray, n, n2, nArray);
        }
        if (this instanceof MD5) {
            int[] nArray = ((MD5)this).state();
            return this.implCompressMultiBlockMD5(byArray, n, n2, nArray);
        }
        return this.implCompressMultiBlock0(byArray, n, n2);
    }

    private int implCompressMultiBlockSHA2(byte[] byArray, int n, int n2, int[] nArray) {
        return this.implCompressMultiBlock0(byArray, n, n2);
    }

    private int implCompressMultiBlockSHA5(byte[] byArray, int n, int n2, long[] lArray) {
        return this.implCompressMultiBlock0(byArray, n, n2);
    }

    private int implCompressMultiBlockMD5(byte[] byArray, int n, int n2, int[] nArray) {
        return this.implCompressMultiBlock0(byArray, n, n2);
    }

    private int implCompressMultiBlockSHA1(byte[] byArray, int n, int n2, int[] nArray) {
        return this.implCompressMultiBlock0(byArray, n, n2);
    }

    private int implCompressMultiBlock0(byte[] byArray, int n, int n2) {
        while (n <= n2) {
            this.implCompress(byArray, n);
            n += this.blockSize;
        }
        return n;
    }

    private void implCompressMultiBlockCheck(byte[] byArray, int n, int n2) {
        if (n2 < 0) {
            return;
        }
        Objects.requireNonNull(byArray);
        if (n < 0 || n >= byArray.length) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        int n3 = n2 / this.blockSize * this.blockSize + this.blockSize - 1;
        if (n3 >= byArray.length) {
            throw new ArrayIndexOutOfBoundsException(n3);
        }
    }

    @Override
    protected final void engineReset() {
        if (this.bytesProcessed == 0L) {
            return;
        }
        this.implReset();
        this.bufOfs = 0;
        this.bytesProcessed = 0L;
        Arrays.fill(this.buffer, (byte)0);
    }

    @Override
    protected final byte[] engineDigest() {
        byte[] byArray = new byte[this.digestLength];
        try {
            this.engineDigest(byArray, 0, byArray.length);
        }
        catch (DigestException digestException) {
            throw (ProviderException)new ProviderException("Internal error").initCause(digestException);
        }
        return byArray;
    }

    @Override
    protected final int engineDigest(byte[] byArray, int n, int n2) throws DigestException {
        if (n2 < this.digestLength) {
            throw new DigestException("Length must be at least " + this.digestLength + " for " + this.algorithm + "digests");
        }
        if (n < 0 || n2 < 0 || n > byArray.length - n2) {
            throw new DigestException("Buffer too short to store digest");
        }
        if (this.bytesProcessed < 0L) {
            this.engineReset();
        }
        this.implDigest(byArray, n);
        this.bytesProcessed = -1L;
        return this.digestLength;
    }

    abstract void implCompress(byte[] var1, int var2);

    abstract void implDigest(byte[] var1, int var2);

    abstract void implReset();

    @Override
    public Object clone() throws CloneNotSupportedException {
        DigestBase digestBase = (DigestBase)super.clone();
        digestBase.buffer = (byte[])digestBase.buffer.clone();
        return digestBase;
    }

    static {
        DigestBase.padding[0] = -128;
    }
}

