/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.marlin;

import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.security.AccessController;
import java.util.Vector;
import sun.java2d.marlin.MarlinConst;
import sun.java2d.marlin.MarlinUtils;
import sun.misc.ThreadGroupUtils;
import sun.misc.Unsafe;

final class OffHeapArray {
    static final Unsafe UNSAFE;
    static final int SIZE_INT;
    private static final ReferenceQueue<Object> rdrQueue;
    private static final Vector<OffHeapReference> refList;
    long address;
    long length;
    int used;

    OffHeapArray(Object object, long l) {
        this.address = UNSAFE.allocateMemory(l);
        this.length = l;
        this.used = 0;
        if (MarlinConst.LOG_UNSAFE_MALLOC) {
            MarlinUtils.logInfo(System.currentTimeMillis() + ": OffHeapArray.allocateMemory = " + l + " to addr = " + this.address);
        }
        refList.add(new OffHeapReference(object, this));
    }

    void resize(long l) {
        this.address = UNSAFE.reallocateMemory(this.address, l);
        this.length = l;
        if (MarlinConst.LOG_UNSAFE_MALLOC) {
            MarlinUtils.logInfo(System.currentTimeMillis() + ": OffHeapArray.reallocateMemory = " + l + " to addr = " + this.address);
        }
    }

    void free() {
        UNSAFE.freeMemory(this.address);
        if (MarlinConst.LOG_UNSAFE_MALLOC) {
            MarlinUtils.logInfo(System.currentTimeMillis() + ": OffHeapEdgeArray.free = " + this.length + " at addr = " + this.address);
        }
        this.address = 0L;
    }

    void fill(byte by) {
        UNSAFE.setMemory(this.address, this.length, by);
    }

    static {
        rdrQueue = new ReferenceQueue();
        refList = new Vector(32);
        UNSAFE = Unsafe.getUnsafe();
        SIZE_INT = Unsafe.ARRAY_INT_INDEX_SCALE;
        AccessController.doPrivileged(() -> {
            ThreadGroup threadGroup = ThreadGroupUtils.getRootThreadGroup();
            Thread thread = new Thread(threadGroup, (Runnable)new OffHeapDisposer(), "MarlinRenderer Disposer");
            thread.setContextClassLoader(null);
            thread.setDaemon(true);
            thread.setPriority(10);
            thread.start();
            return null;
        });
    }

    static final class OffHeapDisposer
    implements Runnable {
        OffHeapDisposer() {
        }

        @Override
        public void run() {
            Thread thread = Thread.currentThread();
            while (!thread.isInterrupted()) {
                try {
                    OffHeapReference offHeapReference = (OffHeapReference)rdrQueue.remove();
                    offHeapReference.dispose();
                    refList.remove(offHeapReference);
                }
                catch (InterruptedException interruptedException) {
                    MarlinUtils.logException("OffHeapDisposer interrupted:", interruptedException);
                }
            }
        }
    }

    static final class OffHeapReference
    extends PhantomReference<Object> {
        private final OffHeapArray array;

        OffHeapReference(Object object, OffHeapArray offHeapArray) {
            super(object, rdrQueue);
            this.array = offHeapArray;
        }

        void dispose() {
            this.array.free();
        }
    }
}

