/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.marlin;

import java.awt.geom.Path2D;
import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicInteger;
import sun.awt.geom.PathConsumer2D;
import sun.java2d.ReentrantContext;
import sun.java2d.marlin.ArrayCacheConst;
import sun.java2d.marlin.ByteArrayCache;
import sun.java2d.marlin.DCollinearSimplifier;
import sun.java2d.marlin.DCurve;
import sun.java2d.marlin.DDasher;
import sun.java2d.marlin.DMarlinRenderingEngine;
import sun.java2d.marlin.DPathConsumer2D;
import sun.java2d.marlin.DPathSimplifier;
import sun.java2d.marlin.DRenderer;
import sun.java2d.marlin.DStroker;
import sun.java2d.marlin.DTransformingPathConsumer2D;
import sun.java2d.marlin.DoubleArrayCache;
import sun.java2d.marlin.IRendererContext;
import sun.java2d.marlin.IntArrayCache;
import sun.java2d.marlin.MarlinCache;
import sun.java2d.marlin.MarlinTileGenerator;
import sun.java2d.marlin.MarlinUtils;
import sun.java2d.marlin.OffHeapArray;
import sun.java2d.marlin.RendererStats;

final class DRendererContext
extends ReentrantContext
implements IRendererContext {
    private static final AtomicInteger CTX_COUNT = new AtomicInteger(1);
    private final Object cleanerObj;
    boolean dirty = false;
    final double[] double6 = new double[6];
    final DCurve curve = new DCurve();
    final DMarlinRenderingEngine.NormalizingPathIterator nPCPathIterator;
    final DMarlinRenderingEngine.NormalizingPathIterator nPQPathIterator;
    final DTransformingPathConsumer2D transformerPC2D;
    private WeakReference<Path2D.Double> refPath2D = null;
    final DRenderer renderer;
    final DStroker stroker;
    final DCollinearSimplifier simplifier = new DCollinearSimplifier();
    final DPathSimplifier pathSimplifier = new DPathSimplifier();
    final DDasher dasher;
    final MarlinTileGenerator ptg;
    final MarlinCache cache;
    int stroking = 0;
    boolean doClip = false;
    boolean closedPath = false;
    final double[] clipRect = new double[4];
    double clipInvScale = 0.0;
    final DTransformingPathConsumer2D.CurveBasicMonotonizer monotonizer;
    final DTransformingPathConsumer2D.CurveClipSplitter curveClipSplitter;
    private final IntArrayCache cleanIntCache = new IntArrayCache(true, 5);
    private final IntArrayCache dirtyIntCache = new IntArrayCache(false, 5);
    private final DoubleArrayCache dirtyDoubleCache = new DoubleArrayCache(false, 4);
    private final ByteArrayCache dirtyByteCache = new ByteArrayCache(false, 2);
    final RendererStats stats;
    final PathConsumer2DAdapter p2dAdapter = new PathConsumer2DAdapter();

    static DRendererContext createContext() {
        return new DRendererContext("ctx" + Integer.toString(CTX_COUNT.getAndIncrement()));
    }

    DRendererContext(String string) {
        if (LOG_CREATE_CONTEXT) {
            MarlinUtils.logInfo("new RendererContext = " + string);
        }
        this.cleanerObj = new Object();
        if (DO_STATS) {
            this.stats = RendererStats.createInstance(this.cleanerObj, string);
            this.stats.cacheStats = new ArrayCacheConst.CacheStats[]{this.cleanIntCache.stats, this.dirtyIntCache.stats, this.dirtyDoubleCache.stats, this.dirtyByteCache.stats};
        } else {
            this.stats = null;
        }
        this.nPCPathIterator = new DMarlinRenderingEngine.NormalizingPathIterator.NearestPixelCenter(this.double6);
        this.nPQPathIterator = new DMarlinRenderingEngine.NormalizingPathIterator.NearestPixelQuarter(this.double6);
        this.monotonizer = new DTransformingPathConsumer2D.CurveBasicMonotonizer(this);
        this.curveClipSplitter = new DTransformingPathConsumer2D.CurveClipSplitter(this);
        this.transformerPC2D = new DTransformingPathConsumer2D(this);
        this.cache = new MarlinCache(this);
        this.renderer = new DRenderer(this);
        this.ptg = new MarlinTileGenerator(this.stats, this.renderer, this.cache);
        this.stroker = new DStroker(this);
        this.dasher = new DDasher(this);
    }

    void dispose() {
        if (DO_STATS) {
            if (this.stats.totalOffHeap > this.stats.totalOffHeapMax) {
                this.stats.totalOffHeapMax = this.stats.totalOffHeap;
            }
            this.stats.totalOffHeap = 0L;
        }
        this.stroking = 0;
        this.doClip = false;
        this.closedPath = false;
        this.clipInvScale = 0.0;
        if (this.dirty) {
            this.nPCPathIterator.dispose();
            this.nPQPathIterator.dispose();
            this.dasher.dispose();
            this.stroker.dispose();
            this.dirty = false;
        }
    }

    Path2D.Double getPath2D() {
        Path2D.Double double_;
        Path2D.Double double_2 = double_ = this.refPath2D != null ? this.refPath2D.get() : null;
        if (double_ == null) {
            double_ = new Path2D.Double(1, INITIAL_EDGES_COUNT);
            this.refPath2D = new WeakReference<Path2D.Double>(double_);
        }
        double_.reset();
        return double_;
    }

    @Override
    public RendererStats stats() {
        return this.stats;
    }

    @Override
    public OffHeapArray newOffHeapArray(long l) {
        if (DO_STATS) {
            this.stats.totalOffHeapInitial += l;
        }
        return new OffHeapArray(this.cleanerObj, l);
    }

    @Override
    public IntArrayCache.Reference newCleanIntArrayRef(int n) {
        return this.cleanIntCache.createRef(n);
    }

    IntArrayCache.Reference newDirtyIntArrayRef(int n) {
        return this.dirtyIntCache.createRef(n);
    }

    DoubleArrayCache.Reference newDirtyDoubleArrayRef(int n) {
        return this.dirtyDoubleCache.createRef(n);
    }

    ByteArrayCache.Reference newDirtyByteArrayRef(int n) {
        return this.dirtyByteCache.createRef(n);
    }

    static final class PathConsumer2DAdapter
    implements DPathConsumer2D {
        private PathConsumer2D out;

        PathConsumer2DAdapter() {
        }

        PathConsumer2DAdapter init(PathConsumer2D pathConsumer2D) {
            this.out = pathConsumer2D;
            return this;
        }

        @Override
        public void moveTo(double d, double d2) {
            this.out.moveTo((float)d, (float)d2);
        }

        @Override
        public void lineTo(double d, double d2) {
            this.out.lineTo((float)d, (float)d2);
        }

        @Override
        public void closePath() {
            this.out.closePath();
        }

        @Override
        public void pathDone() {
            this.out.pathDone();
        }

        @Override
        public void curveTo(double d, double d2, double d3, double d4, double d5, double d6) {
            this.out.curveTo((float)d, (float)d2, (float)d3, (float)d4, (float)d5, (float)d6);
        }

        @Override
        public void quadTo(double d, double d2, double d3, double d4) {
            this.out.quadTo((float)d, (float)d2, (float)d3, (float)d4);
        }

        @Override
        public long getNativeConsumer() {
            throw new InternalError("Not using a native peer");
        }
    }
}

