/*
 * Decompiled with CFR 0.152.
 */
package org.openeddsa.java.security.spec;

import java.security.InvalidParameterException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Objects;
import java.util.Optional;

public class EdDSAParameterSpec
implements AlgorithmParameterSpec {
    private final boolean prehash;
    private final byte[] context;

    public EdDSAParameterSpec(boolean bl) {
        this.prehash = bl;
        this.context = null;
    }

    public EdDSAParameterSpec(boolean bl, byte[] byArray) {
        Objects.requireNonNull(byArray, "context may not be null");
        if (byArray.length > 255) {
            throw new InvalidParameterException("context length cannot be greater than 255");
        }
        this.prehash = bl;
        this.context = (byte[])byArray.clone();
    }

    public boolean isPrehash() {
        return this.prehash;
    }

    public Optional<byte[]> getContext() {
        if (this.context == null) {
            return Optional.empty();
        }
        return Optional.of(this.context.clone());
    }
}

