/*
 * Decompiled with CFR 0.152.
 */
package javax.management.remote.rmi;

import com.sun.jmx.remote.internal.ArrayNotificationBuffer;
import com.sun.jmx.remote.internal.NotificationBuffer;
import com.sun.jmx.remote.security.JMXPluggableAuthenticator;
import com.sun.jmx.remote.util.ClassLogger;
import java.io.Closeable;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.rmi.Remote;
import java.rmi.server.RemoteServer;
import java.rmi.server.ServerNotActiveException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.remote.JMXAuthenticator;
import javax.management.remote.rmi.RMIConnection;
import javax.management.remote.rmi.RMIConnectorServer;
import javax.management.remote.rmi.RMIServer;
import javax.security.auth.Subject;

public abstract class RMIServerImpl
implements Closeable,
RMIServer {
    private static final ClassLogger logger = new ClassLogger("javax.management.remote.rmi", "RMIServerImpl");
    private final List<WeakReference<RMIConnection>> clientList = new ArrayList<WeakReference<RMIConnection>>();
    private ClassLoader cl;
    private MBeanServer mbeanServer;
    private final Map<String, ?> env;
    private RMIConnectorServer connServer;
    private static int connectionIdNumber;
    private NotificationBuffer notifBuffer;

    public RMIServerImpl(Map<String, ?> map) {
        this.env = map == null ? Collections.emptyMap() : map;
    }

    void setRMIConnectorServer(RMIConnectorServer rMIConnectorServer) throws IOException {
        this.connServer = rMIConnectorServer;
    }

    protected abstract void export() throws IOException;

    public abstract Remote toStub() throws IOException;

    public synchronized void setDefaultClassLoader(ClassLoader classLoader) {
        this.cl = classLoader;
    }

    public synchronized ClassLoader getDefaultClassLoader() {
        return this.cl;
    }

    public synchronized void setMBeanServer(MBeanServer mBeanServer) {
        this.mbeanServer = mBeanServer;
    }

    public synchronized MBeanServer getMBeanServer() {
        return this.mbeanServer;
    }

    @Override
    public String getVersion() {
        try {
            return "1.0 java_runtime_" + System.getProperty("java.runtime.version");
        }
        catch (SecurityException securityException) {
            return "1.0 ";
        }
    }

    @Override
    public RMIConnection newClient(Object object) throws IOException {
        return this.doNewClient(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RMIConnection doNewClient(Object object) throws IOException {
        boolean bl = logger.traceOn();
        if (bl) {
            logger.trace("newClient", "making new client");
        }
        if (this.getMBeanServer() == null) {
            throw new IllegalStateException("Not attached to an MBean server");
        }
        Subject subject = null;
        JMXAuthenticator jMXAuthenticator = (JMXAuthenticator)this.env.get("jmx.remote.authenticator");
        if (jMXAuthenticator == null && (this.env.get("jmx.remote.x.password.file") != null || this.env.get("jmx.remote.x.login.config") != null)) {
            jMXAuthenticator = new JMXPluggableAuthenticator(this.env);
        }
        if (jMXAuthenticator != null) {
            if (bl) {
                logger.trace("newClient", "got authenticator: " + jMXAuthenticator.getClass().getName());
            }
            try {
                subject = jMXAuthenticator.authenticate(object);
            }
            catch (SecurityException securityException) {
                logger.trace("newClient", "Authentication failed: " + securityException);
                throw securityException;
            }
        }
        if (bl) {
            if (subject != null) {
                logger.trace("newClient", "subject is not null");
            } else {
                logger.trace("newClient", "no subject");
            }
        }
        String string = RMIServerImpl.makeConnectionId(this.getProtocol(), subject);
        if (bl) {
            logger.trace("newClient", "making new connection: " + string);
        }
        RMIConnection rMIConnection = this.makeClient(string, subject);
        this.dropDeadReferences();
        WeakReference<RMIConnection> weakReference = new WeakReference<RMIConnection>(rMIConnection);
        List<WeakReference<RMIConnection>> list = this.clientList;
        synchronized (list) {
            this.clientList.add(weakReference);
        }
        this.connServer.connectionOpened(string, "Connection opened", null);
        list = this.clientList;
        synchronized (list) {
            if (!this.clientList.contains(weakReference)) {
                throw new IOException("The connection is refused.");
            }
        }
        if (bl) {
            logger.trace("newClient", "new connection done: " + string);
        }
        return rMIConnection;
    }

    protected abstract RMIConnection makeClient(String var1, Subject var2) throws IOException;

    protected abstract void closeClient(RMIConnection var1) throws IOException;

    protected abstract String getProtocol();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clientClosed(RMIConnection rMIConnection) throws IOException {
        boolean bl = logger.debugOn();
        if (bl) {
            logger.trace("clientClosed", "client=" + rMIConnection);
        }
        if (rMIConnection == null) {
            throw new NullPointerException("Null client");
        }
        List<WeakReference<RMIConnection>> list = this.clientList;
        synchronized (list) {
            this.dropDeadReferences();
            Iterator<WeakReference<RMIConnection>> iterator = this.clientList.iterator();
            while (iterator.hasNext()) {
                WeakReference<RMIConnection> weakReference = iterator.next();
                if (weakReference.get() != rMIConnection) continue;
                iterator.remove();
                break;
            }
        }
        if (bl) {
            logger.trace("clientClosed", "closing client.");
        }
        this.closeClient(rMIConnection);
        if (bl) {
            logger.trace("clientClosed", "sending notif");
        }
        this.connServer.connectionClosed(rMIConnection.getConnectionId(), "Client connection closed", null);
        if (bl) {
            logger.trace("clientClosed", "done");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws IOException {
        boolean bl = logger.traceOn();
        boolean bl2 = logger.debugOn();
        if (bl) {
            logger.trace("close", "closing");
        }
        IOException iOException = null;
        try {
            if (bl2) {
                logger.debug("close", "closing Server");
            }
            this.closeServer();
        }
        catch (IOException iOException2) {
            if (bl) {
                logger.trace("close", "Failed to close server: " + iOException2);
            }
            if (bl2) {
                logger.debug("close", iOException2);
            }
            iOException = iOException2;
        }
        if (bl2) {
            logger.debug("close", "closing Clients");
        }
        while (true) {
            List<WeakReference<RMIConnection>> list = this.clientList;
            synchronized (list) {
                if (bl2) {
                    logger.debug("close", "droping dead references");
                }
                this.dropDeadReferences();
                if (bl2) {
                    logger.debug("close", "client count: " + this.clientList.size());
                }
                if (this.clientList.size() == 0) {
                    break;
                }
                Iterator<WeakReference<RMIConnection>> iterator = this.clientList.iterator();
                while (iterator.hasNext()) {
                    WeakReference<RMIConnection> weakReference = iterator.next();
                    RMIConnection rMIConnection = weakReference.get();
                    iterator.remove();
                    if (rMIConnection == null) continue;
                    try {
                        rMIConnection.close();
                    }
                    catch (IOException iOException3) {
                        if (bl) {
                            logger.trace("close", "Failed to close client: " + iOException3);
                        }
                        if (bl2) {
                            logger.debug("close", iOException3);
                        }
                        if (iOException != null) break;
                        iOException = iOException3;
                    }
                    break;
                }
            }
        }
        if (this.notifBuffer != null) {
            this.notifBuffer.dispose();
        }
        if (iOException != null) {
            if (bl) {
                logger.trace("close", "close failed.");
            }
            throw iOException;
        }
        if (bl) {
            logger.trace("close", "closed.");
        }
    }

    protected abstract void closeServer() throws IOException;

    private static synchronized String makeConnectionId(String string, Subject subject) {
        ++connectionIdNumber;
        String string2 = "";
        try {
            string2 = RemoteServer.getClientHost();
            if (string2.contains(":")) {
                string2 = "[" + string2 + "]";
            }
        }
        catch (ServerNotActiveException serverNotActiveException) {
            logger.trace("makeConnectionId", "getClientHost", serverNotActiveException);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string).append(":");
        if (string2.length() > 0) {
            stringBuilder.append("//").append(string2);
        }
        stringBuilder.append(" ");
        if (subject != null) {
            Set<Principal> set = subject.getPrincipals();
            String string3 = "";
            for (Principal principal : set) {
                String string4 = principal.getName().replace(' ', '_').replace(';', ':');
                stringBuilder.append(string3).append(string4);
                string3 = ";";
            }
        }
        stringBuilder.append(" ").append(connectionIdNumber);
        if (logger.traceOn()) {
            logger.trace("newConnectionId", "connectionId=" + stringBuilder);
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropDeadReferences() {
        List<WeakReference<RMIConnection>> list = this.clientList;
        synchronized (list) {
            Iterator<WeakReference<RMIConnection>> iterator = this.clientList.iterator();
            while (iterator.hasNext()) {
                WeakReference<RMIConnection> weakReference = iterator.next();
                if (weakReference.get() != null) continue;
                iterator.remove();
            }
        }
    }

    synchronized NotificationBuffer getNotifBuffer() {
        if (this.notifBuffer == null) {
            this.notifBuffer = ArrayNotificationBuffer.getNotificationBuffer(this.mbeanServer, this.env);
        }
        return this.notifBuffer;
    }
}

