/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.atomic;

import java.io.Serializable;
import java.util.function.IntBinaryOperator;
import java.util.function.IntUnaryOperator;
import sun.misc.Unsafe;

public class AtomicIntegerArray
implements Serializable {
    private static final long serialVersionUID = 2862133569453604235L;
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static final int base = unsafe.arrayBaseOffset(int[].class);
    private static final int shift;
    private final int[] array;

    private long checkedByteOffset(int n) {
        if (n < 0 || n >= this.array.length) {
            throw new IndexOutOfBoundsException("index " + n);
        }
        return AtomicIntegerArray.byteOffset(n);
    }

    private static long byteOffset(int n) {
        return ((long)n << shift) + (long)base;
    }

    public AtomicIntegerArray(int n) {
        this.array = new int[n];
    }

    public AtomicIntegerArray(int[] nArray) {
        this.array = (int[])nArray.clone();
    }

    public final int length() {
        return this.array.length;
    }

    public final int get(int n) {
        return this.getRaw(this.checkedByteOffset(n));
    }

    private int getRaw(long l) {
        return unsafe.getIntVolatile(this.array, l);
    }

    public final void set(int n, int n2) {
        unsafe.putIntVolatile(this.array, this.checkedByteOffset(n), n2);
    }

    public final void lazySet(int n, int n2) {
        unsafe.putOrderedInt(this.array, this.checkedByteOffset(n), n2);
    }

    public final int getAndSet(int n, int n2) {
        return unsafe.getAndSetInt(this.array, this.checkedByteOffset(n), n2);
    }

    public final boolean compareAndSet(int n, int n2, int n3) {
        return this.compareAndSetRaw(this.checkedByteOffset(n), n2, n3);
    }

    private boolean compareAndSetRaw(long l, int n, int n2) {
        return unsafe.compareAndSwapInt(this.array, l, n, n2);
    }

    public final boolean weakCompareAndSet(int n, int n2, int n3) {
        return this.compareAndSet(n, n2, n3);
    }

    public final int getAndIncrement(int n) {
        return unsafe.getAndAddInt(this.array, this.checkedByteOffset(n), 1);
    }

    public final int getAndDecrement(int n) {
        return unsafe.getAndAddInt(this.array, this.checkedByteOffset(n), -1);
    }

    public final int getAndAdd(int n, int n2) {
        return unsafe.getAndAddInt(this.array, this.checkedByteOffset(n), n2);
    }

    public final int incrementAndGet(int n) {
        return unsafe.getAndAddInt(this.array, this.checkedByteOffset(n), 1) + 1;
    }

    public final int decrementAndGet(int n) {
        return unsafe.getAndAddInt(this.array, this.checkedByteOffset(n), -1) - 1;
    }

    public final int addAndGet(int n, int n2) {
        return unsafe.getAndAddInt(this.array, this.checkedByteOffset(n), n2) + n2;
    }

    public final int getAndUpdate(int n, IntUnaryOperator intUnaryOperator) {
        int n2;
        int n3;
        long l = this.checkedByteOffset(n);
        while (!this.compareAndSetRaw(l, n3 = this.getRaw(l), n2 = intUnaryOperator.applyAsInt(n3))) {
        }
        return n3;
    }

    public final int updateAndGet(int n, IntUnaryOperator intUnaryOperator) {
        int n2;
        int n3;
        long l = this.checkedByteOffset(n);
        while (!this.compareAndSetRaw(l, n3 = this.getRaw(l), n2 = intUnaryOperator.applyAsInt(n3))) {
        }
        return n2;
    }

    public final int getAndAccumulate(int n, int n2, IntBinaryOperator intBinaryOperator) {
        int n3;
        int n4;
        long l = this.checkedByteOffset(n);
        while (!this.compareAndSetRaw(l, n4 = this.getRaw(l), n3 = intBinaryOperator.applyAsInt(n4, n2))) {
        }
        return n4;
    }

    public final int accumulateAndGet(int n, int n2, IntBinaryOperator intBinaryOperator) {
        int n3;
        int n4;
        long l = this.checkedByteOffset(n);
        while (!this.compareAndSetRaw(l, n4 = this.getRaw(l), n3 = intBinaryOperator.applyAsInt(n4, n2))) {
        }
        return n3;
    }

    public String toString() {
        int n = this.array.length - 1;
        if (n == -1) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        int n2 = 0;
        while (true) {
            stringBuilder.append(this.getRaw(AtomicIntegerArray.byteOffset(n2)));
            if (n2 == n) {
                return stringBuilder.append(']').toString();
            }
            stringBuilder.append(',').append(' ');
            ++n2;
        }
    }

    static {
        int n = unsafe.arrayIndexScale(int[].class);
        if ((n & n - 1) != 0) {
            throw new Error("data type scale not a power of two");
        }
        shift = 31 - Integer.numberOfLeadingZeros(n);
    }
}

