/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.DuplicateFormatFlagsException;
import java.util.FormatFlagsConversionMismatchException;
import java.util.Formattable;
import java.util.FormatterClosedException;
import java.util.IllegalFormatCodePointException;
import java.util.IllegalFormatConversionException;
import java.util.IllegalFormatFlagsException;
import java.util.IllegalFormatPrecisionException;
import java.util.IllegalFormatWidthException;
import java.util.Locale;
import java.util.MissingFormatArgumentException;
import java.util.MissingFormatWidthException;
import java.util.Objects;
import java.util.TimeZone;
import java.util.UnknownFormatConversionException;
import java.util.UnknownFormatFlagsException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sun.misc.FormattedFloatingDecimal;

public final class Formatter
implements Closeable,
Flushable {
    private Appendable a;
    private final Locale l;
    private IOException lastException;
    private final char zero;
    private static double scaleUp;
    private static final int MAX_FD_CHARS = 30;
    private static final String formatSpecifier = "%(\\d+\\$)?([-#+ 0,(\\<]*)?(\\d+)?(\\.\\d+)?([tT])?([a-zA-Z%])";
    private static Pattern fsPattern;

    private static Charset toCharset(String string) throws UnsupportedEncodingException {
        Objects.requireNonNull(string, "charsetName");
        try {
            return Charset.forName(string);
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException illegalArgumentException) {
            throw new UnsupportedEncodingException(string);
        }
    }

    private static final Appendable nonNullAppendable(Appendable appendable) {
        if (appendable == null) {
            return new StringBuilder();
        }
        return appendable;
    }

    private Formatter(Locale locale, Appendable appendable) {
        this.a = appendable;
        this.l = locale;
        this.zero = Formatter.getZero(locale);
    }

    private Formatter(Charset charset, Locale locale, File file) throws FileNotFoundException {
        this(locale, new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), charset)));
    }

    public Formatter() {
        this(Locale.getDefault(Locale.Category.FORMAT), new StringBuilder());
    }

    public Formatter(Appendable appendable) {
        this(Locale.getDefault(Locale.Category.FORMAT), Formatter.nonNullAppendable(appendable));
    }

    public Formatter(Locale locale) {
        this(locale, new StringBuilder());
    }

    public Formatter(Appendable appendable, Locale locale) {
        this(locale, Formatter.nonNullAppendable(appendable));
    }

    public Formatter(String string) throws FileNotFoundException {
        this(Locale.getDefault(Locale.Category.FORMAT), new BufferedWriter(new OutputStreamWriter(new FileOutputStream(string))));
    }

    public Formatter(String string, String string2) throws FileNotFoundException, UnsupportedEncodingException {
        this(string, string2, Locale.getDefault(Locale.Category.FORMAT));
    }

    public Formatter(String string, String string2, Locale locale) throws FileNotFoundException, UnsupportedEncodingException {
        this(Formatter.toCharset(string2), locale, new File(string));
    }

    public Formatter(File file) throws FileNotFoundException {
        this(Locale.getDefault(Locale.Category.FORMAT), new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file))));
    }

    public Formatter(File file, String string) throws FileNotFoundException, UnsupportedEncodingException {
        this(file, string, Locale.getDefault(Locale.Category.FORMAT));
    }

    public Formatter(File file, String string, Locale locale) throws FileNotFoundException, UnsupportedEncodingException {
        this(Formatter.toCharset(string), locale, file);
    }

    public Formatter(PrintStream printStream) {
        this(Locale.getDefault(Locale.Category.FORMAT), Objects.requireNonNull(printStream));
    }

    public Formatter(OutputStream outputStream) {
        this(Locale.getDefault(Locale.Category.FORMAT), new BufferedWriter(new OutputStreamWriter(outputStream)));
    }

    public Formatter(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        this(outputStream, string, Locale.getDefault(Locale.Category.FORMAT));
    }

    public Formatter(OutputStream outputStream, String string, Locale locale) throws UnsupportedEncodingException {
        this(locale, new BufferedWriter(new OutputStreamWriter(outputStream, string)));
    }

    private static char getZero(Locale locale) {
        if (locale != null && !locale.equals(Locale.US)) {
            DecimalFormatSymbols decimalFormatSymbols = DecimalFormatSymbols.getInstance(locale);
            return decimalFormatSymbols.getZeroDigit();
        }
        return '0';
    }

    public Locale locale() {
        this.ensureOpen();
        return this.l;
    }

    public Appendable out() {
        this.ensureOpen();
        return this.a;
    }

    public String toString() {
        this.ensureOpen();
        return this.a.toString();
    }

    @Override
    public void flush() {
        this.ensureOpen();
        if (this.a instanceof Flushable) {
            try {
                ((Flushable)((Object)this.a)).flush();
            }
            catch (IOException iOException) {
                this.lastException = iOException;
            }
        }
    }

    @Override
    public void close() {
        if (this.a == null) {
            return;
        }
        try {
            if (this.a instanceof Closeable) {
                ((Closeable)((Object)this.a)).close();
            }
        }
        catch (IOException iOException) {
            this.lastException = iOException;
        }
        finally {
            this.a = null;
        }
    }

    private void ensureOpen() {
        if (this.a == null) {
            throw new FormatterClosedException();
        }
    }

    public IOException ioException() {
        return this.lastException;
    }

    public Formatter format(String string, Object ... objectArray) {
        return this.format(this.l, string, objectArray);
    }

    public Formatter format(Locale locale, String string, Object ... objectArray) {
        this.ensureOpen();
        int n = -1;
        int n2 = -1;
        FormatString[] formatStringArray = this.parse(string);
        for (int i = 0; i < formatStringArray.length; ++i) {
            FormatString formatString = formatStringArray[i];
            int n3 = formatString.index();
            try {
                switch (n3) {
                    case -2: {
                        formatString.print(null, locale);
                        break;
                    }
                    case -1: {
                        if (n < 0 || objectArray != null && n > objectArray.length - 1) {
                            throw new MissingFormatArgumentException(formatString.toString());
                        }
                        formatString.print(objectArray == null ? null : objectArray[n], locale);
                        break;
                    }
                    case 0: {
                        n = ++n2;
                        if (objectArray != null && n2 > objectArray.length - 1) {
                            throw new MissingFormatArgumentException(formatString.toString());
                        }
                        formatString.print(objectArray == null ? null : objectArray[n2], locale);
                        break;
                    }
                    default: {
                        n = n3 - 1;
                        if (objectArray != null && n > objectArray.length - 1) {
                            throw new MissingFormatArgumentException(formatString.toString());
                        }
                        formatString.print(objectArray == null ? null : objectArray[n], locale);
                        break;
                    }
                }
                continue;
            }
            catch (IOException iOException) {
                this.lastException = iOException;
            }
        }
        return this;
    }

    private FormatString[] parse(String string) {
        ArrayList<FormatString> arrayList = new ArrayList<FormatString>();
        Matcher matcher = fsPattern.matcher(string);
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            if (matcher.find(n)) {
                if (matcher.start() != n) {
                    Formatter.checkText(string, n, matcher.start());
                    arrayList.add(new FixedString(string.substring(n, matcher.start())));
                }
                arrayList.add(new FormatSpecifier(matcher));
                n = matcher.end();
                continue;
            }
            Formatter.checkText(string, n, n2);
            arrayList.add(new FixedString(string.substring(n)));
            break;
        }
        return arrayList.toArray(new FormatString[arrayList.size()]);
    }

    private static void checkText(String string, int n, int n2) {
        for (int i = n; i < n2; ++i) {
            if (string.charAt(i) != '%') continue;
            char c = i == n2 - 1 ? (char)'%' : (char)string.charAt(i + 1);
            throw new UnknownFormatConversionException(String.valueOf(c));
        }
    }

    static {
        fsPattern = Pattern.compile(formatSpecifier);
    }

    private static class DateTime {
        static final char HOUR_OF_DAY_0 = 'H';
        static final char HOUR_0 = 'I';
        static final char HOUR_OF_DAY = 'k';
        static final char HOUR = 'l';
        static final char MINUTE = 'M';
        static final char NANOSECOND = 'N';
        static final char MILLISECOND = 'L';
        static final char MILLISECOND_SINCE_EPOCH = 'Q';
        static final char AM_PM = 'p';
        static final char SECONDS_SINCE_EPOCH = 's';
        static final char SECOND = 'S';
        static final char TIME = 'T';
        static final char ZONE_NUMERIC = 'z';
        static final char ZONE = 'Z';
        static final char NAME_OF_DAY_ABBREV = 'a';
        static final char NAME_OF_DAY = 'A';
        static final char NAME_OF_MONTH_ABBREV = 'b';
        static final char NAME_OF_MONTH = 'B';
        static final char CENTURY = 'C';
        static final char DAY_OF_MONTH_0 = 'd';
        static final char DAY_OF_MONTH = 'e';
        static final char NAME_OF_MONTH_ABBREV_X = 'h';
        static final char DAY_OF_YEAR = 'j';
        static final char MONTH = 'm';
        static final char YEAR_2 = 'y';
        static final char YEAR_4 = 'Y';
        static final char TIME_12_HOUR = 'r';
        static final char TIME_24_HOUR = 'R';
        static final char DATE_TIME = 'c';
        static final char DATE = 'D';
        static final char ISO_STANDARD_DATE = 'F';

        private DateTime() {
        }

        static boolean isValid(char c) {
            switch (c) {
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'H': 
                case 'I': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'Y': 
                case 'Z': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'h': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'p': 
                case 'r': 
                case 's': 
                case 'y': 
                case 'z': {
                    return true;
                }
            }
            return false;
        }
    }

    private static class Conversion {
        static final char DECIMAL_INTEGER = 'd';
        static final char OCTAL_INTEGER = 'o';
        static final char HEXADECIMAL_INTEGER = 'x';
        static final char HEXADECIMAL_INTEGER_UPPER = 'X';
        static final char SCIENTIFIC = 'e';
        static final char SCIENTIFIC_UPPER = 'E';
        static final char GENERAL = 'g';
        static final char GENERAL_UPPER = 'G';
        static final char DECIMAL_FLOAT = 'f';
        static final char HEXADECIMAL_FLOAT = 'a';
        static final char HEXADECIMAL_FLOAT_UPPER = 'A';
        static final char CHARACTER = 'c';
        static final char CHARACTER_UPPER = 'C';
        static final char DATE_TIME = 't';
        static final char DATE_TIME_UPPER = 'T';
        static final char BOOLEAN = 'b';
        static final char BOOLEAN_UPPER = 'B';
        static final char STRING = 's';
        static final char STRING_UPPER = 'S';
        static final char HASHCODE = 'h';
        static final char HASHCODE_UPPER = 'H';
        static final char LINE_SEPARATOR = 'n';
        static final char PERCENT_SIGN = '%';

        private Conversion() {
        }

        static boolean isValid(char c) {
            return Conversion.isGeneral(c) || Conversion.isInteger(c) || Conversion.isFloat(c) || Conversion.isText(c) || c == 't' || Conversion.isCharacter(c);
        }

        static boolean isGeneral(char c) {
            switch (c) {
                case 'B': 
                case 'H': 
                case 'S': 
                case 'b': 
                case 'h': 
                case 's': {
                    return true;
                }
            }
            return false;
        }

        static boolean isCharacter(char c) {
            switch (c) {
                case 'C': 
                case 'c': {
                    return true;
                }
            }
            return false;
        }

        static boolean isInteger(char c) {
            switch (c) {
                case 'X': 
                case 'd': 
                case 'o': 
                case 'x': {
                    return true;
                }
            }
            return false;
        }

        static boolean isFloat(char c) {
            switch (c) {
                case 'A': 
                case 'E': 
                case 'G': 
                case 'a': 
                case 'e': 
                case 'f': 
                case 'g': {
                    return true;
                }
            }
            return false;
        }

        static boolean isText(char c) {
            switch (c) {
                case '%': 
                case 'n': {
                    return true;
                }
            }
            return false;
        }
    }

    private static class Flags {
        private int flags;
        static final Flags NONE = new Flags(0);
        static final Flags LEFT_JUSTIFY = new Flags(1);
        static final Flags UPPERCASE = new Flags(2);
        static final Flags ALTERNATE = new Flags(4);
        static final Flags PLUS = new Flags(8);
        static final Flags LEADING_SPACE = new Flags(16);
        static final Flags ZERO_PAD = new Flags(32);
        static final Flags GROUP = new Flags(64);
        static final Flags PARENTHESES = new Flags(128);
        static final Flags PREVIOUS = new Flags(256);

        private Flags(int n) {
            this.flags = n;
        }

        public int valueOf() {
            return this.flags;
        }

        public boolean contains(Flags flags) {
            return (this.flags & flags.valueOf()) == flags.valueOf();
        }

        public Flags dup() {
            return new Flags(this.flags);
        }

        private Flags add(Flags flags) {
            this.flags |= flags.valueOf();
            return this;
        }

        public Flags remove(Flags flags) {
            this.flags &= ~flags.valueOf();
            return this;
        }

        public static Flags parse(String string) {
            char[] cArray = string.toCharArray();
            Flags flags = new Flags(0);
            for (int i = 0; i < cArray.length; ++i) {
                Flags flags2 = Flags.parse(cArray[i]);
                if (flags.contains(flags2)) {
                    throw new DuplicateFormatFlagsException(flags2.toString());
                }
                flags.add(flags2);
            }
            return flags;
        }

        private static Flags parse(char c) {
            switch (c) {
                case '-': {
                    return LEFT_JUSTIFY;
                }
                case '#': {
                    return ALTERNATE;
                }
                case '+': {
                    return PLUS;
                }
                case ' ': {
                    return LEADING_SPACE;
                }
                case '0': {
                    return ZERO_PAD;
                }
                case ',': {
                    return GROUP;
                }
                case '(': {
                    return PARENTHESES;
                }
                case '<': {
                    return PREVIOUS;
                }
            }
            throw new UnknownFormatFlagsException(String.valueOf(c));
        }

        public static String toString(Flags flags) {
            return flags.toString();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.contains(LEFT_JUSTIFY)) {
                stringBuilder.append('-');
            }
            if (this.contains(UPPERCASE)) {
                stringBuilder.append('^');
            }
            if (this.contains(ALTERNATE)) {
                stringBuilder.append('#');
            }
            if (this.contains(PLUS)) {
                stringBuilder.append('+');
            }
            if (this.contains(LEADING_SPACE)) {
                stringBuilder.append(' ');
            }
            if (this.contains(ZERO_PAD)) {
                stringBuilder.append('0');
            }
            if (this.contains(GROUP)) {
                stringBuilder.append(',');
            }
            if (this.contains(PARENTHESES)) {
                stringBuilder.append('(');
            }
            if (this.contains(PREVIOUS)) {
                stringBuilder.append('<');
            }
            return stringBuilder.toString();
        }
    }

    private class FormatSpecifier
    implements FormatString {
        private int index = -1;
        private Flags f = Flags.NONE;
        private int width;
        private int precision;
        private boolean dt = false;
        private char c;

        private int index(String string) {
            if (string != null) {
                try {
                    this.index = Integer.parseInt(string.substring(0, string.length() - 1));
                }
                catch (NumberFormatException numberFormatException) {
                    assert (false);
                }
            } else {
                this.index = 0;
            }
            return this.index;
        }

        @Override
        public int index() {
            return this.index;
        }

        private Flags flags(String string) {
            this.f = Flags.parse(string);
            if (this.f.contains(Flags.PREVIOUS)) {
                this.index = -1;
            }
            return this.f;
        }

        Flags flags() {
            return this.f;
        }

        private int width(String string) {
            block4: {
                this.width = -1;
                if (string != null) {
                    try {
                        this.width = Integer.parseInt(string);
                        if (this.width < 0) {
                            throw new IllegalFormatWidthException(this.width);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        if ($assertionsDisabled) break block4;
                        throw new AssertionError();
                    }
                }
            }
            return this.width;
        }

        int width() {
            return this.width;
        }

        private int precision(String string) {
            block4: {
                this.precision = -1;
                if (string != null) {
                    try {
                        this.precision = Integer.parseInt(string.substring(1));
                        if (this.precision < 0) {
                            throw new IllegalFormatPrecisionException(this.precision);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        if ($assertionsDisabled) break block4;
                        throw new AssertionError();
                    }
                }
            }
            return this.precision;
        }

        int precision() {
            return this.precision;
        }

        private char conversion(String string) {
            this.c = string.charAt(0);
            if (!this.dt) {
                if (!Conversion.isValid(this.c)) {
                    throw new UnknownFormatConversionException(String.valueOf(this.c));
                }
                if (Character.isUpperCase(this.c)) {
                    this.f.add(Flags.UPPERCASE);
                }
                this.c = Character.toLowerCase(this.c);
                if (Conversion.isText(this.c)) {
                    this.index = -2;
                }
            }
            return this.c;
        }

        private char conversion() {
            return this.c;
        }

        FormatSpecifier(Matcher matcher) {
            int n = 1;
            this.index(matcher.group(n++));
            this.flags(matcher.group(n++));
            this.width(matcher.group(n++));
            this.precision(matcher.group(n++));
            String string = matcher.group(n++);
            if (string != null) {
                this.dt = true;
                if (string.equals("T")) {
                    this.f.add(Flags.UPPERCASE);
                }
            }
            this.conversion(matcher.group(n));
            if (this.dt) {
                this.checkDateTime();
            } else if (Conversion.isGeneral(this.c)) {
                this.checkGeneral();
            } else if (Conversion.isCharacter(this.c)) {
                this.checkCharacter();
            } else if (Conversion.isInteger(this.c)) {
                this.checkInteger();
            } else if (Conversion.isFloat(this.c)) {
                this.checkFloat();
            } else if (Conversion.isText(this.c)) {
                this.checkText();
            } else {
                throw new UnknownFormatConversionException(String.valueOf(this.c));
            }
        }

        @Override
        public void print(Object object, Locale locale) throws IOException {
            if (this.dt) {
                this.printDateTime(object, locale);
                return;
            }
            switch (this.c) {
                case 'd': 
                case 'o': 
                case 'x': {
                    this.printInteger(object, locale);
                    break;
                }
                case 'a': 
                case 'e': 
                case 'f': 
                case 'g': {
                    this.printFloat(object, locale);
                    break;
                }
                case 'C': 
                case 'c': {
                    this.printCharacter(object);
                    break;
                }
                case 'b': {
                    this.printBoolean(object);
                    break;
                }
                case 's': {
                    this.printString(object, locale);
                    break;
                }
                case 'h': {
                    this.printHashCode(object);
                    break;
                }
                case 'n': {
                    Formatter.this.a.append(System.lineSeparator());
                    break;
                }
                case '%': {
                    Formatter.this.a.append('%');
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }

        private void printInteger(Object object, Locale locale) throws IOException {
            if (object == null) {
                this.print("null");
            } else if (object instanceof Byte) {
                this.print((Byte)object, locale);
            } else if (object instanceof Short) {
                this.print((Short)object, locale);
            } else if (object instanceof Integer) {
                this.print((Integer)object, locale);
            } else if (object instanceof Long) {
                this.print((Long)object, locale);
            } else if (object instanceof BigInteger) {
                this.print((BigInteger)object, locale);
            } else {
                this.failConversion(this.c, object);
            }
        }

        private void printFloat(Object object, Locale locale) throws IOException {
            if (object == null) {
                this.print("null");
            } else if (object instanceof Float) {
                this.print(((Float)object).floatValue(), locale);
            } else if (object instanceof Double) {
                this.print((Double)object, locale);
            } else if (object instanceof BigDecimal) {
                this.print((BigDecimal)object, locale);
            } else {
                this.failConversion(this.c, object);
            }
        }

        private void printDateTime(Object object, Locale locale) throws IOException {
            if (object == null) {
                this.print("null");
                return;
            }
            Calendar calendar = null;
            if (object instanceof Long) {
                calendar = Calendar.getInstance(locale == null ? Locale.US : locale);
                calendar.setTimeInMillis((Long)object);
            } else if (object instanceof Date) {
                calendar = Calendar.getInstance(locale == null ? Locale.US : locale);
                calendar.setTime((Date)object);
            } else if (object instanceof Calendar) {
                calendar = (Calendar)((Calendar)object).clone();
                calendar.setLenient(true);
            } else {
                if (object instanceof TemporalAccessor) {
                    this.print((TemporalAccessor)object, this.c, locale);
                    return;
                }
                this.failConversion(this.c, object);
            }
            this.print(calendar, this.c, locale);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void printCharacter(Object object) throws IOException {
            if (object == null) {
                this.print("null");
                return;
            }
            String string = null;
            if (object instanceof Character) {
                string = ((Character)object).toString();
            } else if (object instanceof Byte) {
                byte by = (Byte)object;
                if (!Character.isValidCodePoint(by)) throw new IllegalFormatCodePointException(by);
                string = new String(Character.toChars(by));
            } else if (object instanceof Short) {
                short s = (Short)object;
                if (!Character.isValidCodePoint(s)) throw new IllegalFormatCodePointException(s);
                string = new String(Character.toChars(s));
            } else if (object instanceof Integer) {
                int n = (Integer)object;
                if (!Character.isValidCodePoint(n)) throw new IllegalFormatCodePointException(n);
                string = new String(Character.toChars(n));
            } else {
                this.failConversion(this.c, object);
            }
            this.print(string);
        }

        private void printString(Object object, Locale locale) throws IOException {
            if (object instanceof Formattable) {
                Formatter formatter = Formatter.this;
                if (formatter.locale() != locale) {
                    formatter = new Formatter(formatter.out(), locale);
                }
                ((Formattable)object).formatTo(formatter, this.f.valueOf(), this.width, this.precision);
            } else {
                if (this.f.contains(Flags.ALTERNATE)) {
                    this.failMismatch(Flags.ALTERNATE, 's');
                }
                if (object == null) {
                    this.print("null");
                } else {
                    this.print(object.toString());
                }
            }
        }

        private void printBoolean(Object object) throws IOException {
            String string = object != null ? (object instanceof Boolean ? ((Boolean)object).toString() : Boolean.toString(true)) : Boolean.toString(false);
            this.print(string);
        }

        private void printHashCode(Object object) throws IOException {
            String string = object == null ? "null" : Integer.toHexString(object.hashCode());
            this.print(string);
        }

        private void print(String string) throws IOException {
            if (this.precision != -1 && this.precision < string.length()) {
                string = string.substring(0, this.precision);
            }
            if (this.f.contains(Flags.UPPERCASE)) {
                string = string.toUpperCase();
            }
            Formatter.this.a.append(this.justify(string));
        }

        private String justify(String string) {
            int n;
            if (this.width == -1) {
                return string;
            }
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = this.f.contains(Flags.LEFT_JUSTIFY);
            int n2 = this.width - string.length();
            if (!bl) {
                for (n = 0; n < n2; ++n) {
                    stringBuilder.append(' ');
                }
            }
            stringBuilder.append(string);
            if (bl) {
                for (n = 0; n < n2; ++n) {
                    stringBuilder.append(' ');
                }
            }
            return stringBuilder.toString();
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("%");
            Flags flags = this.f.dup().remove(Flags.UPPERCASE);
            stringBuilder.append(flags.toString());
            if (this.index > 0) {
                stringBuilder.append(this.index).append('$');
            }
            if (this.width != -1) {
                stringBuilder.append(this.width);
            }
            if (this.precision != -1) {
                stringBuilder.append('.').append(this.precision);
            }
            if (this.dt) {
                stringBuilder.append(this.f.contains(Flags.UPPERCASE) ? (char)'T' : 't');
            }
            stringBuilder.append(this.f.contains(Flags.UPPERCASE) ? Character.toUpperCase(this.c) : this.c);
            return stringBuilder.toString();
        }

        private void checkGeneral() {
            if ((this.c == 'b' || this.c == 'h') && this.f.contains(Flags.ALTERNATE)) {
                this.failMismatch(Flags.ALTERNATE, this.c);
            }
            if (this.width == -1 && this.f.contains(Flags.LEFT_JUSTIFY)) {
                throw new MissingFormatWidthException(this.toString());
            }
            this.checkBadFlags(Flags.PLUS, Flags.LEADING_SPACE, Flags.ZERO_PAD, Flags.GROUP, Flags.PARENTHESES);
        }

        private void checkDateTime() {
            if (this.precision != -1) {
                throw new IllegalFormatPrecisionException(this.precision);
            }
            if (!DateTime.isValid(this.c)) {
                throw new UnknownFormatConversionException("t" + this.c);
            }
            this.checkBadFlags(Flags.ALTERNATE, Flags.PLUS, Flags.LEADING_SPACE, Flags.ZERO_PAD, Flags.GROUP, Flags.PARENTHESES);
            if (this.width == -1 && this.f.contains(Flags.LEFT_JUSTIFY)) {
                throw new MissingFormatWidthException(this.toString());
            }
        }

        private void checkCharacter() {
            if (this.precision != -1) {
                throw new IllegalFormatPrecisionException(this.precision);
            }
            this.checkBadFlags(Flags.ALTERNATE, Flags.PLUS, Flags.LEADING_SPACE, Flags.ZERO_PAD, Flags.GROUP, Flags.PARENTHESES);
            if (this.width == -1 && this.f.contains(Flags.LEFT_JUSTIFY)) {
                throw new MissingFormatWidthException(this.toString());
            }
        }

        private void checkInteger() {
            this.checkNumeric();
            if (this.precision != -1) {
                throw new IllegalFormatPrecisionException(this.precision);
            }
            if (this.c == 'd') {
                this.checkBadFlags(Flags.ALTERNATE);
            } else if (this.c == 'o') {
                this.checkBadFlags(Flags.GROUP);
            } else {
                this.checkBadFlags(Flags.GROUP);
            }
        }

        private void checkBadFlags(Flags ... flagsArray) {
            for (int i = 0; i < flagsArray.length; ++i) {
                if (!this.f.contains(flagsArray[i])) continue;
                this.failMismatch(flagsArray[i], this.c);
            }
        }

        private void checkFloat() {
            this.checkNumeric();
            if (this.c != 'f') {
                if (this.c == 'a') {
                    this.checkBadFlags(Flags.PARENTHESES, Flags.GROUP);
                } else if (this.c == 'e') {
                    this.checkBadFlags(Flags.GROUP);
                } else if (this.c == 'g') {
                    this.checkBadFlags(Flags.ALTERNATE);
                }
            }
        }

        private void checkNumeric() {
            if (this.width != -1 && this.width < 0) {
                throw new IllegalFormatWidthException(this.width);
            }
            if (this.precision != -1 && this.precision < 0) {
                throw new IllegalFormatPrecisionException(this.precision);
            }
            if (this.width == -1 && (this.f.contains(Flags.LEFT_JUSTIFY) || this.f.contains(Flags.ZERO_PAD))) {
                throw new MissingFormatWidthException(this.toString());
            }
            if (this.f.contains(Flags.PLUS) && this.f.contains(Flags.LEADING_SPACE) || this.f.contains(Flags.LEFT_JUSTIFY) && this.f.contains(Flags.ZERO_PAD)) {
                throw new IllegalFormatFlagsException(this.f.toString());
            }
        }

        private void checkText() {
            if (this.precision != -1) {
                throw new IllegalFormatPrecisionException(this.precision);
            }
            switch (this.c) {
                case '%': {
                    if (this.f.valueOf() != Flags.LEFT_JUSTIFY.valueOf() && this.f.valueOf() != Flags.NONE.valueOf()) {
                        throw new IllegalFormatFlagsException(this.f.toString());
                    }
                    if (this.width != -1 || !this.f.contains(Flags.LEFT_JUSTIFY)) break;
                    throw new MissingFormatWidthException(this.toString());
                }
                case 'n': {
                    if (this.width != -1) {
                        throw new IllegalFormatWidthException(this.width);
                    }
                    if (this.f.valueOf() == Flags.NONE.valueOf()) break;
                    throw new IllegalFormatFlagsException(this.f.toString());
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }

        private void print(byte by, Locale locale) throws IOException {
            long l = by;
            if (by < 0 && (this.c == 'o' || this.c == 'x')) assert ((l += 256L) >= 0L) : l;
            this.print(l, locale);
        }

        private void print(short s, Locale locale) throws IOException {
            long l = s;
            if (s < 0 && (this.c == 'o' || this.c == 'x')) assert ((l += 65536L) >= 0L) : l;
            this.print(l, locale);
        }

        private void print(int n, Locale locale) throws IOException {
            long l = n;
            if (n < 0 && (this.c == 'o' || this.c == 'x')) assert ((l += 0x100000000L) >= 0L) : l;
            this.print(l, locale);
        }

        private void print(long l, Locale locale) throws IOException {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.c == 'd') {
                boolean bl = l < 0L;
                char[] cArray = l < 0L ? Long.toString(l, 10).substring(1).toCharArray() : Long.toString(l, 10).toCharArray();
                this.leadingSign(stringBuilder, bl);
                this.localizedMagnitude(stringBuilder, cArray, this.f, this.adjustWidth(this.width, this.f, bl), locale);
                this.trailingSign(stringBuilder, bl);
            } else if (this.c == 'o') {
                int n;
                this.checkBadFlags(Flags.PARENTHESES, Flags.LEADING_SPACE, Flags.PLUS);
                String string = Long.toOctalString(l);
                int n2 = n = this.f.contains(Flags.ALTERNATE) ? string.length() + 1 : string.length();
                if (this.f.contains(Flags.ALTERNATE)) {
                    stringBuilder.append('0');
                }
                if (this.f.contains(Flags.ZERO_PAD)) {
                    for (int i = 0; i < this.width - n; ++i) {
                        stringBuilder.append('0');
                    }
                }
                stringBuilder.append(string);
            } else if (this.c == 'x') {
                int n;
                this.checkBadFlags(Flags.PARENTHESES, Flags.LEADING_SPACE, Flags.PLUS);
                String string = Long.toHexString(l);
                int n3 = n = this.f.contains(Flags.ALTERNATE) ? string.length() + 2 : string.length();
                if (this.f.contains(Flags.ALTERNATE)) {
                    stringBuilder.append(this.f.contains(Flags.UPPERCASE) ? "0X" : "0x");
                }
                if (this.f.contains(Flags.ZERO_PAD)) {
                    for (int i = 0; i < this.width - n; ++i) {
                        stringBuilder.append('0');
                    }
                }
                if (this.f.contains(Flags.UPPERCASE)) {
                    string = string.toUpperCase();
                }
                stringBuilder.append(string);
            }
            Formatter.this.a.append(this.justify(stringBuilder.toString()));
        }

        private StringBuilder leadingSign(StringBuilder stringBuilder, boolean bl) {
            if (!bl) {
                if (this.f.contains(Flags.PLUS)) {
                    stringBuilder.append('+');
                } else if (this.f.contains(Flags.LEADING_SPACE)) {
                    stringBuilder.append(' ');
                }
            } else if (this.f.contains(Flags.PARENTHESES)) {
                stringBuilder.append('(');
            } else {
                stringBuilder.append('-');
            }
            return stringBuilder;
        }

        private StringBuilder trailingSign(StringBuilder stringBuilder, boolean bl) {
            if (bl && this.f.contains(Flags.PARENTHESES)) {
                stringBuilder.append(')');
            }
            return stringBuilder;
        }

        private void print(BigInteger bigInteger, Locale locale) throws IOException {
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = bigInteger.signum() == -1;
            BigInteger bigInteger2 = bigInteger.abs();
            this.leadingSign(stringBuilder, bl);
            if (this.c == 'd') {
                char[] cArray = bigInteger2.toString().toCharArray();
                this.localizedMagnitude(stringBuilder, cArray, this.f, this.adjustWidth(this.width, this.f, bl), locale);
            } else if (this.c == 'o') {
                String string = bigInteger2.toString(8);
                int n = string.length() + stringBuilder.length();
                if (bl && this.f.contains(Flags.PARENTHESES)) {
                    ++n;
                }
                if (this.f.contains(Flags.ALTERNATE)) {
                    ++n;
                    stringBuilder.append('0');
                }
                if (this.f.contains(Flags.ZERO_PAD)) {
                    for (int i = 0; i < this.width - n; ++i) {
                        stringBuilder.append('0');
                    }
                }
                stringBuilder.append(string);
            } else if (this.c == 'x') {
                String string = bigInteger2.toString(16);
                int n = string.length() + stringBuilder.length();
                if (bl && this.f.contains(Flags.PARENTHESES)) {
                    ++n;
                }
                if (this.f.contains(Flags.ALTERNATE)) {
                    n += 2;
                    stringBuilder.append(this.f.contains(Flags.UPPERCASE) ? "0X" : "0x");
                }
                if (this.f.contains(Flags.ZERO_PAD)) {
                    for (int i = 0; i < this.width - n; ++i) {
                        stringBuilder.append('0');
                    }
                }
                if (this.f.contains(Flags.UPPERCASE)) {
                    string = string.toUpperCase();
                }
                stringBuilder.append(string);
            }
            this.trailingSign(stringBuilder, bigInteger.signum() == -1);
            Formatter.this.a.append(this.justify(stringBuilder.toString()));
        }

        private void print(float f, Locale locale) throws IOException {
            this.print((double)f, locale);
        }

        private void print(double d, Locale locale) throws IOException {
            boolean bl;
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl2 = bl = Double.compare(d, 0.0) == -1;
            if (!Double.isNaN(d)) {
                double d2 = Math.abs(d);
                this.leadingSign(stringBuilder, bl);
                if (!Double.isInfinite(d2)) {
                    this.print(stringBuilder, d2, locale, this.f, this.c, this.precision, bl);
                } else {
                    stringBuilder.append(this.f.contains(Flags.UPPERCASE) ? "INFINITY" : "Infinity");
                }
                this.trailingSign(stringBuilder, bl);
            } else {
                stringBuilder.append(this.f.contains(Flags.UPPERCASE) ? "NAN" : "NaN");
            }
            Formatter.this.a.append(this.justify(stringBuilder.toString()));
        }

        private void print(StringBuilder stringBuilder, double d, Locale locale, Flags flags, char c, int n, boolean bl) throws IOException {
            if (c == 'e') {
                char[] cArray;
                int n2 = n == -1 ? 6 : n;
                FormattedFloatingDecimal formattedFloatingDecimal = FormattedFloatingDecimal.valueOf(d, n2, FormattedFloatingDecimal.Form.SCIENTIFIC);
                char[] cArray2 = this.addZeros(formattedFloatingDecimal.getMantissa(), n2);
                if (flags.contains(Flags.ALTERNATE) && n2 == 0) {
                    cArray2 = this.addDot(cArray2);
                }
                if (d == 0.0) {
                    char[] cArray3 = new char[3];
                    cArray3[0] = 43;
                    cArray3[1] = 48;
                    cArray = cArray3;
                    cArray3[2] = 48;
                } else {
                    cArray = formattedFloatingDecimal.getExponent();
                }
                char[] cArray4 = cArray;
                int n3 = this.width;
                if (this.width != -1) {
                    n3 = this.adjustWidth(this.width - cArray4.length - 1, flags, bl);
                }
                this.localizedMagnitude(stringBuilder, cArray2, flags, n3, locale);
                stringBuilder.append(flags.contains(Flags.UPPERCASE) ? (char)'E' : 'e');
                Flags flags2 = flags.dup().remove(Flags.GROUP);
                char c2 = cArray4[0];
                assert (c2 == '+' || c2 == '-');
                stringBuilder.append(c2);
                char[] cArray5 = new char[cArray4.length - 1];
                System.arraycopy(cArray4, 1, cArray5, 0, cArray4.length - 1);
                stringBuilder.append((CharSequence)this.localizedMagnitude(null, cArray5, flags2, -1, locale));
            } else if (c == 'f') {
                int n4 = n == -1 ? 6 : n;
                FormattedFloatingDecimal formattedFloatingDecimal = FormattedFloatingDecimal.valueOf(d, n4, FormattedFloatingDecimal.Form.DECIMAL_FLOAT);
                char[] cArray = this.addZeros(formattedFloatingDecimal.getMantissa(), n4);
                if (flags.contains(Flags.ALTERNATE) && n4 == 0) {
                    cArray = this.addDot(cArray);
                }
                int n5 = this.width;
                if (this.width != -1) {
                    n5 = this.adjustWidth(this.width, flags, bl);
                }
                this.localizedMagnitude(stringBuilder, cArray, flags, n5, locale);
            } else if (c == 'g') {
                int n6;
                char[] cArray;
                char[] cArray6;
                int n7 = n;
                if (n == -1) {
                    n7 = 6;
                } else if (n == 0) {
                    n7 = 1;
                }
                if (d == 0.0) {
                    cArray6 = null;
                    cArray = new char[]{'0'};
                    n6 = 0;
                } else {
                    FormattedFloatingDecimal formattedFloatingDecimal = FormattedFloatingDecimal.valueOf(d, n7, FormattedFloatingDecimal.Form.GENERAL);
                    cArray6 = formattedFloatingDecimal.getExponent();
                    cArray = formattedFloatingDecimal.getMantissa();
                    n6 = formattedFloatingDecimal.getExponentRounded();
                }
                n7 = cArray6 != null ? --n7 : (n7 -= n6 + 1);
                cArray = this.addZeros(cArray, n7);
                if (flags.contains(Flags.ALTERNATE) && n7 == 0) {
                    cArray = this.addDot(cArray);
                }
                int n8 = this.width;
                if (this.width != -1) {
                    n8 = cArray6 != null ? this.adjustWidth(this.width - cArray6.length - 1, flags, bl) : this.adjustWidth(this.width, flags, bl);
                }
                this.localizedMagnitude(stringBuilder, cArray, flags, n8, locale);
                if (cArray6 != null) {
                    stringBuilder.append(flags.contains(Flags.UPPERCASE) ? (char)'E' : 'e');
                    Flags flags3 = flags.dup().remove(Flags.GROUP);
                    char c3 = cArray6[0];
                    assert (c3 == '+' || c3 == '-');
                    stringBuilder.append(c3);
                    char[] cArray7 = new char[cArray6.length - 1];
                    System.arraycopy(cArray6, 1, cArray7, 0, cArray6.length - 1);
                    stringBuilder.append((CharSequence)this.localizedMagnitude(null, cArray7, flags3, -1, locale));
                }
            } else if (c == 'a') {
                int n9;
                int n10 = n;
                if (n == -1) {
                    n10 = 0;
                } else if (n == 0) {
                    n10 = 1;
                }
                String string = this.hexDouble(d, n10);
                boolean bl2 = flags.contains(Flags.UPPERCASE);
                stringBuilder.append(bl2 ? "0X" : "0x");
                if (flags.contains(Flags.ZERO_PAD)) {
                    for (n9 = 0; n9 < this.width - string.length() - 2; ++n9) {
                        stringBuilder.append('0');
                    }
                }
                n9 = string.indexOf(112);
                char[] cArray = string.substring(0, n9).toCharArray();
                if (bl2) {
                    String string2 = new String(cArray);
                    string2 = string2.toUpperCase(Locale.US);
                    cArray = string2.toCharArray();
                }
                stringBuilder.append(n10 != 0 ? this.addZeros(cArray, n10) : cArray);
                stringBuilder.append(bl2 ? (char)'P' : 'p');
                stringBuilder.append(string.substring(n9 + 1));
            }
        }

        private char[] addZeros(char[] cArray, int n) {
            int n2;
            for (n2 = 0; n2 < cArray.length && cArray[n2] != '.'; ++n2) {
            }
            boolean bl = false;
            if (n2 == cArray.length) {
                bl = true;
            }
            int n3 = cArray.length - n2 - (bl ? 0 : 1);
            assert (n3 <= n);
            if (n3 == n) {
                return cArray;
            }
            char[] cArray2 = new char[cArray.length + n - n3 + (bl ? 1 : 0)];
            System.arraycopy(cArray, 0, cArray2, 0, cArray.length);
            int n4 = cArray.length;
            if (bl) {
                cArray2[cArray.length] = 46;
                ++n4;
            }
            for (int i = n4; i < cArray2.length; ++i) {
                cArray2[i] = 48;
            }
            return cArray2;
        }

        private String hexDouble(double d, int n) {
            long l;
            double d2;
            boolean bl;
            boolean bl2;
            if (!Double.isFinite(d) || d == 0.0 || n == 0 || n >= 13) {
                return Double.toHexString(d).substring(2);
            }
            assert (n >= 1 && n <= 12);
            int n2 = Math.getExponent(d);
            boolean bl3 = bl2 = n2 == -1023;
            if (bl2) {
                scaleUp = Math.scalb(1.0, 54);
                n2 = Math.getExponent(d *= scaleUp);
                assert (n2 >= -1022 && n2 <= 1023) : n2;
            }
            int n3 = 1 + n * 4;
            int n4 = 53 - n3;
            assert (n4 >= 1 && n4 < 53);
            long l2 = Double.doubleToLongBits(d);
            long l3 = (l2 & Long.MAX_VALUE) >> n4;
            long l4 = l2 & (-1L << n4 ^ 0xFFFFFFFFFFFFFFFFL);
            boolean bl4 = (l3 & 1L) == 0L;
            boolean bl5 = (1L << n4 - 1 & l4) != 0L;
            boolean bl6 = bl = n4 > 1 && ((1L << n4 - 1 ^ 0xFFFFFFFFFFFFFFFFL) & l4) != 0L;
            if (bl4 && bl5 && bl || !bl4 && bl5) {
                ++l3;
            }
            if (Double.isInfinite(d2 = Double.longBitsToDouble(l3 = (l = l2 & Long.MIN_VALUE) | l3 << n4))) {
                return "1.0p1024";
            }
            String string = Double.toHexString(d2).substring(2);
            if (!bl2) {
                return string;
            }
            int n5 = string.indexOf(112);
            if (n5 == -1) {
                assert (false);
                return null;
            }
            String string2 = string.substring(n5 + 1);
            int n6 = Integer.parseInt(string2) - 54;
            return string.substring(0, n5) + "p" + Integer.toString(n6);
        }

        private void print(BigDecimal bigDecimal, Locale locale) throws IOException {
            if (this.c == 'a') {
                this.failConversion(this.c, bigDecimal);
            }
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = bigDecimal.signum() == -1;
            BigDecimal bigDecimal2 = bigDecimal.abs();
            this.leadingSign(stringBuilder, bl);
            this.print(stringBuilder, bigDecimal2, locale, this.f, this.c, this.precision, bl);
            this.trailingSign(stringBuilder, bl);
            Formatter.this.a.append(this.justify(stringBuilder.toString()));
        }

        private void print(StringBuilder stringBuilder, BigDecimal bigDecimal, Locale locale, Flags flags, char c, int n, boolean bl) throws IOException {
            if (c == 'e') {
                int n2;
                int n3 = n == -1 ? 6 : n;
                int n4 = bigDecimal.scale();
                int n5 = bigDecimal.precision();
                int n6 = 0;
                if (n3 > n5 - 1) {
                    n2 = n5;
                    n6 = n3 - (n5 - 1);
                } else {
                    n2 = n3 + 1;
                }
                MathContext mathContext = new MathContext(n2);
                BigDecimal bigDecimal2 = new BigDecimal(bigDecimal.unscaledValue(), n4, mathContext);
                BigDecimalLayout bigDecimalLayout = new BigDecimalLayout(bigDecimal2.unscaledValue(), bigDecimal2.scale(), BigDecimalLayoutForm.SCIENTIFIC);
                char[] cArray = bigDecimalLayout.mantissa();
                if (!(n5 != 1 && bigDecimalLayout.hasDot() || n6 <= 0 && !flags.contains(Flags.ALTERNATE))) {
                    cArray = this.addDot(cArray);
                }
                cArray = this.trailingZeros(cArray, n6);
                char[] cArray2 = bigDecimalLayout.exponent();
                int n7 = this.width;
                if (this.width != -1) {
                    n7 = this.adjustWidth(this.width - cArray2.length - 1, flags, bl);
                }
                this.localizedMagnitude(stringBuilder, cArray, flags, n7, locale);
                stringBuilder.append(flags.contains(Flags.UPPERCASE) ? (char)'E' : 'e');
                Flags flags2 = flags.dup().remove(Flags.GROUP);
                char c2 = cArray2[0];
                assert (c2 == '+' || c2 == '-');
                stringBuilder.append(cArray2[0]);
                char[] cArray3 = new char[cArray2.length - 1];
                System.arraycopy(cArray2, 1, cArray3, 0, cArray2.length - 1);
                stringBuilder.append((CharSequence)this.localizedMagnitude(null, cArray3, flags2, -1, locale));
            } else if (c == 'f') {
                int n8;
                int n9 = n == -1 ? 6 : n;
                int n10 = bigDecimal.scale();
                if (n10 > n9) {
                    int n11 = bigDecimal.precision();
                    bigDecimal = n11 <= n10 ? bigDecimal.setScale(n9, RoundingMode.HALF_UP) : new BigDecimal(bigDecimal.unscaledValue(), n10, new MathContext(n11 -= n10 - n9));
                }
                BigDecimalLayout bigDecimalLayout = new BigDecimalLayout(bigDecimal.unscaledValue(), bigDecimal.scale(), BigDecimalLayoutForm.DECIMAL_FLOAT);
                char[] cArray = bigDecimalLayout.mantissa();
                int n12 = n8 = bigDecimalLayout.scale() < n9 ? n9 - bigDecimalLayout.scale() : 0;
                if (bigDecimalLayout.scale() == 0 && (flags.contains(Flags.ALTERNATE) || n8 > 0)) {
                    cArray = this.addDot(bigDecimalLayout.mantissa());
                }
                cArray = this.trailingZeros(cArray, n8);
                this.localizedMagnitude(stringBuilder, cArray, flags, this.adjustWidth(this.width, flags, bl), locale);
            } else if (c == 'g') {
                int n13 = n;
                if (n == -1) {
                    n13 = 6;
                } else if (n == 0) {
                    n13 = 1;
                }
                BigDecimal bigDecimal3 = BigDecimal.valueOf(1L, 4);
                BigDecimal bigDecimal4 = BigDecimal.valueOf(1L, -n13);
                if (bigDecimal.equals(BigDecimal.ZERO) || bigDecimal.compareTo(bigDecimal3) != -1 && bigDecimal.compareTo(bigDecimal4) == -1) {
                    int n14 = -bigDecimal.scale() + (bigDecimal.unscaledValue().toString().length() - 1);
                    n13 = n13 - n14 - 1;
                    this.print(stringBuilder, bigDecimal, locale, flags, 'f', n13, bl);
                } else {
                    this.print(stringBuilder, bigDecimal, locale, flags, 'e', n13 - 1, bl);
                }
            } else if (c == 'a') assert (false);
        }

        private int adjustWidth(int n, Flags flags, boolean bl) {
            int n2 = n;
            if (n2 != -1 && bl && flags.contains(Flags.PARENTHESES)) {
                --n2;
            }
            return n2;
        }

        private char[] addDot(char[] cArray) {
            char[] cArray2 = cArray;
            cArray2 = new char[cArray.length + 1];
            System.arraycopy(cArray, 0, cArray2, 0, cArray.length);
            cArray2[cArray2.length - 1] = 46;
            return cArray2;
        }

        private char[] trailingZeros(char[] cArray, int n) {
            char[] cArray2 = cArray;
            if (n > 0) {
                cArray2 = new char[cArray.length + n];
                System.arraycopy(cArray, 0, cArray2, 0, cArray.length);
                for (int i = cArray.length; i < cArray2.length; ++i) {
                    cArray2[i] = 48;
                }
            }
            return cArray2;
        }

        private void print(Calendar calendar, char c, Locale locale) throws IOException {
            StringBuilder stringBuilder = new StringBuilder();
            this.print(stringBuilder, calendar, c, locale);
            String string = this.justify(stringBuilder.toString());
            if (this.f.contains(Flags.UPPERCASE)) {
                string = string.toUpperCase();
            }
            Formatter.this.a.append(string);
        }

        private Appendable print(StringBuilder stringBuilder, Calendar calendar, char c, Locale locale) throws IOException {
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            }
            switch (c) {
                case 'H': 
                case 'I': 
                case 'k': 
                case 'l': {
                    int n = calendar.get(11);
                    if (c == 'I' || c == 'l') {
                        n = n == 0 || n == 12 ? 12 : n % 12;
                    }
                    Flags flags = c == 'H' || c == 'I' ? Flags.ZERO_PAD : Flags.NONE;
                    stringBuilder.append((CharSequence)this.localizedMagnitude(null, n, flags, 2, locale));
                    break;
                }
                case 'M': {
                    int n = calendar.get(12);
                    Flags flags = Flags.ZERO_PAD;
                    stringBuilder.append((CharSequence)this.localizedMagnitude(null, n, flags, 2, locale));
                    break;
                }
                case 'N': {
                    int n = calendar.get(14) * 1000000;
                    Flags flags = Flags.ZERO_PAD;
                    stringBuilder.append((CharSequence)this.localizedMagnitude(null, n, flags, 9, locale));
                    break;
                }
                case 'L': {
                    int n = calendar.get(14);
                    Flags flags = Flags.ZERO_PAD;
                    stringBuilder.append((CharSequence)this.localizedMagnitude(null, n, flags, 3, locale));
                    break;
                }
                case 'Q': {
                    long l = calendar.getTimeInMillis();
                    Flags flags = Flags.NONE;
                    stringBuilder.append((CharSequence)this.localizedMagnitude(null, l, flags, this.width, locale));
                    break;
                }
                case 'p': {
                    Object object;
                    String[] stringArray = new String[]{"AM", "PM"};
                    if (locale != null && locale != Locale.US) {
                        object = DateFormatSymbols.getInstance(locale);
                        stringArray = ((DateFormatSymbols)object).getAmPmStrings();
                    }
                    object = stringArray[calendar.get(9)];
                    stringBuilder.append(((String)object).toLowerCase(locale != null ? locale : Locale.US));
                    break;
                }
                case 's': {
                    long l = calendar.getTimeInMillis() / 1000L;
                    Flags flags = Flags.NONE;
                    stringBuilder.append((CharSequence)this.localizedMagnitude(null, l, flags, this.width, locale));
                    break;
                }
                case 'S': {
                    int n = calendar.get(13);
                    Flags flags = Flags.ZERO_PAD;
                    stringBuilder.append((CharSequence)this.localizedMagnitude(null, n, flags, 2, locale));
                    break;
                }
                case 'z': {
                    int n = calendar.get(15) + calendar.get(16);
                    boolean bl = n < 0;
                    stringBuilder.append(bl ? (char)'-' : '+');
                    if (bl) {
                        n = -n;
                    }
                    int n2 = n / 60000;
                    int n3 = n2 / 60 * 100 + n2 % 60;
                    Flags flags = Flags.ZERO_PAD;
                    stringBuilder.append((CharSequence)this.localizedMagnitude(null, n3, flags, 4, locale));
                    break;
                }
                case 'Z': {
                    TimeZone timeZone = calendar.getTimeZone();
                    stringBuilder.append(timeZone.getDisplayName(calendar.get(16) != 0, 0, locale == null ? Locale.US : locale));
                    break;
                }
                case 'A': 
                case 'a': {
                    int n = calendar.get(7);
                    Locale locale2 = locale == null ? Locale.US : locale;
                    DateFormatSymbols dateFormatSymbols = DateFormatSymbols.getInstance(locale2);
                    if (c == 'A') {
                        stringBuilder.append(dateFormatSymbols.getWeekdays()[n]);
                        break;
                    }
                    stringBuilder.append(dateFormatSymbols.getShortWeekdays()[n]);
                    break;
                }
                case 'B': 
                case 'b': 
                case 'h': {
                    int n = calendar.get(2);
                    Locale locale3 = locale == null ? Locale.US : locale;
                    DateFormatSymbols dateFormatSymbols = DateFormatSymbols.getInstance(locale3);
                    if (c == 'B') {
                        stringBuilder.append(dateFormatSymbols.getMonths()[n]);
                        break;
                    }
                    stringBuilder.append(dateFormatSymbols.getShortMonths()[n]);
                    break;
                }
                case 'C': 
                case 'Y': 
                case 'y': {
                    int n = calendar.get(1);
                    int n4 = 2;
                    switch (c) {
                        case 'C': {
                            n /= 100;
                            break;
                        }
                        case 'y': {
                            n %= 100;
                            break;
                        }
                        case 'Y': {
                            n4 = 4;
                        }
                    }
                    Flags flags = Flags.ZERO_PAD;
                    stringBuilder.append((CharSequence)this.localizedMagnitude(null, n, flags, n4, locale));
                    break;
                }
                case 'd': 
                case 'e': {
                    int n = calendar.get(5);
                    Flags flags = c == 'd' ? Flags.ZERO_PAD : Flags.NONE;
                    stringBuilder.append((CharSequence)this.localizedMagnitude(null, n, flags, 2, locale));
                    break;
                }
                case 'j': {
                    int n = calendar.get(6);
                    Flags flags = Flags.ZERO_PAD;
                    stringBuilder.append((CharSequence)this.localizedMagnitude(null, n, flags, 3, locale));
                    break;
                }
                case 'm': {
                    int n = calendar.get(2) + 1;
                    Flags flags = Flags.ZERO_PAD;
                    stringBuilder.append((CharSequence)this.localizedMagnitude(null, n, flags, 2, locale));
                    break;
                }
                case 'R': 
                case 'T': {
                    char c2 = ':';
                    this.print(stringBuilder, calendar, 'H', locale).append(c2);
                    this.print(stringBuilder, calendar, 'M', locale);
                    if (c != 'T') break;
                    stringBuilder.append(c2);
                    this.print(stringBuilder, calendar, 'S', locale);
                    break;
                }
                case 'r': {
                    char c3 = ':';
                    this.print(stringBuilder, calendar, 'I', locale).append(c3);
                    this.print(stringBuilder, calendar, 'M', locale).append(c3);
                    this.print(stringBuilder, calendar, 'S', locale).append(' ');
                    StringBuilder stringBuilder2 = new StringBuilder();
                    this.print(stringBuilder2, calendar, 'p', locale);
                    stringBuilder.append(stringBuilder2.toString().toUpperCase(locale != null ? locale : Locale.US));
                    break;
                }
                case 'c': {
                    char c4 = ' ';
                    this.print(stringBuilder, calendar, 'a', locale).append(c4);
                    this.print(stringBuilder, calendar, 'b', locale).append(c4);
                    this.print(stringBuilder, calendar, 'd', locale).append(c4);
                    this.print(stringBuilder, calendar, 'T', locale).append(c4);
                    this.print(stringBuilder, calendar, 'Z', locale).append(c4);
                    this.print(stringBuilder, calendar, 'Y', locale);
                    break;
                }
                case 'D': {
                    char c5 = '/';
                    this.print(stringBuilder, calendar, 'm', locale).append(c5);
                    this.print(stringBuilder, calendar, 'd', locale).append(c5);
                    this.print(stringBuilder, calendar, 'y', locale);
                    break;
                }
                case 'F': {
                    char c6 = '-';
                    this.print(stringBuilder, calendar, 'Y', locale).append(c6);
                    this.print(stringBuilder, calendar, 'm', locale).append(c6);
                    this.print(stringBuilder, calendar, 'd', locale);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            return stringBuilder;
        }

        private void print(TemporalAccessor temporalAccessor, char c, Locale locale) throws IOException {
            StringBuilder stringBuilder = new StringBuilder();
            this.print(stringBuilder, temporalAccessor, c, locale);
            String string = this.justify(stringBuilder.toString());
            if (this.f.contains(Flags.UPPERCASE)) {
                string = string.toUpperCase();
            }
            Formatter.this.a.append(string);
        }

        private Appendable print(StringBuilder stringBuilder, TemporalAccessor temporalAccessor, char c, Locale locale) throws IOException {
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            }
            try {
                switch (c) {
                    case 'H': {
                        int n = temporalAccessor.get(ChronoField.HOUR_OF_DAY);
                        stringBuilder.append((CharSequence)this.localizedMagnitude(null, n, Flags.ZERO_PAD, 2, locale));
                        break;
                    }
                    case 'k': {
                        int n = temporalAccessor.get(ChronoField.HOUR_OF_DAY);
                        stringBuilder.append((CharSequence)this.localizedMagnitude(null, n, Flags.NONE, 2, locale));
                        break;
                    }
                    case 'I': {
                        int n = temporalAccessor.get(ChronoField.CLOCK_HOUR_OF_AMPM);
                        stringBuilder.append((CharSequence)this.localizedMagnitude(null, n, Flags.ZERO_PAD, 2, locale));
                        break;
                    }
                    case 'l': {
                        int n = temporalAccessor.get(ChronoField.CLOCK_HOUR_OF_AMPM);
                        stringBuilder.append((CharSequence)this.localizedMagnitude(null, n, Flags.NONE, 2, locale));
                        break;
                    }
                    case 'M': {
                        int n = temporalAccessor.get(ChronoField.MINUTE_OF_HOUR);
                        Flags flags = Flags.ZERO_PAD;
                        stringBuilder.append((CharSequence)this.localizedMagnitude(null, n, flags, 2, locale));
                        break;
                    }
                    case 'N': {
                        int n;
                        try {
                            n = temporalAccessor.get(ChronoField.NANO_OF_SECOND);
                        }
                        catch (UnsupportedTemporalTypeException unsupportedTemporalTypeException) {
                            n = temporalAccessor.get(ChronoField.MILLI_OF_SECOND) * 1000000;
                        }
                        Flags flags = Flags.ZERO_PAD;
                        stringBuilder.append((CharSequence)this.localizedMagnitude(null, n, flags, 9, locale));
                        break;
                    }
                    case 'L': {
                        int n = temporalAccessor.get(ChronoField.MILLI_OF_SECOND);
                        Flags flags = Flags.ZERO_PAD;
                        stringBuilder.append((CharSequence)this.localizedMagnitude(null, n, flags, 3, locale));
                        break;
                    }
                    case 'Q': {
                        long l = temporalAccessor.getLong(ChronoField.INSTANT_SECONDS) * 1000L + temporalAccessor.getLong(ChronoField.MILLI_OF_SECOND);
                        Flags flags = Flags.NONE;
                        stringBuilder.append((CharSequence)this.localizedMagnitude(null, l, flags, this.width, locale));
                        break;
                    }
                    case 'p': {
                        Object object;
                        String[] stringArray = new String[]{"AM", "PM"};
                        if (locale != null && locale != Locale.US) {
                            object = DateFormatSymbols.getInstance(locale);
                            stringArray = ((DateFormatSymbols)object).getAmPmStrings();
                        }
                        object = stringArray[temporalAccessor.get(ChronoField.AMPM_OF_DAY)];
                        stringBuilder.append(((String)object).toLowerCase(locale != null ? locale : Locale.US));
                        break;
                    }
                    case 's': {
                        long l = temporalAccessor.getLong(ChronoField.INSTANT_SECONDS);
                        Flags flags = Flags.NONE;
                        stringBuilder.append((CharSequence)this.localizedMagnitude(null, l, flags, this.width, locale));
                        break;
                    }
                    case 'S': {
                        int n = temporalAccessor.get(ChronoField.SECOND_OF_MINUTE);
                        Flags flags = Flags.ZERO_PAD;
                        stringBuilder.append((CharSequence)this.localizedMagnitude(null, n, flags, 2, locale));
                        break;
                    }
                    case 'z': {
                        int n = temporalAccessor.get(ChronoField.OFFSET_SECONDS);
                        boolean bl = n < 0;
                        stringBuilder.append(bl ? (char)'-' : '+');
                        if (bl) {
                            n = -n;
                        }
                        int n2 = n / 60;
                        int n3 = n2 / 60 * 100 + n2 % 60;
                        Flags flags = Flags.ZERO_PAD;
                        stringBuilder.append((CharSequence)this.localizedMagnitude(null, n3, flags, 4, locale));
                        break;
                    }
                    case 'Z': {
                        ZoneId zoneId = temporalAccessor.query(TemporalQueries.zone());
                        if (zoneId == null) {
                            throw new IllegalFormatConversionException(c, temporalAccessor.getClass());
                        }
                        if (!(zoneId instanceof ZoneOffset) && temporalAccessor.isSupported(ChronoField.INSTANT_SECONDS)) {
                            Instant instant = Instant.from(temporalAccessor);
                            stringBuilder.append(TimeZone.getTimeZone(zoneId.getId()).getDisplayName(zoneId.getRules().isDaylightSavings(instant), 0, locale == null ? Locale.US : locale));
                            break;
                        }
                        stringBuilder.append(zoneId.getId());
                        break;
                    }
                    case 'A': 
                    case 'a': {
                        int n = temporalAccessor.get(ChronoField.DAY_OF_WEEK) % 7 + 1;
                        Locale locale2 = locale == null ? Locale.US : locale;
                        DateFormatSymbols dateFormatSymbols = DateFormatSymbols.getInstance(locale2);
                        if (c == 'A') {
                            stringBuilder.append(dateFormatSymbols.getWeekdays()[n]);
                            break;
                        }
                        stringBuilder.append(dateFormatSymbols.getShortWeekdays()[n]);
                        break;
                    }
                    case 'B': 
                    case 'b': 
                    case 'h': {
                        int n = temporalAccessor.get(ChronoField.MONTH_OF_YEAR) - 1;
                        Locale locale3 = locale == null ? Locale.US : locale;
                        DateFormatSymbols dateFormatSymbols = DateFormatSymbols.getInstance(locale3);
                        if (c == 'B') {
                            stringBuilder.append(dateFormatSymbols.getMonths()[n]);
                            break;
                        }
                        stringBuilder.append(dateFormatSymbols.getShortMonths()[n]);
                        break;
                    }
                    case 'C': 
                    case 'Y': 
                    case 'y': {
                        int n = temporalAccessor.get(ChronoField.YEAR_OF_ERA);
                        int n4 = 2;
                        switch (c) {
                            case 'C': {
                                n /= 100;
                                break;
                            }
                            case 'y': {
                                n %= 100;
                                break;
                            }
                            case 'Y': {
                                n4 = 4;
                            }
                        }
                        Flags flags = Flags.ZERO_PAD;
                        stringBuilder.append((CharSequence)this.localizedMagnitude(null, n, flags, n4, locale));
                        break;
                    }
                    case 'd': 
                    case 'e': {
                        int n = temporalAccessor.get(ChronoField.DAY_OF_MONTH);
                        Flags flags = c == 'd' ? Flags.ZERO_PAD : Flags.NONE;
                        stringBuilder.append((CharSequence)this.localizedMagnitude(null, n, flags, 2, locale));
                        break;
                    }
                    case 'j': {
                        int n = temporalAccessor.get(ChronoField.DAY_OF_YEAR);
                        Flags flags = Flags.ZERO_PAD;
                        stringBuilder.append((CharSequence)this.localizedMagnitude(null, n, flags, 3, locale));
                        break;
                    }
                    case 'm': {
                        int n = temporalAccessor.get(ChronoField.MONTH_OF_YEAR);
                        Flags flags = Flags.ZERO_PAD;
                        stringBuilder.append((CharSequence)this.localizedMagnitude(null, n, flags, 2, locale));
                        break;
                    }
                    case 'R': 
                    case 'T': {
                        char c2 = ':';
                        this.print(stringBuilder, temporalAccessor, 'H', locale).append(c2);
                        this.print(stringBuilder, temporalAccessor, 'M', locale);
                        if (c == 'T') {
                            stringBuilder.append(c2);
                            this.print(stringBuilder, temporalAccessor, 'S', locale);
                        }
                        break;
                    }
                    case 'r': {
                        char c3 = ':';
                        this.print(stringBuilder, temporalAccessor, 'I', locale).append(c3);
                        this.print(stringBuilder, temporalAccessor, 'M', locale).append(c3);
                        this.print(stringBuilder, temporalAccessor, 'S', locale).append(' ');
                        StringBuilder stringBuilder2 = new StringBuilder();
                        this.print(stringBuilder2, temporalAccessor, 'p', locale);
                        stringBuilder.append(stringBuilder2.toString().toUpperCase(locale != null ? locale : Locale.US));
                        break;
                    }
                    case 'c': {
                        char c4 = ' ';
                        this.print(stringBuilder, temporalAccessor, 'a', locale).append(c4);
                        this.print(stringBuilder, temporalAccessor, 'b', locale).append(c4);
                        this.print(stringBuilder, temporalAccessor, 'd', locale).append(c4);
                        this.print(stringBuilder, temporalAccessor, 'T', locale).append(c4);
                        this.print(stringBuilder, temporalAccessor, 'Z', locale).append(c4);
                        this.print(stringBuilder, temporalAccessor, 'Y', locale);
                        break;
                    }
                    case 'D': {
                        char c5 = '/';
                        this.print(stringBuilder, temporalAccessor, 'm', locale).append(c5);
                        this.print(stringBuilder, temporalAccessor, 'd', locale).append(c5);
                        this.print(stringBuilder, temporalAccessor, 'y', locale);
                        break;
                    }
                    case 'F': {
                        char c6 = '-';
                        this.print(stringBuilder, temporalAccessor, 'Y', locale).append(c6);
                        this.print(stringBuilder, temporalAccessor, 'm', locale).append(c6);
                        this.print(stringBuilder, temporalAccessor, 'd', locale);
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
            }
            catch (DateTimeException dateTimeException) {
                throw new IllegalFormatConversionException(c, temporalAccessor.getClass());
            }
            return stringBuilder;
        }

        private void failMismatch(Flags flags, char c) {
            String string = flags.toString();
            throw new FormatFlagsConversionMismatchException(string, c);
        }

        private void failConversion(char c, Object object) {
            throw new IllegalFormatConversionException(c, object.getClass());
        }

        private char getZero(Locale locale) {
            if (locale != null && !locale.equals(Formatter.this.locale())) {
                DecimalFormatSymbols decimalFormatSymbols = DecimalFormatSymbols.getInstance(locale);
                return decimalFormatSymbols.getZeroDigit();
            }
            return Formatter.this.zero;
        }

        private StringBuilder localizedMagnitude(StringBuilder stringBuilder, long l, Flags flags, int n, Locale locale) {
            char[] cArray = Long.toString(l, 10).toCharArray();
            return this.localizedMagnitude(stringBuilder, cArray, flags, n, locale);
        }

        private StringBuilder localizedMagnitude(StringBuilder stringBuilder, char[] cArray, Flags flags, int n, Locale locale) {
            int n2;
            int n3;
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            }
            int n4 = stringBuilder.length();
            char c = this.getZero(locale);
            char c2 = '\u0000';
            int n5 = -1;
            char c3 = '\u0000';
            int n6 = n3 = cArray.length;
            for (n2 = 0; n2 < n3; ++n2) {
                if (cArray[n2] != '.') continue;
                n6 = n2;
                break;
            }
            if (n6 < n3) {
                if (locale == null || locale.equals(Locale.US)) {
                    c3 = '.';
                } else {
                    DecimalFormatSymbols decimalFormatSymbols = DecimalFormatSymbols.getInstance(locale);
                    c3 = decimalFormatSymbols.getDecimalSeparator();
                }
            }
            if (flags.contains(Flags.GROUP)) {
                if (locale == null || locale.equals(Locale.US)) {
                    c2 = ',';
                    n5 = 3;
                } else {
                    DecimalFormatSymbols decimalFormatSymbols = DecimalFormatSymbols.getInstance(locale);
                    c2 = decimalFormatSymbols.getGroupingSeparator();
                    DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getIntegerInstance(locale);
                    n5 = decimalFormat.getGroupingSize();
                }
            }
            for (n2 = 0; n2 < n3; ++n2) {
                if (n2 == n6) {
                    stringBuilder.append(c3);
                    c2 = '\u0000';
                    continue;
                }
                char c4 = cArray[n2];
                stringBuilder.append((char)(c4 - 48 + c));
                if (c2 == '\u0000' || n2 == n6 - 1 || (n6 - n2) % n5 != 1) continue;
                stringBuilder.append(c2);
            }
            n3 = stringBuilder.length();
            if (n > n3 && flags.contains(Flags.ZERO_PAD)) {
                char[] cArray2 = new char[n - n3];
                Arrays.fill(cArray2, c);
                stringBuilder.insert(n4, cArray2);
            }
            return stringBuilder;
        }

        private class BigDecimalLayout {
            private StringBuilder mant;
            private StringBuilder exp;
            private boolean dot = false;
            private int scale;

            public BigDecimalLayout(BigInteger bigInteger, int n, BigDecimalLayoutForm bigDecimalLayoutForm) {
                this.layout(bigInteger, n, bigDecimalLayoutForm);
            }

            public boolean hasDot() {
                return this.dot;
            }

            public int scale() {
                return this.scale;
            }

            public char[] layoutChars() {
                StringBuilder stringBuilder = new StringBuilder(this.mant);
                if (this.exp != null) {
                    stringBuilder.append('E');
                    stringBuilder.append((CharSequence)this.exp);
                }
                return this.toCharArray(stringBuilder);
            }

            public char[] mantissa() {
                return this.toCharArray(this.mant);
            }

            public char[] exponent() {
                return this.toCharArray(this.exp);
            }

            private char[] toCharArray(StringBuilder stringBuilder) {
                if (stringBuilder == null) {
                    return null;
                }
                char[] cArray = new char[stringBuilder.length()];
                stringBuilder.getChars(0, cArray.length, cArray, 0);
                return cArray;
            }

            private void layout(BigInteger bigInteger, int n, BigDecimalLayoutForm bigDecimalLayoutForm) {
                char[] cArray = bigInteger.toString().toCharArray();
                this.scale = n;
                this.mant = new StringBuilder(cArray.length + 14);
                if (n == 0) {
                    int n2 = cArray.length;
                    if (n2 > 1) {
                        this.mant.append(cArray[0]);
                        if (bigDecimalLayoutForm == BigDecimalLayoutForm.SCIENTIFIC) {
                            this.mant.append('.');
                            this.dot = true;
                            this.mant.append(cArray, 1, n2 - 1);
                            this.exp = new StringBuilder("+");
                            if (n2 < 10) {
                                this.exp.append("0").append(n2 - 1);
                            } else {
                                this.exp.append(n2 - 1);
                            }
                        } else {
                            this.mant.append(cArray, 1, n2 - 1);
                        }
                    } else {
                        this.mant.append(cArray);
                        if (bigDecimalLayoutForm == BigDecimalLayoutForm.SCIENTIFIC) {
                            this.exp = new StringBuilder("+00");
                        }
                    }
                    return;
                }
                long l = -((long)n) + (long)(cArray.length - 1);
                if (bigDecimalLayoutForm == BigDecimalLayoutForm.DECIMAL_FLOAT) {
                    int n3 = n - cArray.length;
                    if (n3 >= 0) {
                        this.mant.append("0.");
                        this.dot = true;
                        while (n3 > 0) {
                            this.mant.append('0');
                            --n3;
                        }
                        this.mant.append(cArray);
                    } else if (-n3 < cArray.length) {
                        this.mant.append(cArray, 0, -n3);
                        this.mant.append('.');
                        this.dot = true;
                        this.mant.append(cArray, -n3, n);
                    } else {
                        this.mant.append(cArray, 0, cArray.length);
                        for (int i = 0; i < -n; ++i) {
                            this.mant.append('0');
                        }
                        this.scale = 0;
                    }
                } else {
                    this.mant.append(cArray[0]);
                    if (cArray.length > 1) {
                        this.mant.append('.');
                        this.dot = true;
                        this.mant.append(cArray, 1, cArray.length - 1);
                    }
                    this.exp = new StringBuilder();
                    if (l != 0L) {
                        long l2 = Math.abs(l);
                        this.exp.append(l < 0L ? (char)'-' : '+');
                        if (l2 < 10L) {
                            this.exp.append('0');
                        }
                        this.exp.append(l2);
                    } else {
                        this.exp.append("+00");
                    }
                }
            }
        }
    }

    public static enum BigDecimalLayoutForm {
        SCIENTIFIC,
        DECIMAL_FLOAT;

    }

    private class FixedString
    implements FormatString {
        private String s;

        FixedString(String string) {
            this.s = string;
        }

        @Override
        public int index() {
            return -2;
        }

        @Override
        public void print(Object object, Locale locale) throws IOException {
            Formatter.this.a.append(this.s);
        }

        @Override
        public String toString() {
            return this.s;
        }
    }

    private static interface FormatString {
        public int index();

        public void print(Object var1, Locale var2) throws IOException;

        public String toString();
    }
}

