/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;

public class Base64 {
    private Base64() {
    }

    public static Encoder getEncoder() {
        return Encoder.RFC4648;
    }

    public static Encoder getUrlEncoder() {
        return Encoder.RFC4648_URLSAFE;
    }

    public static Encoder getMimeEncoder() {
        return Encoder.RFC2045;
    }

    public static Encoder getMimeEncoder(int n, byte[] byArray) {
        Objects.requireNonNull(byArray);
        int[] nArray = Decoder.fromBase64;
        for (byte by : byArray) {
            if (nArray[by & 0xFF] == -1) continue;
            throw new IllegalArgumentException("Illegal base64 line separator character 0x" + Integer.toString(by, 16));
        }
        if (n <= 0) {
            return Encoder.RFC4648;
        }
        return new Encoder(false, byArray, n >> 2 << 2, true);
    }

    public static Decoder getDecoder() {
        return Decoder.RFC4648;
    }

    public static Decoder getUrlDecoder() {
        return Decoder.RFC4648_URLSAFE;
    }

    public static Decoder getMimeDecoder() {
        return Decoder.RFC2045;
    }

    private static class DecInputStream
    extends InputStream {
        private final InputStream is;
        private final boolean isMIME;
        private final int[] base64;
        private int bits = 0;
        private int nextin = 18;
        private int nextout = -8;
        private boolean eof = false;
        private boolean closed = false;
        private byte[] sbBuf = new byte[1];

        DecInputStream(InputStream inputStream, int[] nArray, boolean bl) {
            this.is = inputStream;
            this.base64 = nArray;
            this.isMIME = bl;
        }

        @Override
        public int read() throws IOException {
            return this.read(this.sbBuf, 0, 1) == -1 ? -1 : this.sbBuf[0] & 0xFF;
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (this.closed) {
                throw new IOException("Stream is closed");
            }
            if (this.eof && this.nextout < 0) {
                return -1;
            }
            if (n < 0 || n2 < 0 || n2 > byArray.length - n) {
                throw new IndexOutOfBoundsException();
            }
            int n3 = n;
            if (this.nextout >= 0) {
                do {
                    if (n2 == 0) {
                        return n - n3;
                    }
                    byArray[n++] = (byte)(this.bits >> this.nextout);
                    --n2;
                    this.nextout -= 8;
                } while (this.nextout >= 0);
                this.bits = 0;
            }
            while (n2 > 0) {
                int n4 = this.is.read();
                if (n4 == -1) {
                    this.eof = true;
                    if (this.nextin != 18) {
                        if (this.nextin == 12) {
                            throw new IOException("Base64 stream has one un-decoded dangling byte.");
                        }
                        byArray[n++] = (byte)(this.bits >> 16);
                        --n2;
                        if (this.nextin == 0) {
                            if (n2 == 0) {
                                this.bits >>= 8;
                                this.nextout = 0;
                            } else {
                                byArray[n++] = (byte)(this.bits >> 8);
                            }
                        }
                    }
                    if (n == n3) {
                        return -1;
                    }
                    return n - n3;
                }
                if (n4 == 61) {
                    if (this.nextin == 18 || this.nextin == 12 || this.nextin == 6 && this.is.read() != 61) {
                        throw new IOException("Illegal base64 ending sequence:" + this.nextin);
                    }
                    byArray[n++] = (byte)(this.bits >> 16);
                    --n2;
                    if (this.nextin == 0) {
                        if (n2 == 0) {
                            this.bits >>= 8;
                            this.nextout = 0;
                        } else {
                            byArray[n++] = (byte)(this.bits >> 8);
                        }
                    }
                    this.eof = true;
                    break;
                }
                if ((n4 = this.base64[n4]) == -1) {
                    if (this.isMIME) continue;
                    throw new IOException("Illegal base64 character " + Integer.toString(n4, 16));
                }
                this.bits |= n4 << this.nextin;
                if (this.nextin == 0) {
                    this.nextin = 18;
                    this.nextout = 16;
                    while (this.nextout >= 0) {
                        byArray[n++] = (byte)(this.bits >> this.nextout);
                        this.nextout -= 8;
                        if (--n2 != 0 || this.nextout < 0) continue;
                        return n - n3;
                    }
                    this.bits = 0;
                    continue;
                }
                this.nextin -= 6;
            }
            return n - n3;
        }

        @Override
        public int available() throws IOException {
            if (this.closed) {
                throw new IOException("Stream is closed");
            }
            return this.is.available();
        }

        @Override
        public void close() throws IOException {
            if (!this.closed) {
                this.closed = true;
                this.is.close();
            }
        }
    }

    private static class EncOutputStream
    extends FilterOutputStream {
        private int leftover = 0;
        private int b0;
        private int b1;
        private int b2;
        private boolean closed = false;
        private final char[] base64;
        private final byte[] newline;
        private final int linemax;
        private final boolean doPadding;
        private int linepos = 0;

        EncOutputStream(OutputStream outputStream, char[] cArray, byte[] byArray, int n, boolean bl) {
            super(outputStream);
            this.base64 = cArray;
            this.newline = byArray;
            this.linemax = n;
            this.doPadding = bl;
        }

        @Override
        public void write(int n) throws IOException {
            byte[] byArray = new byte[]{(byte)(n & 0xFF)};
            this.write(byArray, 0, 1);
        }

        private void checkNewline() throws IOException {
            if (this.linepos == this.linemax) {
                this.out.write(this.newline);
                this.linepos = 0;
            }
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            if (this.closed) {
                throw new IOException("Stream is closed");
            }
            if (n < 0 || n2 < 0 || n2 > byArray.length - n) {
                throw new ArrayIndexOutOfBoundsException();
            }
            if (n2 == 0) {
                return;
            }
            if (this.leftover != 0) {
                if (this.leftover == 1) {
                    this.b1 = byArray[n++] & 0xFF;
                    if (--n2 == 0) {
                        ++this.leftover;
                        return;
                    }
                }
                this.b2 = byArray[n++] & 0xFF;
                --n2;
                this.checkNewline();
                this.out.write(this.base64[this.b0 >> 2]);
                this.out.write(this.base64[this.b0 << 4 & 0x3F | this.b1 >> 4]);
                this.out.write(this.base64[this.b1 << 2 & 0x3F | this.b2 >> 6]);
                this.out.write(this.base64[this.b2 & 0x3F]);
                this.linepos += 4;
            }
            int n3 = n2 / 3;
            this.leftover = n2 - n3 * 3;
            while (n3-- > 0) {
                this.checkNewline();
                int n4 = (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
                this.out.write(this.base64[n4 >>> 18 & 0x3F]);
                this.out.write(this.base64[n4 >>> 12 & 0x3F]);
                this.out.write(this.base64[n4 >>> 6 & 0x3F]);
                this.out.write(this.base64[n4 & 0x3F]);
                this.linepos += 4;
            }
            if (this.leftover == 1) {
                this.b0 = byArray[n++] & 0xFF;
            } else if (this.leftover == 2) {
                this.b0 = byArray[n++] & 0xFF;
                this.b1 = byArray[n++] & 0xFF;
            }
        }

        @Override
        public void close() throws IOException {
            if (!this.closed) {
                this.closed = true;
                if (this.leftover == 1) {
                    this.checkNewline();
                    this.out.write(this.base64[this.b0 >> 2]);
                    this.out.write(this.base64[this.b0 << 4 & 0x3F]);
                    if (this.doPadding) {
                        this.out.write(61);
                        this.out.write(61);
                    }
                } else if (this.leftover == 2) {
                    this.checkNewline();
                    this.out.write(this.base64[this.b0 >> 2]);
                    this.out.write(this.base64[this.b0 << 4 & 0x3F | this.b1 >> 4]);
                    this.out.write(this.base64[this.b1 << 2 & 0x3F]);
                    if (this.doPadding) {
                        this.out.write(61);
                    }
                }
                this.leftover = 0;
                this.out.close();
            }
        }
    }

    public static class Decoder {
        private final boolean isURL;
        private final boolean isMIME;
        private static final int[] fromBase64;
        private static final int[] fromBase64URL;
        static final Decoder RFC4648;
        static final Decoder RFC4648_URLSAFE;
        static final Decoder RFC2045;

        private Decoder(boolean bl, boolean bl2) {
            this.isURL = bl;
            this.isMIME = bl2;
        }

        public byte[] decode(byte[] byArray) {
            byte[] byArray2 = new byte[this.outLength(byArray, 0, byArray.length)];
            int n = this.decode0(byArray, 0, byArray.length, byArray2);
            if (n != byArray2.length) {
                byArray2 = Arrays.copyOf(byArray2, n);
            }
            return byArray2;
        }

        public byte[] decode(String string) {
            return this.decode(string.getBytes(StandardCharsets.ISO_8859_1));
        }

        public int decode(byte[] byArray, byte[] byArray2) {
            int n = this.outLength(byArray, 0, byArray.length);
            if (byArray2.length < n) {
                throw new IllegalArgumentException("Output byte array is too small for decoding all input bytes");
            }
            return this.decode0(byArray, 0, byArray.length, byArray2);
        }

        public ByteBuffer decode(ByteBuffer byteBuffer) {
            int n = byteBuffer.position();
            try {
                int n2;
                int n3;
                byte[] byArray;
                if (byteBuffer.hasArray()) {
                    byArray = byteBuffer.array();
                    n3 = byteBuffer.arrayOffset() + byteBuffer.position();
                    n2 = byteBuffer.arrayOffset() + byteBuffer.limit();
                    byteBuffer.position(byteBuffer.limit());
                } else {
                    byArray = new byte[byteBuffer.remaining()];
                    byteBuffer.get(byArray);
                    n3 = 0;
                    n2 = byArray.length;
                }
                byte[] byArray2 = new byte[this.outLength(byArray, n3, n2)];
                return ByteBuffer.wrap(byArray2, 0, this.decode0(byArray, n3, n2, byArray2));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                byteBuffer.position(n);
                throw illegalArgumentException;
            }
        }

        public InputStream wrap(InputStream inputStream) {
            Objects.requireNonNull(inputStream);
            return new DecInputStream(inputStream, this.isURL ? fromBase64URL : fromBase64, this.isMIME);
        }

        private int outLength(byte[] byArray, int n, int n2) {
            int[] nArray = this.isURL ? fromBase64URL : fromBase64;
            int n3 = 0;
            int n4 = n2 - n;
            if (n4 == 0) {
                return 0;
            }
            if (n4 < 2) {
                if (this.isMIME && nArray[0] == -1) {
                    return 0;
                }
                throw new IllegalArgumentException("Input byte[] should at least have 2 bytes for base64 bytes");
            }
            if (this.isMIME) {
                int n5 = 0;
                while (n < n2) {
                    int n6;
                    if ((n6 = byArray[n++] & 0xFF) == 61) {
                        n4 -= n2 - n + 1;
                        break;
                    }
                    if ((n6 = nArray[n6]) != -1) continue;
                    ++n5;
                }
                n4 -= n5;
            } else if (byArray[n2 - 1] == 61) {
                ++n3;
                if (byArray[n2 - 2] == 61) {
                    ++n3;
                }
            }
            if (n3 == 0 && (n4 & 3) != 0) {
                n3 = 4 - (n4 & 3);
            }
            return 3 * ((n4 + 3) / 4) - n3;
        }

        private int decodeBlock(byte[] byArray, int n, int n2, byte[] byArray2, int n3, boolean bl, boolean bl2) {
            int[] nArray = bl ? fromBase64URL : fromBase64;
            int n4 = n + (n2 - n & 0xFFFFFFFC);
            int n5 = n3;
            while (n < n4) {
                int n6;
                int n7;
                int n8 = nArray[byArray[n++] & 0xFF];
                int n9 = nArray[byArray[n++] & 0xFF];
                if ((n8 | n9 | (n7 = nArray[byArray[n++] & 0xFF]) | (n6 = nArray[byArray[n++] & 0xFF])) < 0) {
                    return n5 - n3;
                }
                int n10 = n8 << 18 | n9 << 12 | n7 << 6 | n6;
                byArray2[n5++] = (byte)(n10 >> 16);
                byArray2[n5++] = (byte)(n10 >> 8);
                byArray2[n5++] = (byte)n10;
            }
            return n5 - n3;
        }

        private int decode0(byte[] byArray, int n, int n2, byte[] byArray2) {
            int[] nArray = this.isURL ? fromBase64URL : fromBase64;
            int n3 = 0;
            int n4 = 0;
            int n5 = 18;
            while (n < n2) {
                int n6;
                if (n5 == 18 && n < n2 - 4) {
                    n6 = this.decodeBlock(byArray, n, n2, byArray2, n3, this.isURL, this.isMIME);
                    int n7 = (n6 + 2) / 3 * 4;
                    n += n7;
                    n3 += n6;
                }
                if (n >= n2) break;
                n6 = byArray[n++] & 0xFF;
                if ((n6 = nArray[n6]) < 0) {
                    if (n6 == -2) {
                        if ((n5 != 6 || n != n2 && byArray[n++] == 61) && n5 != 18) break;
                        throw new IllegalArgumentException("Input byte array has wrong 4-byte ending unit");
                    }
                    if (this.isMIME) continue;
                    throw new IllegalArgumentException("Illegal base64 character " + Integer.toString(byArray[n - 1], 16));
                }
                n4 |= n6 << n5;
                if ((n5 -= 6) >= 0) continue;
                byArray2[n3++] = (byte)(n4 >> 16);
                byArray2[n3++] = (byte)(n4 >> 8);
                byArray2[n3++] = (byte)n4;
                n5 = 18;
                n4 = 0;
            }
            if (n5 == 6) {
                byArray2[n3++] = (byte)(n4 >> 16);
            } else if (n5 == 0) {
                byArray2[n3++] = (byte)(n4 >> 16);
                byArray2[n3++] = (byte)(n4 >> 8);
            } else if (n5 == 12) {
                throw new IllegalArgumentException("Last unit does not have enough valid bits");
            }
            while (n < n2) {
                if (this.isMIME && nArray[byArray[n++]] < 0) continue;
                throw new IllegalArgumentException("Input byte array has incorrect ending byte at " + n);
            }
            return n3;
        }

        static {
            int n;
            fromBase64 = new int[256];
            Arrays.fill(fromBase64, -1);
            for (n = 0; n < Encoder.toBase64.length; ++n) {
                Decoder.fromBase64[Encoder.toBase64[n]] = n;
            }
            Decoder.fromBase64[61] = -2;
            fromBase64URL = new int[256];
            Arrays.fill(fromBase64URL, -1);
            for (n = 0; n < Encoder.toBase64URL.length; ++n) {
                Decoder.fromBase64URL[Encoder.toBase64URL[n]] = n;
            }
            Decoder.fromBase64URL[61] = -2;
            RFC4648 = new Decoder(false, false);
            RFC4648_URLSAFE = new Decoder(true, false);
            RFC2045 = new Decoder(false, true);
        }
    }

    public static class Encoder {
        private final byte[] newline;
        private final int linemax;
        private final boolean isURL;
        private final boolean doPadding;
        private static final char[] toBase64 = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
        private static final char[] toBase64URL = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '-', '_'};
        private static final int MIMELINEMAX = 76;
        private static final byte[] CRLF = new byte[]{13, 10};
        static final Encoder RFC4648 = new Encoder(false, null, -1, true);
        static final Encoder RFC4648_URLSAFE = new Encoder(true, null, -1, true);
        static final Encoder RFC2045 = new Encoder(false, CRLF, 76, true);

        private Encoder(boolean bl, byte[] byArray, int n, boolean bl2) {
            this.isURL = bl;
            this.newline = byArray;
            this.linemax = n;
            this.doPadding = bl2;
        }

        private final int outLength(int n) {
            int n2 = 0;
            if (this.doPadding) {
                n2 = 4 * ((n + 2) / 3);
            } else {
                int n3 = n % 3;
                n2 = 4 * (n / 3) + (n3 == 0 ? 0 : n3 + 1);
            }
            if (this.linemax > 0) {
                n2 += (n2 - 1) / this.linemax * this.newline.length;
            }
            return n2;
        }

        public byte[] encode(byte[] byArray) {
            int n = this.outLength(byArray.length);
            byte[] byArray2 = new byte[n];
            int n2 = this.encode0(byArray, 0, byArray.length, byArray2);
            if (n2 != byArray2.length) {
                return Arrays.copyOf(byArray2, n2);
            }
            return byArray2;
        }

        public int encode(byte[] byArray, byte[] byArray2) {
            int n = this.outLength(byArray.length);
            if (byArray2.length < n) {
                throw new IllegalArgumentException("Output byte array is too small for encoding all input bytes");
            }
            return this.encode0(byArray, 0, byArray.length, byArray2);
        }

        public String encodeToString(byte[] byArray) {
            byte[] byArray2 = this.encode(byArray);
            return new String(byArray2, 0, 0, byArray2.length);
        }

        public ByteBuffer encode(ByteBuffer byteBuffer) {
            int n = this.outLength(byteBuffer.remaining());
            byte[] byArray = new byte[n];
            int n2 = 0;
            if (byteBuffer.hasArray()) {
                n2 = this.encode0(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.arrayOffset() + byteBuffer.limit(), byArray);
                byteBuffer.position(byteBuffer.limit());
            } else {
                byte[] byArray2 = new byte[byteBuffer.remaining()];
                byteBuffer.get(byArray2);
                n2 = this.encode0(byArray2, 0, byArray2.length, byArray);
            }
            if (n2 != byArray.length) {
                byArray = Arrays.copyOf(byArray, n2);
            }
            return ByteBuffer.wrap(byArray);
        }

        public OutputStream wrap(OutputStream outputStream) {
            Objects.requireNonNull(outputStream);
            return new EncOutputStream(outputStream, this.isURL ? toBase64URL : toBase64, this.newline, this.linemax, this.doPadding);
        }

        public Encoder withoutPadding() {
            if (!this.doPadding) {
                return this;
            }
            return new Encoder(this.isURL, this.newline, this.linemax, false);
        }

        private void encodeBlock(byte[] byArray, int n, int n2, byte[] byArray2, int n3, boolean bl) {
            char[] cArray = bl ? toBase64URL : toBase64;
            int n4 = n;
            int n5 = n3;
            while (n4 < n2) {
                int n6 = (byArray[n4++] & 0xFF) << 16 | (byArray[n4++] & 0xFF) << 8 | byArray[n4++] & 0xFF;
                byArray2[n5++] = (byte)cArray[n6 >>> 18 & 0x3F];
                byArray2[n5++] = (byte)cArray[n6 >>> 12 & 0x3F];
                byArray2[n5++] = (byte)cArray[n6 >>> 6 & 0x3F];
                byArray2[n5++] = (byte)cArray[n6 & 0x3F];
            }
        }

        private int encode0(byte[] byArray, int n, int n2, byte[] byArray2) {
            int n3;
            int n4;
            char[] cArray = this.isURL ? toBase64URL : toBase64;
            int n5 = n;
            int n6 = (n2 - n) / 3 * 3;
            int n7 = n + n6;
            if (this.linemax > 0 && n6 > this.linemax / 4 * 3) {
                n6 = this.linemax / 4 * 3;
            }
            int n8 = 0;
            while (n5 < n7) {
                n4 = Math.min(n5 + n6, n7);
                this.encodeBlock(byArray, n5, n4, byArray2, n8, this.isURL);
                n3 = (n4 - n5) / 3 * 4;
                n8 += n3;
                n5 = n4;
                if (n3 != this.linemax || n5 >= n2) continue;
                for (byte by : this.newline) {
                    byArray2[n8++] = by;
                }
            }
            if (n5 < n2) {
                n4 = byArray[n5++] & 0xFF;
                byArray2[n8++] = (byte)cArray[n4 >> 2];
                if (n5 == n2) {
                    byArray2[n8++] = (byte)cArray[n4 << 4 & 0x3F];
                    if (this.doPadding) {
                        byArray2[n8++] = 61;
                        byArray2[n8++] = 61;
                    }
                } else {
                    n3 = byArray[n5++] & 0xFF;
                    byArray2[n8++] = (byte)cArray[n4 << 4 & 0x3F | n3 >> 4];
                    byArray2[n8++] = (byte)cArray[n3 << 2 & 0x3F];
                    if (this.doPadding) {
                        byArray2[n8++] = 61;
                    }
                }
            }
            return n8;
        }
    }
}

