/*
 * Decompiled with CFR 0.152.
 */
package java.lang.ref;

import com.azulsystems.misc.VM;
import java.lang.ref.ReferenceQueue;
import sun.misc.Cleaner;
import sun.misc.JavaLangRefAccess;
import sun.misc.SharedSecrets;

public abstract class Reference<T> {
    private T referent;
    private Reference<Object> pending;
    volatile ReferenceQueue<? super T> queue;
    volatile Reference next;
    private transient Reference<T> discovered;
    private static Lock lock = new Lock();
    private static Reference<Object> pending_list;

    private static native void registerNatives();

    static native boolean pendingInNext();

    native T concurrentGetReferent();

    static boolean tryHandlePending(boolean bl) {
        return Reference.processThroughPending(bl);
    }

    private static boolean processPending(Cleaner cleaner, Reference<Object> reference) {
        if (cleaner != null) {
            cleaner.clean();
            return true;
        }
        ReferenceQueue<Object> referenceQueue = reference.queue;
        if (referenceQueue != ReferenceQueue.NULL) {
            referenceQueue.enqueue(reference);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean processThroughNext(boolean bl) {
        Cleaner cleaner;
        Reference<Object> reference;
        try {
            Lock lock = Reference.lock;
            synchronized (lock) {
                if (pending_list == null) {
                    if (bl) {
                        Reference.lock.wait();
                    }
                    return bl;
                }
                reference = pending_list;
                cleaner = reference instanceof Cleaner ? (Cleaner)reference : null;
                Reference reference2 = reference.next;
                pending_list = reference2 == reference ? null : reference2;
                reference.next = reference;
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            Thread.yield();
            return true;
        }
        catch (InterruptedException interruptedException) {
            return true;
        }
        return Reference.processPending(cleaner, reference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean processThroughPending(boolean bl) {
        Cleaner cleaner;
        Reference<Object> reference;
        try {
            Lock lock = Reference.lock;
            synchronized (lock) {
                if (pending_list == null) {
                    if (bl) {
                        Reference.lock.wait();
                    }
                    return bl;
                }
                reference = pending_list;
                cleaner = reference instanceof Cleaner ? (Cleaner)reference : null;
                Reference<Object> reference2 = reference.pending;
                pending_list = reference2 == reference ? null : reference2;
                reference.pending = reference;
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            Thread.yield();
            return true;
        }
        catch (InterruptedException interruptedException) {
            return true;
        }
        return Reference.processPending(cleaner, reference);
    }

    public T get() {
        return (T)VM.staticGetReferent(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    T getReferentSafe() {
        Lock lock = Reference.lock;
        synchronized (lock) {
            return (T)VM.staticGetReferent(this);
        }
    }

    public void clear() {
        VM.staticSetReferent(this, null);
    }

    public boolean isEnqueued() {
        return this.queue == ReferenceQueue.ENQUEUED;
    }

    public boolean enqueue() {
        VM.staticSetReferent(this, null);
        return this.queue.enqueue(this);
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    Reference(T t) {
        this(t, null);
    }

    Reference(T t, ReferenceQueue<? super T> referenceQueue) {
        VM.staticSetReferent(this, t);
        this.queue = referenceQueue == null ? ReferenceQueue.NULL : referenceQueue;
    }

    static {
        Reference.registerNatives();
        pending_list = null;
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        Object object = threadGroup;
        while (object != null) {
            threadGroup = object;
            object = threadGroup.getParent();
        }
        object = new ReferenceHandler(threadGroup, "Reference Handler");
        ((Thread)object).setPriority(10);
        ((Thread)object).setDaemon(true);
        ((Thread)object).start();
        SharedSecrets.setJavaLangRefAccess(new JavaLangRefAccess(){

            @Override
            public boolean tryHandlePendingReference() {
                return Reference.tryHandlePending(false);
            }
        });
    }

    private static class ReferenceHandler
    extends Thread {
        private static void ensureClassInitialized(Class<?> clazz) {
            try {
                Class.forName(clazz.getName(), true, clazz.getClassLoader());
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw (Error)new NoClassDefFoundError(classNotFoundException.getMessage()).initCause(classNotFoundException);
            }
        }

        ReferenceHandler(ThreadGroup threadGroup, String string) {
            super(threadGroup, string);
        }

        @Override
        public void run() {
            while (true) {
                Reference.tryHandlePending(true);
            }
        }

        static {
            ReferenceHandler.ensureClassInitialized(InterruptedException.class);
            ReferenceHandler.ensureClassInitialized(Cleaner.class);
        }
    }

    private static class Lock {
        private Lock() {
        }
    }
}

