/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.LambdaForm;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodType;
import java.lang.ref.SoftReference;
import jdk.internal.vm.annotation.Stable;
import sun.invoke.util.Wrapper;

final class MethodTypeForm {
    final int[] argToSlotTable;
    final int[] slotToArgTable;
    final long argCounts;
    final long primCounts;
    final MethodType erasedType;
    final MethodType basicType;
    @Stable
    final SoftReference<MethodHandle>[] methodHandles;
    static final int MH_BASIC_INV = 0;
    static final int MH_NF_INV = 1;
    static final int MH_UNINIT_CS = 2;
    static final int MH_LIMIT = 3;
    @Stable
    final SoftReference<LambdaForm>[] lambdaForms;
    static final int LF_INVVIRTUAL = 0;
    static final int LF_INVSTATIC = 1;
    static final int LF_INVSPECIAL = 2;
    static final int LF_NEWINVSPECIAL = 3;
    static final int LF_INVINTERFACE = 4;
    static final int LF_INVSTATIC_INIT = 5;
    static final int LF_INTERPRET = 6;
    static final int LF_REBIND = 7;
    static final int LF_DELEGATE = 8;
    static final int LF_DELEGATE_BLOCK_INLINING = 9;
    static final int LF_EX_LINKER = 10;
    static final int LF_EX_INVOKER = 11;
    static final int LF_GEN_LINKER = 12;
    static final int LF_GEN_INVOKER = 13;
    static final int LF_CS_LINKER = 14;
    static final int LF_MH_LINKER = 15;
    static final int LF_GWC = 16;
    static final int LF_GWT = 17;
    static final int LF_LIMIT = 18;
    public static final int NO_CHANGE = 0;
    public static final int ERASE = 1;
    public static final int WRAP = 2;
    public static final int UNWRAP = 3;
    public static final int INTS = 4;
    public static final int LONGS = 5;
    public static final int RAW_RETURN = 6;

    public MethodType erasedType() {
        return this.erasedType;
    }

    public MethodType basicType() {
        return this.basicType;
    }

    private boolean assertIsBasicType() {
        assert (this.erasedType == this.basicType) : "erasedType: " + this.erasedType + " != basicType: " + this.basicType;
        return true;
    }

    public MethodHandle cachedMethodHandle(int n) {
        assert (this.assertIsBasicType());
        SoftReference<MethodHandle> softReference = this.methodHandles[n];
        return softReference != null ? softReference.get() : null;
    }

    public synchronized MethodHandle setCachedMethodHandle(int n, MethodHandle methodHandle) {
        MethodHandle methodHandle2;
        SoftReference<MethodHandle> softReference = this.methodHandles[n];
        if (softReference != null && (methodHandle2 = softReference.get()) != null) {
            return methodHandle2;
        }
        this.methodHandles[n] = new SoftReference<MethodHandle>(methodHandle);
        return methodHandle;
    }

    public LambdaForm cachedLambdaForm(int n) {
        assert (this.assertIsBasicType());
        SoftReference<LambdaForm> softReference = this.lambdaForms[n];
        return softReference != null ? softReference.get() : null;
    }

    public synchronized LambdaForm setCachedLambdaForm(int n, LambdaForm lambdaForm) {
        LambdaForm lambdaForm2;
        SoftReference<LambdaForm> softReference = this.lambdaForms[n];
        if (softReference != null && (lambdaForm2 = softReference.get()) != null) {
            return lambdaForm2;
        }
        this.lambdaForms[n] = new SoftReference<LambdaForm>(lambdaForm);
        return lambdaForm;
    }

    protected MethodTypeForm(MethodType methodType) {
        Object object;
        Class<Object> clazz;
        Class<?>[] classArray;
        int n;
        this.erasedType = methodType;
        Class<?>[] classArray2 = methodType.ptypes();
        int n2 = n = classArray2.length;
        int n3 = 1;
        int n4 = 1;
        int[] nArray = null;
        int[] nArray2 = null;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        Class<?>[] classArray3 = classArray = classArray2;
        for (int i = 0; i < classArray.length; ++i) {
            clazz = classArray[i];
            if (clazz == Object.class) continue;
            ++n5;
            object = Wrapper.forPrimitiveType(clazz);
            if (object.isDoubleWord()) {
                ++n6;
            }
            if (!object.isSubwordOrInt() || clazz == Integer.TYPE) continue;
            if (classArray3 == classArray) {
                classArray3 = (Class[])classArray3.clone();
            }
            classArray3[i] = Integer.TYPE;
        }
        n2 += n6;
        Class<?> clazz2 = methodType.returnType();
        clazz = clazz2;
        if (clazz2 != Object.class) {
            ++n7;
            object = Wrapper.forPrimitiveType(clazz2);
            if (object.isDoubleWord()) {
                ++n8;
            }
            if (object.isSubwordOrInt() && clazz2 != Integer.TYPE) {
                clazz = Integer.TYPE;
            }
            if (clazz2 == Void.TYPE) {
                n4 = 0;
                n3 = 0;
            } else {
                n4 += n8;
            }
        }
        if (classArray != classArray3 || clazz != clazz2) {
            this.basicType = MethodType.makeImpl(clazz, classArray3, true);
            object = this.basicType.form();
            assert (this != object);
            this.primCounts = ((MethodTypeForm)object).primCounts;
            this.argCounts = ((MethodTypeForm)object).argCounts;
            this.argToSlotTable = ((MethodTypeForm)object).argToSlotTable;
            this.slotToArgTable = ((MethodTypeForm)object).slotToArgTable;
            this.methodHandles = null;
            this.lambdaForms = null;
            return;
        }
        this.basicType = methodType;
        if (n6 != 0) {
            int n9 = n + n6;
            nArray2 = new int[n9 + 1];
            nArray = new int[1 + n];
            nArray[0] = n9;
            for (int i = 0; i < classArray.length; ++i) {
                Class<?> clazz3 = classArray[i];
                Wrapper wrapper = Wrapper.forBasicType(clazz3);
                if (wrapper.isDoubleWord()) {
                    --n9;
                }
                nArray2[--n9] = i + 1;
                nArray[1 + i] = n9;
            }
            assert (n9 == 0);
        } else if (n5 != 0) {
            assert (n == n2);
            object = MethodType.genericMethodType(n).form();
            assert (this != object);
            nArray2 = ((MethodTypeForm)object).slotToArgTable;
            nArray = ((MethodTypeForm)object).argToSlotTable;
        } else {
            int n10 = n;
            nArray2 = new int[n10 + 1];
            nArray = new int[1 + n];
            nArray[0] = n10;
            for (int i = 0; i < n; ++i) {
                nArray2[--n10] = i + 1;
                nArray[1 + i] = n10;
            }
        }
        this.primCounts = MethodTypeForm.pack(n8, n7, n6, n5);
        this.argCounts = MethodTypeForm.pack(n4, n3, n2, n);
        this.argToSlotTable = nArray;
        this.slotToArgTable = nArray2;
        if (n2 >= 256) {
            throw MethodHandleStatics.newIllegalArgumentException("too many arguments");
        }
        assert (this.basicType == methodType);
        this.lambdaForms = new SoftReference[18];
        this.methodHandles = new SoftReference[3];
    }

    private static long pack(int n, int n2, int n3, int n4) {
        assert (((n | n2 | n3 | n4) & 0xFFFF0000) == 0);
        long l = n << 16 | n2;
        long l2 = n3 << 16 | n4;
        return l << 32 | l2;
    }

    private static char unpack(long l, int n) {
        assert (n <= 3);
        return (char)(l >> (3 - n) * 16);
    }

    public int parameterCount() {
        return MethodTypeForm.unpack(this.argCounts, 3);
    }

    public int parameterSlotCount() {
        return MethodTypeForm.unpack(this.argCounts, 2);
    }

    public int returnCount() {
        return MethodTypeForm.unpack(this.argCounts, 1);
    }

    public int returnSlotCount() {
        return MethodTypeForm.unpack(this.argCounts, 0);
    }

    public int primitiveParameterCount() {
        return MethodTypeForm.unpack(this.primCounts, 3);
    }

    public int longPrimitiveParameterCount() {
        return MethodTypeForm.unpack(this.primCounts, 2);
    }

    public int primitiveReturnCount() {
        return MethodTypeForm.unpack(this.primCounts, 1);
    }

    public int longPrimitiveReturnCount() {
        return MethodTypeForm.unpack(this.primCounts, 0);
    }

    public boolean hasPrimitives() {
        return this.primCounts != 0L;
    }

    public boolean hasNonVoidPrimitives() {
        if (this.primCounts == 0L) {
            return false;
        }
        if (this.primitiveParameterCount() != 0) {
            return true;
        }
        return this.primitiveReturnCount() != 0 && this.returnCount() != 0;
    }

    public boolean hasLongPrimitives() {
        return (this.longPrimitiveParameterCount() | this.longPrimitiveReturnCount()) != 0;
    }

    public int parameterToArgSlot(int n) {
        return this.argToSlotTable[1 + n];
    }

    public int argSlotToParameter(int n) {
        return this.slotToArgTable[n] - 1;
    }

    static MethodTypeForm findForm(MethodType methodType) {
        MethodType methodType2 = MethodTypeForm.canonicalize(methodType, 1, 1);
        if (methodType2 == null) {
            return new MethodTypeForm(methodType);
        }
        return methodType2.form();
    }

    public static MethodType canonicalize(MethodType methodType, int n, int n2) {
        Class<?>[] classArray = methodType.ptypes();
        Class<?>[] classArray2 = MethodTypeForm.canonicalizeAll(classArray, n2);
        Class<?> clazz = methodType.returnType();
        Class<?> clazz2 = MethodTypeForm.canonicalize(clazz, n);
        if (classArray2 == null && clazz2 == null) {
            return null;
        }
        if (clazz2 == null) {
            clazz2 = clazz;
        }
        if (classArray2 == null) {
            classArray2 = classArray;
        }
        return MethodType.makeImpl(clazz2, classArray2, true);
    }

    static Class<?> canonicalize(Class<?> clazz, int n) {
        if (clazz != Object.class) {
            if (!clazz.isPrimitive()) {
                switch (n) {
                    case 3: {
                        Class<?> clazz2 = Wrapper.asPrimitiveType(clazz);
                        if (clazz2 == clazz) break;
                        return clazz2;
                    }
                    case 1: 
                    case 6: {
                        return Object.class;
                    }
                }
            } else if (clazz == Void.TYPE) {
                switch (n) {
                    case 6: {
                        return Integer.TYPE;
                    }
                    case 2: {
                        return Void.class;
                    }
                }
            } else {
                switch (n) {
                    case 2: {
                        return Wrapper.asWrapperType(clazz);
                    }
                    case 4: {
                        if (clazz == Integer.TYPE || clazz == Long.TYPE) {
                            return null;
                        }
                        if (clazz == Double.TYPE) {
                            return Long.TYPE;
                        }
                        return Integer.TYPE;
                    }
                    case 5: {
                        if (clazz == Long.TYPE) {
                            return null;
                        }
                        return Long.TYPE;
                    }
                    case 6: {
                        if (clazz == Integer.TYPE || clazz == Long.TYPE || clazz == Float.TYPE || clazz == Double.TYPE) {
                            return null;
                        }
                        return Integer.TYPE;
                    }
                }
            }
        }
        return null;
    }

    static Class<?>[] canonicalizeAll(Class<?>[] classArray, int n) {
        Class[] classArray2 = null;
        int n2 = classArray.length;
        for (int i = 0; i < n2; ++i) {
            Class<?> clazz = MethodTypeForm.canonicalize(classArray[i], n);
            if (clazz == Void.TYPE) {
                clazz = null;
            }
            if (clazz == null) continue;
            if (classArray2 == null) {
                classArray2 = (Class[])classArray.clone();
            }
            classArray2[i] = clazz;
        }
        return classArray2;
    }

    public String toString() {
        return "Form" + this.erasedType;
    }
}

