/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.DelegatingMethodHandle;
import java.lang.invoke.InvokerBytecodeGenerator;
import java.lang.invoke.LambdaForm;
import java.lang.invoke.LambdaFormEditor;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import jdk.internal.org.objectweb.asm.ClassWriter;
import jdk.internal.org.objectweb.asm.FieldVisitor;
import jdk.internal.org.objectweb.asm.MethodVisitor;
import jdk.internal.vm.annotation.Stable;
import sun.invoke.util.ValueConversions;
import sun.invoke.util.Wrapper;

abstract class BoundMethodHandle
extends MethodHandle {
    private static final int FIELD_COUNT_THRESHOLD = 12;
    private static final int FORM_EXPRESSION_THRESHOLD = 24;
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.Lookup.IMPL_LOOKUP;
    static final SpeciesData SPECIES_DATA = SpeciesData.EMPTY;
    private static final SpeciesData[] SPECIES_DATA_CACHE = new SpeciesData[5];

    BoundMethodHandle(MethodType methodType, LambdaForm lambdaForm) {
        super(methodType, lambdaForm);
        assert (this.speciesData() == BoundMethodHandle.speciesData(lambdaForm));
    }

    static BoundMethodHandle bindSingle(MethodType methodType, LambdaForm lambdaForm, LambdaForm.BasicType basicType, Object object) {
        try {
            switch (basicType) {
                case L_TYPE: {
                    return BoundMethodHandle.bindSingle(methodType, lambdaForm, object);
                }
                case I_TYPE: {
                    return SpeciesData.EMPTY.extendWith(LambdaForm.BasicType.I_TYPE).constructor().invokeBasic(methodType, lambdaForm, ValueConversions.widenSubword(object));
                }
                case J_TYPE: {
                    return SpeciesData.EMPTY.extendWith(LambdaForm.BasicType.J_TYPE).constructor().invokeBasic(methodType, lambdaForm, (Long)object);
                }
                case F_TYPE: {
                    return SpeciesData.EMPTY.extendWith(LambdaForm.BasicType.F_TYPE).constructor().invokeBasic(methodType, lambdaForm, ((Float)object).floatValue());
                }
                case D_TYPE: {
                    return SpeciesData.EMPTY.extendWith(LambdaForm.BasicType.D_TYPE).constructor().invokeBasic(methodType, lambdaForm, (Double)object);
                }
            }
            throw MethodHandleStatics.newInternalError("unexpected xtype: " + (Object)((Object)basicType));
        }
        catch (Throwable throwable) {
            throw MethodHandleStatics.newInternalError(throwable);
        }
    }

    LambdaFormEditor editor() {
        return this.form.editor();
    }

    static BoundMethodHandle bindSingle(MethodType methodType, LambdaForm lambdaForm, Object object) {
        return Species_L.make(methodType, lambdaForm, object);
    }

    @Override
    BoundMethodHandle bindArgumentL(int n, Object object) {
        return this.editor().bindArgumentL(this, n, object);
    }

    BoundMethodHandle bindArgumentI(int n, int n2) {
        return this.editor().bindArgumentI(this, n, n2);
    }

    BoundMethodHandle bindArgumentJ(int n, long l) {
        return this.editor().bindArgumentJ(this, n, l);
    }

    BoundMethodHandle bindArgumentF(int n, float f) {
        return this.editor().bindArgumentF(this, n, f);
    }

    BoundMethodHandle bindArgumentD(int n, double d) {
        return this.editor().bindArgumentD(this, n, d);
    }

    @Override
    BoundMethodHandle rebind() {
        if (!this.tooComplex()) {
            return this;
        }
        return BoundMethodHandle.makeReinvoker(this);
    }

    private boolean tooComplex() {
        return this.fieldCount() > 12 || this.form.expressionCount() > 24;
    }

    static BoundMethodHandle makeReinvoker(MethodHandle methodHandle) {
        LambdaForm lambdaForm = DelegatingMethodHandle.makeReinvokerForm(methodHandle, 7, Species_L.SPECIES_DATA, Species_L.SPECIES_DATA.getterFunction(0));
        return Species_L.make(methodHandle.type(), lambdaForm, methodHandle);
    }

    abstract SpeciesData speciesData();

    static SpeciesData speciesData(LambdaForm lambdaForm) {
        Object object = lambdaForm.names[0].constraint;
        if (object instanceof SpeciesData) {
            return (SpeciesData)object;
        }
        return SpeciesData.EMPTY;
    }

    abstract int fieldCount();

    @Override
    Object internalProperties() {
        return "\n& BMH=" + this.internalValues();
    }

    @Override
    final Object internalValues() {
        Object[] objectArray = new Object[this.speciesData().fieldCount()];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = this.arg(i);
        }
        return Arrays.asList(objectArray);
    }

    final Object arg(int n) {
        try {
            switch (this.speciesData().fieldType(n)) {
                case L_TYPE: {
                    return this.speciesData().getters[n].invokeBasic(this);
                }
                case I_TYPE: {
                    return this.speciesData().getters[n].invokeBasic(this);
                }
                case J_TYPE: {
                    return this.speciesData().getters[n].invokeBasic(this);
                }
                case F_TYPE: {
                    return Float.valueOf(this.speciesData().getters[n].invokeBasic(this));
                }
                case D_TYPE: {
                    return this.speciesData().getters[n].invokeBasic(this);
                }
            }
        }
        catch (Throwable throwable) {
            throw MethodHandleStatics.newInternalError(throwable);
        }
        throw new InternalError("unexpected type: " + this.speciesData().typeChars + "." + n);
    }

    @Override
    abstract BoundMethodHandle copyWith(MethodType var1, LambdaForm var2);

    abstract BoundMethodHandle copyWithExtendL(MethodType var1, LambdaForm var2, Object var3);

    abstract BoundMethodHandle copyWithExtendI(MethodType var1, LambdaForm var2, int var3);

    abstract BoundMethodHandle copyWithExtendJ(MethodType var1, LambdaForm var2, long var3);

    abstract BoundMethodHandle copyWithExtendF(MethodType var1, LambdaForm var2, float var3);

    abstract BoundMethodHandle copyWithExtendD(MethodType var1, LambdaForm var2, double var3);

    static SpeciesData getSpeciesData(String string) {
        return SpeciesData.get(string);
    }

    private static SpeciesData checkCache(int n, String string) {
        int n2 = n - 1;
        SpeciesData speciesData = SPECIES_DATA_CACHE[n2];
        if (speciesData != null) {
            return speciesData;
        }
        BoundMethodHandle.SPECIES_DATA_CACHE[n2] = speciesData = BoundMethodHandle.getSpeciesData(string);
        return speciesData;
    }

    static SpeciesData speciesData_L() {
        return BoundMethodHandle.checkCache(1, "L");
    }

    static SpeciesData speciesData_LL() {
        return BoundMethodHandle.checkCache(2, "LL");
    }

    static SpeciesData speciesData_LLL() {
        return BoundMethodHandle.checkCache(3, "LLL");
    }

    static SpeciesData speciesData_LLLL() {
        return BoundMethodHandle.checkCache(4, "LLLL");
    }

    static SpeciesData speciesData_LLLLL() {
        return BoundMethodHandle.checkCache(5, "LLLLL");
    }

    static class Factory {
        static final String JLO_SIG = "Ljava/lang/Object;";
        static final String JLS_SIG = "Ljava/lang/String;";
        static final String JLC_SIG = "Ljava/lang/Class;";
        static final String MH = "java/lang/invoke/MethodHandle";
        static final String MH_SIG = "Ljava/lang/invoke/MethodHandle;";
        static final String BMH = "java/lang/invoke/BoundMethodHandle";
        static final String BMH_SIG = "Ljava/lang/invoke/BoundMethodHandle;";
        static final String SPECIES_DATA = "java/lang/invoke/BoundMethodHandle$SpeciesData";
        static final String SPECIES_DATA_SIG = "Ljava/lang/invoke/BoundMethodHandle$SpeciesData;";
        static final String STABLE_SIG = "Ljdk/internal/vm/annotation/Stable;";
        static final String SPECIES_PREFIX_NAME = "Species_";
        static final String SPECIES_PREFIX_PATH = "java/lang/invoke/BoundMethodHandle$Species_";
        static final String BMHSPECIES_DATA_EWI_SIG = "(B)Ljava/lang/invoke/BoundMethodHandle$SpeciesData;";
        static final String BMHSPECIES_DATA_GFC_SIG = "(Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/invoke/BoundMethodHandle$SpeciesData;";
        static final String MYSPECIES_DATA_SIG = "()Ljava/lang/invoke/BoundMethodHandle$SpeciesData;";
        static final String VOID_SIG = "()V";
        static final String INT_SIG = "()I";
        static final String SIG_INCIPIT = "(Ljava/lang/invoke/MethodType;Ljava/lang/invoke/LambdaForm;";
        static final String[] E_THROWABLE = new String[]{"java/lang/Throwable"};
        static final ConcurrentMap<String, Class<? extends BoundMethodHandle>> CLASS_CACHE = new ConcurrentHashMap<String, Class<? extends BoundMethodHandle>>();

        Factory() {
        }

        static Class<? extends BoundMethodHandle> getConcreteBMHClass(String string) {
            return CLASS_CACHE.computeIfAbsent(string, new Function<String, Class<? extends BoundMethodHandle>>(){

                @Override
                public Class<? extends BoundMethodHandle> apply(String string) {
                    return Factory.generateConcreteBMHClass(string);
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        static Class<? extends BoundMethodHandle> generateConcreteBMHClass(String string) {
            void var9_13;
            int n;
            ClassWriter classWriter = new ClassWriter(3);
            String string2 = LambdaForm.shortenSignature(string);
            String string3 = SPECIES_PREFIX_PATH + string2;
            String string4 = SPECIES_PREFIX_NAME + string2;
            classWriter.visit(50, 48, string3, null, BMH, null);
            classWriter.visitSource(string4, null);
            FieldVisitor fieldVisitor = classWriter.visitField(8, "SPECIES_DATA", SPECIES_DATA_SIG, null, null);
            fieldVisitor.visitAnnotation(STABLE_SIG, true);
            fieldVisitor.visitEnd();
            for (int i = 0; i < string.length(); ++i) {
                n = string.charAt(i);
                String string5 = Factory.makeFieldName(string, i);
                String string6 = n == 76 ? JLO_SIG : String.valueOf((char)n);
                classWriter.visitField(16, string5, string6, null, null).visitEnd();
            }
            MethodVisitor methodVisitor = classWriter.visitMethod(2, "<init>", Factory.makeSignature(string, true), null, null);
            methodVisitor.visitCode();
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitVarInsn(25, 2);
            methodVisitor.visitMethodInsn(183, BMH, "<init>", Factory.makeSignature("", true), false);
            n = 0;
            boolean n2 = false;
            while (n < string.length()) {
                void objectArray;
                char c = string.charAt(n);
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitVarInsn(Factory.typeLoadOp(c), (int)(objectArray + 3));
                methodVisitor.visitFieldInsn(181, string3, Factory.makeFieldName(string, n), Factory.typeSig(c));
                if (c == 'J' || c == 'D') {
                    ++objectArray;
                }
                ++n;
                ++objectArray;
            }
            methodVisitor.visitInsn(177);
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
            methodVisitor = classWriter.visitMethod(16, "speciesData", MYSPECIES_DATA_SIG, null, null);
            methodVisitor.visitCode();
            methodVisitor.visitFieldInsn(178, string3, "SPECIES_DATA", SPECIES_DATA_SIG);
            methodVisitor.visitInsn(176);
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
            methodVisitor = classWriter.visitMethod(16, "fieldCount", INT_SIG, null, null);
            methodVisitor.visitCode();
            n = string.length();
            if (n <= 5) {
                methodVisitor.visitInsn(3 + n);
            } else {
                methodVisitor.visitIntInsn(17, n);
            }
            methodVisitor.visitInsn(172);
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
            methodVisitor = classWriter.visitMethod(8, "make", Factory.makeSignature(string, false), null, null);
            methodVisitor.visitCode();
            methodVisitor.visitTypeInsn(187, string3);
            methodVisitor.visitInsn(89);
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitVarInsn(25, 1);
            boolean bl = false;
            int n3 = 0;
            while (var9_13 < string.length()) {
                int n4 = string.charAt((int)var9_13);
                methodVisitor.visitVarInsn(Factory.typeLoadOp((char)n4), n3 + 2);
                if (n4 == 74 || n4 == 68) {
                    ++n3;
                }
                ++var9_13;
                ++n3;
            }
            methodVisitor.visitMethodInsn(183, string3, "<init>", Factory.makeSignature(string, true), false);
            methodVisitor.visitInsn(176);
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
            methodVisitor = classWriter.visitMethod(16, "copyWith", Factory.makeSignature("", false), null, null);
            methodVisitor.visitCode();
            methodVisitor.visitTypeInsn(187, string3);
            methodVisitor.visitInsn(89);
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitVarInsn(25, 2);
            Factory.emitPushFields(string, string3, methodVisitor);
            methodVisitor.visitMethodInsn(183, string3, "<init>", Factory.makeSignature(string, true), false);
            methodVisitor.visitInsn(176);
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
            for (LambdaForm.BasicType basicType : LambdaForm.BasicType.ARG_TYPES) {
                int n5 = basicType.ordinal();
                char c = basicType.basicTypeChar();
                methodVisitor = classWriter.visitMethod(16, "copyWithExtend" + c, Factory.makeSignature(String.valueOf(c), false), null, E_THROWABLE);
                methodVisitor.visitCode();
                methodVisitor.visitFieldInsn(178, string3, "SPECIES_DATA", SPECIES_DATA_SIG);
                int n6 = 3 + n5;
                assert (n6 <= 8);
                methodVisitor.visitInsn(n6);
                methodVisitor.visitMethodInsn(182, SPECIES_DATA, "extendWith", BMHSPECIES_DATA_EWI_SIG, false);
                methodVisitor.visitMethodInsn(182, SPECIES_DATA, "constructor", "()Ljava/lang/invoke/MethodHandle;", false);
                methodVisitor.visitVarInsn(25, 1);
                methodVisitor.visitVarInsn(25, 2);
                Factory.emitPushFields(string, string3, methodVisitor);
                methodVisitor.visitVarInsn(Factory.typeLoadOp(c), 3);
                methodVisitor.visitMethodInsn(182, MH, "invokeBasic", Factory.makeSignature(string + c, false), false);
                methodVisitor.visitInsn(176);
                methodVisitor.visitMaxs(0, 0);
                methodVisitor.visitEnd();
            }
            classWriter.visitEnd();
            byte[] byArray = classWriter.toByteArray();
            InvokerBytecodeGenerator.maybeDump(string3, byArray);
            Class<BoundMethodHandle> clazz = MethodHandleStatics.UNSAFE.defineClass(string3, byArray, 0, byArray.length, BoundMethodHandle.class.getClassLoader(), null).asSubclass(BoundMethodHandle.class);
            return clazz;
        }

        private static int typeLoadOp(char c) {
            switch (c) {
                case 'L': {
                    return 25;
                }
                case 'I': {
                    return 21;
                }
                case 'J': {
                    return 22;
                }
                case 'F': {
                    return 23;
                }
                case 'D': {
                    return 24;
                }
            }
            throw MethodHandleStatics.newInternalError("unrecognized type " + c);
        }

        private static void emitPushFields(String string, String string2, MethodVisitor methodVisitor) {
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitFieldInsn(180, string2, Factory.makeFieldName(string, i), Factory.typeSig(c));
            }
        }

        static String typeSig(char c) {
            return c == 'L' ? JLO_SIG : String.valueOf(c);
        }

        private static MethodHandle makeGetter(Class<?> clazz, String string, int n) {
            String string2 = Factory.makeFieldName(string, n);
            Class<?> clazz2 = Wrapper.forBasicType(string.charAt(n)).primitiveType();
            try {
                return LOOKUP.findGetter(clazz, string2, clazz2);
            }
            catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                throw MethodHandleStatics.newInternalError(reflectiveOperationException);
            }
        }

        static MethodHandle[] makeGetters(Class<?> clazz, String string, MethodHandle[] methodHandleArray) {
            if (methodHandleArray == null) {
                methodHandleArray = new MethodHandle[string.length()];
            }
            for (int i = 0; i < methodHandleArray.length; ++i) {
                methodHandleArray[i] = Factory.makeGetter(clazz, string, i);
                assert (methodHandleArray[i].internalMemberName().getDeclaringClass() == clazz);
            }
            return methodHandleArray;
        }

        static MethodHandle[] makeCtors(Class<? extends BoundMethodHandle> clazz, String string, MethodHandle[] methodHandleArray) {
            if (methodHandleArray == null) {
                methodHandleArray = new MethodHandle[1];
            }
            if (string.equals("")) {
                return methodHandleArray;
            }
            methodHandleArray[0] = Factory.makeCbmhCtor(clazz, string);
            return methodHandleArray;
        }

        static LambdaForm.NamedFunction[] makeNominalGetters(String string, LambdaForm.NamedFunction[] namedFunctionArray, MethodHandle[] methodHandleArray) {
            if (namedFunctionArray == null) {
                namedFunctionArray = new LambdaForm.NamedFunction[string.length()];
            }
            for (int i = 0; i < namedFunctionArray.length; ++i) {
                namedFunctionArray[i] = new LambdaForm.NamedFunction(methodHandleArray[i]);
            }
            return namedFunctionArray;
        }

        static SpeciesData getSpeciesDataFromConcreteBMHClass(Class<? extends BoundMethodHandle> clazz) {
            try {
                Field field = clazz.getDeclaredField("SPECIES_DATA");
                return (SpeciesData)field.get(null);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                throw MethodHandleStatics.newInternalError(reflectiveOperationException);
            }
        }

        static void setSpeciesDataToConcreteBMHClass(Class<? extends BoundMethodHandle> clazz, SpeciesData speciesData) {
            try {
                Field field = clazz.getDeclaredField("SPECIES_DATA");
                assert (field.getDeclaredAnnotation(Stable.class) != null);
                field.set(null, speciesData);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                throw MethodHandleStatics.newInternalError(reflectiveOperationException);
            }
        }

        private static String makeFieldName(String string, int n) {
            assert (n >= 0 && n < string.length());
            return "arg" + string.charAt(n) + n;
        }

        private static String makeSignature(String string, boolean bl) {
            StringBuilder stringBuilder = new StringBuilder(SIG_INCIPIT);
            for (char c : string.toCharArray()) {
                stringBuilder.append(Factory.typeSig(c));
            }
            return stringBuilder.append(')').append(bl ? "V" : BMH_SIG).toString();
        }

        static MethodHandle makeCbmhCtor(Class<? extends BoundMethodHandle> clazz, String string) {
            try {
                return LOOKUP.findStatic(clazz, "make", MethodType.fromMethodDescriptorString(Factory.makeSignature(string, false), null));
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | TypeNotPresentException exception) {
                throw MethodHandleStatics.newInternalError(exception);
            }
        }
    }

    static class SpeciesData {
        private final String typeChars;
        private final LambdaForm.BasicType[] typeCodes;
        private final Class<? extends BoundMethodHandle> clazz;
        @Stable
        private final MethodHandle[] constructor;
        @Stable
        private final MethodHandle[] getters;
        @Stable
        private final LambdaForm.NamedFunction[] nominalGetters;
        @Stable
        private final SpeciesData[] extensions;
        static final SpeciesData EMPTY = new SpeciesData("", BoundMethodHandle.class);
        private static final ConcurrentMap<String, SpeciesData> CACHE = new ConcurrentHashMap<String, SpeciesData>();
        private static final boolean INIT_DONE;

        int fieldCount() {
            return this.typeCodes.length;
        }

        LambdaForm.BasicType fieldType(int n) {
            return this.typeCodes[n];
        }

        char fieldTypeChar(int n) {
            return this.typeChars.charAt(n);
        }

        Object fieldSignature() {
            return this.typeChars;
        }

        public Class<? extends BoundMethodHandle> fieldHolder() {
            return this.clazz;
        }

        public String toString() {
            return "SpeciesData<" + this.fieldSignature() + ">";
        }

        LambdaForm.NamedFunction getterFunction(int n) {
            LambdaForm.NamedFunction namedFunction = this.nominalGetters[n];
            assert (namedFunction.memberDeclaringClassOrNull() == this.fieldHolder());
            assert (namedFunction.returnType() == this.fieldType(n));
            return namedFunction;
        }

        LambdaForm.NamedFunction[] getterFunctions() {
            return this.nominalGetters;
        }

        MethodHandle[] getterHandles() {
            return this.getters;
        }

        MethodHandle constructor() {
            return this.constructor[0];
        }

        SpeciesData(String string, Class<? extends BoundMethodHandle> clazz) {
            this.typeChars = string;
            this.typeCodes = LambdaForm.BasicType.basicTypes(string);
            this.clazz = clazz;
            if (!INIT_DONE) {
                this.constructor = new MethodHandle[1];
                this.getters = new MethodHandle[string.length()];
                this.nominalGetters = new LambdaForm.NamedFunction[string.length()];
            } else {
                this.constructor = Factory.makeCtors(clazz, string, null);
                this.getters = Factory.makeGetters(clazz, string, null);
                this.nominalGetters = Factory.makeNominalGetters(string, null, this.getters);
            }
            this.extensions = new SpeciesData[LambdaForm.BasicType.ARG_TYPE_LIMIT];
        }

        private void initForBootstrap() {
            assert (!INIT_DONE);
            if (this.constructor() == null) {
                String string = this.typeChars;
                CACHE.put(string, this);
                Factory.makeCtors(this.clazz, string, this.constructor);
                Factory.makeGetters(this.clazz, string, this.getters);
                Factory.makeNominalGetters(string, this.nominalGetters, this.getters);
            }
        }

        SpeciesData extendWith(byte by) {
            return this.extendWith(LambdaForm.BasicType.basicType(by));
        }

        SpeciesData extendWith(LambdaForm.BasicType basicType) {
            int n = basicType.ordinal();
            SpeciesData speciesData = this.extensions[n];
            if (speciesData != null) {
                return speciesData;
            }
            this.extensions[n] = speciesData = SpeciesData.get(this.typeChars + basicType.basicTypeChar());
            return speciesData;
        }

        private static SpeciesData get(String string) {
            return CACHE.computeIfAbsent(string, new Function<String, SpeciesData>(){

                @Override
                public SpeciesData apply(String string) {
                    Class<? extends BoundMethodHandle> clazz = Factory.getConcreteBMHClass(string);
                    SpeciesData speciesData = new SpeciesData(string, clazz);
                    Factory.setSpeciesDataToConcreteBMHClass(clazz, speciesData);
                    return speciesData;
                }
            });
        }

        static boolean speciesDataCachePopulated() {
            Class<BoundMethodHandle> clazz = BoundMethodHandle.class;
            try {
                for (Class<?> clazz2 : clazz.getDeclaredClasses()) {
                    if (!clazz.isAssignableFrom(clazz2)) continue;
                    Class<BoundMethodHandle> clazz3 = clazz2.asSubclass(BoundMethodHandle.class);
                    SpeciesData speciesData = Factory.getSpeciesDataFromConcreteBMHClass(clazz3);
                    assert (speciesData != null) : clazz3.getName();
                    assert (speciesData.clazz == clazz3);
                    assert (CACHE.get(speciesData.typeChars) == speciesData);
                }
            }
            catch (Throwable throwable) {
                throw MethodHandleStatics.newInternalError(throwable);
            }
            return true;
        }

        static {
            EMPTY.initForBootstrap();
            Species_L.SPECIES_DATA.initForBootstrap();
            assert (SpeciesData.speciesDataCachePopulated());
            INIT_DONE = Boolean.TRUE;
        }
    }

    private static final class Species_L
    extends BoundMethodHandle {
        final Object argL0;
        static final SpeciesData SPECIES_DATA = new SpeciesData("L", Species_L.class);

        private Species_L(MethodType methodType, LambdaForm lambdaForm, Object object) {
            super(methodType, lambdaForm);
            this.argL0 = object;
        }

        @Override
        SpeciesData speciesData() {
            return SPECIES_DATA;
        }

        @Override
        int fieldCount() {
            return 1;
        }

        static BoundMethodHandle make(MethodType methodType, LambdaForm lambdaForm, Object object) {
            return new Species_L(methodType, lambdaForm, object);
        }

        @Override
        final BoundMethodHandle copyWith(MethodType methodType, LambdaForm lambdaForm) {
            return new Species_L(methodType, lambdaForm, this.argL0);
        }

        @Override
        final BoundMethodHandle copyWithExtendL(MethodType methodType, LambdaForm lambdaForm, Object object) {
            try {
                return SPECIES_DATA.extendWith(LambdaForm.BasicType.L_TYPE).constructor().invokeBasic(methodType, lambdaForm, this.argL0, object);
            }
            catch (Throwable throwable) {
                throw MethodHandleStatics.uncaughtException(throwable);
            }
        }

        @Override
        final BoundMethodHandle copyWithExtendI(MethodType methodType, LambdaForm lambdaForm, int n) {
            try {
                return SPECIES_DATA.extendWith(LambdaForm.BasicType.I_TYPE).constructor().invokeBasic(methodType, lambdaForm, this.argL0, n);
            }
            catch (Throwable throwable) {
                throw MethodHandleStatics.uncaughtException(throwable);
            }
        }

        @Override
        final BoundMethodHandle copyWithExtendJ(MethodType methodType, LambdaForm lambdaForm, long l) {
            try {
                return SPECIES_DATA.extendWith(LambdaForm.BasicType.J_TYPE).constructor().invokeBasic(methodType, lambdaForm, this.argL0, l);
            }
            catch (Throwable throwable) {
                throw MethodHandleStatics.uncaughtException(throwable);
            }
        }

        @Override
        final BoundMethodHandle copyWithExtendF(MethodType methodType, LambdaForm lambdaForm, float f) {
            try {
                return SPECIES_DATA.extendWith(LambdaForm.BasicType.F_TYPE).constructor().invokeBasic(methodType, lambdaForm, this.argL0, f);
            }
            catch (Throwable throwable) {
                throw MethodHandleStatics.uncaughtException(throwable);
            }
        }

        @Override
        final BoundMethodHandle copyWithExtendD(MethodType methodType, LambdaForm lambdaForm, double d) {
            try {
                return SPECIES_DATA.extendWith(LambdaForm.BasicType.D_TYPE).constructor().invokeBasic(methodType, lambdaForm, this.argL0, d);
            }
            catch (Throwable throwable) {
                throw MethodHandleStatics.uncaughtException(throwable);
            }
        }
    }
}

