/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.InputStream;

public class ByteArrayInputStream
extends InputStream {
    protected byte[] buf;
    protected int pos;
    protected int mark = 0;
    protected int count;

    public ByteArrayInputStream(byte[] byArray) {
        this.buf = byArray;
        this.pos = 0;
        this.count = byArray.length;
    }

    public ByteArrayInputStream(byte[] byArray, int n, int n2) {
        this.buf = byArray;
        this.pos = n;
        this.count = Math.min(n + n2, byArray.length);
        this.mark = n;
    }

    @Override
    public synchronized int read() {
        return this.pos < this.count ? this.buf[this.pos++] & 0xFF : -1;
    }

    @Override
    public synchronized int read(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n2 > byArray.length - n) {
            throw new IndexOutOfBoundsException();
        }
        if (this.pos >= this.count) {
            return -1;
        }
        int n3 = this.count - this.pos;
        if (n2 > n3) {
            n2 = n3;
        }
        if (n2 <= 0) {
            return 0;
        }
        if (n2 == 4) {
            byArray[n + 0] = this.buf[this.pos];
            byArray[n + 1] = this.buf[this.pos + 1];
            byArray[n + 2] = this.buf[this.pos + 2];
            byArray[n + 3] = this.buf[this.pos + 3];
        } else {
            System.arraycopy(this.buf, this.pos, byArray, n, n2);
        }
        this.pos += n2;
        return n2;
    }

    @Override
    public synchronized long skip(long l) {
        long l2 = this.count - this.pos;
        if (l < l2) {
            l2 = l < 0L ? 0L : l;
        }
        this.pos = (int)((long)this.pos + l2);
        return l2;
    }

    @Override
    public synchronized int available() {
        return this.count - this.pos;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int n) {
        this.mark = this.pos;
    }

    @Override
    public synchronized void reset() {
        this.pos = this.mark;
    }

    @Override
    public void close() throws IOException {
    }

    class UnsynchronizedInputStream
    extends InputStream {
        UnsynchronizedInputStream() {
        }

        @Override
        public int available() {
            return ByteArrayInputStream.this.count - ByteArrayInputStream.this.pos;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public void mark(int n) {
            ByteArrayInputStream.this.mark = ByteArrayInputStream.this.pos;
        }

        @Override
        public boolean markSupported() {
            return true;
        }

        @Override
        public int read() {
            return ByteArrayInputStream.this.pos < ByteArrayInputStream.this.count ? ByteArrayInputStream.this.buf[ByteArrayInputStream.this.pos++] & 0xFF : -1;
        }

        @Override
        public int read(byte[] byArray, int n, int n2) {
            if (byArray == null) {
                throw new NullPointerException();
            }
            if (n < 0 || n2 < 0 || n2 > byArray.length - n) {
                throw new IndexOutOfBoundsException();
            }
            if (ByteArrayInputStream.this.pos >= ByteArrayInputStream.this.count) {
                return -1;
            }
            int n3 = ByteArrayInputStream.this.count - ByteArrayInputStream.this.pos;
            if (n2 > n3) {
                n2 = n3;
            }
            if (n2 <= 0) {
                return 0;
            }
            if (n2 == 4) {
                byArray[n + 0] = ByteArrayInputStream.this.buf[ByteArrayInputStream.this.pos];
                byArray[n + 1] = ByteArrayInputStream.this.buf[ByteArrayInputStream.this.pos + 1];
                byArray[n + 2] = ByteArrayInputStream.this.buf[ByteArrayInputStream.this.pos + 2];
                byArray[n + 3] = ByteArrayInputStream.this.buf[ByteArrayInputStream.this.pos + 3];
            } else {
                System.arraycopy(ByteArrayInputStream.this.buf, ByteArrayInputStream.this.pos, byArray, n, n2);
            }
            ByteArrayInputStream.this.pos += n2;
            return n2;
        }

        @Override
        public synchronized void reset() {
            ByteArrayInputStream.this.pos = ByteArrayInputStream.this.mark;
        }

        @Override
        public synchronized long skip(long l) {
            long l2 = ByteArrayInputStream.this.count - ByteArrayInputStream.this.pos;
            if (l < l2) {
                l2 = l < 0L ? 0L : l;
            }
            ByteArrayInputStream.this.pos = (int)((long)ByteArrayInputStream.this.pos + l2);
            return l2;
        }
    }
}

