/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.TMSchema;
import com.sun.java.swing.plaf.windows.XPStyle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicScrollBarUI;

public class WindowsScrollBarUI
extends BasicScrollBarUI {
    private Grid thumbGrid;
    private Grid highlightGrid;
    private Dimension horizontalThumbSize;
    private Dimension verticalThumbSize;

    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsScrollBarUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        XPStyle xPStyle = XPStyle.getXP();
        if (xPStyle != null) {
            this.scrollbar.setBorder(null);
            this.horizontalThumbSize = WindowsScrollBarUI.getSize(this.scrollbar, xPStyle, TMSchema.Part.SBP_THUMBBTNHORZ);
            this.verticalThumbSize = WindowsScrollBarUI.getSize(this.scrollbar, xPStyle, TMSchema.Part.SBP_THUMBBTNVERT);
        } else {
            this.horizontalThumbSize = null;
            this.verticalThumbSize = null;
        }
    }

    private static Dimension getSize(Component component, XPStyle xPStyle, TMSchema.Part part) {
        XPStyle.Skin skin = xPStyle.getSkin(component, part);
        return new Dimension(skin.getWidth(), skin.getHeight());
    }

    @Override
    protected Dimension getMinimumThumbSize() {
        if (this.horizontalThumbSize == null || this.verticalThumbSize == null) {
            return super.getMinimumThumbSize();
        }
        return 0 == this.scrollbar.getOrientation() ? this.horizontalThumbSize : this.verticalThumbSize;
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        this.highlightGrid = null;
        this.thumbGrid = null;
    }

    @Override
    protected void configureScrollBarColors() {
        super.configureScrollBarColors();
        Color color = UIManager.getColor("ScrollBar.trackForeground");
        if (color != null && this.trackColor != null) {
            this.thumbGrid = Grid.getGrid(color, this.trackColor);
        }
        if ((color = UIManager.getColor("ScrollBar.trackHighlightForeground")) != null && this.trackHighlightColor != null) {
            this.highlightGrid = Grid.getGrid(color, this.trackHighlightColor);
        }
    }

    @Override
    protected JButton createDecreaseButton(int n) {
        return new WindowsArrowButton(n, UIManager.getColor("ScrollBar.thumb"), UIManager.getColor("ScrollBar.thumbShadow"), UIManager.getColor("ScrollBar.thumbDarkShadow"), UIManager.getColor("ScrollBar.thumbHighlight"));
    }

    @Override
    protected JButton createIncreaseButton(int n) {
        return new WindowsArrowButton(n, UIManager.getColor("ScrollBar.thumb"), UIManager.getColor("ScrollBar.thumbShadow"), UIManager.getColor("ScrollBar.thumbDarkShadow"), UIManager.getColor("ScrollBar.thumbHighlight"));
    }

    @Override
    protected BasicScrollBarUI.ArrowButtonListener createArrowButtonListener() {
        if (XPStyle.isVista()) {
            return new BasicScrollBarUI.ArrowButtonListener(){

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    this.repaint();
                    super.mouseEntered(mouseEvent);
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    this.repaint();
                    super.mouseExited(mouseEvent);
                }

                private void repaint() {
                    WindowsScrollBarUI.this.scrollbar.repaint();
                }
            };
        }
        return super.createArrowButtonListener();
    }

    @Override
    protected void paintTrack(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        boolean bl = this.scrollbar.getOrientation() == 1;
        XPStyle xPStyle = XPStyle.getXP();
        if (xPStyle != null) {
            JScrollBar jScrollBar = (JScrollBar)jComponent;
            TMSchema.State state = TMSchema.State.NORMAL;
            if (!jScrollBar.isEnabled()) {
                state = TMSchema.State.DISABLED;
            }
            TMSchema.Part part = bl ? TMSchema.Part.SBP_LOWERTRACKVERT : TMSchema.Part.SBP_LOWERTRACKHORZ;
            xPStyle.getSkin(jScrollBar, part).paintSkin(graphics, rectangle, state);
        } else if (this.thumbGrid == null) {
            super.paintTrack(graphics, jComponent, rectangle);
        } else {
            this.thumbGrid.paint(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            if (this.trackHighlight == 1) {
                this.paintDecreaseHighlight(graphics);
            } else if (this.trackHighlight == 2) {
                this.paintIncreaseHighlight(graphics);
            }
        }
    }

    @Override
    protected void paintThumb(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        boolean bl = this.scrollbar.getOrientation() == 1;
        XPStyle xPStyle = XPStyle.getXP();
        if (xPStyle != null) {
            JScrollBar jScrollBar = (JScrollBar)jComponent;
            TMSchema.State state = TMSchema.State.NORMAL;
            if (!jScrollBar.isEnabled()) {
                state = TMSchema.State.DISABLED;
            } else if (this.isDragging) {
                state = TMSchema.State.PRESSED;
            } else if (this.isThumbRollover()) {
                state = TMSchema.State.HOT;
            } else if (XPStyle.isVista() && (this.incrButton != null && this.incrButton.getModel().isRollover() || this.decrButton != null && this.decrButton.getModel().isRollover())) {
                state = TMSchema.State.HOVER;
            }
            TMSchema.Part part = bl ? TMSchema.Part.SBP_THUMBBTNVERT : TMSchema.Part.SBP_THUMBBTNHORZ;
            xPStyle.getSkin(jScrollBar, part).paintSkin(graphics, rectangle, state);
            TMSchema.Part part2 = bl ? TMSchema.Part.SBP_GRIPPERVERT : TMSchema.Part.SBP_GRIPPERHORZ;
            XPStyle.Skin skin = xPStyle.getSkin(jScrollBar, part2);
            Insets insets = xPStyle.getMargin(jComponent, part, null, TMSchema.Prop.CONTENTMARGINS);
            if (insets == null || bl && rectangle.height - insets.top - insets.bottom >= skin.getHeight() || !bl && rectangle.width - insets.left - insets.right >= skin.getWidth()) {
                skin.paintSkin(graphics, rectangle.x + (rectangle.width - skin.getWidth()) / 2, rectangle.y + (rectangle.height - skin.getHeight()) / 2, skin.getWidth(), skin.getHeight(), state);
            }
        } else {
            super.paintThumb(graphics, jComponent, rectangle);
        }
    }

    @Override
    protected void paintDecreaseHighlight(Graphics graphics) {
        if (this.highlightGrid == null) {
            super.paintDecreaseHighlight(graphics);
        } else {
            int n;
            int n2;
            int n3;
            int n4;
            Insets insets = this.scrollbar.getInsets();
            Rectangle rectangle = this.getThumbBounds();
            if (this.scrollbar.getOrientation() == 1) {
                n4 = insets.left;
                n3 = this.decrButton.getY() + this.decrButton.getHeight();
                n2 = this.scrollbar.getWidth() - (insets.left + insets.right);
                n = rectangle.y - n3;
            } else {
                n4 = this.decrButton.getX() + this.decrButton.getHeight();
                n3 = insets.top;
                n2 = rectangle.x - n4;
                n = this.scrollbar.getHeight() - (insets.top + insets.bottom);
            }
            this.highlightGrid.paint(graphics, n4, n3, n2, n);
        }
    }

    @Override
    protected void paintIncreaseHighlight(Graphics graphics) {
        if (this.highlightGrid == null) {
            super.paintDecreaseHighlight(graphics);
        } else {
            int n;
            int n2;
            int n3;
            int n4;
            Insets insets = this.scrollbar.getInsets();
            Rectangle rectangle = this.getThumbBounds();
            if (this.scrollbar.getOrientation() == 1) {
                n4 = insets.left;
                n3 = rectangle.y + rectangle.height;
                n2 = this.scrollbar.getWidth() - (insets.left + insets.right);
                n = this.incrButton.getY() - n3;
            } else {
                n4 = rectangle.x + rectangle.width;
                n3 = insets.top;
                n2 = this.incrButton.getX() - n4;
                n = this.scrollbar.getHeight() - (insets.top + insets.bottom);
            }
            this.highlightGrid.paint(graphics, n4, n3, n2, n);
        }
    }

    @Override
    protected void setThumbRollover(boolean bl) {
        boolean bl2 = this.isThumbRollover();
        super.setThumbRollover(bl);
        if (XPStyle.isVista() && bl != bl2) {
            this.scrollbar.repaint();
        }
    }

    private static class Grid {
        private static final int BUFFER_SIZE = 64;
        private static HashMap<String, WeakReference<Grid>> map = new HashMap();
        private BufferedImage image;

        public static Grid getGrid(Color color, Color color2) {
            Grid grid;
            String string = color.getRGB() + " " + color2.getRGB();
            WeakReference<Grid> weakReference = map.get(string);
            Grid grid2 = grid = weakReference == null ? null : weakReference.get();
            if (grid == null) {
                grid = new Grid(color, color2);
                map.put(string, new WeakReference<Grid>(grid));
            }
            return grid;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Grid(Color color, Color color2) {
            int[] nArray = new int[]{color.getRGB(), color2.getRGB()};
            IndexColorModel indexColorModel = new IndexColorModel(8, 2, nArray, 0, false, -1, 0);
            this.image = new BufferedImage(64, 64, 13, indexColorModel);
            Graphics graphics = this.image.getGraphics();
            try {
                graphics.setClip(0, 0, 64, 64);
                this.paintGrid(graphics, color, color2);
            }
            finally {
                graphics.dispose();
            }
        }

        public void paint(Graphics graphics, int n, int n2, int n3, int n4) {
            Rectangle rectangle = graphics.getClipBounds();
            int n5 = Math.max(n, rectangle.x);
            int n6 = Math.max(n2, rectangle.y);
            int n7 = Math.min(rectangle.x + rectangle.width, n + n3);
            int n8 = Math.min(rectangle.y + rectangle.height, n2 + n4);
            if (n7 <= n5 || n8 <= n6) {
                return;
            }
            int n9 = (n5 - n) % 2;
            for (int i = n5; i < n7; i += 64) {
                int n10 = (n6 - n2) % 2;
                int n11 = Math.min(64 - n9, n7 - i);
                for (int j = n6; j < n8; j += 64) {
                    int n12 = Math.min(64 - n10, n8 - j);
                    graphics.drawImage(this.image, i, j, i + n11, j + n12, n9, n10, n9 + n11, n10 + n12, null);
                    if (n10 == 0) continue;
                    j -= n10;
                    n10 = 0;
                }
                if (n9 == 0) continue;
                i -= n9;
                n9 = 0;
            }
        }

        private void paintGrid(Graphics graphics, Color color, Color color2) {
            int n;
            Rectangle rectangle = graphics.getClipBounds();
            graphics.setColor(color2);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.setColor(color);
            graphics.translate(rectangle.x, rectangle.y);
            int n2 = rectangle.width;
            int n3 = rectangle.height;
            int n4 = n2 - n3;
            for (n = rectangle.x % 2; n < n4; n += 2) {
                graphics.drawLine(n, 0, n + n3, n3);
            }
            n4 = n2;
            while (n < n4) {
                graphics.drawLine(n, 0, n2, n2 - n);
                n += 2;
            }
            int n5 = n3 - n2;
            for (n4 = rectangle.x % 2 == 0 ? 2 : 1; n4 < n5; n4 += 2) {
                graphics.drawLine(0, n4, n2, n4 + n2);
            }
            n5 = n3;
            while (n4 < n5) {
                graphics.drawLine(0, n4, n3 - n4, n3);
                n4 += 2;
            }
            graphics.translate(-rectangle.x, -rectangle.y);
        }
    }

    private class WindowsArrowButton
    extends BasicArrowButton {
        public WindowsArrowButton(int n, Color color, Color color2, Color color3, Color color4) {
            super(n, color, color2, color3, color4);
        }

        public WindowsArrowButton(int n) {
            super(n);
        }

        @Override
        public void paint(Graphics graphics) {
            XPStyle xPStyle = XPStyle.getXP();
            if (xPStyle != null) {
                boolean bl;
                ButtonModel buttonModel = this.getModel();
                XPStyle.Skin skin = xPStyle.getSkin(this, TMSchema.Part.SBP_ARROWBTN);
                TMSchema.State state = null;
                boolean bl2 = bl = XPStyle.isVista() && (WindowsScrollBarUI.this.isThumbRollover() || this == WindowsScrollBarUI.this.incrButton && WindowsScrollBarUI.this.decrButton.getModel().isRollover() || this == WindowsScrollBarUI.this.decrButton && WindowsScrollBarUI.this.incrButton.getModel().isRollover());
                if (buttonModel.isArmed() && buttonModel.isPressed()) {
                    switch (this.direction) {
                        case 1: {
                            state = TMSchema.State.UPPRESSED;
                            break;
                        }
                        case 5: {
                            state = TMSchema.State.DOWNPRESSED;
                            break;
                        }
                        case 7: {
                            state = TMSchema.State.LEFTPRESSED;
                            break;
                        }
                        case 3: {
                            state = TMSchema.State.RIGHTPRESSED;
                        }
                    }
                } else if (!buttonModel.isEnabled()) {
                    switch (this.direction) {
                        case 1: {
                            state = TMSchema.State.UPDISABLED;
                            break;
                        }
                        case 5: {
                            state = TMSchema.State.DOWNDISABLED;
                            break;
                        }
                        case 7: {
                            state = TMSchema.State.LEFTDISABLED;
                            break;
                        }
                        case 3: {
                            state = TMSchema.State.RIGHTDISABLED;
                        }
                    }
                } else if (buttonModel.isRollover() || buttonModel.isPressed()) {
                    switch (this.direction) {
                        case 1: {
                            state = TMSchema.State.UPHOT;
                            break;
                        }
                        case 5: {
                            state = TMSchema.State.DOWNHOT;
                            break;
                        }
                        case 7: {
                            state = TMSchema.State.LEFTHOT;
                            break;
                        }
                        case 3: {
                            state = TMSchema.State.RIGHTHOT;
                        }
                    }
                } else if (bl) {
                    switch (this.direction) {
                        case 1: {
                            state = TMSchema.State.UPHOVER;
                            break;
                        }
                        case 5: {
                            state = TMSchema.State.DOWNHOVER;
                            break;
                        }
                        case 7: {
                            state = TMSchema.State.LEFTHOVER;
                            break;
                        }
                        case 3: {
                            state = TMSchema.State.RIGHTHOVER;
                        }
                    }
                } else {
                    switch (this.direction) {
                        case 1: {
                            state = TMSchema.State.UPNORMAL;
                            break;
                        }
                        case 5: {
                            state = TMSchema.State.DOWNNORMAL;
                            break;
                        }
                        case 7: {
                            state = TMSchema.State.LEFTNORMAL;
                            break;
                        }
                        case 3: {
                            state = TMSchema.State.RIGHTNORMAL;
                        }
                    }
                }
                skin.paintSkin(graphics, 0, 0, this.getWidth(), this.getHeight(), state);
            } else {
                super.paint(graphics);
            }
        }

        @Override
        public Dimension getPreferredSize() {
            int n = 16;
            if (WindowsScrollBarUI.this.scrollbar != null) {
                switch (WindowsScrollBarUI.this.scrollbar.getOrientation()) {
                    case 1: {
                        n = WindowsScrollBarUI.this.scrollbar.getWidth();
                        break;
                    }
                    case 0: {
                        n = WindowsScrollBarUI.this.scrollbar.getHeight();
                    }
                }
                n = Math.max(n, 5);
            }
            return new Dimension(n, n);
        }
    }
}

