/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.util.Arrays;
import java.util.Locale;
import java.util.Spliterator;
import java.util.function.IntConsumer;

final class StringUTF16 {
    static final int HI_BYTE_SHIFT;
    static final int LO_BYTE_SHIFT;
    static final int MAX_LENGTH = 0x3FFFFFFF;
    static final /* synthetic */ boolean $assertionsDisabled;

    StringUTF16() {
    }

    public static byte[] newBytesFor(int n) {
        if (n < 0) {
            throw new NegativeArraySizeException();
        }
        if (n > 0x3FFFFFFF) {
            throw new OutOfMemoryError("UTF16 String size is " + n + ", should be less than " + 0x3FFFFFFF);
        }
        return new byte[n << 1];
    }

    static void putChar(byte[] byArray, int n, int n2) {
        if (!($assertionsDisabled || n >= 0 && n < StringUTF16.length(byArray))) {
            throw new AssertionError((Object)"Trusted caller missed bounds check");
        }
        n <<= 1;
        byArray[n++] = (byte)(n2 >> HI_BYTE_SHIFT);
        byArray[n] = (byte)(n2 >> LO_BYTE_SHIFT);
    }

    static char getChar(byte[] byArray, int n) {
        if (!($assertionsDisabled || n >= 0 && n < StringUTF16.length(byArray))) {
            throw new AssertionError((Object)"Trusted caller missed bounds check");
        }
        n <<= 1;
        return (char)((byArray[n++] & 0xFF) << HI_BYTE_SHIFT | (byArray[n] & 0xFF) << LO_BYTE_SHIFT);
    }

    public static int length(byte[] byArray) {
        return byArray.length >> 1;
    }

    private static int codePointAt(byte[] byArray, int n, int n2, boolean bl) {
        char c;
        if (!$assertionsDisabled && n >= n2) {
            throw new AssertionError();
        }
        if (bl) {
            StringUTF16.checkIndex(n, byArray);
        }
        if (Character.isHighSurrogate(c = StringUTF16.getChar(byArray, n)) && ++n < n2) {
            char c2;
            if (bl) {
                StringUTF16.checkIndex(n, byArray);
            }
            if (Character.isLowSurrogate(c2 = StringUTF16.getChar(byArray, n))) {
                return Character.toCodePoint(c, c2);
            }
        }
        return c;
    }

    public static int codePointAt(byte[] byArray, int n, int n2) {
        return StringUTF16.codePointAt(byArray, n, n2, false);
    }

    private static int codePointBefore(byte[] byArray, int n, boolean bl) {
        char c;
        --n;
        if (bl) {
            StringUTF16.checkIndex(n, byArray);
        }
        if (Character.isLowSurrogate(c = StringUTF16.getChar(byArray, n)) && n > 0) {
            char c2;
            --n;
            if (bl) {
                StringUTF16.checkIndex(n, byArray);
            }
            if (Character.isHighSurrogate(c2 = StringUTF16.getChar(byArray, n))) {
                return Character.toCodePoint(c2, c);
            }
        }
        return c;
    }

    public static int codePointBefore(byte[] byArray, int n) {
        return StringUTF16.codePointBefore(byArray, n, false);
    }

    private static int codePointCount(byte[] byArray, int n, int n2, boolean bl) {
        if (!$assertionsDisabled && n > n2) {
            throw new AssertionError();
        }
        int n3 = n2 - n;
        int n4 = n;
        if (bl && n4 < n2) {
            StringUTF16.checkBoundsBeginEnd(n4, n2, byArray);
        }
        while (n4 < n2 - 1) {
            if (!Character.isHighSurrogate(StringUTF16.getChar(byArray, n4++)) || !Character.isLowSurrogate(StringUTF16.getChar(byArray, n4))) continue;
            --n3;
            ++n4;
        }
        return n3;
    }

    public static int codePointCount(byte[] byArray, int n, int n2) {
        return StringUTF16.codePointCount(byArray, n, n2, false);
    }

    public static char[] toChars(byte[] byArray) {
        char[] cArray = new char[byArray.length >> 1];
        StringUTF16.getChars(byArray, 0, cArray.length, cArray, 0);
        return cArray;
    }

    public static byte[] toBytes(char[] cArray, int n, int n2) {
        byte[] byArray = StringUTF16.newBytesFor(n2);
        for (int i = 0; i < n2; ++i) {
            StringUTF16.putChar(byArray, i, cArray[n]);
            ++n;
        }
        return byArray;
    }

    public static byte[] compress(char[] cArray, int n, int n2) {
        byte[] byArray = new byte[n2];
        if (StringUTF16.compress(cArray, n, byArray, 0, n2) == n2) {
            return byArray;
        }
        return null;
    }

    public static byte[] compress(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2];
        if (StringUTF16.compress(byArray, n, byArray2, 0, n2) == n2) {
            return byArray2;
        }
        return null;
    }

    public static int compress(char[] cArray, int n, byte[] byArray, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            char c = cArray[n];
            if (c > '\u00ff') {
                n3 = 0;
                break;
            }
            byArray[n2] = (byte)c;
            ++n;
            ++n2;
        }
        return n3;
    }

    public static int compress(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        StringUTF16.checkBoundsOffCount(n, n3, byArray);
        for (int i = 0; i < n3; ++i) {
            char c = StringUTF16.getChar(byArray, n);
            if (c > '\u00ff') {
                n3 = 0;
                break;
            }
            byArray2[n2] = (byte)c;
            ++n;
            ++n2;
        }
        return n3;
    }

    public static byte[] toBytes(int[] nArray, int n, int n2) {
        int n3;
        int n4 = n + n2;
        int n5 = n2;
        for (int i = n; i < n4; ++i) {
            n3 = nArray[i];
            if (Character.isBmpCodePoint(n3)) continue;
            if (Character.isValidCodePoint(n3)) {
                ++n5;
                continue;
            }
            throw new IllegalArgumentException(Integer.toString(n3));
        }
        byte[] byArray = StringUTF16.newBytesFor(n5);
        n3 = n;
        int n6 = 0;
        while (n3 < n4) {
            int n7 = nArray[n3];
            if (Character.isBmpCodePoint(n7)) {
                StringUTF16.putChar(byArray, n6, n7);
            } else {
                StringUTF16.putChar(byArray, n6++, Character.highSurrogate(n7));
                StringUTF16.putChar(byArray, n6, Character.lowSurrogate(n7));
            }
            ++n3;
            ++n6;
        }
        return byArray;
    }

    public static byte[] toBytes(char c) {
        byte[] byArray = new byte[2];
        StringUTF16.putChar(byArray, 0, c);
        return byArray;
    }

    public static void getChars(byte[] byArray, int n, int n2, char[] cArray, int n3) {
        if (n < n2) {
            StringUTF16.checkBoundsOffCount(n, n2 - n, byArray);
        }
        for (int i = n; i < n2; ++i) {
            cArray[n3++] = StringUTF16.getChar(byArray, i);
        }
    }

    public static void getBytes(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        n2 <<= 1;
        for (int i = (n <<= 1) + (1 >> LO_BYTE_SHIFT); i < n2; i += 2) {
            byArray2[n3++] = byArray[i];
        }
    }

    public static boolean equals(byte[] byArray, byte[] byArray2) {
        if (byArray.length == byArray2.length) {
            int n = byArray.length >> 1;
            for (int i = 0; i < n; ++i) {
                if (StringUTF16.getChar(byArray, i) == StringUTF16.getChar(byArray2, i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static int compareTo(byte[] byArray, byte[] byArray2) {
        int n = StringUTF16.length(byArray);
        int n2 = StringUTF16.length(byArray2);
        int n3 = Math.min(n, n2);
        for (int i = 0; i < n3; ++i) {
            char c;
            char c2 = StringUTF16.getChar(byArray, i);
            if (c2 == (c = StringUTF16.getChar(byArray2, i))) continue;
            return c2 - c;
        }
        return n - n2;
    }

    public static int compareToLatin1(byte[] byArray, byte[] byArray2) {
        return -StringLatin1.compareToUTF16(byArray2, byArray);
    }

    public static int compareToCI(byte[] byArray, byte[] byArray2) {
        int n = StringUTF16.length(byArray);
        int n2 = StringUTF16.length(byArray2);
        int n3 = Math.min(n, n2);
        for (int i = 0; i < n3; ++i) {
            char c;
            char c2 = StringUTF16.getChar(byArray, i);
            if (c2 == (c = StringUTF16.getChar(byArray2, i)) || (c2 = Character.toUpperCase(c2)) == (c = Character.toUpperCase(c)) || (c2 = Character.toLowerCase(c2)) == (c = Character.toLowerCase(c))) continue;
            return c2 - c;
        }
        return n - n2;
    }

    public static int compareToCI_Latin1(byte[] byArray, byte[] byArray2) {
        return -StringLatin1.compareToCI_UTF16(byArray2, byArray);
    }

    public static int hashCode(byte[] byArray) {
        int n = 0;
        int n2 = byArray.length >> 1;
        for (int i = 0; i < n2; ++i) {
            n = 31 * n + StringUTF16.getChar(byArray, i);
        }
        return n;
    }

    public static int indexOf(byte[] byArray, int n, int n2) {
        int n3 = byArray.length >> 1;
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 >= n3) {
            return -1;
        }
        if (n < 65536) {
            return StringUTF16.indexOfChar(byArray, n, n2, n3);
        }
        return StringUTF16.indexOfSupplementary(byArray, n, n2, n3);
    }

    public static int indexOf(byte[] byArray, byte[] byArray2) {
        if (byArray2.length == 0) {
            return 0;
        }
        if (byArray.length < byArray2.length) {
            return -1;
        }
        return StringUTF16.indexOfUnsafe(byArray, StringUTF16.length(byArray), byArray2, StringUTF16.length(byArray2), 0);
    }

    public static int indexOf(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        StringUTF16.checkBoundsBeginEnd(n3, n, byArray);
        StringUTF16.checkBoundsBeginEnd(0, n2, byArray2);
        return StringUTF16.indexOfUnsafe(byArray, n, byArray2, n2, n3);
    }

    private static int indexOfUnsafe(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        if (!$assertionsDisabled && n3 < 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && n2 <= 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && n2 > StringUTF16.length(byArray2)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && n < n2) {
            throw new AssertionError();
        }
        char c = StringUTF16.getChar(byArray2, 0);
        int n4 = n - n2;
        for (int i = n3; i <= n4; ++i) {
            if (StringUTF16.getChar(byArray, i) != c) {
                while (++i <= n4 && StringUTF16.getChar(byArray, i) != c) {
                }
            }
            if (i > n4) continue;
            int n5 = i + 1;
            int n6 = n5 + n2 - 1;
            int n7 = 1;
            while (n5 < n6 && StringUTF16.getChar(byArray, n5) == StringUTF16.getChar(byArray2, n7)) {
                ++n5;
                ++n7;
            }
            if (n5 != n6) continue;
            return i;
        }
        return -1;
    }

    public static int indexOfLatin1(byte[] byArray, byte[] byArray2) {
        if (byArray2.length == 0) {
            return 0;
        }
        if (StringUTF16.length(byArray) < byArray2.length) {
            return -1;
        }
        return StringUTF16.indexOfLatin1Unsafe(byArray, StringUTF16.length(byArray), byArray2, byArray2.length, 0);
    }

    public static int indexOfLatin1(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        StringUTF16.checkBoundsBeginEnd(n3, n, byArray);
        String.checkBoundsBeginEnd(0, n2, byArray2.length);
        return StringUTF16.indexOfLatin1Unsafe(byArray, n, byArray2, n2, n3);
    }

    public static int indexOfLatin1Unsafe(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        if (!$assertionsDisabled && n3 < 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && n2 <= 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && n2 > byArray2.length) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && n < n2) {
            throw new AssertionError();
        }
        char c = (char)(byArray2[0] & 0xFF);
        int n4 = n - n2;
        for (int i = n3; i <= n4; ++i) {
            if (StringUTF16.getChar(byArray, i) != c) {
                while (++i <= n4 && StringUTF16.getChar(byArray, i) != c) {
                }
            }
            if (i > n4) continue;
            int n5 = i + 1;
            int n6 = n5 + n2 - 1;
            int n7 = 1;
            while (n5 < n6 && StringUTF16.getChar(byArray, n5) == (byArray2[n7] & 0xFF)) {
                ++n5;
                ++n7;
            }
            if (n5 != n6) continue;
            return i;
        }
        return -1;
    }

    private static int indexOfChar(byte[] byArray, int n, int n2, int n3) {
        StringUTF16.checkBoundsBeginEnd(n2, n3, byArray);
        return StringUTF16.indexOfCharUnsafe(byArray, n, n2, n3);
    }

    private static int indexOfCharUnsafe(byte[] byArray, int n, int n2, int n3) {
        for (int i = n2; i < n3; ++i) {
            if (StringUTF16.getChar(byArray, i) != n) continue;
            return i;
        }
        return -1;
    }

    private static int indexOfSupplementary(byte[] byArray, int n, int n2, int n3) {
        if (Character.isValidCodePoint(n)) {
            char c = Character.highSurrogate(n);
            char c2 = Character.lowSurrogate(n);
            StringUTF16.checkBoundsBeginEnd(n2, n3, byArray);
            for (int i = n2; i < n3 - 1; ++i) {
                if (StringUTF16.getChar(byArray, i) != c || StringUTF16.getChar(byArray, i + 1) != c2) continue;
                return i;
            }
        }
        return -1;
    }

    public static int lastIndexOf(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        int n4;
        if (!$assertionsDisabled && n3 < 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && n2 <= 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && n2 > StringUTF16.length(byArray2)) {
            throw new AssertionError();
        }
        int n5 = n2 - 1;
        int n6 = n5 + n3;
        int n7 = n2 - 1;
        StringUTF16.checkIndex(n7, byArray2);
        char c = StringUTF16.getChar(byArray2, n7);
        StringUTF16.checkIndex(n6, byArray);
        block0: while (true) {
            if (n6 >= n5 && StringUTF16.getChar(byArray, n6) != c) {
                --n6;
                continue;
            }
            if (n6 < n5) {
                return -1;
            }
            int n8 = n6 - 1;
            n4 = n8 - n7;
            int n9 = n7 - 1;
            while (n8 > n4) {
                if (StringUTF16.getChar(byArray, n8--) == StringUTF16.getChar(byArray2, n9--)) continue;
                --n6;
                continue block0;
            }
            break;
        }
        return n4 + 1;
    }

    public static int lastIndexOf(byte[] byArray, int n, int n2) {
        if (n < 65536) {
            for (int i = Math.min(n2, (byArray.length >> 1) - 1); i >= 0; --i) {
                if (StringUTF16.getChar(byArray, i) != n) continue;
                return i;
            }
            return -1;
        }
        return StringUTF16.lastIndexOfSupplementary(byArray, n, n2);
    }

    private static int lastIndexOfSupplementary(byte[] byArray, int n, int n2) {
        if (Character.isValidCodePoint(n)) {
            char c = Character.highSurrogate(n);
            char c2 = Character.lowSurrogate(n);
            for (int i = Math.min(n2, (byArray.length >> 1) - 2); i >= 0; --i) {
                if (StringUTF16.getChar(byArray, i) != c || StringUTF16.getChar(byArray, i + 1) != c2) continue;
                return i;
            }
        }
        return -1;
    }

    public static String replace(byte[] byArray, char c, char n) {
        int n2 = byArray.length >> 1;
        int n3 = -1;
        while (++n3 < n2 && StringUTF16.getChar(byArray, n3) != c) {
        }
        if (n3 < n2) {
            byte[] byArray2;
            int n4;
            byte[] byArray3 = new byte[byArray.length];
            for (n4 = 0; n4 < n3; ++n4) {
                StringUTF16.putChar(byArray3, n4, StringUTF16.getChar(byArray, n4));
            }
            while (n3 < n2) {
                n4 = StringUTF16.getChar(byArray, n3);
                StringUTF16.putChar(byArray3, n3, n4 == c ? n : n4);
                ++n3;
            }
            if (String.COMPACT_STRINGS && !StringLatin1.canEncode(c) && StringLatin1.canEncode(n) && (byArray2 = StringUTF16.compress(byArray3, 0, n2)) != null) {
                return new String(byArray2, 0);
            }
            return new String(byArray3, 1);
        }
        return null;
    }

    public static boolean regionMatchesCI(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        int n4 = n + n3;
        if (!($assertionsDisabled || n >= 0 && n2 >= 0)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && n2 + n3 > StringUTF16.length(byArray2)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && n4 > StringUTF16.length(byArray)) {
            throw new AssertionError();
        }
        while (n < n4) {
            char c;
            char c2;
            char c3;
            char c4;
            if ((c4 = StringUTF16.getChar(byArray, n++)) == (c3 = StringUTF16.getChar(byArray2, n2++)) || (c2 = Character.toUpperCase(c4)) == (c = Character.toUpperCase(c3)) || Character.toLowerCase(c2) == Character.toLowerCase(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean regionMatchesCI_Latin1(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        return StringLatin1.regionMatchesCI_UTF16(byArray2, n2, byArray, n, n3);
    }

    public static String toLowerCase(String string, byte[] byArray, Locale locale) {
        int n;
        if (locale == null) {
            throw new NullPointerException();
        }
        boolean bl = false;
        int n2 = byArray.length >> 1;
        for (n = 0; n < n2; ++n) {
            char c = StringUTF16.getChar(byArray, n);
            if (Character.isSurrogate(c)) {
                bl = true;
                break;
            }
            if (c != Character.toLowerCase((int)c)) break;
        }
        if (n == n2) {
            return string;
        }
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, n << 1);
        String string2 = locale.getLanguage();
        if (string2 == "tr" || string2 == "az" || string2 == "lt") {
            return StringUTF16.toLowerCaseEx(string, byArray, byArray2, n, locale, true);
        }
        if (bl) {
            return StringUTF16.toLowerCaseEx(string, byArray, byArray2, n, locale, false);
        }
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            int n4 = StringUTF16.getChar(byArray, i);
            if (n4 == 931 || Character.isSurrogate((char)n4)) {
                return StringUTF16.toLowerCaseEx(string, byArray, byArray2, i, locale, false);
            }
            if (n4 == 304) {
                return StringUTF16.toLowerCaseEx(string, byArray, byArray2, i, locale, true);
            }
            if (!Character.isBmpCodePoint(n4 = Character.toLowerCase(n4))) {
                return StringUTF16.toLowerCaseEx(string, byArray, byArray2, i, locale, false);
            }
            n3 |= n4;
            StringUTF16.putChar(byArray2, i, n4);
        }
        if (n3 > 255) {
            return new String(byArray2, 1);
        }
        return StringUTF16.newString(byArray2, 0, n2);
    }

    private static String toLowerCaseEx(String string, byte[] byArray, byte[] byArray2, int n, Locale locale, boolean bl) {
        int n2;
        if (!$assertionsDisabled && byArray2.length != byArray.length) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && n < 0) {
            throw new AssertionError();
        }
        int n3 = n;
        int n4 = byArray.length >> 1;
        for (int i = n; i < n4; i += n2) {
            int n5;
            int n6 = StringUTF16.getChar(byArray, i);
            n2 = 1;
            if (Character.isSurrogate((char)n6)) {
                n6 = StringUTF16.codePointAt(byArray, i, n4);
                n2 = Character.charCount(n6);
            }
            if (Character.isBmpCodePoint(n5 = bl || n6 == 931 || n6 == 304 ? ConditionalSpecialCasing.toLowerCaseEx(string, i, locale) : Character.toLowerCase(n6))) {
                StringUTF16.putChar(byArray2, n3++, n5);
                continue;
            }
            char[] cArray = n5 == -1 ? ConditionalSpecialCasing.toLowerCaseCharArray(string, i, locale) : Character.toChars(n5);
            int n7 = cArray.length;
            if (n7 > n2) {
                byte[] byArray3 = StringUTF16.newBytesFor((byArray2.length >> 1) + n7 - n2);
                System.arraycopy(byArray2, 0, byArray3, 0, n3 << 1);
                byArray2 = byArray3;
            }
            if (!$assertionsDisabled && n3 < 0) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && n3 + n7 > StringUTF16.length(byArray2)) {
                throw new AssertionError();
            }
            for (int j = 0; j < n7; ++j) {
                StringUTF16.putChar(byArray2, n3++, cArray[j]);
            }
        }
        return StringUTF16.newString(byArray2, 0, n3);
    }

    public static String toUpperCase(String string, byte[] byArray, Locale locale) {
        int n;
        if (locale == null) {
            throw new NullPointerException();
        }
        boolean bl = false;
        int n2 = byArray.length >> 1;
        for (n = 0; n < n2; ++n) {
            char c = StringUTF16.getChar(byArray, n);
            if (Character.isSurrogate(c)) {
                bl = true;
                break;
            }
            if (c != Character.toUpperCaseEx(c)) break;
        }
        if (n == n2) {
            return string;
        }
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, n << 1);
        String string2 = locale.getLanguage();
        if (string2 == "tr" || string2 == "az" || string2 == "lt") {
            return StringUTF16.toUpperCaseEx(string, byArray, byArray2, n, locale, true);
        }
        if (bl) {
            return StringUTF16.toUpperCaseEx(string, byArray, byArray2, n, locale, false);
        }
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            int n4 = StringUTF16.getChar(byArray, i);
            if (Character.isSurrogate((char)n4)) {
                return StringUTF16.toUpperCaseEx(string, byArray, byArray2, i, locale, false);
            }
            if (!Character.isBmpCodePoint(n4 = Character.toUpperCaseEx(n4))) {
                return StringUTF16.toUpperCaseEx(string, byArray, byArray2, i, locale, false);
            }
            n3 |= n4;
            StringUTF16.putChar(byArray2, i, n4);
        }
        if (n3 > 255) {
            return new String(byArray2, 1);
        }
        return StringUTF16.newString(byArray2, 0, n2);
    }

    private static String toUpperCaseEx(String string, byte[] byArray, byte[] byArray2, int n, Locale locale, boolean bl) {
        int n2;
        if (!$assertionsDisabled && byArray2.length != byArray.length) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && n < 0) {
            throw new AssertionError();
        }
        int n3 = n;
        int n4 = byArray.length >> 1;
        for (int i = n; i < n4; i += n2) {
            int n5;
            int n6 = StringUTF16.getChar(byArray, i);
            n2 = 1;
            if (Character.isSurrogate((char)n6)) {
                n6 = StringUTF16.codePointAt(byArray, i, n4);
                n2 = Character.charCount(n6);
            }
            if (Character.isBmpCodePoint(n5 = bl ? ConditionalSpecialCasing.toUpperCaseEx(string, i, locale) : Character.toUpperCaseEx(n6))) {
                StringUTF16.putChar(byArray2, n3++, n5);
                continue;
            }
            char[] cArray = n5 == -1 ? (bl ? ConditionalSpecialCasing.toUpperCaseCharArray(string, i, locale) : Character.toUpperCaseCharArray(n6)) : Character.toChars(n5);
            int n7 = cArray.length;
            if (n7 > n2) {
                byte[] byArray3 = StringUTF16.newBytesFor((byArray2.length >> 1) + n7 - n2);
                System.arraycopy(byArray2, 0, byArray3, 0, n3 << 1);
                byArray2 = byArray3;
            }
            if (!$assertionsDisabled && n3 < 0) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && n3 + n7 > StringUTF16.length(byArray2)) {
                throw new AssertionError();
            }
            for (int j = 0; j < n7; ++j) {
                StringUTF16.putChar(byArray2, n3++, cArray[j]);
            }
        }
        return StringUTF16.newString(byArray2, 0, n3);
    }

    public static String trim(byte[] byArray) {
        int n;
        int n2;
        int n3 = n2 = byArray.length >> 1;
        for (n = 0; n < n3 && StringUTF16.getChar(byArray, n) <= ' '; ++n) {
        }
        while (n < n3 && StringUTF16.getChar(byArray, n3 - 1) <= ' ') {
            --n3;
        }
        return n > 0 || n3 < n2 ? new String(Arrays.copyOfRange(byArray, n << 1, n3 << 1), 1) : null;
    }

    private static void putChars(byte[] byArray, int n, char[] cArray, int n2, int n3) {
        while (n2 < n3) {
            StringUTF16.putChar(byArray, n++, cArray[n2++]);
        }
    }

    public static String newString(byte[] byArray, int n, int n2) {
        byte[] byArray2;
        if (String.COMPACT_STRINGS && (byArray2 = StringUTF16.compress(byArray, n, n2)) != null) {
            return new String(byArray2, 0);
        }
        int n3 = n + n2;
        return new String(Arrays.copyOfRange(byArray, n << 1, n3 << 1), 1);
    }

    public static void fillNull(byte[] byArray, int n, int n2) {
        Arrays.fill(byArray, n << 1, n2 << 1, (byte)0);
    }

    public static void putCharSB(byte[] byArray, int n, int n2) {
        StringUTF16.checkIndex(n, byArray);
        StringUTF16.putChar(byArray, n, n2);
    }

    public static void putCharsSB(byte[] byArray, int n, char[] cArray, int n2, int n3) {
        StringUTF16.checkBoundsBeginEnd(n, n + n3 - n2, byArray);
        StringUTF16.putChars(byArray, n, cArray, n2, n3);
    }

    public static void putCharsSB(byte[] byArray, int n, CharSequence charSequence, int n2, int n3) {
        StringUTF16.checkBoundsBeginEnd(n, n + n3 - n2, byArray);
        for (int i = n2; i < n3; ++i) {
            StringUTF16.putChar(byArray, n++, charSequence.charAt(i));
        }
    }

    public static int codePointAtSB(byte[] byArray, int n, int n2) {
        return StringUTF16.codePointAt(byArray, n, n2, true);
    }

    public static int codePointBeforeSB(byte[] byArray, int n) {
        return StringUTF16.codePointBefore(byArray, n, true);
    }

    public static int codePointCountSB(byte[] byArray, int n, int n2) {
        return StringUTF16.codePointCount(byArray, n, n2, true);
    }

    public static int getChars(int n, int n2, int n3, byte[] byArray) {
        StringUTF16.checkBoundsBeginEnd(n2, n3, byArray);
        int n4 = StringUTF16.getChars(n, n3, byArray);
        if (!$assertionsDisabled && n2 != n4) {
            throw new AssertionError();
        }
        return n4;
    }

    public static int getChars(long l, int n, int n2, byte[] byArray) {
        StringUTF16.checkBoundsBeginEnd(n, n2, byArray);
        int n3 = StringUTF16.getChars(l, n2, byArray);
        if (!$assertionsDisabled && n != n3) {
            throw new AssertionError();
        }
        return n3;
    }

    public static boolean contentEquals(byte[] byArray, byte[] byArray2, int n) {
        StringUTF16.checkBoundsOffCount(0, n, byArray2);
        for (int i = 0; i < n; ++i) {
            if ((char)(byArray[i] & 0xFF) == StringUTF16.getChar(byArray2, i)) continue;
            return false;
        }
        return true;
    }

    public static boolean contentEquals(byte[] byArray, CharSequence charSequence, int n) {
        StringUTF16.checkOffset(n, byArray);
        for (int i = 0; i < n; ++i) {
            if (StringUTF16.getChar(byArray, i) == charSequence.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static int putCharsAt(byte[] byArray, int n, char c, char c2, char c3, char c4) {
        int n2 = n + 4;
        StringUTF16.checkBoundsBeginEnd(n, n2, byArray);
        StringUTF16.putChar(byArray, n++, c);
        StringUTF16.putChar(byArray, n++, c2);
        StringUTF16.putChar(byArray, n++, c3);
        StringUTF16.putChar(byArray, n++, c4);
        if (!$assertionsDisabled && n != n2) {
            throw new AssertionError();
        }
        return n2;
    }

    public static int putCharsAt(byte[] byArray, int n, char c, char c2, char c3, char c4, char c5) {
        int n2 = n + 5;
        StringUTF16.checkBoundsBeginEnd(n, n2, byArray);
        StringUTF16.putChar(byArray, n++, c);
        StringUTF16.putChar(byArray, n++, c2);
        StringUTF16.putChar(byArray, n++, c3);
        StringUTF16.putChar(byArray, n++, c4);
        StringUTF16.putChar(byArray, n++, c5);
        if (!$assertionsDisabled && n != n2) {
            throw new AssertionError();
        }
        return n2;
    }

    public static char charAt(byte[] byArray, int n) {
        StringUTF16.checkIndex(n, byArray);
        return StringUTF16.getChar(byArray, n);
    }

    public static void reverse(byte[] byArray, int n) {
        StringUTF16.checkOffset(n, byArray);
        int n2 = n - 1;
        boolean bl = false;
        for (int i = n2 - 1 >> 1; i >= 0; --i) {
            int n3 = n2 - i;
            char c = StringUTF16.getChar(byArray, i);
            char c2 = StringUTF16.getChar(byArray, n3);
            StringUTF16.putChar(byArray, i, c2);
            StringUTF16.putChar(byArray, n3, c);
            if (!Character.isSurrogate(c) && !Character.isSurrogate(c2)) continue;
            bl = true;
        }
        if (bl) {
            StringUTF16.reverseAllValidSurrogatePairs(byArray, n);
        }
    }

    private static void reverseAllValidSurrogatePairs(byte[] byArray, int n) {
        for (int i = 0; i < n - 1; ++i) {
            char c;
            char c2 = StringUTF16.getChar(byArray, i);
            if (!Character.isLowSurrogate(c2) || !Character.isHighSurrogate(c = StringUTF16.getChar(byArray, i + 1))) continue;
            StringUTF16.putChar(byArray, i++, c);
            StringUTF16.putChar(byArray, i, c2);
        }
    }

    public static void inflate(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        StringUTF16.checkBoundsOffCount(n2, n3, byArray2);
        for (int i = 0; i < n3; ++i) {
            StringUTF16.putChar(byArray2, n2++, byArray[n++] & 0xFF);
        }
    }

    public static int lastIndexOfLatin1(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        int n4;
        if (!$assertionsDisabled && n3 < 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && n2 <= 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && n2 > byArray2.length) {
            throw new AssertionError();
        }
        int n5 = n2 - 1;
        int n6 = n5 + n3;
        int n7 = n2 - 1;
        char c = (char)(byArray2[n7] & 0xFF);
        StringUTF16.checkIndex(n6, byArray);
        block0: while (true) {
            if (n6 >= n5 && StringUTF16.getChar(byArray, n6) != c) {
                --n6;
                continue;
            }
            if (n6 < n5) {
                return -1;
            }
            int n8 = n6 - 1;
            n4 = n8 - n7;
            int n9 = n7 - 1;
            while (n8 > n4) {
                if (StringUTF16.getChar(byArray, n8--) == (byArray2[n9--] & 0xFF)) continue;
                --n6;
                continue block0;
            }
            break;
        }
        return n4 + 1;
    }

    private static native boolean isBigEndian();

    static int getChars(int n, int n2, byte[] byArray) {
        int n3;
        int n4;
        boolean bl;
        int n5 = n2;
        boolean bl2 = bl = n < 0;
        if (!bl) {
            n = -n;
        }
        while (n <= -100) {
            n4 = n / 100;
            n3 = n4 * 100 - n;
            n = n4;
            StringUTF16.putChar(byArray, --n5, Integer.DigitOnes[n3]);
            StringUTF16.putChar(byArray, --n5, Integer.DigitTens[n3]);
        }
        n4 = n / 10;
        n3 = n4 * 10 - n;
        StringUTF16.putChar(byArray, --n5, 48 + n3);
        if (n4 < 0) {
            StringUTF16.putChar(byArray, --n5, 48 - n4);
        }
        if (bl) {
            StringUTF16.putChar(byArray, --n5, 45);
        }
        return n5;
    }

    static int getChars(long l, int n, byte[] byArray) {
        int n2;
        int n3;
        boolean bl;
        int n4 = n;
        boolean bl2 = bl = l < 0L;
        if (!bl) {
            l = -l;
        }
        while (l <= Integer.MIN_VALUE) {
            long l2 = l / 100L;
            n3 = (int)(l2 * 100L - l);
            l = l2;
            StringUTF16.putChar(byArray, --n4, Integer.DigitOnes[n3]);
            StringUTF16.putChar(byArray, --n4, Integer.DigitTens[n3]);
        }
        int n5 = (int)l;
        while (n5 <= -100) {
            n2 = n5 / 100;
            n3 = n2 * 100 - n5;
            n5 = n2;
            StringUTF16.putChar(byArray, --n4, Integer.DigitOnes[n3]);
            StringUTF16.putChar(byArray, --n4, Integer.DigitTens[n3]);
        }
        n2 = n5 / 10;
        n3 = n2 * 10 - n5;
        StringUTF16.putChar(byArray, --n4, 48 + n3);
        if (n2 < 0) {
            StringUTF16.putChar(byArray, --n4, 48 - n2);
        }
        if (bl) {
            StringUTF16.putChar(byArray, --n4, 45);
        }
        return n4;
    }

    public static void checkIndex(int n, byte[] byArray) {
        String.checkIndex(n, StringUTF16.length(byArray));
    }

    public static void checkOffset(int n, byte[] byArray) {
        String.checkOffset(n, StringUTF16.length(byArray));
    }

    public static void checkBoundsBeginEnd(int n, int n2, byte[] byArray) {
        String.checkBoundsBeginEnd(n, n2, StringUTF16.length(byArray));
    }

    public static void checkBoundsOffCount(int n, int n2, byte[] byArray) {
        String.checkBoundsOffCount(n, n2, StringUTF16.length(byArray));
    }

    static {
        boolean bl = $assertionsDisabled = !StringUTF16.class.desiredAssertionStatus();
        if (StringUTF16.isBigEndian()) {
            HI_BYTE_SHIFT = 8;
            LO_BYTE_SHIFT = 0;
        } else {
            HI_BYTE_SHIFT = 0;
            LO_BYTE_SHIFT = 8;
        }
    }

    static class CodePointsSpliterator
    implements Spliterator.OfInt {
        private final byte[] array;
        private int index;
        private final int fence;
        private final int cs;

        CodePointsSpliterator(byte[] byArray, int n) {
            this(byArray, 0, byArray.length >> 1, n);
        }

        CodePointsSpliterator(byte[] byArray, int n, int n2, int n3) {
            this.array = byArray;
            this.index = n;
            this.fence = n2;
            this.cs = n3 | 0x10;
        }

        @Override
        public Spliterator.OfInt trySplit() {
            int n;
            int n2 = this.index;
            int n3 = n2 + this.fence >>> 1;
            if (n2 >= n3) {
                return null;
            }
            if (Character.isLowSurrogate(StringUTF16.charAt(this.array, n3)) && Character.isHighSurrogate(StringUTF16.charAt(this.array, n = n3 - 1))) {
                if (n2 >= n) {
                    return null;
                }
                this.index = n;
                return new CodePointsSpliterator(this.array, n2, this.index, this.cs);
            }
            this.index = n3;
            return new CodePointsSpliterator(this.array, n2, this.index, this.cs);
        }

        @Override
        public void forEachRemaining(IntConsumer intConsumer) {
            int n;
            if (intConsumer == null) {
                throw new NullPointerException();
            }
            byte[] byArray = this.array;
            int n2 = this.fence;
            if (this.array.length >> 1 >= n2 && (n = this.index) >= 0 && n < (this.index = n2)) {
                while ((n = CodePointsSpliterator.advance(byArray, n, n2, intConsumer)) < n2) {
                }
            }
        }

        @Override
        public boolean tryAdvance(IntConsumer intConsumer) {
            if (intConsumer == null) {
                throw new NullPointerException();
            }
            if (this.index >= 0 && this.index < this.fence) {
                this.index = CodePointsSpliterator.advance(this.array, this.index, this.fence, intConsumer);
                return true;
            }
            return false;
        }

        private static int advance(byte[] byArray, int n, int n2, IntConsumer intConsumer) {
            char c;
            int n3;
            int n4 = n3 = StringUTF16.charAt(byArray, n++);
            if (Character.isHighSurrogate((char)n3) && n < n2 && Character.isLowSurrogate(c = StringUTF16.charAt(byArray, n))) {
                ++n;
                n4 = Character.toCodePoint((char)n3, c);
            }
            intConsumer.accept(n4);
            return n;
        }

        @Override
        public long estimateSize() {
            return this.fence - this.index;
        }

        @Override
        public int characteristics() {
            return this.cs;
        }
    }

    static class CharsSpliterator
    implements Spliterator.OfInt {
        private final byte[] array;
        private int index;
        private final int fence;
        private final int cs;

        CharsSpliterator(byte[] byArray, int n) {
            this(byArray, 0, byArray.length >> 1, n);
        }

        CharsSpliterator(byte[] byArray, int n, int n2, int n3) {
            this.array = byArray;
            this.index = n;
            this.fence = n2;
            this.cs = n3 | 0x10 | 0x40 | 0x4000;
        }

        @Override
        public Spliterator.OfInt trySplit() {
            CharsSpliterator charsSpliterator;
            int n = this.index;
            int n2 = n + this.fence >>> 1;
            if (n >= n2) {
                charsSpliterator = null;
            } else {
                this.index = n2;
                CharsSpliterator charsSpliterator2 = new CharsSpliterator(this.array, n, this.index, this.cs);
                charsSpliterator = charsSpliterator2;
            }
            return charsSpliterator;
        }

        @Override
        public void forEachRemaining(IntConsumer intConsumer) {
            int n;
            if (intConsumer == null) {
                throw new NullPointerException();
            }
            byte[] byArray = this.array;
            int n2 = this.fence;
            if (this.array.length >> 1 >= n2 && (n = this.index) >= 0 && n < (this.index = n2)) {
                do {
                    intConsumer.accept(StringUTF16.charAt(byArray, n));
                } while (++n < n2);
            }
        }

        @Override
        public boolean tryAdvance(IntConsumer intConsumer) {
            int n;
            if (intConsumer == null) {
                throw new NullPointerException();
            }
            if ((n = this.index++) >= 0 && n < this.fence) {
                intConsumer.accept(StringUTF16.charAt(this.array, n));
                return true;
            }
            return false;
        }

        @Override
        public long estimateSize() {
            return this.fence - this.index;
        }

        @Override
        public int characteristics() {
            return this.cs;
        }
    }
}

