/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.util.Arrays;
import java.util.Locale;
import java.util.Spliterator;
import java.util.function.IntConsumer;

final class StringLatin1 {
    StringLatin1() {
    }

    public static char charAt(byte[] byArray, int n) {
        if (n < 0 || n >= byArray.length) {
            throw new StringIndexOutOfBoundsException(n);
        }
        return (char)(byArray[n] & 0xFF);
    }

    public static boolean canEncode(int n) {
        return n >>> 8 == 0;
    }

    public static int length(byte[] byArray) {
        return byArray.length;
    }

    public static int codePointAt(byte[] byArray, int n, int n2) {
        return byArray[n] & 0xFF;
    }

    public static int codePointBefore(byte[] byArray, int n) {
        return byArray[n - 1] & 0xFF;
    }

    public static int codePointCount(byte[] byArray, int n, int n2) {
        return n2 - n;
    }

    public static char[] toChars(byte[] byArray) {
        char[] cArray = new char[byArray.length];
        StringLatin1.inflate(byArray, 0, cArray, 0, byArray.length);
        return cArray;
    }

    public static byte[] inflate(byte[] byArray, int n, int n2) {
        byte[] byArray2 = StringUTF16.newBytesFor(n2);
        StringLatin1.inflate(byArray, n, byArray2, 0, n2);
        return byArray2;
    }

    public static void getChars(byte[] byArray, int n, int n2, char[] cArray, int n3) {
        StringLatin1.inflate(byArray, n, cArray, n3, n2 - n);
    }

    public static void getBytes(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        System.arraycopy(byArray, n, byArray2, n3, n2 - n);
    }

    public static boolean equals(byte[] byArray, byte[] byArray2) {
        if (byArray.length == byArray2.length) {
            for (int i = 0; i < byArray.length; ++i) {
                if (byArray[i] == byArray2[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static int compareTo(byte[] byArray, byte[] byArray2) {
        int n = byArray.length;
        int n2 = byArray2.length;
        int n3 = Math.min(n, n2);
        for (int i = 0; i < n3; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return StringLatin1.getChar(byArray, i) - StringLatin1.getChar(byArray2, i);
        }
        return n - n2;
    }

    public static int compareToUTF16(byte[] byArray, byte[] byArray2) {
        int n = StringLatin1.length(byArray);
        int n2 = StringUTF16.length(byArray2);
        int n3 = Math.min(n, n2);
        for (int i = 0; i < n3; ++i) {
            char c;
            char c2 = StringLatin1.getChar(byArray, i);
            if (c2 == (c = StringUTF16.getChar(byArray2, i))) continue;
            return c2 - c;
        }
        return n - n2;
    }

    public static int compareToCI(byte[] byArray, byte[] byArray2) {
        int n = byArray.length;
        int n2 = byArray2.length;
        int n3 = Math.min(n, n2);
        for (int i = 0; i < n3; ++i) {
            char c;
            char c2;
            if (byArray[i] == byArray2[i] || (c2 = (char)CharacterDataLatin1.instance.toUpperCase(StringLatin1.getChar(byArray, i))) == (c = (char)CharacterDataLatin1.instance.toUpperCase(StringLatin1.getChar(byArray2, i))) || (c2 = Character.toLowerCase(c2)) == (c = Character.toLowerCase(c))) continue;
            return c2 - c;
        }
        return n - n2;
    }

    public static int compareToCI_UTF16(byte[] byArray, byte[] byArray2) {
        int n = StringLatin1.length(byArray);
        int n2 = StringUTF16.length(byArray2);
        int n3 = Math.min(n, n2);
        for (int i = 0; i < n3; ++i) {
            char c;
            char c2 = StringLatin1.getChar(byArray, i);
            if (c2 == (c = StringUTF16.getChar(byArray2, i)) || (c2 = Character.toUpperCase(c2)) == (c = Character.toUpperCase(c)) || (c2 = Character.toLowerCase(c2)) == (c = Character.toLowerCase(c))) continue;
            return c2 - c;
        }
        return n - n2;
    }

    public static int hashCode(byte[] byArray) {
        int n = 0;
        for (byte by : byArray) {
            n = 31 * n + (by & 0xFF);
        }
        return n;
    }

    public static int indexOf(byte[] byArray, int n, int n2) {
        if (!StringLatin1.canEncode(n)) {
            return -1;
        }
        int n3 = byArray.length;
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 >= n3) {
            return -1;
        }
        byte by = (byte)n;
        for (int i = n2; i < n3; ++i) {
            if (byArray[i] != by) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(byte[] byArray, byte[] byArray2) {
        if (byArray2.length == 0) {
            return 0;
        }
        if (byArray.length == 0) {
            return -1;
        }
        return StringLatin1.indexOf(byArray, byArray.length, byArray2, byArray2.length, 0);
    }

    public static int indexOf(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        byte by = byArray2[0];
        int n4 = n - n2;
        for (int i = n3; i <= n4; ++i) {
            if (byArray[i] != by) {
                while (++i <= n4 && byArray[i] != by) {
                }
            }
            if (i > n4) continue;
            int n5 = i + 1;
            int n6 = n5 + n2 - 1;
            int n7 = 1;
            while (n5 < n6 && byArray[n5] == byArray2[n7]) {
                ++n5;
                ++n7;
            }
            if (n5 != n6) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        int n4;
        int n5 = n2 - 1;
        int n6 = n5 + n3;
        int n7 = n2 - 1;
        char c = (char)(byArray2[n7] & 0xFF);
        block0: while (true) {
            if (n6 >= n5 && (byArray[n6] & 0xFF) != c) {
                --n6;
                continue;
            }
            if (n6 < n5) {
                return -1;
            }
            int n8 = n6 - 1;
            n4 = n8 - n7;
            int n9 = n7 - 1;
            while (n8 > n4) {
                if ((byArray[n8--] & 0xFF) == (byArray2[n9--] & 0xFF)) continue;
                --n6;
                continue block0;
            }
            break;
        }
        return n4 + 1;
    }

    public static int lastIndexOf(byte[] byArray, int n, int n2) {
        if (!StringLatin1.canEncode(n)) {
            return -1;
        }
        for (int i = Math.min(n2, byArray.length - 1); i >= 0; --i) {
            if (byArray[i] != (byte)n) continue;
            return i;
        }
        return -1;
    }

    public static String replace(byte[] byArray, char c, char c2) {
        if (StringLatin1.canEncode(c)) {
            int n = byArray.length;
            int n2 = -1;
            while (++n2 < n && byArray[n2] != (byte)c) {
            }
            if (n2 < n) {
                if (StringLatin1.canEncode(c2)) {
                    int n3;
                    byte[] byArray2 = new byte[n];
                    for (n3 = 0; n3 < n2; ++n3) {
                        byArray2[n3] = byArray[n3];
                    }
                    while (n2 < n) {
                        n3 = byArray[n2];
                        byArray2[n2] = n3 == (byte)c ? (int)c2 : n3;
                        ++n2;
                    }
                    return new String(byArray2, 0);
                }
                byte[] byArray3 = StringUTF16.newBytesFor(n);
                StringLatin1.inflate(byArray, 0, byArray3, 0, n2);
                while (n2 < n) {
                    char c3 = (char)(byArray[n2] & 0xFF);
                    StringUTF16.putChar(byArray3, n2, c3 == c ? c2 : c3);
                    ++n2;
                }
                return new String(byArray3, 1);
            }
        }
        return null;
    }

    public static boolean regionMatchesCI(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        int n4 = n + n3;
        while (n < n4) {
            char c;
            char c2;
            char c3;
            char c4;
            if ((c4 = (char)(byArray[n++] & 0xFF)) == (c3 = (char)(byArray2[n2++] & 0xFF)) || (c2 = Character.toUpperCase(c4)) == (c = Character.toUpperCase(c3)) || Character.toLowerCase(c2) == Character.toLowerCase(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean regionMatchesCI_UTF16(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        int n4 = n + n3;
        while (n < n4) {
            char c;
            char c2;
            char c3;
            char c4;
            if ((c4 = (char)(byArray[n++] & 0xFF)) == (c3 = StringUTF16.getChar(byArray2, n2++)) || (c2 = Character.toUpperCase(c4)) == (c = Character.toUpperCase(c3)) || Character.toLowerCase(c2) == Character.toLowerCase(c)) continue;
            return false;
        }
        return true;
    }

    public static String toLowerCase(String string, byte[] byArray, Locale locale) {
        int n;
        int n2;
        if (locale == null) {
            throw new NullPointerException();
        }
        int n3 = byArray.length;
        for (n2 = 0; n2 < n3 && (n = byArray[n2] & 0xFF) == Character.toLowerCase(n); ++n2) {
        }
        if (n2 == n3) {
            return string;
        }
        String string2 = locale.getLanguage();
        if (string2 == "tr" || string2 == "az" || string2 == "lt") {
            return StringLatin1.toLowerCaseEx(string, byArray, n2, locale, true);
        }
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        for (int i = n2; i < n3; ++i) {
            int n4 = byArray[i] & 0xFF;
            if (!StringLatin1.canEncode(n4 = Character.toLowerCase(n4))) {
                return StringLatin1.toLowerCaseEx(string, byArray, n2, locale, false);
            }
            byArray2[i] = (byte)n4;
        }
        return new String(byArray2, 0);
    }

    private static String toLowerCaseEx(String string, byte[] byArray, int n, Locale locale, boolean bl) {
        int n2;
        byte[] byArray2 = StringUTF16.newBytesFor(byArray.length);
        int n3 = 0;
        for (n2 = 0; n2 < n; ++n2) {
            StringUTF16.putChar(byArray2, n3++, byArray[n2] & 0xFF);
        }
        for (n2 = n; n2 < byArray.length; ++n2) {
            int n4 = byArray[n2] & 0xFF;
            int n5 = bl ? ConditionalSpecialCasing.toLowerCaseEx(string, n2, locale) : Character.toLowerCase(n4);
            if (Character.isBmpCodePoint(n5)) {
                StringUTF16.putChar(byArray2, n3++, n5);
                continue;
            }
            char[] cArray = n5 == -1 ? ConditionalSpecialCasing.toLowerCaseCharArray(string, n2, locale) : Character.toChars(n5);
            int n6 = cArray.length;
            if (n6 > 1) {
                byte[] byArray3 = StringUTF16.newBytesFor((byArray2.length >> 1) + n6 - 1);
                System.arraycopy(byArray2, 0, byArray3, 0, n3 << 1);
                byArray2 = byArray3;
            }
            for (int i = 0; i < n6; ++i) {
                StringUTF16.putChar(byArray2, n3++, cArray[i]);
            }
        }
        return StringUTF16.newString(byArray2, 0, n3);
    }

    public static String toUpperCase(String string, byte[] byArray, Locale locale) {
        int n;
        int n2;
        if (locale == null) {
            throw new NullPointerException();
        }
        int n3 = byArray.length;
        for (n2 = 0; n2 < n3 && (n = byArray[n2] & 0xFF) == Character.toUpperCaseEx(n); ++n2) {
        }
        if (n2 == n3) {
            return string;
        }
        String string2 = locale.getLanguage();
        if (string2 == "tr" || string2 == "az" || string2 == "lt") {
            return StringLatin1.toUpperCaseEx(string, byArray, n2, locale, true);
        }
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        for (int i = n2; i < n3; ++i) {
            int n4 = byArray[i] & 0xFF;
            if (!StringLatin1.canEncode(n4 = Character.toUpperCaseEx(n4))) {
                return StringLatin1.toUpperCaseEx(string, byArray, n2, locale, false);
            }
            byArray2[i] = (byte)n4;
        }
        return new String(byArray2, 0);
    }

    private static String toUpperCaseEx(String string, byte[] byArray, int n, Locale locale, boolean bl) {
        int n2;
        byte[] byArray2 = StringUTF16.newBytesFor(byArray.length);
        int n3 = 0;
        for (n2 = 0; n2 < n; ++n2) {
            StringUTF16.putChar(byArray2, n3++, byArray[n2] & 0xFF);
        }
        for (n2 = n; n2 < byArray.length; ++n2) {
            int n4 = byArray[n2] & 0xFF;
            int n5 = bl ? ConditionalSpecialCasing.toUpperCaseEx(string, n2, locale) : Character.toUpperCaseEx(n4);
            if (Character.isBmpCodePoint(n5)) {
                StringUTF16.putChar(byArray2, n3++, n5);
                continue;
            }
            char[] cArray = n5 == -1 ? (bl ? ConditionalSpecialCasing.toUpperCaseCharArray(string, n2, locale) : Character.toUpperCaseCharArray(n4)) : Character.toChars(n5);
            int n6 = cArray.length;
            if (n6 > 1) {
                byte[] byArray3 = StringUTF16.newBytesFor((byArray2.length >> 1) + n6 - 1);
                System.arraycopy(byArray2, 0, byArray3, 0, n3 << 1);
                byArray2 = byArray3;
            }
            for (int i = 0; i < n6; ++i) {
                StringUTF16.putChar(byArray2, n3++, cArray[i]);
            }
        }
        return StringUTF16.newString(byArray2, 0, n3);
    }

    public static String trim(byte[] byArray) {
        int n;
        int n2 = byArray.length;
        for (n = 0; n < n2 && (byArray[n] & 0xFF) <= 32; ++n) {
        }
        while (n < n2 && (byArray[n2 - 1] & 0xFF) <= 32) {
            --n2;
        }
        return n > 0 || n2 < byArray.length ? StringLatin1.newString(byArray, n, n2 - n) : null;
    }

    public static void putChar(byte[] byArray, int n, int n2) {
        byArray[n] = (byte)n2;
    }

    public static char getChar(byte[] byArray, int n) {
        return (char)(byArray[n] & 0xFF);
    }

    public static byte[] toBytes(int[] nArray, int n, int n2) {
        byte[] byArray = new byte[n2];
        for (int i = 0; i < n2; ++i) {
            int n3;
            if (!StringLatin1.canEncode(n3 = nArray[n++])) {
                return null;
            }
            byArray[i] = (byte)n3;
        }
        return byArray;
    }

    public static byte[] toBytes(char c) {
        return new byte[]{(byte)c};
    }

    public static String newString(byte[] byArray, int n, int n2) {
        return new String(Arrays.copyOfRange(byArray, n, n + n2), 0);
    }

    public static void fillNull(byte[] byArray, int n, int n2) {
        Arrays.fill(byArray, n, n2, (byte)0);
    }

    public static void inflate(byte[] byArray, int n, char[] cArray, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            cArray[n2++] = (char)(byArray[n++] & 0xFF);
        }
    }

    public static void inflate(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        StringUTF16.inflate(byArray, n, byArray2, n2, n3);
    }

    static class CharsSpliterator
    implements Spliterator.OfInt {
        private final byte[] array;
        private int index;
        private final int fence;
        private final int cs;

        CharsSpliterator(byte[] byArray, int n) {
            this(byArray, 0, byArray.length, n);
        }

        CharsSpliterator(byte[] byArray, int n, int n2, int n3) {
            this.array = byArray;
            this.index = n;
            this.fence = n2;
            this.cs = n3 | 0x10 | 0x40 | 0x4000;
        }

        @Override
        public Spliterator.OfInt trySplit() {
            CharsSpliterator charsSpliterator;
            int n = this.index;
            int n2 = n + this.fence >>> 1;
            if (n >= n2) {
                charsSpliterator = null;
            } else {
                this.index = n2;
                CharsSpliterator charsSpliterator2 = new CharsSpliterator(this.array, n, this.index, this.cs);
                charsSpliterator = charsSpliterator2;
            }
            return charsSpliterator;
        }

        @Override
        public void forEachRemaining(IntConsumer intConsumer) {
            int n;
            if (intConsumer == null) {
                throw new NullPointerException();
            }
            byte[] byArray = this.array;
            int n2 = this.fence;
            if (this.array.length >= n2 && (n = this.index) >= 0 && n < (this.index = n2)) {
                do {
                    intConsumer.accept(byArray[n] & 0xFF);
                } while (++n < n2);
            }
        }

        @Override
        public boolean tryAdvance(IntConsumer intConsumer) {
            if (intConsumer == null) {
                throw new NullPointerException();
            }
            if (this.index >= 0 && this.index < this.fence) {
                intConsumer.accept(this.array[this.index++] & 0xFF);
                return true;
            }
            return false;
        }

        @Override
        public long estimateSize() {
            return this.fence - this.index;
        }

        @Override
        public int characteristics() {
            return this.cs;
        }
    }
}

