/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.UnsupportedEncodingException;
import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Arrays;
import sun.misc.MessageUtils;
import sun.nio.cs.ArrayDecoder;
import sun.nio.cs.ArrayEncoder;
import sun.nio.cs.HistoricallyNamedCharset;

class StringCoding {
    private static final ThreadLocal<SoftReference<StringDecoder>> decoder = new ThreadLocal();
    private static final ThreadLocal<SoftReference<StringEncoder>> encoder = new ThreadLocal();
    private static boolean warnUnsupportedCharset = true;
    private static final ThreadLocal<Result> resultCached = new ThreadLocal<Result>(){

        @Override
        protected Result initialValue() {
            return new Result();
        }
    };
    private static char repl = (char)65533;

    private StringCoding() {
    }

    private static <T> T deref(ThreadLocal<SoftReference<T>> threadLocal) {
        SoftReference<T> softReference = threadLocal.get();
        if (softReference == null) {
            return null;
        }
        return softReference.get();
    }

    private static <T> void set(ThreadLocal<SoftReference<T>> threadLocal, T t) {
        threadLocal.set(new SoftReference<T>(t));
    }

    private static byte[] safeTrim(byte[] byArray, int n, boolean bl) {
        if (n == byArray.length && (bl || System.getSecurityManager() == null)) {
            return byArray;
        }
        return Arrays.copyOf(byArray, n);
    }

    private static int scale(int n, float f) {
        return (int)((double)n * (double)f);
    }

    private static Charset lookupCharset(String string) {
        if (Charset.isSupported(string)) {
            try {
                return Charset.forName(string);
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                throw new Error(unsupportedCharsetException);
            }
        }
        return null;
    }

    public static boolean hasNegatives(byte[] byArray, int n, int n2) {
        for (int i = n; i < n + n2; ++i) {
            if (byArray[i] >= 0) continue;
            return true;
        }
        return false;
    }

    private static void warnUnsupportedCharset(String string) {
        if (warnUnsupportedCharset) {
            MessageUtils.err((String)("WARNING: Default charset " + string + " not supported, using ISO-8859-1 instead"));
            warnUnsupportedCharset = false;
        }
    }

    static Result decode(String string, byte[] byArray, int n, int n2) throws UnsupportedEncodingException {
        String string2;
        StringDecoder stringDecoder = (StringDecoder)StringCoding.deref(decoder);
        String string3 = string2 = string == null ? "ISO-8859-1" : string;
        if (stringDecoder == null || !string2.equals(stringDecoder.requestedCharsetName()) && !string2.equals(stringDecoder.charsetName())) {
            stringDecoder = null;
            try {
                Charset charset = StringCoding.lookupCharset(string2);
                if (charset != null) {
                    if (charset == StandardCharsets.UTF_8) {
                        return StringCoding.decodeUTF8(byArray, n, n2, true);
                    }
                    if (charset == StandardCharsets.ISO_8859_1) {
                        return StringCoding.decodeLatin1(byArray, n, n2);
                    }
                    if (charset == StandardCharsets.US_ASCII) {
                        return StringCoding.decodeASCII(byArray, n, n2);
                    }
                    stringDecoder = new StringDecoder(charset, string2);
                }
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {
                // empty catch block
            }
            if (stringDecoder == null) {
                throw new UnsupportedEncodingException(string2);
            }
            StringCoding.set(decoder, stringDecoder);
        }
        return stringDecoder.decode(byArray, n, n2);
    }

    static Result decode(Charset charset, byte[] byArray, int n, int n2) {
        if (charset == StandardCharsets.UTF_8) {
            return StringCoding.decodeUTF8(byArray, n, n2, true);
        }
        if (charset == StandardCharsets.ISO_8859_1) {
            return StringCoding.decodeLatin1(byArray, n, n2);
        }
        if (charset == StandardCharsets.US_ASCII) {
            return StringCoding.decodeASCII(byArray, n, n2);
        }
        CharsetDecoder charsetDecoder = charset.newDecoder();
        if (charsetDecoder instanceof ArrayDecoder && ((ArrayDecoder)((Object)charsetDecoder)).isASCIICompatible() && !StringCoding.hasNegatives(byArray, n, n2)) {
            return StringCoding.decodeLatin1(byArray, n, n2);
        }
        int n3 = StringCoding.scale(n2, charsetDecoder.maxCharsPerByte());
        if (n2 == 0) {
            return new Result().with();
        }
        charsetDecoder.onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).reset();
        char[] cArray = new char[n3];
        if (charsetDecoder instanceof ArrayDecoder) {
            int n4 = ((ArrayDecoder)((Object)charsetDecoder)).decode(byArray, n, n2, cArray);
            return new Result().with(cArray, 0, n4);
        }
        if (charset.getClass().getClassLoader0() != null && System.getSecurityManager() != null) {
            byArray = Arrays.copyOfRange(byArray, n, n + n2);
            n = 0;
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n, n2);
        CharBuffer charBuffer = CharBuffer.wrap(cArray);
        try {
            CoderResult coderResult = charsetDecoder.decode(byteBuffer, charBuffer, true);
            if (!coderResult.isUnderflow()) {
                coderResult.throwException();
            }
            if (!(coderResult = charsetDecoder.flush(charBuffer)).isUnderflow()) {
                coderResult.throwException();
            }
        }
        catch (CharacterCodingException characterCodingException) {
            throw new Error(characterCodingException);
        }
        return new Result().with(cArray, 0, charBuffer.position());
    }

    static Result decode(byte[] byArray, int n, int n2) {
        Charset charset = Charset.defaultCharset();
        if (charset == StandardCharsets.UTF_8) {
            return StringCoding.decodeUTF8(byArray, n, n2, true);
        }
        if (charset == StandardCharsets.ISO_8859_1) {
            return StringCoding.decodeLatin1(byArray, n, n2);
        }
        if (charset == StandardCharsets.US_ASCII) {
            return StringCoding.decodeASCII(byArray, n, n2);
        }
        StringDecoder stringDecoder = (StringDecoder)StringCoding.deref(decoder);
        if (stringDecoder == null || !charset.name().equals(stringDecoder.cs.name())) {
            stringDecoder = new StringDecoder(charset, charset.name());
            StringCoding.set(decoder, stringDecoder);
        }
        return stringDecoder.decode(byArray, n, n2);
    }

    static byte[] encode(String string, byte by, byte[] byArray) throws UnsupportedEncodingException {
        String string2;
        StringEncoder stringEncoder = (StringEncoder)StringCoding.deref(encoder);
        String string3 = string2 = string == null ? "ISO-8859-1" : string;
        if (stringEncoder == null || !string2.equals(stringEncoder.requestedCharsetName()) && !string2.equals(stringEncoder.charsetName())) {
            stringEncoder = null;
            try {
                Charset charset = StringCoding.lookupCharset(string2);
                if (charset != null) {
                    if (charset == StandardCharsets.UTF_8) {
                        return StringCoding.encodeUTF8(by, byArray, true);
                    }
                    if (charset == StandardCharsets.ISO_8859_1) {
                        return StringCoding.encode8859_1(by, byArray);
                    }
                    if (charset == StandardCharsets.US_ASCII) {
                        return StringCoding.encodeASCII(by, byArray);
                    }
                    stringEncoder = new StringEncoder(charset, string2);
                }
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {
                // empty catch block
            }
            if (stringEncoder == null) {
                throw new UnsupportedEncodingException(string2);
            }
            StringCoding.set(encoder, stringEncoder);
        }
        return stringEncoder.encode(by, byArray);
    }

    static byte[] encode(Charset charset, byte by, byte[] byArray) {
        int n;
        if (charset == StandardCharsets.UTF_8) {
            return StringCoding.encodeUTF8(by, byArray, true);
        }
        if (charset == StandardCharsets.ISO_8859_1) {
            return StringCoding.encode8859_1(by, byArray);
        }
        if (charset == StandardCharsets.US_ASCII) {
            return StringCoding.encodeASCII(by, byArray);
        }
        CharsetEncoder charsetEncoder = charset.newEncoder();
        if (by == 0 && charsetEncoder instanceof ArrayEncoder && ((ArrayEncoder)((Object)charsetEncoder)).isASCIICompatible() && !StringCoding.hasNegatives(byArray, 0, byArray.length)) {
            return Arrays.copyOf(byArray, byArray.length);
        }
        int n2 = byArray.length >> by;
        int n3 = StringCoding.scale(n2, charsetEncoder.maxBytesPerChar());
        byte[] byArray2 = new byte[n3];
        if (n2 == 0) {
            return byArray2;
        }
        charsetEncoder.onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).reset();
        if (charsetEncoder instanceof ArrayEncoder) {
            int n4 = n = by == 0 ? ((ArrayEncoder)((Object)charsetEncoder)).encodeFromLatin1(byArray, 0, n2, byArray2) : ((ArrayEncoder)((Object)charsetEncoder)).encodeFromUTF16(byArray, 0, n2, byArray2);
            if (n != -1) {
                return StringCoding.safeTrim(byArray2, n, true);
            }
        }
        n = charset.getClass().getClassLoader0() == null || System.getSecurityManager() == null ? 1 : 0;
        char[] cArray = by == 0 ? StringLatin1.toChars(byArray) : StringUTF16.toChars(byArray);
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray2);
        CharBuffer charBuffer = CharBuffer.wrap(cArray, 0, n2);
        try {
            CoderResult coderResult = charsetEncoder.encode(charBuffer, byteBuffer, true);
            if (!coderResult.isUnderflow()) {
                coderResult.throwException();
            }
            if (!(coderResult = charsetEncoder.flush(byteBuffer)).isUnderflow()) {
                coderResult.throwException();
            }
        }
        catch (CharacterCodingException characterCodingException) {
            throw new Error(characterCodingException);
        }
        return StringCoding.safeTrim(byArray2, byteBuffer.position(), n != 0);
    }

    static byte[] encode(byte by, byte[] byArray) {
        Charset charset = Charset.defaultCharset();
        if (charset == StandardCharsets.UTF_8) {
            return StringCoding.encodeUTF8(by, byArray, true);
        }
        if (charset == StandardCharsets.ISO_8859_1) {
            return StringCoding.encode8859_1(by, byArray);
        }
        if (charset == StandardCharsets.US_ASCII) {
            return StringCoding.encodeASCII(by, byArray);
        }
        StringEncoder stringEncoder = (StringEncoder)StringCoding.deref(encoder);
        if (stringEncoder == null || !charset.name().equals(stringEncoder.cs.name())) {
            stringEncoder = new StringEncoder(charset, charset.name());
            StringCoding.set(encoder, stringEncoder);
        }
        return stringEncoder.encode(by, byArray);
    }

    private static Result decodeASCII(byte[] byArray, int n, int n2) {
        Result result = resultCached.get();
        if (String.COMPACT_STRINGS && !StringCoding.hasNegatives(byArray, n, n2)) {
            return result.with(Arrays.copyOfRange(byArray, n, n + n2), (byte)0);
        }
        byte[] byArray2 = new byte[n2 << 1];
        int n3 = 0;
        while (n3 < n2) {
            byte by = byArray[n++];
            StringUTF16.putChar(byArray2, n3++, by >= 0 ? (char)by : repl);
        }
        return result.with(byArray2, (byte)1);
    }

    private static byte[] encodeASCII(byte by, byte[] byArray) {
        if (by == 0) {
            byte[] byArray2 = new byte[byArray.length];
            for (int i = 0; i < byArray.length; ++i) {
                byArray2[i] = byArray[i] < 0 ? 63 : byArray[i];
            }
            return byArray2;
        }
        int n = byArray.length >> 1;
        byte[] byArray3 = new byte[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            char c = StringUTF16.getChar(byArray, i);
            if (c < '\u0080') {
                byArray3[n2++] = (byte)c;
                continue;
            }
            if (Character.isHighSurrogate(c) && i + 1 < n && Character.isLowSurrogate(StringUTF16.getChar(byArray, i + 1))) {
                ++i;
            }
            byArray3[n2++] = 63;
        }
        if (n == n2) {
            return byArray3;
        }
        return Arrays.copyOf(byArray3, n2);
    }

    private static Result decodeLatin1(byte[] byArray, int n, int n2) {
        Result result = resultCached.get();
        if (String.COMPACT_STRINGS) {
            return result.with(Arrays.copyOfRange(byArray, n, n + n2), (byte)0);
        }
        return result.with(StringLatin1.inflate(byArray, n, n2), (byte)1);
    }

    private static int implEncodeISOArray(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        char c;
        int n4;
        for (n4 = 0; n4 < n3 && (c = StringUTF16.getChar(byArray, n++)) <= '\u00ff'; ++n4) {
            byArray2[n2++] = (byte)c;
        }
        return n4;
    }

    private static byte[] encode8859_1(byte by, byte[] byArray) {
        if (by == 0) {
            return Arrays.copyOf(byArray, byArray.length);
        }
        int n = byArray.length >> 1;
        byte[] byArray2 = new byte[n];
        int n2 = 0;
        int n3 = 0;
        int n4 = n;
        while (n3 < n4) {
            char c;
            int n5 = StringCoding.implEncodeISOArray(byArray, n3, byArray2, n2, n);
            n3 += n5;
            n2 += n5;
            if (n5 == n) continue;
            if (Character.isHighSurrogate(c = StringUTF16.getChar(byArray, n3++)) && n3 < n4 && Character.isLowSurrogate(StringUTF16.getChar(byArray, n3))) {
                ++n3;
            }
            byArray2[n2++] = 63;
            n = n4 - n3;
        }
        if (n2 == byArray2.length) {
            return byArray2;
        }
        return Arrays.copyOf(byArray2, n2);
    }

    private static boolean isNotContinuation(int n) {
        return (n & 0xC0) != 128;
    }

    private static boolean isMalformed3(int n, int n2, int n3) {
        return n == -32 && (n2 & 0xE0) == 128 || (n2 & 0xC0) != 128 || (n3 & 0xC0) != 128;
    }

    private static boolean isMalformed3_2(int n, int n2) {
        return n == -32 && (n2 & 0xE0) == 128 || (n2 & 0xC0) != 128;
    }

    private static boolean isMalformed4(int n, int n2, int n3) {
        return (n & 0xC0) != 128 || (n2 & 0xC0) != 128 || (n3 & 0xC0) != 128;
    }

    private static boolean isMalformed4_2(int n, int n2) {
        return n == 240 && (n2 < 144 || n2 > 191) || n == 244 && (n2 & 0xF0) != 128 || (n2 & 0xC0) != 128;
    }

    private static boolean isMalformed4_3(int n) {
        return (n & 0xC0) != 128;
    }

    private static int malformedN(byte[] byArray, int n, int n2) {
        if (n2 == 3) {
            byte by = byArray[n++];
            byte by2 = byArray[n++];
            return by == -32 && (by2 & 0xE0) == 128 || StringCoding.isNotContinuation(by2) ? 1 : 2;
        }
        if (n2 == 4) {
            int n3 = byArray[n++] & 0xFF;
            int n4 = byArray[n++] & 0xFF;
            if (n3 > 244 || n3 == 240 && (n4 < 144 || n4 > 191) || n3 == 244 && (n4 & 0xF0) != 128 || StringCoding.isNotContinuation(n4)) {
                return 1;
            }
            if (StringCoding.isNotContinuation(byArray[n++])) {
                return 2;
            }
            return 3;
        }
        assert (false);
        return -1;
    }

    private static void throwMalformed(int n, int n2) {
        throw new IllegalArgumentException("malformed input off : " + n + ", length : " + n2);
    }

    private static Result decodeUTF8(byte[] byArray, int n, int n2, boolean bl) {
        if (String.COMPACT_STRINGS && !StringCoding.hasNegatives(byArray, n, n2)) {
            return resultCached.get().with(Arrays.copyOfRange(byArray, n, n + n2), (byte)0);
        }
        return StringCoding.decodeUTF8_0(byArray, n, n2, bl);
    }

    private static Result decodeUTF8_0(byte[] byArray, int n, int n2, boolean bl) {
        byte by;
        int n3;
        Result result = resultCached.get();
        int n4 = n + n2;
        int n5 = 0;
        byte[] byArray2 = new byte[n2];
        if (String.COMPACT_STRINGS) {
            while (n < n4) {
                n3 = byArray[n];
                if (n3 >= 0) {
                    byArray2[n5++] = (byte)n3;
                    ++n;
                    continue;
                }
                if (n3 != -62 && n3 != -61 || n + 1 >= n4 || StringCoding.isNotContinuation(by = byArray[n + 1])) break;
                byArray2[n5++] = (byte)(n3 << 6 ^ by ^ 0xF80);
                n += 2;
            }
            if (n == n4) {
                if (n5 != byArray2.length) {
                    byArray2 = Arrays.copyOf(byArray2, n5);
                }
                return result.with(byArray2, (byte)0);
            }
        }
        if (n5 == 0) {
            byArray2 = new byte[n2 << 1];
        } else {
            byte[] byArray3 = new byte[n2 << 1];
            StringLatin1.inflate(byArray2, 0, byArray3, 0, n5);
            byArray2 = byArray3;
        }
        while (n < n4) {
            char c;
            byte by2;
            if ((n3 = byArray[n++]) >= 0) {
                StringUTF16.putChar(byArray2, n5++, (char)n3);
                continue;
            }
            if (n3 >> 5 == -2 && (n3 & 0x1E) != 0) {
                if (n < n4) {
                    if (StringCoding.isNotContinuation(by = byArray[n++])) {
                        if (!bl) {
                            StringCoding.throwMalformed(n - 1, 1);
                        }
                        StringUTF16.putChar(byArray2, n5++, repl);
                        --n;
                        continue;
                    }
                    StringUTF16.putChar(byArray2, n5++, (char)(n3 << 6 ^ by ^ 0xF80));
                    continue;
                }
                if (!bl) {
                    StringCoding.throwMalformed(n, 1);
                }
                StringUTF16.putChar(byArray2, n5++, repl);
                break;
            }
            if (n3 >> 4 == -2) {
                if (n + 1 < n4) {
                    if (StringCoding.isMalformed3(n3, by = byArray[n++], by2 = byArray[n++])) {
                        if (!bl) {
                            StringCoding.throwMalformed(n - 3, 3);
                        }
                        StringUTF16.putChar(byArray2, n5++, repl);
                        n -= 3;
                        n += StringCoding.malformedN(byArray, n, 3);
                        continue;
                    }
                    c = (char)(n3 << 12 ^ by << 6 ^ (by2 ^ 0xFFFE1F80));
                    if (Character.isSurrogate(c)) {
                        if (!bl) {
                            StringCoding.throwMalformed(n - 3, 3);
                        }
                        StringUTF16.putChar(byArray2, n5++, repl);
                        continue;
                    }
                    StringUTF16.putChar(byArray2, n5++, c);
                    continue;
                }
                if (n < n4 && StringCoding.isMalformed3_2(n3, byArray[n])) {
                    if (!bl) {
                        StringCoding.throwMalformed(n - 1, 2);
                    }
                    StringUTF16.putChar(byArray2, n5++, repl);
                    continue;
                }
                if (!bl) {
                    StringCoding.throwMalformed(n, 1);
                }
                StringUTF16.putChar(byArray2, n5++, repl);
                break;
            }
            if (n3 >> 3 == -2) {
                if (n + 2 < n4) {
                    by = byArray[n++];
                    by2 = byArray[n++];
                    c = byArray[n++];
                    int n6 = n3 << 18 ^ by << 12 ^ by2 << 6 ^ (c ^ 0x381F80);
                    if (StringCoding.isMalformed4(by, by2, c) || !Character.isSupplementaryCodePoint(n6)) {
                        if (!bl) {
                            StringCoding.throwMalformed(n - 4, 4);
                        }
                        StringUTF16.putChar(byArray2, n5++, repl);
                        n -= 4;
                        n += StringCoding.malformedN(byArray, n, 4);
                        continue;
                    }
                    StringUTF16.putChar(byArray2, n5++, Character.highSurrogate(n6));
                    StringUTF16.putChar(byArray2, n5++, Character.lowSurrogate(n6));
                    continue;
                }
                if ((n3 &= 0xFF) > 244 || n < n4 && StringCoding.isMalformed4_2(n3, byArray[n] & 0xFF)) {
                    if (!bl) {
                        StringCoding.throwMalformed(n - 1, 1);
                    }
                    StringUTF16.putChar(byArray2, n5++, repl);
                    continue;
                }
                if (!bl) {
                    StringCoding.throwMalformed(n - 1, 1);
                }
                StringUTF16.putChar(byArray2, n5++, repl);
                if (++n >= n4 || !StringCoding.isMalformed4_3(byArray[n])) break;
                continue;
            }
            if (!bl) {
                StringCoding.throwMalformed(n - 1, 1);
            }
            StringUTF16.putChar(byArray2, n5++, repl);
        }
        if (n5 != n2) {
            byArray2 = Arrays.copyOf(byArray2, n5 << 1);
        }
        return result.with(byArray2, (byte)1);
    }

    private static byte[] encodeUTF8(byte by, byte[] byArray, boolean bl) {
        if (by == 1) {
            return StringCoding.encodeUTF8_UTF16(byArray, bl);
        }
        if (!StringCoding.hasNegatives(byArray, 0, byArray.length)) {
            return Arrays.copyOf(byArray, byArray.length);
        }
        int n = 0;
        byte[] byArray2 = new byte[byArray.length << 1];
        for (int i = 0; i < byArray.length; ++i) {
            byte by2 = byArray[i];
            if (by2 < 0) {
                byArray2[n++] = (byte)(0xC0 | (by2 & 0xFF) >> 6);
                byArray2[n++] = (byte)(0x80 | by2 & 0x3F);
                continue;
            }
            byArray2[n++] = by2;
        }
        if (n == byArray2.length) {
            return byArray2;
        }
        return Arrays.copyOf(byArray2, n);
    }

    private static byte[] encodeUTF8_UTF16(byte[] byArray, boolean bl) {
        char c;
        int n;
        int n2 = 0;
        int n3 = byArray.length >> 1;
        byte[] byArray2 = new byte[n3 * 3];
        for (n = 0; n < n3 && (c = StringUTF16.getChar(byArray, n)) < '\u0080'; ++n) {
            byArray2[n2++] = (byte)c;
        }
        while (n < n3) {
            if ((c = StringUTF16.getChar(byArray, n++)) < '\u0080') {
                byArray2[n2++] = (byte)c;
                continue;
            }
            if (c < '\u0800') {
                byArray2[n2++] = (byte)(0xC0 | c >> 6);
                byArray2[n2++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            if (Character.isSurrogate(c)) {
                char c2;
                int n4 = -1;
                if (Character.isHighSurrogate(c) && n < n3 && Character.isLowSurrogate(c2 = StringUTF16.getChar(byArray, n))) {
                    n4 = Character.toCodePoint(c, c2);
                }
                if (n4 < 0) {
                    if (bl) {
                        byArray2[n2++] = 63;
                        continue;
                    }
                    StringCoding.throwMalformed(n - 1, 1);
                    continue;
                }
                byArray2[n2++] = (byte)(0xF0 | n4 >> 18);
                byArray2[n2++] = (byte)(0x80 | n4 >> 12 & 0x3F);
                byArray2[n2++] = (byte)(0x80 | n4 >> 6 & 0x3F);
                byArray2[n2++] = (byte)(0x80 | n4 & 0x3F);
                ++n;
                continue;
            }
            byArray2[n2++] = (byte)(0xE0 | c >> 12);
            byArray2[n2++] = (byte)(0x80 | c >> 6 & 0x3F);
            byArray2[n2++] = (byte)(0x80 | c & 0x3F);
        }
        if (n2 == byArray2.length) {
            return byArray2;
        }
        return Arrays.copyOf(byArray2, n2);
    }

    static String newStringUTF8NoRepl(byte[] byArray, int n, int n2) {
        if (String.COMPACT_STRINGS && !StringCoding.hasNegatives(byArray, n, n2)) {
            return new String(Arrays.copyOfRange(byArray, n, n + n2), 0);
        }
        Result result = StringCoding.decodeUTF8_0(byArray, n, n2, false);
        return new String(result.value, result.coder);
    }

    static byte[] getBytesUTF8NoRepl(String string) {
        return StringCoding.encodeUTF8(string.coder(), string.value(), false);
    }

    private static class StringEncoder {
        private Charset cs;
        private CharsetEncoder ce;
        private final boolean isASCIICompatible;
        private final String requestedCharsetName;
        private final boolean isTrusted;

        private StringEncoder(Charset charset, String string) {
            this.requestedCharsetName = string;
            this.cs = charset;
            this.ce = charset.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
            this.isTrusted = charset.getClass().getClassLoader0() == null;
            this.isASCIICompatible = this.ce instanceof ArrayEncoder && ((ArrayEncoder)((Object)this.ce)).isASCIICompatible();
        }

        String charsetName() {
            if (this.cs instanceof HistoricallyNamedCharset) {
                return ((HistoricallyNamedCharset)((Object)this.cs)).historicalName();
            }
            return this.cs.name();
        }

        final String requestedCharsetName() {
            return this.requestedCharsetName;
        }

        byte[] encode(byte by, byte[] byArray) {
            if (by == 0 && this.isASCIICompatible && !StringCoding.hasNegatives(byArray, 0, byArray.length)) {
                return Arrays.copyOf(byArray, byArray.length);
            }
            int n = byArray.length >> by;
            int n2 = StringCoding.scale(n, this.ce.maxBytesPerChar());
            byte[] byArray2 = new byte[n2];
            if (n == 0) {
                return byArray2;
            }
            if (this.ce instanceof ArrayEncoder) {
                int n3;
                int n4 = n3 = by == 0 ? ((ArrayEncoder)((Object)this.ce)).encodeFromLatin1(byArray, 0, n, byArray2) : ((ArrayEncoder)((Object)this.ce)).encodeFromUTF16(byArray, 0, n, byArray2);
                if (n3 != -1) {
                    return StringCoding.safeTrim(byArray2, n3, this.isTrusted);
                }
            }
            char[] cArray = by == 0 ? StringLatin1.toChars(byArray) : StringUTF16.toChars(byArray);
            this.ce.reset();
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray2);
            CharBuffer charBuffer = CharBuffer.wrap(cArray, 0, n);
            try {
                CoderResult coderResult = this.ce.encode(charBuffer, byteBuffer, true);
                if (!coderResult.isUnderflow()) {
                    coderResult.throwException();
                }
                if (!(coderResult = this.ce.flush(byteBuffer)).isUnderflow()) {
                    coderResult.throwException();
                }
            }
            catch (CharacterCodingException characterCodingException) {
                throw new Error(characterCodingException);
            }
            return StringCoding.safeTrim(byArray2, byteBuffer.position(), this.isTrusted);
        }
    }

    private static class StringDecoder {
        private final String requestedCharsetName;
        private final Charset cs;
        private final boolean isASCIICompatible;
        private final CharsetDecoder cd;
        protected final Result result;

        private StringDecoder(Charset charset, String string) {
            this.requestedCharsetName = string;
            this.cs = charset;
            this.cd = charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
            this.result = new Result();
            this.isASCIICompatible = this.cd instanceof ArrayDecoder && ((ArrayDecoder)((Object)this.cd)).isASCIICompatible();
        }

        String charsetName() {
            if (this.cs instanceof HistoricallyNamedCharset) {
                return ((HistoricallyNamedCharset)((Object)this.cs)).historicalName();
            }
            return this.cs.name();
        }

        final String requestedCharsetName() {
            return this.requestedCharsetName;
        }

        Result decode(byte[] byArray, int n, int n2) {
            if (n2 == 0) {
                return this.result.with();
            }
            if (this.isASCIICompatible && !StringCoding.hasNegatives(byArray, n, n2)) {
                if (String.COMPACT_STRINGS) {
                    return this.result.with(Arrays.copyOfRange(byArray, n, n + n2), (byte)0);
                }
                return this.result.with(StringLatin1.inflate(byArray, n, n2), (byte)1);
            }
            int n3 = StringCoding.scale(n2, this.cd.maxCharsPerByte());
            char[] cArray = new char[n3];
            if (this.cd instanceof ArrayDecoder) {
                int n4 = ((ArrayDecoder)((Object)this.cd)).decode(byArray, n, n2, cArray);
                return this.result.with(cArray, 0, n4);
            }
            this.cd.reset();
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n, n2);
            CharBuffer charBuffer = CharBuffer.wrap(cArray);
            try {
                CoderResult coderResult = this.cd.decode(byteBuffer, charBuffer, true);
                if (!coderResult.isUnderflow()) {
                    coderResult.throwException();
                }
                if (!(coderResult = this.cd.flush(charBuffer)).isUnderflow()) {
                    coderResult.throwException();
                }
            }
            catch (CharacterCodingException characterCodingException) {
                throw new Error(characterCodingException);
            }
            return this.result.with(cArray, 0, charBuffer.position());
        }
    }

    static class Result {
        byte[] value;
        byte coder;

        Result() {
        }

        Result with() {
            this.coder = String.COMPACT_STRINGS ? (byte)0 : 1;
            this.value = new byte[0];
            return this;
        }

        Result with(char[] cArray, int n, int n2) {
            byte[] byArray;
            if (String.COMPACT_STRINGS && (byArray = StringUTF16.compress(cArray, n, n2)) != null) {
                this.value = byArray;
                this.coder = 0;
                return this;
            }
            this.coder = 1;
            this.value = StringUTF16.toBytes(cArray, n, n2);
            return this;
        }

        Result with(byte[] byArray, byte by) {
            this.coder = by;
            this.value = byArray;
            return this;
        }
    }
}

