/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.ObjectStreamField;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Formatter;
import java.util.Locale;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.regex.Pattern;
import jdk.internal.vm.annotation.Stable;

public final class String
implements Serializable,
Comparable<String>,
CharSequence {
    @Stable
    private final byte[] value;
    private final byte coder;
    @Stable
    private int hash;
    private static final long serialVersionUID = -6849794470754667710L;
    static final boolean COMPACT_STRINGS = true;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[0];
    public static final Comparator<String> CASE_INSENSITIVE_ORDER = new CaseInsensitiveComparator();
    static final byte LATIN1 = 0;
    static final byte UTF16 = 1;

    public String() {
        this.value = "".value;
        this.coder = "".coder;
    }

    public String(String string) {
        this.value = string.value;
        this.coder = string.coder;
        this.hash = string.hash;
    }

    public String(char[] cArray) {
        this(cArray, 0, cArray.length, null);
    }

    public String(char[] cArray, int n, int n2) {
        this(cArray, n, n2, String.rangeCheck(cArray, n, n2));
    }

    private static Void rangeCheck(char[] cArray, int n, int n2) {
        String.checkBoundsOffCount(n, n2, cArray.length);
        return null;
    }

    public String(int[] nArray, int n, int n2) {
        byte[] byArray;
        String.checkBoundsOffCount(n, n2, nArray.length);
        if (n2 == 0) {
            this.value = "".value;
            this.coder = "".coder;
            return;
        }
        if (COMPACT_STRINGS && (byArray = StringLatin1.toBytes(nArray, n, n2)) != null) {
            this.coder = 0;
            this.value = byArray;
            return;
        }
        this.coder = 1;
        this.value = StringUTF16.toBytes(nArray, n, n2);
    }

    @Deprecated
    public String(byte[] byArray, int n, int n2, int n3) {
        String.checkBoundsOffCount(n2, n3, byArray.length);
        if (n3 == 0) {
            this.value = "".value;
            this.coder = "".coder;
            return;
        }
        if (COMPACT_STRINGS && (byte)n == 0) {
            this.value = Arrays.copyOfRange(byArray, n2, n2 + n3);
            this.coder = 0;
        } else {
            n <<= 8;
            byte[] byArray2 = StringUTF16.newBytesFor(n3);
            for (int i = 0; i < n3; ++i) {
                StringUTF16.putChar(byArray2, i, n | byArray[n2++] & 0xFF);
            }
            this.value = byArray2;
            this.coder = 1;
        }
    }

    @Deprecated
    public String(byte[] byArray, int n) {
        this(byArray, n, 0, byArray.length);
    }

    public String(byte[] byArray, int n, int n2, String string) throws UnsupportedEncodingException {
        if (string == null) {
            throw new NullPointerException("charsetName");
        }
        String.checkBoundsOffCount(n, n2, byArray.length);
        StringCoding.Result result = StringCoding.decode(string, byArray, n, n2);
        this.value = result.value;
        this.coder = result.coder;
    }

    public String(byte[] byArray, int n, int n2, Charset charset) {
        if (charset == null) {
            throw new NullPointerException("charset");
        }
        String.checkBoundsOffCount(n, n2, byArray.length);
        StringCoding.Result result = StringCoding.decode(charset, byArray, n, n2);
        this.value = result.value;
        this.coder = result.coder;
    }

    public String(byte[] byArray, String string) throws UnsupportedEncodingException {
        this(byArray, 0, byArray.length, string);
    }

    public String(byte[] byArray, Charset charset) {
        this(byArray, 0, byArray.length, charset);
    }

    public String(byte[] byArray, int n, int n2) {
        String.checkBoundsOffCount(n, n2, byArray.length);
        StringCoding.Result result = StringCoding.decode(byArray, n, n2);
        this.value = result.value;
        this.coder = result.coder;
    }

    public String(byte[] byArray) {
        this(byArray, 0, byArray.length);
    }

    public String(StringBuffer stringBuffer) {
        this(stringBuffer.toString());
    }

    public String(StringBuilder stringBuilder) {
        this(stringBuilder, null);
    }

    @Override
    public int length() {
        return this.value.length >> this.coder();
    }

    @Override
    public boolean isEmpty() {
        return this.value.length == 0;
    }

    @Override
    public char charAt(int n) {
        if (this.isLatin1()) {
            return StringLatin1.charAt(this.value, n);
        }
        return StringUTF16.charAt(this.value, n);
    }

    public int codePointAt(int n) {
        if (this.isLatin1()) {
            String.checkIndex(n, this.value.length);
            return this.value[n] & 0xFF;
        }
        int n2 = this.value.length >> 1;
        String.checkIndex(n, n2);
        return StringUTF16.codePointAt(this.value, n, n2);
    }

    public int codePointBefore(int n) {
        int n2 = n - 1;
        if (n2 < 0 || n2 >= this.length()) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (this.isLatin1()) {
            return this.value[n2] & 0xFF;
        }
        return StringUTF16.codePointBefore(this.value, n);
    }

    public int codePointCount(int n, int n2) {
        if (n < 0 || n > n2 || n2 > this.length()) {
            throw new IndexOutOfBoundsException();
        }
        if (this.isLatin1()) {
            return n2 - n;
        }
        return StringUTF16.codePointCount(this.value, n, n2);
    }

    public int offsetByCodePoints(int n, int n2) {
        if (n < 0 || n > this.length()) {
            throw new IndexOutOfBoundsException();
        }
        return Character.offsetByCodePoints(this, n, n2);
    }

    public void getChars(int n, int n2, char[] cArray, int n3) {
        String.checkBoundsBeginEnd(n, n2, this.length());
        String.checkBoundsOffCount(n3, n2 - n, cArray.length);
        if (this.isLatin1()) {
            StringLatin1.getChars(this.value, n, n2, cArray, n3);
        } else {
            StringUTF16.getChars(this.value, n, n2, cArray, n3);
        }
    }

    @Deprecated
    public void getBytes(int n, int n2, byte[] byArray, int n3) {
        String.checkBoundsBeginEnd(n, n2, this.length());
        Objects.requireNonNull(byArray);
        String.checkBoundsOffCount(n3, n2 - n, byArray.length);
        if (this.isLatin1()) {
            StringLatin1.getBytes(this.value, n, n2, byArray, n3);
        } else {
            StringUTF16.getBytes(this.value, n, n2, byArray, n3);
        }
    }

    public byte[] getBytes(String string) throws UnsupportedEncodingException {
        if (string == null) {
            throw new NullPointerException();
        }
        return StringCoding.encode(string, this.coder(), this.value);
    }

    public byte[] getBytes(Charset charset) {
        if (charset == null) {
            throw new NullPointerException();
        }
        return StringCoding.encode(charset, this.coder(), this.value);
    }

    public byte[] getBytes() {
        return StringCoding.encode(this.coder(), this.value);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof String) {
            String string = (String)object;
            if (this.coder() == string.coder()) {
                return this.isLatin1() ? StringLatin1.equals(this.value, string.value) : StringUTF16.equals(this.value, string.value);
            }
        }
        return false;
    }

    public boolean contentEquals(StringBuffer stringBuffer) {
        return this.contentEquals((CharSequence)stringBuffer);
    }

    private boolean nonSyncContentEquals(AbstractStringBuilder abstractStringBuilder) {
        int n = this.length();
        if (n != abstractStringBuilder.length()) {
            return false;
        }
        byte[] byArray = this.value;
        byte[] byArray2 = abstractStringBuilder.getValue();
        if (this.coder() == abstractStringBuilder.getCoder()) {
            int n2 = byArray.length;
            for (int i = 0; i < n2; ++i) {
                if (byArray[i] == byArray2[i]) continue;
                return false;
            }
        } else {
            if (!this.isLatin1()) {
                return false;
            }
            return StringUTF16.contentEquals(byArray, byArray2, n);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contentEquals(CharSequence charSequence) {
        if (charSequence instanceof AbstractStringBuilder) {
            if (charSequence instanceof StringBuffer) {
                CharSequence charSequence2 = charSequence;
                synchronized (charSequence2) {
                    return this.nonSyncContentEquals((AbstractStringBuilder)charSequence);
                }
            }
            return this.nonSyncContentEquals((AbstractStringBuilder)charSequence);
        }
        if (charSequence instanceof String) {
            return this.equals(charSequence);
        }
        int n = charSequence.length();
        if (n != this.length()) {
            return false;
        }
        byte[] byArray = this.value;
        if (this.isLatin1()) {
            for (int i = 0; i < n; ++i) {
                if ((byArray[i] & 0xFF) == charSequence.charAt(i)) continue;
                return false;
            }
        } else if (!StringUTF16.contentEquals(byArray, charSequence, n)) {
            return false;
        }
        return true;
    }

    public boolean equalsIgnoreCase(String string) {
        return this == string ? true : string != null && string.length() == this.length() && this.regionMatches(true, 0, string, 0, this.length());
    }

    @Override
    public int compareTo(String string) {
        byte[] byArray = this.value;
        byte[] byArray2 = string.value;
        if (this.coder() == string.coder()) {
            return this.isLatin1() ? StringLatin1.compareTo(byArray, byArray2) : StringUTF16.compareTo(byArray, byArray2);
        }
        return this.isLatin1() ? StringLatin1.compareToUTF16(byArray, byArray2) : StringUTF16.compareToLatin1(byArray, byArray2);
    }

    public int compareToIgnoreCase(String string) {
        return CASE_INSENSITIVE_ORDER.compare(this, string);
    }

    public boolean regionMatches(int n, String string, int n2, int n3) {
        byte[] byArray = this.value;
        byte[] byArray2 = string.value;
        if (n2 < 0 || n < 0 || (long)n > (long)this.length() - (long)n3 || (long)n2 > (long)string.length() - (long)n3) {
            return false;
        }
        if (this.coder() == string.coder()) {
            if (!this.isLatin1() && n3 > 0) {
                n <<= 1;
                n2 <<= 1;
                n3 <<= 1;
            }
            while (n3-- > 0) {
                if (byArray[n++] == byArray2[n2++]) continue;
                return false;
            }
        } else if (this.coder() == 0) {
            while (n3-- > 0) {
                if (StringLatin1.getChar(byArray, n++) == StringUTF16.getChar(byArray2, n2++)) continue;
                return false;
            }
        } else {
            while (n3-- > 0) {
                if (StringUTF16.getChar(byArray, n++) == StringLatin1.getChar(byArray2, n2++)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean regionMatches(boolean bl, int n, String string, int n2, int n3) {
        if (!bl) {
            return this.regionMatches(n, string, n2, n3);
        }
        if (n2 < 0 || n < 0 || (long)n > (long)this.length() - (long)n3 || (long)n2 > (long)string.length() - (long)n3) {
            return false;
        }
        byte[] byArray = this.value;
        byte[] byArray2 = string.value;
        if (this.coder() == string.coder()) {
            return this.isLatin1() ? StringLatin1.regionMatchesCI(byArray, n, byArray2, n2, n3) : StringUTF16.regionMatchesCI(byArray, n, byArray2, n2, n3);
        }
        return this.isLatin1() ? StringLatin1.regionMatchesCI_UTF16(byArray, n, byArray2, n2, n3) : StringUTF16.regionMatchesCI_Latin1(byArray, n, byArray2, n2, n3);
    }

    public boolean startsWith(String string, int n) {
        if (n < 0 || n > this.length() - string.length()) {
            return false;
        }
        byte[] byArray = this.value;
        byte[] byArray2 = string.value;
        int n2 = 0;
        int n3 = byArray2.length;
        if (this.coder() == string.coder()) {
            int n4;
            int n5 = n4 = this.isLatin1() ? n : n << 1;
            while (n2 < n3) {
                if (byArray[n4++] == byArray2[n2++]) continue;
                return false;
            }
        } else {
            if (this.isLatin1()) {
                return false;
            }
            while (n2 < n3) {
                if (StringUTF16.getChar(byArray, n++) == (byArray2[n2++] & 0xFF)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean startsWith(String string) {
        return this.startsWith(string, 0);
    }

    public boolean endsWith(String string) {
        return this.startsWith(string, this.length() - string.length());
    }

    public int hashCode() {
        int n = this.hash;
        if (n == 0 && this.value.length > 0) {
            n = this.isLatin1() ? StringLatin1.hashCode(this.value) : StringUTF16.hashCode(this.value);
            this.hash = n;
        }
        return n;
    }

    private static int stringHashCode(char[] cArray, int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 = 31 * n2 + cArray[i];
        }
        return n2;
    }

    public int indexOf(int n) {
        return this.indexOf(n, 0);
    }

    public int indexOf(int n, int n2) {
        return this.isLatin1() ? StringLatin1.indexOf(this.value, n, n2) : StringUTF16.indexOf(this.value, n, n2);
    }

    public int lastIndexOf(int n) {
        return this.lastIndexOf(n, this.length() - 1);
    }

    public int lastIndexOf(int n, int n2) {
        return this.isLatin1() ? StringLatin1.lastIndexOf(this.value, n, n2) : StringUTF16.lastIndexOf(this.value, n, n2);
    }

    public int indexOf(String string) {
        if (this.coder() == string.coder()) {
            return this.isLatin1() ? StringLatin1.indexOf(this.value, string.value) : StringUTF16.indexOf(this.value, string.value);
        }
        if (this.coder() == 0) {
            return -1;
        }
        return StringUTF16.indexOfLatin1(this.value, string.value);
    }

    public int indexOf(String string, int n) {
        return String.indexOf(this.value, this.coder(), this.length(), string, n);
    }

    static int indexOf(byte[] byArray, byte by, int n, String string, int n2) {
        byte[] byArray2 = string.value;
        byte by2 = string.coder();
        int n3 = string.length();
        if (n2 >= n) {
            return n3 == 0 ? n : -1;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 == 0) {
            return n2;
        }
        if (n3 > n) {
            return -1;
        }
        if (by == by2) {
            return by == 0 ? StringLatin1.indexOf(byArray, n, byArray2, n3, n2) : StringUTF16.indexOf(byArray, n, byArray2, n3, n2);
        }
        if (by == 0) {
            return -1;
        }
        return StringUTF16.indexOfLatin1(byArray, n, byArray2, n3, n2);
    }

    public int lastIndexOf(String string) {
        return this.lastIndexOf(string, this.length());
    }

    public int lastIndexOf(String string, int n) {
        return String.lastIndexOf(this.value, this.coder(), this.length(), string, n);
    }

    static int lastIndexOf(byte[] byArray, byte by, int n, String string, int n2) {
        byte[] byArray2 = string.value;
        byte by2 = string.coder();
        int n3 = string.length();
        int n4 = n - n3;
        if (n2 > n4) {
            n2 = n4;
        }
        if (n2 < 0) {
            return -1;
        }
        if (n3 == 0) {
            return n2;
        }
        if (by == by2) {
            return by == 0 ? StringLatin1.lastIndexOf(byArray, n, byArray2, n3, n2) : StringUTF16.lastIndexOf(byArray, n, byArray2, n3, n2);
        }
        if (by == 0) {
            return -1;
        }
        return StringUTF16.lastIndexOfLatin1(byArray, n, byArray2, n3, n2);
    }

    public String substring(int n) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        int n2 = this.length() - n;
        if (n2 < 0) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n == 0) {
            return this;
        }
        return this.isLatin1() ? StringLatin1.newString(this.value, n, n2) : StringUTF16.newString(this.value, n, n2);
    }

    public String substring(int n, int n2) {
        int n3 = this.length();
        String.checkBoundsBeginEnd(n, n2, n3);
        int n4 = n2 - n;
        if (n == 0 && n2 == n3) {
            return this;
        }
        return this.isLatin1() ? StringLatin1.newString(this.value, n, n4) : StringUTF16.newString(this.value, n, n4);
    }

    @Override
    public CharSequence subSequence(int n, int n2) {
        return this.substring(n, n2);
    }

    public String concat(String string) {
        int n = string.length();
        if (n == 0) {
            return this;
        }
        if (this.coder() == string.coder()) {
            byte[] byArray = this.value;
            byte[] byArray2 = string.value;
            int n2 = byArray.length + byArray2.length;
            byte[] byArray3 = Arrays.copyOf(byArray, n2);
            System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
            return new String(byArray3, this.coder);
        }
        int n3 = this.length();
        byte[] byArray = StringUTF16.newBytesFor(n3 + n);
        this.getBytes(byArray, 0, (byte)1);
        string.getBytes(byArray, n3, (byte)1);
        return new String(byArray, 1);
    }

    public String replace(char c, char c2) {
        if (c != c2) {
            String string;
            String string2 = string = this.isLatin1() ? StringLatin1.replace(this.value, c, c2) : StringUTF16.replace(this.value, c, c2);
            if (string != null) {
                return string;
            }
        }
        return this;
    }

    public boolean matches(String string) {
        return Pattern.matches(string, this);
    }

    public boolean contains(CharSequence charSequence) {
        return this.indexOf(charSequence.toString()) >= 0;
    }

    public String replaceFirst(String string, String string2) {
        return Pattern.compile(string).matcher(this).replaceFirst(string2);
    }

    public String replaceAll(String string, String string2) {
        return Pattern.compile(string).matcher(this).replaceAll(string2);
    }

    public String replace(CharSequence charSequence, CharSequence charSequence2) {
        String string = charSequence.toString();
        String string2 = charSequence2.toString();
        int n = this.indexOf(string);
        if (n < 0) {
            return this;
        }
        int n2 = string.length();
        int n3 = Math.max(n2, 1);
        int n4 = this.length();
        int n5 = n4 - n2 + string2.length();
        if (n5 < 0) {
            throw new OutOfMemoryError();
        }
        StringBuilder stringBuilder = new StringBuilder(n5);
        int n6 = 0;
        do {
            stringBuilder.append(this, n6, n).append(string2);
            n6 = n + n2;
        } while (n < n4 && (n = this.indexOf(string, n + n3)) > 0);
        return stringBuilder.append(this, n6, n4).toString();
    }

    public String[] split(String string, int n) {
        char c = '\u0000';
        if ((string.length() == 1 && ".$|()[{^?*+\\".indexOf(c = string.charAt(0)) == -1 || string.length() == 2 && string.charAt(0) == '\\' && ((c = string.charAt(1)) - 48 | 57 - c) < 0 && (c - 97 | 122 - c) < 0 && (c - 65 | 90 - c) < 0) && (c < '\ud800' || c > '\udfff')) {
            int n2;
            int n3 = 0;
            int n4 = 0;
            boolean bl = n > 0;
            ArrayList<String> arrayList = new ArrayList<String>();
            while ((n4 = this.indexOf(c, n3)) != -1) {
                if (!bl || arrayList.size() < n - 1) {
                    arrayList.add(this.substring(n3, n4));
                    n3 = n4 + 1;
                    continue;
                }
                n2 = this.length();
                arrayList.add(this.substring(n3, n2));
                n3 = n2;
                break;
            }
            if (n3 == 0) {
                return new String[]{this};
            }
            if (!bl || arrayList.size() < n) {
                arrayList.add(this.substring(n3, this.length()));
            }
            if (n == 0) {
                for (n2 = arrayList.size(); n2 > 0 && ((String)arrayList.get(n2 - 1)).length() == 0; --n2) {
                }
            }
            String[] stringArray = new String[n2];
            return arrayList.subList(0, n2).toArray(stringArray);
        }
        return Pattern.compile(string).split(this, n);
    }

    public String[] split(String string) {
        return this.split(string, 0);
    }

    public static String join(CharSequence charSequence, CharSequence ... charSequenceArray) {
        Objects.requireNonNull(charSequence);
        Objects.requireNonNull(charSequenceArray);
        StringJoiner stringJoiner = new StringJoiner(charSequence);
        for (CharSequence charSequence2 : charSequenceArray) {
            stringJoiner.add(charSequence2);
        }
        return stringJoiner.toString();
    }

    public static String join(CharSequence charSequence, Iterable<? extends CharSequence> iterable) {
        Objects.requireNonNull(charSequence);
        Objects.requireNonNull(iterable);
        StringJoiner stringJoiner = new StringJoiner(charSequence);
        for (CharSequence charSequence2 : iterable) {
            stringJoiner.add(charSequence2);
        }
        return stringJoiner.toString();
    }

    public String toLowerCase(Locale locale) {
        return this.isLatin1() ? StringLatin1.toLowerCase(this, this.value, locale) : StringUTF16.toLowerCase(this, this.value, locale);
    }

    public String toLowerCase() {
        return this.toLowerCase(Locale.getDefault());
    }

    public String toUpperCase(Locale locale) {
        return this.isLatin1() ? StringLatin1.toUpperCase(this, this.value, locale) : StringUTF16.toUpperCase(this, this.value, locale);
    }

    public String toUpperCase() {
        return this.toUpperCase(Locale.getDefault());
    }

    public String trim() {
        String string = this.isLatin1() ? StringLatin1.trim(this.value) : StringUTF16.trim(this.value);
        return string == null ? this : string;
    }

    @Override
    public String toString() {
        return this;
    }

    public char[] toCharArray() {
        return this.isLatin1() ? StringLatin1.toChars(this.value) : StringUTF16.toChars(this.value);
    }

    public static String format(String string, Object ... objectArray) {
        return new Formatter().format(string, objectArray).toString();
    }

    public static String format(Locale locale, String string, Object ... objectArray) {
        return new Formatter(locale).format(string, objectArray).toString();
    }

    public static String valueOf(Object object) {
        return object == null ? "null" : object.toString();
    }

    public static String valueOf(char[] cArray) {
        return new String(cArray);
    }

    public static String valueOf(char[] cArray, int n, int n2) {
        return new String(cArray, n, n2);
    }

    public static String copyValueOf(char[] cArray, int n, int n2) {
        return new String(cArray, n, n2);
    }

    public static String copyValueOf(char[] cArray) {
        return new String(cArray);
    }

    public static String valueOf(boolean bl) {
        return bl ? "true" : "false";
    }

    public static String valueOf(char c) {
        if (COMPACT_STRINGS && StringLatin1.canEncode(c)) {
            return new String(StringLatin1.toBytes(c), 0);
        }
        return new String(StringUTF16.toBytes(c), 1);
    }

    public static String valueOf(int n) {
        return Integer.toString(n);
    }

    public static String valueOf(long l) {
        return Long.toString(l);
    }

    public static String valueOf(float f) {
        return Float.toString(f);
    }

    public static String valueOf(double d) {
        return Double.toString(d);
    }

    public native String intern();

    void getBytes(byte[] byArray, int n, byte by) {
        if (this.coder() == by) {
            System.arraycopy(this.value, 0, byArray, n << by, this.value.length);
        } else {
            StringLatin1.inflate(this.value, 0, byArray, n, this.value.length);
        }
    }

    String(char[] cArray, int n, int n2, Void void_) {
        byte[] byArray;
        if (n2 == 0) {
            this.value = "".value;
            this.coder = "".coder;
            return;
        }
        if (COMPACT_STRINGS && (byArray = StringUTF16.compress(cArray, n, n2)) != null) {
            this.value = byArray;
            this.coder = 0;
            return;
        }
        this.coder = 1;
        this.value = StringUTF16.toBytes(cArray, n, n2);
    }

    String(AbstractStringBuilder abstractStringBuilder, Void void_) {
        byte[] byArray = abstractStringBuilder.getValue();
        int n = abstractStringBuilder.length();
        if (abstractStringBuilder.isLatin1()) {
            this.coder = 0;
            this.value = Arrays.copyOfRange(byArray, 0, n);
        } else {
            byte[] byArray2;
            if (COMPACT_STRINGS && (byArray2 = StringUTF16.compress(byArray, 0, n)) != null) {
                this.coder = 0;
                this.value = byArray2;
                return;
            }
            this.coder = 1;
            this.value = Arrays.copyOfRange(byArray, 0, n << 1);
        }
    }

    String(byte[] byArray, byte by) {
        this.value = byArray;
        this.coder = by;
    }

    byte coder() {
        return COMPACT_STRINGS ? this.coder : (byte)1;
    }

    byte[] value() {
        return this.value;
    }

    private boolean isLatin1() {
        return COMPACT_STRINGS && this.coder == 0;
    }

    static void checkIndex(int n, int n2) {
        if (n < 0 || n >= n2) {
            throw new StringIndexOutOfBoundsException("index " + n + ",length " + n2);
        }
    }

    static void checkOffset(int n, int n2) {
        if (n < 0 || n > n2) {
            throw new StringIndexOutOfBoundsException("offset " + n + ",length " + n2);
        }
    }

    static void checkBoundsOffCount(int n, int n2, int n3) {
        if (n < 0 || n2 < 0 || n > n3 - n2) {
            throw new StringIndexOutOfBoundsException("offset " + n + ", count " + n2 + ", length " + n3);
        }
    }

    static void checkBoundsBeginEnd(int n, int n2, int n3) {
        if (n < 0 || n > n2 || n2 > n3) {
            throw new StringIndexOutOfBoundsException("begin " + n + ", end " + n2 + ", length " + n3);
        }
    }

    private static class CaseInsensitiveComparator
    implements Comparator<String>,
    Serializable {
        private static final long serialVersionUID = 8575799808933029326L;

        private CaseInsensitiveComparator() {
        }

        @Override
        public int compare(String string, String string2) {
            byte[] byArray = string.value;
            byte[] byArray2 = string2.value;
            if (string.coder() == string2.coder()) {
                return string.isLatin1() ? StringLatin1.compareToCI(byArray, byArray2) : StringUTF16.compareToCI(byArray, byArray2);
            }
            return string.isLatin1() ? StringLatin1.compareToCI_UTF16(byArray, byArray2) : StringUTF16.compareToCI_Latin1(byArray, byArray2);
        }

        private Object readResolve() {
            return String.CASE_INSENSITIVE_ORDER;
        }
    }
}

