/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import sun.misc.VM;

public final class Integer
extends Number
implements Comparable<Integer> {
    public static final int MIN_VALUE = -2147483648;
    public static final int MAX_VALUE = 0x7FFFFFFF;
    public static final Class<Integer> TYPE = Class.getPrimitiveClass("int");
    static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    static final byte[] DigitTens = new byte[]{48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 53, 53, 53, 53, 53, 53, 53, 53, 53, 53, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57};
    static final byte[] DigitOnes = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57};
    static final int[] sizeTable = new int[]{9, 99, 999, 9999, 99999, 999999, 9999999, 99999999, 999999999, Integer.MAX_VALUE};
    private final int value;
    public static final int SIZE = 32;
    public static final int BYTES = 4;
    private static final long serialVersionUID = 1360826667806852920L;

    public static String toString(int n, int n2) {
        if (n2 < 2 || n2 > 36) {
            n2 = 10;
        }
        if (n2 == 10) {
            return Integer.toString(n);
        }
        if (String.COMPACT_STRINGS) {
            byte[] byArray = new byte[33];
            boolean bl = n < 0;
            int n3 = 32;
            if (!bl) {
                n = -n;
            }
            while (n <= -n2) {
                byArray[n3--] = (byte)digits[-(n % n2)];
                n /= n2;
            }
            byArray[n3] = (byte)digits[-n];
            if (bl) {
                byArray[--n3] = 45;
            }
            return StringLatin1.newString(byArray, n3, 33 - n3);
        }
        return Integer.toStringUTF16(n, n2);
    }

    private static String toStringUTF16(int n, int n2) {
        byte[] byArray = new byte[66];
        boolean bl = n < 0;
        int n3 = 32;
        if (!bl) {
            n = -n;
        }
        while (n <= -n2) {
            StringUTF16.putChar(byArray, n3--, digits[-(n % n2)]);
            n /= n2;
        }
        StringUTF16.putChar(byArray, n3, digits[-n]);
        if (bl) {
            StringUTF16.putChar(byArray, --n3, 45);
        }
        return StringUTF16.newString(byArray, n3, 33 - n3);
    }

    public static String toUnsignedString(int n, int n2) {
        return Long.toUnsignedString(Integer.toUnsignedLong(n), n2);
    }

    public static String toHexString(int n) {
        return Integer.toUnsignedString0(n, 4);
    }

    public static String toOctalString(int n) {
        return Integer.toUnsignedString0(n, 3);
    }

    public static String toBinaryString(int n) {
        return Integer.toUnsignedString0(n, 1);
    }

    private static String toUnsignedString0(int n, int n2) {
        int n3 = 32 - Integer.numberOfLeadingZeros(n);
        int n4 = Math.max((n3 + (n2 - 1)) / n2, 1);
        if (String.COMPACT_STRINGS) {
            byte[] byArray = new byte[n4];
            Integer.formatUnsignedInt(n, n2, byArray, 0, n4);
            return new String(byArray, 0);
        }
        byte[] byArray = new byte[n4 * 2];
        Integer.formatUnsignedIntUTF16(n, n2, byArray, 0, n4);
        return new String(byArray, 1);
    }

    static int formatUnsignedInt(int n, int n2, char[] cArray, int n3, int n4) {
        int n5 = n4;
        int n6 = 1 << n2;
        int n7 = n6 - 1;
        do {
            cArray[n3 + --n5] = digits[n & n7];
        } while ((n >>>= n2) != 0 && n5 > 0);
        return n5;
    }

    static void formatUnsignedInt(int n, int n2, byte[] byArray, int n3, int n4) {
        int n5 = n3 + n4;
        int n6 = 1 << n2;
        int n7 = n6 - 1;
        do {
            byArray[--n5] = (byte)digits[n & n7];
            n >>>= n2;
        } while (n5 > n3);
    }

    private static void formatUnsignedIntUTF16(int n, int n2, byte[] byArray, int n3, int n4) {
        int n5 = n3 + n4;
        int n6 = 1 << n2;
        int n7 = n6 - 1;
        do {
            StringUTF16.putChar(byArray, --n5, digits[n & n7]);
            n >>>= n2;
        } while (n5 > n3);
    }

    public static String toString(int n) {
        int n2 = Integer.stringSize(n);
        if (String.COMPACT_STRINGS) {
            byte[] byArray = new byte[n2];
            Integer.getChars(n, n2, byArray);
            return new String(byArray, 0);
        }
        byte[] byArray = new byte[n2 * 2];
        StringUTF16.getChars(n, n2, byArray);
        return new String(byArray, 1);
    }

    public static String toUnsignedString(int n) {
        return Long.toString(Integer.toUnsignedLong(n));
    }

    static void getChars(int n, int n2, byte[] byArray) {
        int n3;
        int n4;
        boolean bl;
        int n5 = n2;
        boolean bl2 = bl = n < 0;
        if (!bl) {
            n = -n;
        }
        while (n <= -100) {
            n4 = n / 100;
            n3 = n4 * 100 - n;
            n = n4;
            byArray[--n5] = DigitOnes[n3];
            byArray[--n5] = DigitTens[n3];
        }
        n4 = n / 10;
        n3 = n4 * 10 - n;
        byArray[--n5] = (byte)(48 + n3);
        if (n4 < 0) {
            byArray[--n5] = (byte)(48 - n4);
        }
        if (bl) {
            byArray[--n5] = 45;
        }
    }

    static int stringSize(int n) {
        int n2 = 1;
        if (n >= 0) {
            n2 = 0;
            n = -n;
        }
        int n3 = -10;
        for (int i = 1; i < 10; ++i) {
            if (n > n3) {
                return i + n2;
            }
            n3 = 10 * n3;
        }
        return 10 + n2;
    }

    public static int parseInt(String string, int n) throws NumberFormatException {
        if (string == null) {
            throw new NumberFormatException("null");
        }
        if (n < 2) {
            throw new NumberFormatException("radix " + n + " less than Character.MIN_RADIX");
        }
        if (n > 36) {
            throw new NumberFormatException("radix " + n + " greater than Character.MAX_RADIX");
        }
        boolean bl = false;
        int n2 = 0;
        int n3 = string.length();
        int n4 = -2147483647;
        if (n3 > 0) {
            char c = string.charAt(0);
            if (c < '0') {
                if (c == '-') {
                    bl = true;
                    n4 = Integer.MIN_VALUE;
                } else if (c != '+') {
                    throw NumberFormatException.forInputString((String)string);
                }
                if (n3 == 1) {
                    throw NumberFormatException.forInputString((String)string);
                }
                ++n2;
            }
            int n5 = n4 / n;
            int n6 = 0;
            while (n2 < n3) {
                int n7;
                if ((n7 = Character.digit(string.charAt(n2++), n)) < 0 || n6 < n5) {
                    throw NumberFormatException.forInputString((String)string);
                }
                if ((n6 *= n) < n4 + n7) {
                    throw NumberFormatException.forInputString((String)string);
                }
                n6 -= n7;
            }
            return bl ? n6 : -n6;
        }
        throw NumberFormatException.forInputString((String)string);
    }

    public static int parseInt(String string) throws NumberFormatException {
        return Integer.parseInt(string, 10);
    }

    public static int parseUnsignedInt(String string, int n) throws NumberFormatException {
        if (string == null) {
            throw new NumberFormatException("null");
        }
        int n2 = string.length();
        if (n2 > 0) {
            char c = string.charAt(0);
            if (c == '-') {
                throw new NumberFormatException(String.format("Illegal leading minus sign on unsigned string %s.", string));
            }
            if (n2 <= 5 || n == 10 && n2 <= 9) {
                return Integer.parseInt(string, n);
            }
            long l = Long.parseLong(string, n);
            if ((l & 0xFFFFFFFF00000000L) == 0L) {
                return (int)l;
            }
            throw new NumberFormatException(String.format("String value %s exceeds range of unsigned int.", string));
        }
        throw NumberFormatException.forInputString((String)string);
    }

    public static int parseUnsignedInt(String string) throws NumberFormatException {
        return Integer.parseUnsignedInt(string, 10);
    }

    public static Integer valueOf(String string, int n) throws NumberFormatException {
        return Integer.parseInt(string, n);
    }

    public static Integer valueOf(String string) throws NumberFormatException {
        return Integer.parseInt(string, 10);
    }

    public static Integer valueOf(int n) {
        if (n >= -128 && n <= IntegerCache.high) {
            return IntegerCache.cache[n + 128];
        }
        return new Integer(n);
    }

    public Integer(int n) {
        this.value = n;
    }

    public Integer(String string) throws NumberFormatException {
        this.value = Integer.parseInt(string, 10);
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public String toString() {
        return Integer.toString(this.value);
    }

    public int hashCode() {
        return Integer.hashCode(this.value);
    }

    public static int hashCode(int n) {
        return n;
    }

    public boolean equals(Object object) {
        if (object instanceof Integer) {
            return this.value == (Integer)object;
        }
        return false;
    }

    public static Integer getInteger(String string) {
        return Integer.getInteger(string, null);
    }

    public static Integer getInteger(String string, int n) {
        Integer n2 = Integer.getInteger(string, null);
        return n2 == null ? Integer.valueOf(n) : n2;
    }

    public static Integer getInteger(String string, Integer n) {
        String string2 = null;
        try {
            string2 = System.getProperty(string);
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            // empty catch block
        }
        if (string2 != null) {
            try {
                return Integer.decode(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    public static Integer decode(String string) throws NumberFormatException {
        Integer n;
        int n2 = 10;
        int n3 = 0;
        boolean bl = false;
        if (string.isEmpty()) {
            throw new NumberFormatException("Zero length string");
        }
        char c = string.charAt(0);
        if (c == '-') {
            bl = true;
            ++n3;
        } else if (c == '+') {
            ++n3;
        }
        if (string.startsWith("0x", n3) || string.startsWith("0X", n3)) {
            n3 += 2;
            n2 = 16;
        } else if (string.startsWith("#", n3)) {
            ++n3;
            n2 = 16;
        } else if (string.startsWith("0", n3) && string.length() > 1 + n3) {
            ++n3;
            n2 = 8;
        }
        if (string.startsWith("-", n3) || string.startsWith("+", n3)) {
            throw new NumberFormatException("Sign character in wrong position");
        }
        try {
            n = Integer.valueOf(string.substring(n3), n2);
            n = bl ? Integer.valueOf(-n.intValue()) : n;
        }
        catch (NumberFormatException numberFormatException) {
            String string2 = bl ? "-" + string.substring(n3) : string.substring(n3);
            n = Integer.valueOf(string2, n2);
        }
        return n;
    }

    @Override
    public int compareTo(Integer n) {
        return Integer.compare(this.value, n.value);
    }

    public static int compare(int n, int n2) {
        return n < n2 ? -1 : (n == n2 ? 0 : 1);
    }

    public static int compareUnsigned(int n, int n2) {
        return Integer.compare(n + Integer.MIN_VALUE, n2 + Integer.MIN_VALUE);
    }

    public static long toUnsignedLong(int n) {
        return (long)n & 0xFFFFFFFFL;
    }

    public static int divideUnsigned(int n, int n2) {
        return (int)(Integer.toUnsignedLong(n) / Integer.toUnsignedLong(n2));
    }

    public static int remainderUnsigned(int n, int n2) {
        return (int)(Integer.toUnsignedLong(n) % Integer.toUnsignedLong(n2));
    }

    public static int highestOneBit(int n) {
        return n & Integer.MIN_VALUE >>> Integer.numberOfLeadingZeros(n);
    }

    public static int lowestOneBit(int n) {
        return n & -n;
    }

    public static int numberOfLeadingZeros(int n) {
        if (n <= 0) {
            return n == 0 ? 32 : 0;
        }
        int n2 = 31;
        if (n >= 65536) {
            n2 -= 16;
            n >>>= 16;
        }
        if (n >= 256) {
            n2 -= 8;
            n >>>= 8;
        }
        if (n >= 16) {
            n2 -= 4;
            n >>>= 4;
        }
        if (n >= 4) {
            n2 -= 2;
            n >>>= 2;
        }
        return n2 - (n >>> 1);
    }

    public static int numberOfTrailingZeros(int n) {
        if (n == 0) {
            return 32;
        }
        int n2 = 31;
        int n3 = n << 16;
        if (n3 != 0) {
            n2 -= 16;
            n = n3;
        }
        if ((n3 = n << 8) != 0) {
            n2 -= 8;
            n = n3;
        }
        if ((n3 = n << 4) != 0) {
            n2 -= 4;
            n = n3;
        }
        if ((n3 = n << 2) != 0) {
            n2 -= 2;
            n = n3;
        }
        return n2 - (n << 1 >>> 31);
    }

    public static int bitCount(int n) {
        n -= n >>> 1 & 0x55555555;
        n = (n & 0x33333333) + (n >>> 2 & 0x33333333);
        n = n + (n >>> 4) & 0xF0F0F0F;
        n += n >>> 8;
        n += n >>> 16;
        return n & 0x3F;
    }

    public static int rotateLeft(int n, int n2) {
        return n << n2 | n >>> -n2;
    }

    public static int rotateRight(int n, int n2) {
        return n >>> n2 | n << -n2;
    }

    public static int reverse(int n) {
        n = (n & 0x55555555) << 1 | n >>> 1 & 0x55555555;
        n = (n & 0x33333333) << 2 | n >>> 2 & 0x33333333;
        n = (n & 0xF0F0F0F) << 4 | n >>> 4 & 0xF0F0F0F;
        return Integer.reverseBytes(n);
    }

    public static int signum(int n) {
        return n >> 31 | -n >>> 31;
    }

    public static int reverseBytes(int n) {
        return n << 24 | (n & 0xFF00) << 8 | n >>> 8 & 0xFF00 | n >>> 24;
    }

    public static int sum(int n, int n2) {
        return n + n2;
    }

    public static int max(int n, int n2) {
        return Math.max(n, n2);
    }

    public static int min(int n, int n2) {
        return Math.min(n, n2);
    }

    private static class IntegerCache {
        static final int low = -128;
        static final int high;
        static final Integer[] cache;

        private IntegerCache() {
        }

        static {
            int n = 127;
            String string = VM.getSavedProperty((String)"java.lang.Integer.IntegerCache.high");
            if (string != null) {
                try {
                    int n2 = Integer.parseInt(string);
                    n2 = Math.max(n2, 127);
                    n = Math.min(n2, 0x7FFFFF7E);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            high = n;
            cache = new Integer[high - -128 + 1];
            int n3 = -128;
            for (int i = 0; i < cache.length; ++i) {
                IntegerCache.cache[i] = new Integer(n3++);
            }
            assert (high >= 127);
        }
    }
}

