/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.util.Arrays;
import sun.misc.FloatingDecimal;

abstract class AbstractStringBuilder
implements Appendable,
CharSequence {
    byte[] value;
    byte coder;
    int count;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;

    AbstractStringBuilder() {
    }

    AbstractStringBuilder(int n) {
        if (String.COMPACT_STRINGS) {
            this.value = new byte[n];
            this.coder = 0;
        } else {
            this.value = StringUTF16.newBytesFor(n);
            this.coder = 1;
        }
    }

    @Override
    public int length() {
        return this.count;
    }

    public int capacity() {
        return this.value.length >> this.coder;
    }

    public void ensureCapacity(int n) {
        if (n > 0) {
            this.ensureCapacityInternal(n);
        }
    }

    private void ensureCapacityInternal(int n) {
        int n2 = this.value.length >> this.coder;
        if (n - n2 > 0) {
            this.value = Arrays.copyOf(this.value, this.newCapacity(n) << this.coder);
        }
    }

    private int newCapacity(int n) {
        int n2 = this.value.length >> this.coder;
        int n3 = (n2 << 1) + 2;
        if (n3 - n < 0) {
            n3 = n;
        }
        int n4 = 0x7FFFFFF7 >> this.coder;
        return n3 <= 0 || n4 - n3 < 0 ? this.hugeCapacity(n) : n3;
    }

    private int hugeCapacity(int n) {
        int n2 = 0x7FFFFFF7 >> this.coder;
        int n3 = Integer.MAX_VALUE >> this.coder;
        if (n3 - n < 0) {
            throw new OutOfMemoryError();
        }
        return n > n2 ? n : n2;
    }

    private void inflate() {
        if (!this.isLatin1()) {
            return;
        }
        byte[] byArray = StringUTF16.newBytesFor(this.value.length);
        StringLatin1.inflate(this.value, 0, byArray, 0, this.count);
        this.value = byArray;
        this.coder = 1;
    }

    public void trimToSize() {
        int n = this.count << this.coder;
        if (n < this.value.length) {
            this.value = Arrays.copyOf(this.value, n);
        }
    }

    public void setLength(int n) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        this.ensureCapacityInternal(n);
        if (this.count < n) {
            if (this.isLatin1()) {
                StringLatin1.fillNull(this.value, this.count, n);
            } else {
                StringUTF16.fillNull(this.value, this.count, n);
            }
        }
        this.count = n;
    }

    @Override
    public char charAt(int n) {
        String.checkIndex(n, this.count);
        if (this.isLatin1()) {
            return (char)(this.value[n] & 0xFF);
        }
        return StringUTF16.charAt(this.value, n);
    }

    public int codePointAt(int n) {
        int n2 = this.count;
        byte[] byArray = this.value;
        String.checkIndex(n, n2);
        if (this.isLatin1()) {
            return byArray[n] & 0xFF;
        }
        return StringUTF16.codePointAtSB(byArray, n, n2);
    }

    public int codePointBefore(int n) {
        int n2 = n - 1;
        if (n2 < 0 || n2 >= this.count) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (this.isLatin1()) {
            return this.value[n2] & 0xFF;
        }
        return StringUTF16.codePointBeforeSB(this.value, n);
    }

    public int codePointCount(int n, int n2) {
        if (n < 0 || n2 > this.count || n > n2) {
            throw new IndexOutOfBoundsException();
        }
        if (this.isLatin1()) {
            return n2 - n;
        }
        return StringUTF16.codePointCountSB(this.value, n, n2);
    }

    public int offsetByCodePoints(int n, int n2) {
        if (n < 0 || n > this.count) {
            throw new IndexOutOfBoundsException();
        }
        return Character.offsetByCodePoints(this, n, n2);
    }

    public void getChars(int n, int n2, char[] cArray, int n3) {
        AbstractStringBuilder.checkRangeSIOOBE(n, n2, this.count);
        int n4 = n2 - n;
        AbstractStringBuilder.checkRange(n3, n3 + n4, cArray.length);
        if (this.isLatin1()) {
            StringLatin1.getChars(this.value, n, n2, cArray, n3);
        } else {
            StringUTF16.getChars(this.value, n, n2, cArray, n3);
        }
    }

    public void setCharAt(int n, char c) {
        String.checkIndex(n, this.count);
        if (this.isLatin1() && StringLatin1.canEncode(c)) {
            this.value[n] = (byte)c;
        } else {
            if (this.isLatin1()) {
                this.inflate();
            }
            StringUTF16.putCharSB(this.value, n, c);
        }
    }

    public AbstractStringBuilder append(Object object) {
        return this.append(String.valueOf(object));
    }

    public AbstractStringBuilder append(String string) {
        if (string == null) {
            return this.appendNull();
        }
        int n = string.length();
        this.ensureCapacityInternal(this.count + n);
        this.putStringAt(this.count, string);
        this.count += n;
        return this;
    }

    public AbstractStringBuilder append(StringBuffer stringBuffer) {
        return this.append((AbstractStringBuilder)stringBuffer);
    }

    AbstractStringBuilder append(AbstractStringBuilder abstractStringBuilder) {
        if (abstractStringBuilder == null) {
            return this.appendNull();
        }
        int n = abstractStringBuilder.length();
        this.ensureCapacityInternal(this.count + n);
        if (this.getCoder() != abstractStringBuilder.getCoder()) {
            this.inflate();
        }
        abstractStringBuilder.getBytes(this.value, this.count, this.coder);
        this.count += n;
        return this;
    }

    @Override
    public AbstractStringBuilder append(CharSequence charSequence) {
        if (charSequence == null) {
            return this.appendNull();
        }
        if (charSequence instanceof String) {
            return this.append((String)charSequence);
        }
        if (charSequence instanceof AbstractStringBuilder) {
            return this.append((AbstractStringBuilder)charSequence);
        }
        return this.append(charSequence, 0, charSequence.length());
    }

    private AbstractStringBuilder appendNull() {
        this.ensureCapacityInternal(this.count + 4);
        int n = this.count;
        byte[] byArray = this.value;
        if (this.isLatin1()) {
            byArray[n++] = 110;
            byArray[n++] = 117;
            byArray[n++] = 108;
            byArray[n++] = 108;
        } else {
            n = StringUTF16.putCharsAt(byArray, n, 'n', 'u', 'l', 'l');
        }
        this.count = n;
        return this;
    }

    @Override
    public AbstractStringBuilder append(CharSequence charSequence, int n, int n2) {
        if (charSequence == null) {
            charSequence = "null";
        }
        AbstractStringBuilder.checkRange(n, n2, charSequence.length());
        int n3 = n2 - n;
        this.ensureCapacityInternal(this.count + n3);
        this.appendChars(charSequence, n, n2);
        return this;
    }

    public AbstractStringBuilder append(char[] cArray) {
        int n = cArray.length;
        this.ensureCapacityInternal(this.count + n);
        this.appendChars(cArray, 0, n);
        return this;
    }

    public AbstractStringBuilder append(char[] cArray, int n, int n2) {
        int n3 = n + n2;
        AbstractStringBuilder.checkRange(n, n3, cArray.length);
        this.ensureCapacityInternal(this.count + n2);
        this.appendChars(cArray, n, n3);
        return this;
    }

    public AbstractStringBuilder append(boolean bl) {
        this.ensureCapacityInternal(this.count + (bl ? 4 : 5));
        int n = this.count;
        byte[] byArray = this.value;
        if (this.isLatin1()) {
            if (bl) {
                byArray[n++] = 116;
                byArray[n++] = 114;
                byArray[n++] = 117;
                byArray[n++] = 101;
            } else {
                byArray[n++] = 102;
                byArray[n++] = 97;
                byArray[n++] = 108;
                byArray[n++] = 115;
                byArray[n++] = 101;
            }
        } else {
            n = bl ? StringUTF16.putCharsAt(byArray, n, 't', 'r', 'u', 'e') : StringUTF16.putCharsAt(byArray, n, 'f', 'a', 'l', 's', 'e');
        }
        this.count = n;
        return this;
    }

    @Override
    public AbstractStringBuilder append(char c) {
        this.ensureCapacityInternal(this.count + 1);
        if (this.isLatin1() && StringLatin1.canEncode(c)) {
            this.value[this.count++] = (byte)c;
        } else {
            if (this.isLatin1()) {
                this.inflate();
            }
            StringUTF16.putCharSB(this.value, this.count++, c);
        }
        return this;
    }

    public AbstractStringBuilder append(int n) {
        int n2 = this.count;
        int n3 = n2 + Integer.stringSize(n);
        this.ensureCapacityInternal(n3);
        if (this.isLatin1()) {
            Integer.getChars(n, n3, this.value);
        } else {
            StringUTF16.getChars(n, n2, n3, this.value);
        }
        this.count = n3;
        return this;
    }

    public AbstractStringBuilder append(long l) {
        int n = this.count;
        int n2 = n + Long.stringSize(l);
        this.ensureCapacityInternal(n2);
        if (this.isLatin1()) {
            Long.getChars(l, n2, this.value);
        } else {
            StringUTF16.getChars(l, n, n2, this.value);
        }
        this.count = n2;
        return this;
    }

    public AbstractStringBuilder append(float f) {
        FloatingDecimal.appendTo((float)f, (Appendable)this);
        return this;
    }

    public AbstractStringBuilder append(double d) {
        FloatingDecimal.appendTo((double)d, (Appendable)this);
        return this;
    }

    public AbstractStringBuilder delete(int n, int n2) {
        int n3 = this.count;
        if (n2 > n3) {
            n2 = n3;
        }
        AbstractStringBuilder.checkRangeSIOOBE(n, n2, n3);
        int n4 = n2 - n;
        if (n4 > 0) {
            this.shift(n2, -n4);
            this.count = n3 - n4;
        }
        return this;
    }

    public AbstractStringBuilder appendCodePoint(int n) {
        if (Character.isBmpCodePoint(n)) {
            return this.append((char)n);
        }
        return this.append(Character.toChars(n));
    }

    public AbstractStringBuilder deleteCharAt(int n) {
        String.checkIndex(n, this.count);
        this.shift(n + 1, -1);
        --this.count;
        return this;
    }

    public AbstractStringBuilder replace(int n, int n2, String string) {
        int n3 = this.count;
        if (n2 > n3) {
            n2 = n3;
        }
        AbstractStringBuilder.checkRangeSIOOBE(n, n2, n3);
        int n4 = string.length();
        int n5 = n3 + n4 - (n2 - n);
        this.ensureCapacityInternal(n5);
        this.shift(n2, n5 - n3);
        this.count = n5;
        this.putStringAt(n, string);
        return this;
    }

    public String substring(int n) {
        return this.substring(n, this.count);
    }

    @Override
    public CharSequence subSequence(int n, int n2) {
        return this.substring(n, n2);
    }

    public String substring(int n, int n2) {
        AbstractStringBuilder.checkRangeSIOOBE(n, n2, this.count);
        if (this.isLatin1()) {
            return StringLatin1.newString(this.value, n, n2 - n);
        }
        return StringUTF16.newString(this.value, n, n2 - n);
    }

    private void shift(int n, int n2) {
        System.arraycopy(this.value, n << this.coder, this.value, n + n2 << this.coder, this.count - n << this.coder);
    }

    public AbstractStringBuilder insert(int n, char[] cArray, int n2, int n3) {
        String.checkOffset(n, this.count);
        AbstractStringBuilder.checkRangeSIOOBE(n2, n2 + n3, cArray.length);
        this.ensureCapacityInternal(this.count + n3);
        this.shift(n, n3);
        this.count += n3;
        this.putCharsAt(n, cArray, n2, n2 + n3);
        return this;
    }

    public AbstractStringBuilder insert(int n, Object object) {
        return this.insert(n, String.valueOf(object));
    }

    public AbstractStringBuilder insert(int n, String string) {
        String.checkOffset(n, this.count);
        if (string == null) {
            string = "null";
        }
        int n2 = string.length();
        this.ensureCapacityInternal(this.count + n2);
        this.shift(n, n2);
        this.count += n2;
        this.putStringAt(n, string);
        return this;
    }

    public AbstractStringBuilder insert(int n, char[] cArray) {
        String.checkOffset(n, this.count);
        int n2 = cArray.length;
        this.ensureCapacityInternal(this.count + n2);
        this.shift(n, n2);
        this.count += n2;
        this.putCharsAt(n, cArray, 0, n2);
        return this;
    }

    public AbstractStringBuilder insert(int n, CharSequence charSequence) {
        if (charSequence == null) {
            charSequence = "null";
        }
        if (charSequence instanceof String) {
            return this.insert(n, (String)charSequence);
        }
        return this.insert(n, charSequence, 0, charSequence.length());
    }

    public AbstractStringBuilder insert(int n, CharSequence charSequence, int n2, int n3) {
        if (charSequence == null) {
            charSequence = "null";
        }
        String.checkOffset(n, this.count);
        AbstractStringBuilder.checkRange(n2, n3, charSequence.length());
        int n4 = n3 - n2;
        this.ensureCapacityInternal(this.count + n4);
        this.shift(n, n4);
        this.count += n4;
        this.putCharsAt(n, charSequence, n2, n3);
        return this;
    }

    public AbstractStringBuilder insert(int n, boolean bl) {
        return this.insert(n, String.valueOf(bl));
    }

    public AbstractStringBuilder insert(int n, char c) {
        String.checkOffset(n, this.count);
        this.ensureCapacityInternal(this.count + 1);
        this.shift(n, 1);
        ++this.count;
        if (this.isLatin1() && StringLatin1.canEncode(c)) {
            this.value[n] = (byte)c;
        } else {
            if (this.isLatin1()) {
                this.inflate();
            }
            StringUTF16.putCharSB(this.value, n, c);
        }
        return this;
    }

    public AbstractStringBuilder insert(int n, int n2) {
        return this.insert(n, String.valueOf(n2));
    }

    public AbstractStringBuilder insert(int n, long l) {
        return this.insert(n, String.valueOf(l));
    }

    public AbstractStringBuilder insert(int n, float f) {
        return this.insert(n, String.valueOf(f));
    }

    public AbstractStringBuilder insert(int n, double d) {
        return this.insert(n, String.valueOf(d));
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int n) {
        return String.indexOf(this.value, this.coder, this.count, string, n);
    }

    public int lastIndexOf(String string) {
        return this.lastIndexOf(string, this.count);
    }

    public int lastIndexOf(String string, int n) {
        return String.lastIndexOf(this.value, this.coder, this.count, string, n);
    }

    public AbstractStringBuilder reverse() {
        byte[] byArray = this.value;
        int n = this.count;
        byte by = this.coder;
        int n2 = n - 1;
        if (String.COMPACT_STRINGS && by == 0) {
            for (int i = n2 - 1 >> 1; i >= 0; --i) {
                int n3 = n2 - i;
                byte by2 = byArray[i];
                byArray[i] = byArray[n3];
                byArray[n3] = by2;
            }
        } else {
            StringUTF16.reverse(byArray, n);
        }
        return this;
    }

    @Override
    public abstract String toString();

    final byte[] getValue() {
        return this.value;
    }

    void getBytes(byte[] byArray, int n, byte by) {
        if (this.coder == by) {
            System.arraycopy(this.value, 0, byArray, n << by, this.count << by);
        } else {
            StringLatin1.inflate(this.value, 0, byArray, n, this.count);
        }
    }

    void initBytes(char[] cArray, int n, int n2) {
        if (String.COMPACT_STRINGS) {
            this.value = StringUTF16.compress(cArray, n, n2);
            if (this.value != null) {
                this.coder = 0;
                return;
            }
        }
        this.coder = 1;
        this.value = StringUTF16.toBytes(cArray, n, n2);
    }

    final byte getCoder() {
        return String.COMPACT_STRINGS ? this.coder : (byte)1;
    }

    final boolean isLatin1() {
        return String.COMPACT_STRINGS && this.coder == 0;
    }

    private final void putCharsAt(int n, char[] cArray, int n2, int n3) {
        if (this.isLatin1()) {
            byte[] byArray = this.value;
            int n4 = n;
            for (int i = n2; i < n3; ++i) {
                char c = cArray[i];
                if (!StringLatin1.canEncode(c)) {
                    this.inflate();
                    StringUTF16.putCharsSB(this.value, n4, cArray, i, n3);
                    return;
                }
                byArray[n4++] = (byte)c;
            }
        } else {
            StringUTF16.putCharsSB(this.value, n, cArray, n2, n3);
        }
    }

    private final void putCharsAt(int n, CharSequence charSequence, int n2, int n3) {
        if (this.isLatin1()) {
            byte[] byArray = this.value;
            int n4 = n;
            for (int i = n2; i < n3; ++i) {
                char c = charSequence.charAt(i);
                if (!StringLatin1.canEncode(c)) {
                    this.inflate();
                    StringUTF16.putCharsSB(this.value, n4, charSequence, i, n3);
                    return;
                }
                byArray[n4++] = (byte)c;
            }
        } else {
            StringUTF16.putCharsSB(this.value, n, charSequence, n2, n3);
        }
    }

    private final void putStringAt(int n, String string) {
        if (this.getCoder() != string.coder()) {
            this.inflate();
        }
        string.getBytes(this.value, n, this.coder);
    }

    private final void appendChars(char[] cArray, int n, int n2) {
        int n3 = this.count;
        if (this.isLatin1()) {
            byte[] byArray = this.value;
            int n4 = n3;
            for (int i = n; i < n2; ++i) {
                char c = cArray[i];
                if (!StringLatin1.canEncode(c)) {
                    this.count = n3 = n4;
                    this.inflate();
                    StringUTF16.putCharsSB(this.value, n4, cArray, i, n2);
                    this.count = n3 + n2 - i;
                    return;
                }
                byArray[n4++] = (byte)c;
            }
        } else {
            StringUTF16.putCharsSB(this.value, n3, cArray, n, n2);
        }
        this.count = n3 + n2 - n;
    }

    private final void appendChars(CharSequence charSequence, int n, int n2) {
        if (this.isLatin1()) {
            byte[] byArray = this.value;
            int n3 = this.count;
            for (int i = n; i < n2; ++i) {
                char c = charSequence.charAt(i);
                if (!StringLatin1.canEncode(c)) {
                    this.count = n3;
                    this.inflate();
                    StringUTF16.putCharsSB(this.value, n3, charSequence, i, n2);
                    this.count += n2 - i;
                    return;
                }
                byArray[n3++] = (byte)c;
            }
        } else {
            StringUTF16.putCharsSB(this.value, this.count, charSequence, n, n2);
        }
        this.count += n2 - n;
    }

    private static void checkRange(int n, int n2, int n3) {
        if (n < 0 || n > n2 || n2 > n3) {
            throw new IndexOutOfBoundsException("start " + n + ", end " + n2 + ", length " + n3);
        }
    }

    private static void checkRangeSIOOBE(int n, int n2, int n3) {
        if (n < 0 || n > n2 || n2 > n3) {
            throw new StringIndexOutOfBoundsException("start " + n + ", end " + n2 + ", length " + n3);
        }
    }
}

