/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ec.point;

import sun.security.ec.point.AffinePoint;
import sun.security.ec.point.ImmutablePoint;
import sun.security.ec.point.MutablePoint;
import sun.security.ec.point.Point;
import sun.security.util.math.ImmutableIntegerModuloP;
import sun.security.util.math.IntegerFieldModuloP;
import sun.security.util.math.IntegerModuloP;
import sun.security.util.math.MutableIntegerModuloP;

public abstract class ProjectivePoint<T extends IntegerModuloP>
implements Point {
    protected final T x;
    protected final T y;
    protected final T z;

    protected ProjectivePoint(T t, T t2, T t3) {
        this.x = t;
        this.y = t2;
        this.z = t3;
    }

    @Override
    public IntegerFieldModuloP getField() {
        return this.x.getField();
    }

    @Override
    public Immutable fixed() {
        return new Immutable(this.x.fixed(), this.y.fixed(), this.z.fixed());
    }

    @Override
    public Mutable mutable() {
        return new Mutable(this.x.mutable(), this.y.mutable(), this.z.mutable());
    }

    public T getX() {
        return this.x;
    }

    public T getY() {
        return this.y;
    }

    public T getZ() {
        return this.z;
    }

    @Override
    public AffinePoint asAffine() {
        ImmutableIntegerModuloP immutableIntegerModuloP = this.z.multiplicativeInverse();
        return new AffinePoint(this.x.multiply(immutableIntegerModuloP), this.y.multiply(immutableIntegerModuloP));
    }

    private static <T1 extends IntegerModuloP, T2 extends IntegerModuloP> boolean affineEquals(ProjectivePoint<T1> projectivePoint, ProjectivePoint<T2> projectivePoint2) {
        MutableIntegerModuloP mutableIntegerModuloP = projectivePoint.getX().mutable().setProduct((IntegerModuloP)projectivePoint2.getZ());
        MutableIntegerModuloP mutableIntegerModuloP2 = projectivePoint2.getX().mutable().setProduct((IntegerModuloP)projectivePoint.getZ());
        if (!mutableIntegerModuloP.asBigInteger().equals(mutableIntegerModuloP2.asBigInteger())) {
            return false;
        }
        MutableIntegerModuloP mutableIntegerModuloP3 = projectivePoint.getY().mutable().setProduct((IntegerModuloP)projectivePoint2.getZ());
        MutableIntegerModuloP mutableIntegerModuloP4 = projectivePoint2.getY().mutable().setProduct((IntegerModuloP)projectivePoint.getZ());
        return mutableIntegerModuloP3.asBigInteger().equals(mutableIntegerModuloP4.asBigInteger());
    }

    @Override
    public boolean affineEquals(Point point) {
        if (point instanceof ProjectivePoint) {
            ProjectivePoint projectivePoint = (ProjectivePoint)point;
            return ProjectivePoint.affineEquals(this, projectivePoint);
        }
        return this.asAffine().equals(point.asAffine());
    }

    public static class Mutable
    extends ProjectivePoint<MutableIntegerModuloP>
    implements MutablePoint {
        public Mutable(MutableIntegerModuloP mutableIntegerModuloP, MutableIntegerModuloP mutableIntegerModuloP2, MutableIntegerModuloP mutableIntegerModuloP3) {
            super(mutableIntegerModuloP, mutableIntegerModuloP2, mutableIntegerModuloP3);
        }

        public Mutable(IntegerFieldModuloP integerFieldModuloP) {
            super(integerFieldModuloP.get0().mutable(), integerFieldModuloP.get0().mutable(), integerFieldModuloP.get0().mutable());
        }

        @Override
        public Mutable conditionalSet(Point point, int n) {
            if (!(point instanceof ProjectivePoint)) {
                throw new RuntimeException("Incompatible point");
            }
            ProjectivePoint projectivePoint = (ProjectivePoint)point;
            return this.conditionalSet(projectivePoint, n);
        }

        private <T extends IntegerModuloP> Mutable conditionalSet(ProjectivePoint<T> projectivePoint, int n) {
            ((MutableIntegerModuloP)this.x).conditionalSet((IntegerModuloP)projectivePoint.x, n);
            ((MutableIntegerModuloP)this.y).conditionalSet((IntegerModuloP)projectivePoint.y, n);
            ((MutableIntegerModuloP)this.z).conditionalSet((IntegerModuloP)projectivePoint.z, n);
            return this;
        }

        @Override
        public Mutable setValue(AffinePoint affinePoint) {
            ((MutableIntegerModuloP)this.x).setValue(affinePoint.getX());
            ((MutableIntegerModuloP)this.y).setValue(affinePoint.getY());
            ((MutableIntegerModuloP)this.z).setValue(affinePoint.getX().getField().get1());
            return this;
        }

        @Override
        public Mutable setValue(Point point) {
            if (!(point instanceof ProjectivePoint)) {
                throw new RuntimeException("Incompatible point");
            }
            ProjectivePoint projectivePoint = (ProjectivePoint)point;
            return this.setValue(projectivePoint);
        }

        private <T extends IntegerModuloP> Mutable setValue(ProjectivePoint<T> projectivePoint) {
            ((MutableIntegerModuloP)this.x).setValue((IntegerModuloP)projectivePoint.x);
            ((MutableIntegerModuloP)this.y).setValue((IntegerModuloP)projectivePoint.y);
            ((MutableIntegerModuloP)this.z).setValue((IntegerModuloP)projectivePoint.z);
            return this;
        }
    }

    public static class Immutable
    extends ProjectivePoint<ImmutableIntegerModuloP>
    implements ImmutablePoint {
        public Immutable(ImmutableIntegerModuloP immutableIntegerModuloP, ImmutableIntegerModuloP immutableIntegerModuloP2, ImmutableIntegerModuloP immutableIntegerModuloP3) {
            super(immutableIntegerModuloP, immutableIntegerModuloP2, immutableIntegerModuloP3);
        }
    }
}

