/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ec.point;

import sun.security.ec.point.AffinePoint;
import sun.security.ec.point.ImmutablePoint;
import sun.security.ec.point.MutablePoint;
import sun.security.ec.point.Point;
import sun.security.util.math.ImmutableIntegerModuloP;
import sun.security.util.math.IntegerFieldModuloP;
import sun.security.util.math.IntegerModuloP;
import sun.security.util.math.MutableIntegerModuloP;

public abstract class ExtendedHomogeneousPoint<T extends IntegerModuloP>
implements Point {
    protected final T x;
    protected final T y;
    protected final T t;
    protected final T z;

    protected ExtendedHomogeneousPoint(T t, T t2, T t3, T t4) {
        this.x = t;
        this.y = t2;
        this.t = t3;
        this.z = t4;
    }

    @Override
    public IntegerFieldModuloP getField() {
        return this.x.getField();
    }

    @Override
    public Immutable fixed() {
        return new Immutable(this.x.fixed(), this.y.fixed(), this.t.fixed(), this.z.fixed());
    }

    @Override
    public Mutable mutable() {
        return new Mutable(this.x.mutable(), this.y.mutable(), this.t.mutable(), this.z.mutable());
    }

    public T getX() {
        return this.x;
    }

    public T getY() {
        return this.y;
    }

    public T getT() {
        return this.t;
    }

    public T getZ() {
        return this.z;
    }

    @Override
    public AffinePoint asAffine() {
        ImmutableIntegerModuloP immutableIntegerModuloP = this.z.multiplicativeInverse();
        return new AffinePoint(this.x.multiply(immutableIntegerModuloP), this.y.multiply(immutableIntegerModuloP));
    }

    private static <T1 extends IntegerModuloP, T2 extends IntegerModuloP> boolean affineEquals(ExtendedHomogeneousPoint<T1> extendedHomogeneousPoint, ExtendedHomogeneousPoint<T2> extendedHomogeneousPoint2) {
        MutableIntegerModuloP mutableIntegerModuloP = extendedHomogeneousPoint.getX().mutable().setProduct((IntegerModuloP)extendedHomogeneousPoint2.getZ());
        MutableIntegerModuloP mutableIntegerModuloP2 = extendedHomogeneousPoint2.getX().mutable().setProduct((IntegerModuloP)extendedHomogeneousPoint.getZ());
        if (!mutableIntegerModuloP.asBigInteger().equals(mutableIntegerModuloP2.asBigInteger())) {
            return false;
        }
        MutableIntegerModuloP mutableIntegerModuloP3 = extendedHomogeneousPoint.getY().mutable().setProduct((IntegerModuloP)extendedHomogeneousPoint2.getZ());
        MutableIntegerModuloP mutableIntegerModuloP4 = extendedHomogeneousPoint2.getY().mutable().setProduct((IntegerModuloP)extendedHomogeneousPoint.getZ());
        return mutableIntegerModuloP3.asBigInteger().equals(mutableIntegerModuloP4.asBigInteger());
    }

    @Override
    public boolean affineEquals(Point point) {
        if (point instanceof ExtendedHomogeneousPoint) {
            ExtendedHomogeneousPoint extendedHomogeneousPoint = (ExtendedHomogeneousPoint)point;
            return ExtendedHomogeneousPoint.affineEquals(this, extendedHomogeneousPoint);
        }
        return this.asAffine().equals(point.asAffine());
    }

    public static class Mutable
    extends ExtendedHomogeneousPoint<MutableIntegerModuloP>
    implements MutablePoint {
        public Mutable(MutableIntegerModuloP mutableIntegerModuloP, MutableIntegerModuloP mutableIntegerModuloP2, MutableIntegerModuloP mutableIntegerModuloP3, MutableIntegerModuloP mutableIntegerModuloP4) {
            super(mutableIntegerModuloP, mutableIntegerModuloP2, mutableIntegerModuloP3, mutableIntegerModuloP4);
        }

        @Override
        public Mutable conditionalSet(Point point, int n) {
            if (!(point instanceof ExtendedHomogeneousPoint)) {
                throw new RuntimeException("Incompatible point");
            }
            ExtendedHomogeneousPoint extendedHomogeneousPoint = (ExtendedHomogeneousPoint)point;
            return this.conditionalSet(extendedHomogeneousPoint, n);
        }

        private <T extends IntegerModuloP> Mutable conditionalSet(ExtendedHomogeneousPoint<T> extendedHomogeneousPoint, int n) {
            ((MutableIntegerModuloP)this.x).conditionalSet((IntegerModuloP)extendedHomogeneousPoint.x, n);
            ((MutableIntegerModuloP)this.y).conditionalSet((IntegerModuloP)extendedHomogeneousPoint.y, n);
            ((MutableIntegerModuloP)this.t).conditionalSet((IntegerModuloP)extendedHomogeneousPoint.t, n);
            ((MutableIntegerModuloP)this.z).conditionalSet((IntegerModuloP)extendedHomogeneousPoint.z, n);
            return this;
        }

        @Override
        public Mutable setValue(AffinePoint affinePoint) {
            ((MutableIntegerModuloP)this.x).setValue(affinePoint.getX());
            ((MutableIntegerModuloP)this.y).setValue(affinePoint.getY());
            ((MutableIntegerModuloP)this.t).setValue(affinePoint.getX()).setProduct(affinePoint.getY());
            ((MutableIntegerModuloP)this.z).setValue(affinePoint.getX().getField().get1());
            return this;
        }

        @Override
        public Mutable setValue(Point point) {
            ExtendedHomogeneousPoint extendedHomogeneousPoint = (ExtendedHomogeneousPoint)point;
            return this.setValue(extendedHomogeneousPoint);
        }

        private <T extends IntegerModuloP> Mutable setValue(ExtendedHomogeneousPoint<T> extendedHomogeneousPoint) {
            ((MutableIntegerModuloP)this.x).setValue((IntegerModuloP)extendedHomogeneousPoint.x);
            ((MutableIntegerModuloP)this.y).setValue((IntegerModuloP)extendedHomogeneousPoint.y);
            ((MutableIntegerModuloP)this.t).setValue((IntegerModuloP)extendedHomogeneousPoint.t);
            ((MutableIntegerModuloP)this.z).setValue((IntegerModuloP)extendedHomogeneousPoint.z);
            return this;
        }
    }

    public static class Immutable
    extends ExtendedHomogeneousPoint<ImmutableIntegerModuloP>
    implements ImmutablePoint {
        public Immutable(ImmutableIntegerModuloP immutableIntegerModuloP, ImmutableIntegerModuloP immutableIntegerModuloP2, ImmutableIntegerModuloP immutableIntegerModuloP3, ImmutableIntegerModuloP immutableIntegerModuloP4) {
            super(immutableIntegerModuloP, immutableIntegerModuloP2, immutableIntegerModuloP3, immutableIntegerModuloP4);
        }
    }
}

