/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ec;

import java.security.spec.AlgorithmParameterSpec;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.openeddsa.java.security.spec.NamedParameterSpec;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AlgorithmId;

public class ParametersMap<T> {
    private Map<Integer, T> sizeMap = new HashMap<Integer, T>();
    private Map<ObjectIdentifier, T> oidMap = new HashMap<ObjectIdentifier, T>();
    private Map<String, T> nameMap = new HashMap<String, T>();

    public void fix() {
        this.sizeMap = Collections.unmodifiableMap(this.sizeMap);
        this.oidMap = Collections.unmodifiableMap(this.oidMap);
        this.nameMap = Collections.unmodifiableMap(this.nameMap);
    }

    public void put(String string, ObjectIdentifier objectIdentifier, int n, T t) {
        this.nameMap.put(string.toLowerCase(), t);
        this.oidMap.put(objectIdentifier, t);
        this.sizeMap.put(n, t);
    }

    public Optional<T> getByOid(ObjectIdentifier objectIdentifier) {
        return Optional.ofNullable(this.oidMap.get(objectIdentifier));
    }

    public Optional<T> getBySize(int n) {
        return Optional.ofNullable(this.sizeMap.get(n));
    }

    public Optional<T> getByName(String string) {
        return Optional.ofNullable(this.nameMap.get(string.toLowerCase()));
    }

    private static <A, B> Supplier<B> apply(final Function<A, B> function, final A a) {
        return new Supplier<B>(){

            @Override
            public B get() {
                return function.apply(a);
            }
        };
    }

    public <E extends Throwable> T getBySize(Function<String, E> function, int n) throws E {
        Optional<T> optional = this.getBySize(n);
        return optional.orElseThrow(ParametersMap.apply(function, "Unsupported size: " + n));
    }

    public <E extends Throwable> T get(Function<String, E> function, AlgorithmId algorithmId) throws E {
        Optional<T> optional = this.getByOid(algorithmId.getOID());
        return optional.orElseThrow(ParametersMap.apply(function, "Unsupported OID: " + algorithmId.getOID()));
    }

    public <E extends Throwable> T get(Function<String, E> function, AlgorithmParameterSpec algorithmParameterSpec) throws E {
        if (algorithmParameterSpec instanceof NamedParameterSpec) {
            NamedParameterSpec namedParameterSpec = (NamedParameterSpec)algorithmParameterSpec;
            Optional<T> optional = this.getByName(namedParameterSpec.getName());
            return optional.orElseThrow(ParametersMap.apply(function, "Unsupported name: " + namedParameterSpec.getName()));
        }
        throw (Throwable)function.apply("Only NamedParameterSpec is supported.");
    }
}

