/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.ext.base.store;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.xpipe.app.core.AppI18n;
import io.xpipe.app.ext.DataStore;
import io.xpipe.app.hub.action.BatchHubProvider;
import io.xpipe.app.hub.action.HubLeafProvider;
import io.xpipe.app.hub.action.StoreAction;
import io.xpipe.app.hub.action.StoreActionCategory;
import io.xpipe.app.platform.LabelGraphic;
import io.xpipe.app.storage.DataStoreEntryRef;
import io.xpipe.ext.base.store.StartableStore;
import io.xpipe.ext.base.store.StoppableStore;
import javafx.beans.value.ObservableValue;
import lombok.Generated;

public class StoreRestartActionProvider
implements HubLeafProvider<DataStore>,
BatchHubProvider<DataStore> {
    public StoreActionCategory getCategory() {
        return StoreActionCategory.CUSTOM;
    }

    public boolean isApplicable(DataStoreEntryRef<DataStore> o) {
        return o.getStore() instanceof StartableStore && o.getStore() instanceof StoppableStore;
    }

    public ObservableValue<String> getName(DataStoreEntryRef<DataStore> store) {
        return AppI18n.observable((String)"restart", (Object[])new Object[0]);
    }

    public LabelGraphic getIcon(DataStoreEntryRef<DataStore> store) {
        return new LabelGraphic.IconGraphic("mdi2r-restart");
    }

    public Class<?> getApplicableClass() {
        return DataStore.class;
    }

    public boolean requiresValidStore() {
        return false;
    }

    public ObservableValue<String> getName() {
        return AppI18n.observable((String)"restart", (Object[])new Object[0]);
    }

    public LabelGraphic getIcon() {
        return new LabelGraphic.IconGraphic("mdi2r-restart");
    }

    public String getId() {
        return "restartStore";
    }

    @JsonDeserialize(builder=ActionBuilderImpl.class)
    public static class Action
    extends StoreAction<DataStore> {
        public void executeImpl() throws Exception {
            ((StoppableStore)this.ref.getStore()).stop();
            ((StartableStore)this.ref.getStore()).start();
        }

        public boolean isMutation() {
            return true;
        }

        @Generated
        protected Action(ActionBuilder<?, ?> b) {
            super(b);
        }

        @Generated
        public static ActionBuilder<?, ?> builder() {
            return new ActionBuilderImpl();
        }

        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        @Generated
        static final class ActionBuilderImpl
        extends ActionBuilder<Action, ActionBuilderImpl> {
            @Generated
            private ActionBuilderImpl() {
            }

            @Override
            @Generated
            protected ActionBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public Action build() {
                return new Action(this);
            }
        }

        @Generated
        public static abstract class ActionBuilder<C extends Action, B extends ActionBuilder<C, B>>
        extends StoreAction.StoreActionBuilder<DataStore, C, B> {
            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public String toString() {
                return "StoreRestartActionProvider.Action.ActionBuilder(super=" + super.toString() + ")";
            }
        }
    }
}

